/*
 *  $Id$
 *
 *  build_udp.c - Crude UDP packet assembler
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

void
build_udp(u_short len, u_short sp, u_short dp, const u_char *payload,
        u_char *buf)
{
    struct udphdr *udp_hdr;

    udp_hdr = (struct udphdr *)(buf);

    udp_hdr->uh_sport   = htons(sp);
    udp_hdr->uh_dport   = htons(dp);
    udp_hdr->uh_ulen    = htons(UDP_H + len);
    udp_hdr->uh_sum     = 0;

    if (payload)
    {
        /* ... */
    }
}


/* EOF */
