/*
 *  $Id$
 *
 *  libnet
 *  build_udp implementation
 *  build_udp.c - Crude UDP packet assembler
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "../include/libnet.h"

void
build_udp(u_short sp, u_short dp, const u_char *payload, int payload_s,
            u_char *buf)
{
    struct udphdr *udp_hdr;

    assert(buf);
    udp_hdr = (struct udphdr *)(buf);

    udp_hdr->uh_sport   = htons(sp);
    udp_hdr->uh_dport   = htons(dp);
    udp_hdr->uh_ulen    = htons(UDP_H + payload_s);
    udp_hdr->uh_sum     = 0;

    if (payload && payload_s)
    {
        /*
         *  Unchecked runtime error for buf + UDP_HDR + payload to be greater
         *  then the allocated heap memory.
         */
        memcpy(buf + UDP_H, payload, payload_s);
    } 
}


/* EOF */
