/*
 *  $Id$
 *
 *  libnet
 *  write_ip implementation
 *  write_ip.c -
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "../include/libnet.h"

int
write_ip(int sock, const u_char *buf, int len)
{
    int c, s;
    struct sockaddr_in sin;
    struct ip *ip_hdr;
    struct udphdr *udp_hdr;
    struct tcphdr *tcp_hdr;

    ip_hdr = (struct ip *)(buf);

    bzero(&sin, sizeof(sin));
    sin.sin_family      = AF_INET;
    sin.sin_addr.s_addr = ip_hdr->ip_dst.s_addr;


    /*
     *  Figure out which transport (if any) we are using and fill in the 
     *  socket address port information accordingly.  The relative complexity
     *  here is the price we pay for the simple interface.
     */
    switch (ip_hdr->ip_p)
    {
        case IPPROTO_TCP:
            tcp_hdr = (struct tcphdr *)(buf + IP_H);
            sin.sin_port = tcp_hdr->th_sport; 
            break;
        case IPPROTO_UDP:
            udp_hdr = (struct udphdr *)(buf + IP_H);
            sin.sin_port = udp_hdr->uh_sport; 
            break;
        case IPPROTO_ICMP:
        case IPPROTO_IP:
            sin.sin_port = 0;   /* Unused in this case */
            break;
        default:
            fprintf(stderr, "Unknown transport\n");
            return (-1);
    }

    s = sizeof(struct sockaddr);
    c = sendto(sock, buf, len, 0, (struct sockaddr *)&sin, s);
    if (c != len)
    {
        /*
         *  Up to the user to check for error.
         */
        DEBUG("write_ip: error: %d bytes written (%s)\n", c, strerror(errno));
    }
    else
    {
        DEBUG("write_ip: wrote %d bytes\n", c);
    }
    return (c);
}

/* EOF */
