/*
 *  $Id$
 *
 *  libnet
 *  test3 client
 *  test3.c - TCP Packet assembly tester (with payload and IP options)
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "libnet_test.h"

int
main(int argc, char **argv)
{
    int sock, c;
    u_char *buf;
    u_char *payload = "hello world";
    u_char *options = "  This here is a 40-byte IP option list.";
    int payload_s = strlen(payload);
    int option_s  = strlen(options);
    struct ipoption ipopt;

    printf("Test 5: IP + options and TCP + payload packet building/writing test\n");

    /*
     *  Get packet memory.  Let's get plenty.
     */
    buf = malloc(IP_MAXPACKET);
    if (!buf)
    {
        perror("No memory for packet");
        exit(EXIT_FAILURE);
    }

    /*
     *  Open our raw IP socket and set IP_HDRINCL.
     */
    sock = open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    /*
     *  Build the IP header (shown exploded for commenting).
     */
    build_ip(TCP_H + payload_s,             /* Size of the payload */
            242,                            /* IP ID */
            0,                              /* Frag stuff */
            48,                             /* TTL */
            IPPROTO_TCP,                    /* Transport protocol */
            name_resolve(IP1, 1),           /* Source IP */
            name_resolve(IP2, 1),           /* Destination IP */
            NULL,                           /* Pointer to payload (none) */
            0,
            buf);                           /* Packet header memory */

    /*
     *  Build the TCP header.
     */
    build_tcp(1025,                         /* Source TCP port */
            22,                             /* Destination TCP port */
            11111,                          /* Sequence number */
            99999,                          /* Acknowledgement number */
            TH_SYN|TH_ACK,                  /* Control flags */
            1024,                           /* Window size */
            0,                              /* Urgent pointer */
            payload,                        /* Pointer to payload */
            payload_s,
            buf + IP_H);                    /* Packet header memory */

    /*
     *  Calculate the TCP header checksum (IP header checksum is *always* done
     *  by the kernel.
     */
    do_checksum(buf, IPPROTO_TCP, TCP_H + payload_s);


    memcpy(ipopt.ipopt_list, options, option_s);
    *(ipopt.ipopt_list)     = IPOPT_SECURITY;
    *(ipopt.ipopt_list + 1) = 1;
    /*
     *  Insert the IP options.
     */
    c = insert_ipo(&ipopt,                  /* pointer to ipopt struct */
            option_s,                       /* Length of option list */
            buf);                           /* Packet header memory */

    if (c == -1)
    {
        fprintf(stderr, "Can't add options, discarding them.\n");
    }

    /*
     *  Write the packet to the network.
     */
    c = write_ip(sock, buf, TCP_H + IP_H + payload_s + option_s);
    if (c < TCP_H + IP_H + payload_s + option_s)
    {
        fprintf(stderr, "write_ip: %s\n", strerror(errno));
    }
    printf("Completed, wrote %d bytes\n", c);
    free(buf);

    return (EXIT_SUCCESS);
}

/* EOF */
