/*
 *  $Id: 2_udp.c,v 1.1 1998/11/09 05:01:17 route Exp $
 *
 *  libnet
 *  test2 client
 *  test2.c - UDP Packet assembly tester
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "libnet_test.h"

int
main(int argc, char **argv)
{
    int sock, c;
    u_char *buf;

    printf("Test 2: UDP packet building/writing test\n");

    buf = malloc(UDP_H + IP_H);
    if (!buf)
    {
        perror("No memory for packet header");
        exit(EXIT_FAILURE);
    }

    sock = open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    build_ip(UDP_H,
            0,
            242,
            0,
            64,
            IPPROTO_UDP,
            name_resolve(IP1, 1),
            name_resolve(IP2 ,1),
            NULL,
            0,
            buf);

    build_udp(1025, 22, NULL, 0, buf + IP_H);

    do_checksum(buf, IPPROTO_UDP, UDP_H);

    c = write_ip(sock, buf, UDP_H + IP_H);
    if (c < UDP_H + IP_H)
    {
        fprintf(stderr, "write_ip\n");
    }
    printf("Completed, wrote %d bytes\n", c);

    free(buf);
    return (EXIT_SUCCESS);
}

