/*
 *  $Id: build_icmp.c,v 1.6 1998/12/09 00:56:53 route Exp $
 *
 *  libnet
 *  build_icmp.c - Crude ICMP packet assembler
 *
 *  Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../include/libnet.h"

void
build_icmp_echo(u_char type, u_char code, u_short id, u_short seq,
    const u_char *payload, int payload_s, u_char *buf)
{
    struct icmpheader *icmp_hdr;

    assert(buf);
    icmp_hdr = (struct icmpheader *)(buf);

    icmp_hdr->icmp_type = type;         /* packet type */
    icmp_hdr->icmp_code = code;         /* packet code */
    icmp_hdr->icmp_id   = htons(id);    /* packet id */
    icmp_hdr->icmp_seq  = htons(seq);   /* packet seq */

    if (payload && payload_s)
    {
        /*
         *  Unchecked runtime error for buf + ICMP_H payload to be greater than
         *  the allocated heap memory.
         */
        memcpy(buf + ICMP_H, payload, payload_s);
    }
}

/* EOF */
