/*
 *  $Id: 7_icmp.c,v 1.3 1998/12/09 00:56:53 route Exp $
 *
 *  libnet
 *  test7.c - ICMP Packet assembly tester
 *
 *  Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
 */

#include "../libnet_test.h"

int
main(int argc, char **argv)
{
    int sock, c;
    u_char *buf;

    printf("Test 7: ICMP packet building/writing test\n");

    /*
     *  Get our block of memory for the packet.  In this case, we only need
     *  memory for the packet headers.
     */
    buf = malloc(IP_MAXPACKET);
    if (!buf)
    {
        perror("No memory for packet header");
        exit(EXIT_FAILURE);
    }

    /*
     *  Open our raw IP socket and set IP_HDRINCL.
     */
    sock = open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    /*
     *  Build the IP header (shown exploded for commenting).
     */
    build_ip(ICMP_ECHO_H,                   /* Size of the payload */
            IPTOS_LOWDELAY | IPTOS_THROUGHPUT, /* IP tos */
            242,                            /* IP ID */
            0,                              /* Frag stuff */
            48,                             /* TTL */
            IPPROTO_ICMP,                   /* Transport protocol */
            name_resolve(IP1, 1),           /* Source IP */
            name_resolve(IP2, 1),           /* Destination IP */
            NULL,                           /* Pointer to payload (none) */
            0,
            buf);                           /* Packet header memory */

    /*
     *  Build the ICMP header.
     */
    build_icmp_echo(ICMP_ECHO,              /* type */
                0,                          /* code */
                242,                        /* id */
                1,                          /* seq */
                NULL,	                    /* pointer to payload */
                0,                          /* size of payload */
                buf + IP_H);                /* packet header memory */

    do_checksum(buf, IPPROTO_ICMP, ICMP_ECHO_H);

    /*
     *  Write the packet to the network.
     */
    c = write_ip(sock, buf, ICMP_ECHO_H + IP_H);
    if (c < ICMP_ECHO_H + IP_H)
    {
        fprintf(stderr, "write_ip\n");
    }
    printf("Completed, wrote %d bytes\n", c);
    free(buf);

    return (EXIT_SUCCESS);
}

/* EOF */
