/*
 * Demonstrates how to make a generic OSPF LSA packet.
 *
 * Andrew Reiter
 * <areiter@bindview.com>
 * Bindview Development
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <libnet.h>


void 	help(char *);

int
main(int argc, char **argv)
{
    int sock, warn, len;
    u_char *pack;
    char *from, *to;
    u_long src, dst, addrid, addaid, auth[2];

    if (argc != 3) 
	help(argv[0]);

    len = IP_H + OSPF_H + AUTH_H + LSA_H + LS_NET_LEN;
    pack = (u_char *)malloc(len);

    from = argv[1];
    to = argv[2];

    src = libnet_name_resolve(from, 0);
    dst = libnet_name_resolve(to, 0);

    addrid = 0xff00ff00;
    addaid = 0xd00dd00d;

    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1) {
	perror("socket");
	free(pack);
	exit(sock);
    }

    libnet_build_ip(OSPF_H + AUTH_H + LSA_H + LS_NET_LEN,
			0x00, 
			(u_short)rand(), 
			IP_DF,
			0xfe,
			IPPROTO_OSPF,
			src,
			dst,
			NULL,
			0,
			pack);

    libnet_build_ospf(AUTH_H + LSA_H + LS_NET_LEN,
			OSPF_LSA,
			addrid,
			addaid,
			OSPF_AUTH_NULL,
			NULL,
			0,
			pack + IP_H);

    memset(auth, 0, sizeof(auth));
    LIBNET_OSPF_AUTHCPY(pack + OSPF_H + IP_H, auth);

    libnet_build_ospf_lsa(40, 
			  0x00, 
			  LS_TYPE_NET,
			  addrid,
			  src, 
			  0xf0f0f00f,
			  LS_NET_LEN,
			  NULL,
			  0,
			  pack + AUTH_H + OSPF_H + IP_H);

    libnet_build_ospf_lsa_net(0xffffff00, 
				0xc0ffee00, 
				NULL,
				0,
				pack + LSA_H + AUTH_H + OSPF_H + IP_H);

    libnet_do_checksum(pack, IPPROTO_OSPF, len);
    libnet_lsa_cksum(pack + IP_H + OSPF_H + AUTH_H , LS_NET_LEN + LSA_H);

    warn = libnet_write_ip(sock, pack, len);
    if (warn == -1) {
	printf("Error writing packet to the wire\n");
	free(pack);
	exit(warn);
    }

    printf("%d bytes written\n", warn);
    free(pack);

}

void
help(char *pname)
{
    printf("Usage: %s <source ip> <dest. ip>\n", pname);
    printf("[Use x.x.x.x format]\n");
    exit(0);
}
