/*
 * Demonstrates how to build a generic OSPF LSR packet.
 *
 * Andrew Reiter
 * <areiter@bindview.com>
 * Bindview Development
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <libnet.h>

void 	help(char *);

int
main(int argc, char **argv)
{
    int warn, sock, len;
    u_char *pack;
    char *from, *to, *adrtr;
    u_long src, dest, advrouter, addaid, addrid;
    u_char auth[2]; 

    if (argc != 4)
	help(argv[0]);

    from = argv[1];
    to = argv[2];
    adrtr = argv[3]; 

    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1) {
	perror("socket");
	exit(-1);
    }

    src = libnet_name_resolve(from, 0);
    dest = libnet_name_resolve(to, 0);
    advrouter = libnet_name_resolve(adrtr, 0);

    addaid = 0xc0ffeeb0;
    addrid = 0xb00f00d0;

    len = IP_H + OSPF_H + AUTH_H + LSR_H;
    pack = (u_char *)malloc(len);
    
    libnet_build_ip(OSPF_H + AUTH_H + LSR_H, 0x00, (u_short)rand(), IP_DF, 
			0xff, IPPROTO_OSPF, src, dest, NULL, 0, pack);

    memset(auth, 0, sizeof(auth));

    libnet_build_ospf(AUTH_H + LSR_H, OSPF_LSR, addrid, addaid, OSPF_AUTH_NULL,
			NULL, 0, pack + IP_H);

    LIBNET_OSPF_AUTHCPY(pack + IP_H + OSPF_H, auth);

    libnet_build_ospf_lsr(LS_TYPE_RTR, 0xffffffff, advrouter, NULL, 0, 
			pack + IP_H + OSPF_H + AUTH_H);

    libnet_do_checksum(pack, IPPROTO_OSPF, len);

    warn = libnet_write_ip(sock, pack, len); 
    if (warn == -1) {
	printf("Error writing packet to wire\n");
	free(pack);
    } else {
	printf("%d bytes written\n", warn);
    }

    free(pack);
}

void
help(char *pname)
{
    printf("Usage: %s <source ip> <dest. ip> <router ip>\n", pname);
    printf("[Use x.x.x.x format]\n");
    exit(0);
}
    
    
    
