/*
 *  $Id: libnet-structures.h,v 1.24 2002/03/15 17:44:29 route Exp $
 *
 *  libnet-structures.h - Network routine library structures header file
 *
 *  Copyright (c) 1998 - 2002 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __LIBNET_STRUCTURES_H
#define __LIBNET_STRUCTURES_H


/*
 *  Port list chain structure
 */
typedef struct libnet_port_list_chain libnet_plist_t;
struct libnet_port_list_chain
{
    u_short node;                       /* node number */
    u_short bport;                      /* beggining port */
    u_short eport;                      /* terminating port */
    u_char  id;                         /* global array offset */
    libnet_plist_t *next;               /* next node in the list */
};


/*
 *  Libnet statistics structure
 */
struct libnet_stats
{
    u_long packets_sent;                /* packet sent counter */
    u_long packet_errors;               /* packets not written successfully */
    u_long bytes_written;               /* bytes written */
};


/*
 *  Libnet ptags are how we identify specific protocol blocks inside the
 *  list.
 */
typedef long libnet_ptag_t;
#define LIBNET_PTAG_INITIALIZER         0


/*
 *  Libnet generic protocol block memory object.  Sort of a poor man's mbuf.
 */
struct libnet_protocol_block
{
    u_char *buf;                        /* protocol buffer */
    u_long b_len;                       /* length of buf */
    u_short h_len;                      /* header length (for checksumming) */
    u_long copied;                      /* bytes copied */
    u_char type;                        /* type of pblock */
/*
 *  This needs to be updated every time a new packet builder is added.
 */
#define LIBNET_PBLOCK_ARP_H             0x1
#define LIBNET_PBLOCK_DHCPV4_H          0x2
#define LIBNET_PBLOCK_DNSV4_H           0x3
#define LIBNET_PBLOCK_ETH_H             0x4
#define LIBNET_PBLOCK_ICMPV4_H          0x5
#define LIBNET_PBLOCK_ICMPV4_ECHO_H     0x6
#define LIBNET_PBLOCK_ICMPV4_MASK_H     0x7
#define LIBNET_PBLOCK_ICMPV4_UNREACH_H  0x8
#define LIBNET_PBLOCK_ICMPV4_TIMXCEED_H 0x9
#define LIBNET_PBLOCK_ICMPV4_REDIRECT_H 0xa
#define LIBNET_PBLOCK_ICMPV4_TS_H       0xb
#define LIBNET_PBLOCK_IGMP_H            0xc
#define LIBNET_PBLOCK_IPV4_H            0xd
#define LIBNET_PBLOCK_IPO_H             0xe     /* IPv4 options */
#define LIBNET_PBLOCK_OSPF_H            0xf
#define LIBNET_PBLOCK_OSPF_HELLO_H      0x10
#define LIBNET_PBLOCK_OSPF_DBD_H        0x11
#define LIBNET_PBLOCK_OSPF_LSR_H        0x12
#define LIBNET_PBLOCK_OSPF_LSU_H        0x13
#define LIBNET_PBLOCK_OSPF_LSA_H        0x14
#define LIBNET_PBLOCK_OSPF_AUTH_H       0x15
#define LIBNET_PBLOCK_OSPF_CKSUM        0x16
#define LIBNET_PBLOCK_LS_RTR_H          0x17        
#define LIBNET_PBLOCK_LS_NET_H          0x18
#define LIBNET_PBLOCK_LS_SUM_H          0x19
#define LIBNET_PBLOCK_LS_AS_EXT_H       0x1a
#define LIBNET_PBLOCK_NTP_H             0x1b
#define LIBNET_PBLOCK_RIP_H             0x1c
#define LIBNET_PBLOCK_TCP_H             0x1f
#define LIBNET_PBLOCK_TCPO_H            0x20    /* TCP options */
#define LIBNET_PBLOCK_UDP_H             0x21
#define LIBNET_PBLOCK_VRRP_H            0x22
#define LIBNET_PBLOCK_DATA_H            0x23    /* generic data */
#define LIBNET_PBLOCK_CDP_H             0x24
#define LIBNET_PBLOCK_IPSEC_ESP_HDR_H   0x25
#define LIBNET_PBLOCK_IPSEC_ESP_FTR_H   0x26
#define LIBNET_PBLOCK_IPSEC_AH_H        0x27
#define LIBNET_PBLOCK_802_1Q_H          0x28
#define LIBNET_PBLOCK_802_2_H           0x29
#define LIBNET_PBLOCK_802_2SNAP_H       0x2a
#define LIBNET_PBLOCK_802_3_H           0x2b
#define LIBNET_PBLOCK_STP_H             0x2c

    u_char flags;                       /* control flags */
#define LIBNET_PBLOCK_DO_CHECKSUM       1   /* this item needs a checksum */
    libnet_ptag_t ptag;                 /* protocol block tag */
    struct libnet_protocol_block *next; /* next pblock */
    struct libnet_protocol_block *prev; /* prev pblock */
};
typedef struct libnet_protocol_block libnet_pblock_t;


/*
 *  Libnet handle
 *  Opaque structure.  Nothing in here should ever been touched first hand by
 *  the applications programmer.
 */
struct libnet_handle
{
    int fd;                             /* file descriptor of packet device */
    int protocol;                       /* protocol for raw socket stuff */
    int injection_type;                 /* raw (ipv4 or ipv6) or link */
#define LIBNET_LINK 0                   /* link-layer interface */
#define LIBNET_RAW4 1                   /* raw socket interface (ipv4) */
#define LIBNET_RAW6 2                   /* raw socket interface (ipv6) */

    /* XXX - for multiple packets this needs to be modified */
    libnet_pblock_t *protocol_blocks;   /* protocol headers / data */

    int link_type;                      /* link-layer type */
    int link_offset;                    /* link-layer header size */
    int aligner;                        /* used to align packets */
    u_char *device;                     /* device name */

    struct libnet_stats stats;          /* statistics */
    libnet_ptag_t ptag_state;           /* state holder for pblock tag */

    char err_buf[LIBNET_ERRBUF_SIZE];   /* error buffer */
};
typedef struct libnet_handle libnet_t;

#endif  /* __LIBNET_STRUCTURES_H */

/* EOF */
