/*
 *  $Id: radiate.h,v 1.1.1.1 2002/05/02 21:27:16 root Exp $
 *
 *  radiate
 *  radiate.h - 802.11 manipulation library routines
 *
 *  Copyright (c) 2002 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __LIBRADIATE_H
#define __LIBRADIATE_H

#include <assert.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "errno.h"
#include <ctype.h>
#include "./radiate/ieee80211.h"
#include "./radiate/wireless.h"

#define RADIATE_ERRBUF_SIZE 256
#define RADIATE_MONITOR_ON  "on"
#define RADIATE_MONITOR_OFF "off"

#define RADIATE_GET_BIT(x)      (1 << (x))
#define RADIATE_GET_TYPE(fc)    (((fc) & (RADIATE_GET_BIT(3) | \
                                        RADIATE_GET_BIT(2))) >> 2)
#define RADIATE_TYPE_MGMT   0x00
#define RADIATE_TYPE_CTRL   0x01
#define RADIATE_TYPE_DATA   0x02

/* mgmt frame subtype */

#define RADIATE_MGMT_STYPE_ASSOC_REQ        0x00
#define RADIATE_MGMT_STYPE_ASSOC_RESP       0x01
#define RADIATE_MGMT_STYPE_REASSOC_REQ      0x02
#define RADIATE_MGMT_STYPE_REASSOC_RESP     0x03
#define RADIATE_MGMT_STYPE_PROBE_REQ        0x04
#define RADIATE_MGMT_STYPE_PROBE_RESP       0x05
#define RADIATE_MGMT_STYPE_BEACON           0x08
#define RADIATE_MGMT_STYPE_DISASSOC         0x0a
#define RADIATE_MGMT_STYPE_AUTH             0x0b
#define RADIATE_MGMT_STYPE_DEAUTH           0x0c

/* data frame subtype */

#define RADIATE_DATA_STYPE_DATA             0x00
#define RADIATE_DATA_STYPE_DATA_CFACK       0x01
#define RADIATE_DATA_STYPE_DATA_CFPOLL      0x02
#define RADIATE_DATA_STYPE_DATA_CFACKPOLL   0x03
#define RADIATE_DATA_STYPE_NULLFUNC         0x04
#define RADIATE_DATA_STYPE_CFACK            0x05
#define RADIATE_DATA_STYPE_CFPOLL           0x06
#define RADIATE_DATA_STYPE_CFACKPOLL        0x07

/* control flags */

#define RADIATE_CTRL_TODS                   0x01
#define RADIATE_CTRL_FRDS                   0x02
#define RADIATE_CTRL_MFRG                   0x04
#define RADIATE_CTRL_RTRY                   0x08
#define RADIATE_CTRL_PWR                    0x10
#define RADIATE_CTRL_MDTA                   0x20
#define RADIATE_CTRL_WEP                    0x40
#define RADIATE_CTRL_ORDR                   0x80

/* reason codes */

#define RADIATE_REASON_UNSPECIFIED                      0x01
#define RADIATE_REASON_PREV_AUTH_NOT_VALID              0x02
#define RADIATE_REASON_DEAUTH_LEAVING                   0x03
#define RADIATE_REASON_DISASSOC_DUE_TO_INACTIVITY       0x04 
#define RADIATE_REASON_DISASSOC_AP_BUSY                 0x05
#define RADIATE_REASON_CLASS2_FRAME_FROM_NONAUTH_STA    0x06
#define RADIATE_REASON_CLASS3_FRAME_FROM_NONASSOC_STA   0x07
#define RADIATE_REASON_DISASSOC_STA_HAS_LEFT            0x08   
#define RADIATE_REASON_STA_REQ_ASSOC_WITHOUT_AUTH       0x09

struct radiate_context
{
    int fd;
    u_char flags;
#define RADIATE_VERBOSE 0x1         /* verbose debug information */
    char err_buf[RADIATE_ERRBUF_SIZE];
};
typedef struct radiate_context radiate_t;


radiate_t *         /* radiate context pointer or NULL on error */
radiate_init(
    u_char,         /* control flags y0 */
    char *          /* errbuffer of size RADIATE_ERRBUF_SIZE */
    );


void
radiate_destroy(
    radiate_t *     /* radiate context pointer */
    );


int                 /* bytes read on success, -1 on error, sets errno */
radiate_read(
    u_char **,      /* u_char pointer to resulting data */
    radiate_t *     /* radiate context pointer */
    );


int                 /* bytes written on success, -1 on error, sets errno */
radiate_write(
    u_char *,       /* u_char pointer to frame to write */
    int,            /* size of frame */
    radiate_t *     /* radiate context pointer */
    );


u_char *            /* resulting frame ready for writing */
radiate_build_mgmt_frame(
    u_char *,       /* address one (source) */
    u_char *,       /* address two (destination */
    u_char *,       /* BSSID */
    u_char,         /* subtype */
    u_char,         /* control flags */
    u_char *,       /* payload to append */
    int,            /* size of payload */
    radiate_t *     /* radiate context pointer */
    );


u_char *            /* resulting frame ready for writing */
radiate_build_data_frame(
    u_char *,       /* address one (source) */
    u_char *,       /* address two (destination */
    u_char *,       /* BSSID */
    u_char,         /* subtype */
    u_char,         /* control flags */
    u_char *,       /* payload to append */
    int,            /* size of payload */
    radiate_t *     /* radiate context pointer */
    );


int                 /* 1 on success, -1 on error, sets errno */
radiate_set_mm(
    char *,         /* string, "1" or "0" */
    radiate_t *     /* radiate context pointer */
    );


char *              /* error message or NULL if no error occured */
radiate_geterror(
    radiate_t *     /* radiate context pointer */
    );

#endif

/* EOF */
