#include "inject.h"


static void usage(void)
{
	fprintf(stderr,
		"usage:\n"
		"inject 1     send an authentication frame\n"
		"inject 2     send an association request\n");
	exit(1);
}


int main(int argc, char *argv[])
{
	FILE *f;
	struct hfa3841_tx_frame tx;
	char assoc[] = { 0x00, 0x00, /* capability information */
			 0x01, 0x00, /* listen interval */
			 0x00, 0x04, 'T', 'E', 'S', 'T', /* SSID */
			 0x01, 0x04, 0x82, 0x84, 0x0b, 0x16 /* supported rates
							     */
	};
	char auth[] = { 0x00, 0x00, /* auth. alg. - open system */
			0x01, 0x00, /* auth. transaction seq# */
			0x00, 0x00 /* status */
	};
	int msg, buflen;
	u16 fc;
	char *buf;

	if (argc != 2)
		usage();

	msg = atoi(argv[1]);
	if (msg < 1 || msg > 2)
		usage();

	f = fopen("/dev/nl_usersock", "w");
	if (f == NULL) {
		perror("fopen");
		exit(-1);
	}

	memset(&tx, 0, sizeof(tx));
	switch (msg) {
	case 1:
		fc = (WLAN_FC_TYPE_MGMT << 2) |
			(WLAN_FC_STYPE_AUTH << 4);
		buflen = sizeof(auth);
		buf = auth;
		break;
	case 2:
		fc = (WLAN_FC_TYPE_MGMT << 2) |
			(WLAN_FC_STYPE_ASSOC_REQ << 4);
		buflen = sizeof(assoc);
		buf = assoc;
		break;
	};
	tx.frame_control = __cpu_to_le16(fc);
	tx.tx_control = __cpu_to_le16(HFA3841_TX_CTRL_802_11 |
				      HFA3841_TX_CTRL_TX_EX |
				      HFA3841_TX_CTRL_TX_OK |
				      HFA3841_TX_CTRL_ALT_RTRY);
	/* DA */
	tx.addr1[0] = 0x00;
	tx.addr1[1] = 0x12;
	tx.addr1[2] = 0x34;
	tx.addr1[3] = 0x56;
	tx.addr1[4] = 0x78;
	tx.addr1[5] = 0x9a;

	/* addr2 = SA */
	tx.addr2[0] = 0x00;
	tx.addr2[1] = 0x23;
	tx.addr2[2] = 0x45;
	tx.addr2[3] = 0x67;
	tx.addr2[4] = 0x89;
	tx.addr2[5] = 0xab;

	/* BSSID */
	tx.addr3[0] = 0x00;
	tx.addr3[1] = 0x12;
	tx.addr3[2] = 0x34;
	tx.addr3[3] = 0x56;
	tx.addr3[4] = 0x78;
	tx.addr3[5] = 0x9a;

	tx.data_len = __cpu_to_le16(buflen);

	fwrite(&tx, 1, sizeof(tx), f);
	fwrite(buf, 1, buflen, f);

	fclose(f);

	return 0;
}
