#ifndef INJECT_H
#define INJECT_H

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <asm/byteorder.h>


#define BIT(x) (1 << (x))

typedef unsigned int u32;
typedef unsigned short u16;
typedef unsigned char u8;

struct hfa3841_tx_frame {
	/* HFA3841 TX frame descriptor */
	u16 status __attribute__ ((packed));
	u16 reserved1 __attribute__ ((packed));
	u16 reserved2 __attribute__ ((packed));
	u32 sw_support __attribute__ ((packed));
	u8 retry_count __attribute__ ((packed));
	u8 tx_rate __attribute__ ((packed));
	u16 tx_control __attribute__ ((packed));

	/* 802.11 */
	u16 frame_control __attribute__ ((packed)); /* parts not used */
	u16 duration_id __attribute__ ((packed));
	u8 addr1[6] __attribute__ ((packed));
	u8 addr2[6] __attribute__ ((packed)); /* not used */
	u8 addr3[6] __attribute__ ((packed));
	u16 seq_ctrl __attribute__ ((packed)); /* not used */
	u8 addr4[6] __attribute__ ((packed));
	u16 data_len __attribute__ ((packed));

	/* 802.3 */
	u8 dst_addr[6] __attribute__ ((packed));
	u8 src_addr[6] __attribute__ ((packed));
	u16 len __attribute__ ((packed));

	/* followed by frame data */
};

#define WLAN_FC_TYPE_MGMT 0
#define WLAN_FC_TYPE_CTRL 1
#define WLAN_FC_TYPE_DATA 2

/* management */
#define WLAN_FC_STYPE_ASSOC_REQ 0
#define WLAN_FC_STYPE_ASSOC_RESP 1
#define WLAN_FC_STYPE_REASSOC_REQ 2
#define WLAN_FC_STYPE_REASSOC_RESP 3
#define WLAN_FC_STYPE_PROBE_REQ 4
#define WLAN_FC_STYPE_PROBE_RESP 5
#define WLAN_FC_STYPE_BEACON 8
#define WLAN_FC_STYPE_ATIM 9
#define WLAN_FC_STYPE_DISASSOC 10
#define WLAN_FC_STYPE_AUTH 11
#define WLAN_FC_STYPE_DEAUTH 12

/* control */
#define WLAN_FC_STYPE_PSPOLL 10
#define WLAN_FC_STYPE_RTS 11
#define WLAN_FC_STYPE_CTS 12
#define WLAN_FC_STYPE_ACK 13
#define WLAN_FC_STYPE_CFEND 14
#define WLAN_FC_STYPE_CFENDACK 15

/* data */

#define WLAN_FC_STYPE_DATA 0
#define WLAN_FC_STYPE_DATA_CFACK 1
#define WLAN_FC_STYPE_DATA_CFPOLL 2
#define WLAN_FC_STYPE_DATA_CFACKPOLL 3
#define WLAN_FC_STYPE_NULLFUNC 4
#define WLAN_FC_STYPE_CFACK 5
#define WLAN_FC_STYPE_CFPOLL 6
#define WLAN_FC_STYPE_CFACKPOLL 7

#define WLAN_FC_TODS BIT(8)
#define WLAN_FC_FROMDS BIT(9)
#define WLAN_FC_WEP BIT(14)

#define HFA3841_TX_CTRL_ALT_RTRY BIT(5)
#define HFA3841_TX_CTRL_802_11 BIT(3)
#define HFA3841_TX_CTRL_802_3 0
#define HFA3841_TX_CTRL_TX_EX BIT(2)
#define HFA3841_TX_CTRL_TX_OK BIT(1)


#endif /* INJECT_H */
