/*
 *  $Id: radiate_build.c,v 1.1.1.1 2002/05/02 21:27:16 root Exp $
 *
 *  radiate
 *  radiate_build.c - 802.11 creation routines
 *
 *  Copyright (c) 2002 Mike D. Schiffman <mike@stake.com>
 *                       Tim Newsham <tnewsham@stake.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../include/radiate.h"

u_char *
radiate_build_mgmt_frame(u_char *addr1, u_char *addr2, u_char *addr3,
            u_char subtype, u_char control, u_char *payload, int payload_s,
            radiate_t *r)
{
    struct hfa384x_tx_frame tx;
    u_char *buf;

    /* XXX - this needs to get free()'d */
    buf = malloc(sizeof(tx) + payload_s);
    if (buf == NULL)
    {
        snprintf(r->err_buf, RADIATE_ERRBUF_SIZE, "malloc(): %s\n",
                strerror(errno));
        return (NULL);
    }

    memcpy(&tx.addr1, addr1, 6);
    memcpy(&tx.addr2, addr2, 6);
    memcpy(&tx.addr3, addr3, 6);

    tx.frame_control = host_to_le16((WLAN_FC_TYPE_MGMT << 2) |
                                      (subtype << 4) | (control << 8));
    tx.status = 0;
    tx.reserved1 = 0;
    tx.reserved2 = 0;
    tx.retry_count = 0;
    tx.tx_control = host_to_le16(HFA384X_TX_CTRL_802_11 |
                                    HFA384X_TX_CTRL_TX_EX |
                                    HFA384X_TX_CTRL_TX_OK);

    tx.data_len = host_to_le16(payload_s);
    tx.tx_rate = 0;
 
    memcpy(buf, &tx, sizeof (tx));
    memcpy(buf + sizeof (tx), payload, sizeof (payload_s));

    return (buf);
}


u_char *
radiate_build_data_frame(u_char *addr1, u_char *addr2, u_char *addr3, 
            u_char subtype, u_char control, u_char *payload, int payload_s,
            radiate_t *r)
{
    struct hfa384x_tx_frame tx;
    u_char *buf;

    /* XXX - this needs to get free()'d */
    buf = malloc(sizeof(tx) + payload_s);
    if (buf == NULL)
    {
        snprintf(r->err_buf, RADIATE_ERRBUF_SIZE, "malloc(): %s\n",
                strerror(errno));
        return (NULL);
    }

    memcpy(&tx.addr1, addr1, 6);
    memcpy(&tx.addr2, addr2, 6);
    memcpy(&tx.addr3, addr3, 6);

    tx.frame_control = host_to_le16((WLAN_FC_TYPE_DATA << 2) |
                                    (subtype << 4) | (control << 8));
    tx.status = 0;
    tx.reserved1 = 0;
    tx.reserved2 = 0;
    tx.retry_count = 0;
    tx.tx_control = host_to_le16(HFA384X_TX_CTRL_802_11 |
                                    HFA384X_TX_CTRL_TX_EX |
                                    HFA384X_TX_CTRL_TX_OK);

    tx.data_len = host_to_le16(payload_s);
    tx.tx_rate = 0;
 
    memcpy(buf, &tx, sizeof (tx));
    memcpy(buf + sizeof (tx), payload, payload_s);

    return (buf);
}


/* EOF */
