/*
 *  $Id: radiate_init.c,v 1.1.1.1 2002/05/02 21:27:16 root Exp $
 *
 *  radiate
 *  radiate_init.c - 802.11 initialization routines
 *
 *  Copyright (c) 2002 Mike D. Schiffman <mike@stake.com>
 *                       Tim Newsham <tnewsham@stake.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../include/radiate.h"


radiate_t *
radiate_init(u_char control_flags, char *err_buf)
{
    radiate_t *r;
    struct sockaddr_nl addr;

    r = (radiate_t *)malloc(sizeof (radiate_t));
    if (r == NULL)
    {   
        snprintf(err_buf, RADIATE_ERRBUF_SIZE, "malloc(): %s\n",
                strerror(errno));
        goto bad;
    }
    memset(r, 0, sizeof (*r));

    r->flags = control_flags;

    r->fd = socket(AF_NETLINK, SOCK_RAW, NETLINK_USERSOCK);
    if (r->fd == -1)
    {
        snprintf(err_buf, RADIATE_ERRBUF_SIZE, "socket(): %s\n",
                strerror(errno));
        goto bad;
    }

    memset(&addr, 0, sizeof addr);
    addr.nl_family = AF_NETLINK;
    addr.nl_groups = PRISM2_MONITOR_GROUP;

    if (bind(r->fd, (struct sockaddr*)&addr, sizeof (addr)) == -1)
    {
        snprintf(err_buf, RADIATE_ERRBUF_SIZE, "bind(): %s\n",
                strerror(errno));
        goto bad;
    }

    return (r);
bad:
    if (r)
    {
        radiate_destroy(r);
    }
    return (NULL);
}


void
radiate_destroy(radiate_t *r)
{
    if (r->fd)
    {
        close (r->fd);
    }
}


char *
radiate_geterror(radiate_t *r)
{
    return (r->err_buf);
}

/* EOF */
