/*
 *  $Id: radiate_ioctl.c,v 1.1.1.1 2002/05/02 21:27:16 root Exp $
 *
 *  radiate
 *  radiate_ioctl.c - driver ioctl crap
 *
 *  Copyright (c) 2002 Mike D. Schiffman <mike@stake.com>
 *                       Tim Newsham <tnewsham@stake.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../include/radiate.h"


/* cannibalized from wireless tools */
int
radiate_set_mm(char *mode, radiate_t *r)
{
    int q, c;
    u_char buffer[16] = {0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x2e,
                         0x34, 0x2e, 0x32, 0x2d, 0x32, 0x00, 0x00, 0x00};
    struct iwreq wrq;

    wrq.u.data.length = 1;
    sscanf(mode, "%d", ((u_int *) buffer));

    strncpy(wrq.ifr_name, "wlan0", IFNAMSIZ);
    memcpy(wrq.u.name, buffer, IFNAMSIZ);

    q = socket(AF_INET, SOCK_DGRAM, 0);
    if (q == -1)
    {
        snprintf(r->err_buf, RADIATE_ERRBUF_SIZE,
                "(mode %s) socket: %s\n", mode, strerror(errno));
        c = -1;
        goto done;
    }

// old version!    if (ioctl(q, 0x89f6, &wrq) < 0)
    if (ioctl(q, 0x89f0, &wrq) < 0)
    {
        snprintf(r->err_buf, RADIATE_ERRBUF_SIZE,
                "(mode %s) ioctl: %s\n", mode, strerror(errno));
        c = -1;
        goto done;
    }
    else
    {
        c = 1;
    }

done:
    close (q);
    return (c);
}


/* EOF */
