/*
 *  $Id: radiate_read.c,v 1.1.1.1 2002/05/02 21:27:16 root Exp $
 *
 *  radiate
 *  radiate_read.c - 802.11 reading routines
 *
 *  Copyright (c) 2002 Mike D. Schiffman <mike@stake.com>
 *                       Tim Newsham <tnewsham@stake.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../include/radiate.h"


int
radiate_read(u_char **buf, radiate_t *r)
{
    int c;
    static u_char _buf[8192];

read:
    c = recv(r->fd, _buf, sizeof (_buf), 0);

    if (c == -1)
    {
        if (errno == ENOBUFS)
        {
            /*
             *  The driver seems to run out of buffer space sometimes -- if
             *  we reread the problem goes away...
             */
            goto read;
        }
        else
        {
            snprintf(r->err_buf, RADIATE_ERRBUF_SIZE, "recv(): %s\n",
                    strerror(errno));
            memset(_buf, 0, sizeof (_buf));
        }
    }
    *buf = _buf;

    return (c);
}


/* EOF */
