/*
 *  $Id: libnet-structures.h,v 1.1.1.1 2000/05/25 00:28:49 route Exp $
 *
 *  libnet-structures.h - Network routine library structures header file
 *
 *  Copyright (c) 1998 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __LIBNET_STRUCTURES_H
#define __LIBNET_STRUCTURES_H

#ifdef	__cplusplus
 extern "C" {
#endif

/*
 *  Port list chain structure
 */
struct libnet_plist_chain
{
    u_short node;                       /* node number */
    u_short bport;                      /* beggining port */
    u_short eport;                      /* terminating port */
    u_char  id;                         /* global array offset */
    struct libnet_plist_chain *next;    /* next node in the list */
};


/*
 *  Low level packet interface struct
 */

#if (WIN32 || __linux__)
/*
 *  Win32 Adapter Packet stuff
 */

/* to properly emulate the socket interface we need an arp cache mechanism */
typedef struct arp_table
 {
  u_long ipadress; /* ip adress in decimal  */
  u_char mac[6];   /* matching mac adress */
  struct arp_table *next;
 } *Arp_Table;

/* Global info attached to network interface : Mac,IP,Gtw,Long name(WIN32),Packet pointer(WIN32), arp cache */
typedef struct GlobalInfo
{
#if (WIN32)
 LPADAPTER  lpAdapter;
#endif
 char Aname[512];
 u_char MAC[6];
 u_long LocalIp,DefaultGateway;

 /* Arp Data variables */
 Arp_Table Arp_Database; /* Arp table data */
 Arp_Table *Arp_Index; /* Arp_Index of Arp table */
 int nArp_Index; /* Number of Arp_Index entries */
}GINFO, *LPGINFO;

struct libnet_link_int
{
    int fd;             /* link layer file descriptor */
    int linktype;       /* link type */
    int linkoffset;     /* link header size (offset till network layer) */
    u_char *device;     /* device name */
    LPGINFO g_Info;	/* device Adapter,Mac,Name,ip,gateway,Arp cache */
};
#else /* WIN32 / Linux */
struct libnet_link_int
 {
  int fd;             /* link layer file descriptor */
  int linktype;       /* link type */
  int linkoffset;     /* link header size (offset till network layer) */
  u_char *device;     /* device name */
 };
#endif /* WIN32 / Linux */

/*
 *  Arena structure.
 */
struct libnet_arena
{
    int tag;                /* arena tag */
    u_char *memory_pool;    /* the memory */
    u_long current;         /* the current amount of memory allocated */
    u_long size;            /* the size of the pool in bytes */
};


/*
 *  Interface selection stuff
 */
struct libnet_ifaddr_list
{
    u_long addr;
    char *device;
};


#ifdef	__cplusplus
 }
#endif

#endif  /* __LIBNET_STRUCTURES_H */

/* EOF */
