/* Ryan@eEye.com Copyright 2000;
 *  Low level Packet driver interface for libnet.
 *
 * (Heavily) Modified by Jitsu-Disk securitybugware.org 2001
 *
 * Modifications by Jeff Nathan <jeff at snort dot org> (5/2003):
 *
 * Fixed libnet_get_hwaddr to return a hardware address instead of
 * 00:00:00:00:00:00 (previously libnet_get_hwaddr only worked when called
 * by libnet_open_link_interface because the device wasn't set properly in
 * the libnet_link_int structure).  This bugfix is based on fixes discovered
 * and corrected by Larcher Roberto <webteca at lycos dot it>.
 *
 */

#if (HAVE_CONFIG_H)
#include "../include/config.h"
#endif 
#include "../include/libnet.h"

struct ether_addr * 
libnet_get_hwaddr(struct libnet_link_int *l,const char *device,char *err_buf)
{
    static struct ether_addr *mac;
    ULONG IoCtlBufferLength = (sizeof(PACKET_OID_DATA) + sizeof(ULONG) - 1);
    PPACKET_OID_DATA OidData;
    DWORD dwErrorCode;
    BOOL torf;
    int i, gAlloc = 0, dOpened = 0;

    mac = (struct ether_addr *)calloc(1, sizeof(struct ether_addr));
    if (mac == NULL)
    {
        sprintf(err_buf, "calloc: %s", ll_strerror(errno));
        return (NULL);
    }

    OidData = (struct _PACKET_OID_DATA *)calloc(1, IoCtlBufferLength);
    if (OidData == NULL)
        return (NULL);

    if (l->linktype == DLT_IEEE802)
        OidData->Oid = OID_802_5_CURRENT_ADDRESS;
    else
        OidData->Oid = OID_802_3_CURRENT_ADDRESS;

    OidData->Length = 6;

    /* do we need to allocate g_Info ? */
    if (l->g_Info == NULL)
    {
        if ((l->g_Info = (LPGINFO)calloc(1, sizeof(GINFO))) == NULL)
        {
            sprintf(err_buf, "calloc: %s", ll_strerror(errno));
            return (NULL);
        }
        gAlloc = 1;
    }
    
    /* do we need to open the adapter ? */
    if (l->g_Info->lpAdapter == NULL)
    {
        l->g_Info->lpAdapter = PacketOpenAdapter((const char *)device);
        if ((l->g_Info->lpAdapter == NULL) ||
                (l->g_Info->lpAdapter->hFile == INVALID_HANDLE_VALUE))
        {
            dwErrorCode = GetLastError();
            printf("Unable to open the driver, Error Code : %lx\n",
                    dwErrorCode);
            if (gAlloc)
                free(l->g_Info);
            return (NULL);
        }
        dOpened = 1;
    }
    torf = PacketRequest(l->g_Info->lpAdapter, FALSE, OidData);
    if (torf == FALSE)
        memset(l->g_Info->MAC, 0, 6);
    else
        memcpy(l->g_Info->MAC, OidData->Data, 6);

    if (dOpened)
    {
        PacketSetHwFilter(l->g_Info->lpAdapter, NDIS_PACKET_TYPE_ALL_LOCAL);
        PacketCloseAdapter(l->g_Info->lpAdapter);
    }

    for (i = 0; i < 6; i++)
        mac->ether_addr_octet[i] = l->g_Info->MAC[i];

    if (gAlloc)
        free(l->g_Info);

    return(mac);
}

struct libnet_link_int *
libnet_open_link_interface(char *device, char *ebuf)
{
 struct libnet_link_int *l;
 DWORD      dwErrorCode;
 NetType type;
 char	err_buf[LIBNET_ERRBUF_SIZE];

 /* initialize memory */
 l = (struct libnet_link_int *)malloc(sizeof (*l));
 if (l == NULL)
  {
   sprintf(ebuf, "malloc: %s", ll_strerror(errno));
   return (NULL);
  }
 memset(l, 0, sizeof (*l));

 l->g_Info=(LPGINFO)calloc(1,sizeof(GINFO));
 if (l->g_Info == NULL)
  {
   sprintf(ebuf, "malloc: %s", ll_strerror(errno));
   free(l);
   return (NULL);
  }

 /* open adapter */
 l->g_Info->lpAdapter = PacketOpenAdapter(device);
 if (!l->g_Info->lpAdapter || (l->g_Info->lpAdapter->hFile == INVALID_HANDLE_VALUE))
  {
   dwErrorCode=GetLastError();
   printf("Unable to open the driver, Error Code : %lx\n",dwErrorCode); 
   free(l->g_Info);
   free(l);
   return FALSE;
  }

 /*get network type*/
 if(PacketGetNetType (l->g_Info->lpAdapter,&type)==FALSE)
  {
   sprintf(ebuf, "Cannot determine the network type");
   free(l->g_Info);
   free(l);
   return (NULL);
  }
 /*Set the linktype*/
 switch (type.LinkType) {

	case NdisMediumWan:
		l->linktype = DLT_EN10MB;
	break;

	case NdisMedium802_3:
		l->linktype = DLT_EN10MB;
	break;

	case NdisMediumFddi:
		l->linktype = DLT_FDDI;
	break;

	case NdisMedium802_5:			
		l->linktype = DLT_IEEE802;	
	break;

	case NdisMediumArcnet878_2:
		l->linktype = DLT_ARCNET;
	break;

	case NdisMediumAtm:
		l->linktype = DLT_ATM_RFC1483;
	break;

	default:
		l->linktype = DLT_EN10MB; 
		/*an unknown adapter is assumed to be ethernet*/
	}
 l->fd = 1;     
 l->linkoffset = 0xe;

 /* copy requiered structures */ 
 strncpy(l->g_Info->Aname,device,512-1); 
 l->device=l->g_Info->Aname;
 libnet_get_ipaddr(l,l->device,&err_buf[0]);
 libnet_get_hwaddr(l,l->device,&err_buf[0]);

 /* adjust the sending buffer, MIGHT be modified when calling pcap */
 PacketSetBuff(l->g_Info->lpAdapter,512000);

 return (l);
}

int
libnet_close_link_interface(struct libnet_link_int *l)
{
 libnet_reset_arp_database(l);
 if (l->g_Info->lpAdapter)
  {
   PacketSetHwFilter(l->g_Info->lpAdapter,NDIS_PACKET_TYPE_ALL_LOCAL);
   PacketCloseAdapter(l->g_Info->lpAdapter);
  }
 free(l->g_Info);
 free(l);	
 return (1);
}

int
libnet_write_link_layer(struct libnet_link_int *l, const char *device,
            u_char *buf, int len)
{
 LPPACKET   lpPacket;
 /* At this point (WdPacket 2.2) the return value of a packet sent is */
 /* true or false, but we'll be ready when that changes, i.e returns length */
 DWORD      BytesTransfered;	

 if((lpPacket = PacketAllocatePacket())==NULL){
      printf("\nError:failed to allocate the LPPACKET structure.");
	return (-1);
    }
  /* send the packet */
 PacketInitPacket(lpPacket,buf,len);
 lpPacket->ulBytesReceived=len; /* BUG IN THE WINPCAP DRIVER FOR WINDOWS 95/98/ME */
 BytesTransfered=PacketSendPacket(l->g_Info->lpAdapter,lpPacket,TRUE);
 PacketFreePacket(lpPacket);
 /* this is not implemented yet, return (BytesTransfered); */
 return(len);
}
