/*
 *  $Id: libnet_resolve.c,v 1.1.1.1 2000/05/25 00:28:49 route Exp $
 *
 *  libnet
 *  libnet_resolve.c - various name resolution type routines
 *
 *  Copyright (c) 1998 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (HAVE_CONFIG_H)
#include "../include/config.h"
#endif
#include "../include/libnet.h"

#if (WIN32 || __linux__)
unsigned long str_to_uint32(char *in)
{
 char Info[11];
 int i;
 Info[0]='0';Info[1]='x';Info[10]='\0';
 for (i=2;i<10;i++) Info[i]=in[i-2];
 return(strtoul(Info,(char **)NULL,16));
}
#endif

u_char *
libnet_host_lookup(u_long in, u_short use_name)
{
    static u_char hostname[512], hostname2[512];
    static u_short which;
    u_char *p;

    struct hostent *host_ent = NULL;
    struct in_addr addr;

    /*
     *  Swap to the other buffer.  We swap static buffers to avoid having to
     *  pass in a char *.  This makes the code that calls this function more
     *  intuitive, but makes this function ugly.  This function is seriously
     *  non-reentrant.  For threaded applications (or for signal handler code)
     *  use host_lookup_r().
     */
    which++;
    
    if (use_name == LIBNET_RESOLVE)
    {
        addr.s_addr = in;
        host_ent = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    }
    if (!host_ent)
    {

        p = (u_char *)&in;
        sprintf(((which % 2) ? hostname : hostname2),  "%d.%d.%d.%d",
                (p[0] & 255), (p[1] & 255), (p[2] & 255), (p[3] & 255));
    }
    else if (use_name == LIBNET_RESOLVE)
    {
        strncpy(((which % 2) ? hostname : hostname2), host_ent->h_name, 
                                                        sizeof(hostname));
    }
    return (which % 2) ? (hostname) : (hostname2);
}


void
libnet_host_lookup_r(u_long in, u_short use_name, u_char *hostname)
{
    u_char *p;
    struct hostent *host_ent = NULL;
    struct in_addr addr;

    if (use_name == LIBNET_RESOLVE)
    {    
        addr.s_addr = in;
        host_ent = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    }
    if (!host_ent)
    {

        p = (u_char *)&in;
        sprintf(hostname, "%d.%d.%d.%d",
                (p[0] & 255), (p[1] & 255), (p[2] & 255), (p[3] & 255));
    }
    else
    {
        /* XXX - sizeof(hostname) == 4 bytes you moron.  FIX THAT. - r */
        strncpy(hostname, host_ent->h_name, sizeof(hostname));
    }
}


u_long
libnet_name_resolve(u_char *host_name, u_short use_name)
{
    struct in_addr addr;
    struct hostent *host_ent; 
    u_long l;
    u_int val;
    int i;
   
    if (use_name == LIBNET_RESOLVE)
    {
        if ((addr.s_addr = inet_addr(host_name)) == -1)
        {
            if (!(host_ent = gethostbyname(host_name)))
            {
                return (-1);
            }
            memcpy((char *)&addr.s_addr, host_ent->h_addr, host_ent->h_length);
        }
        return (addr.s_addr);
    }
    else
    {
        /*
         *  We only want dots 'n decimals.
         */
        if (!isdigit(host_name[0]))
        {
            return (-1L);
        }

        l = 0;
        for (i = 0; i < 4; i++)
        {
            l <<= 8;
            if (*host_name)
            {
                val = 0;
                while (*host_name && *host_name != '.')
                {   
                    val *= 10;
                    val += *host_name - '0';
                    if (val > 255)
                    {
                        return (-1L);
                    }
                    host_name++;
                }
                l |= val;
                if (*host_name)
                {
                    host_name++;
                }
            }
        }
        return (htonl(l));
    }
}


u_long 
libnet_get_ipaddr(struct libnet_link_int *l, const char *device, char *ebuf)
{
#if (WIN32)
 HKEY hKey;
 int nResult,i;
 char path[512];
 char *ip,*gateway;
 char val[100];
 u_long net, mask;
	
 /* first, let's do it "old style" */
 strncpy(path,device,511);
 PacketGetNetInfo(path,&net,&mask);
 l->g_Info->LocalIp=htonl(net); /* THIS IS BUGGY UNDER WINDOWS 95 WITH DHCP */
 l->g_Info->DefaultGateway=htonl((net&mask)+1); /* THIS IS A VERY UGLY GUESS */

 net=mask=i=0;
 /* fill the path with info */
 while(*(device+i)!='\0')
  {
   if(*(device+i)=='_')
    {
     strcpy(path,(device+i+1));	
     break;
    };
   i++;		
  }
 
 /* then try to be smart */
 nResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services",0,KEY_READ,&hKey);
 if( nResult == ERROR_SUCCESS )
  {
   nResult = RegOpenKeyEx(hKey,path,0,KEY_READ,&hKey);
   if( nResult == ERROR_SUCCESS )
    {
     nResult = RegOpenKeyEx(hKey,"Parameters\\Tcpip",0,KEY_READ,&hKey);
     if( nResult == ERROR_SUCCESS )
      {
       DWORD type=REG_DWORD;
       DWORD value;
       DWORD size=4;
       nResult=RegQueryValueEx(hKey,"EnableDHCP",0,&type,
       (LPBYTE)&value,&size);							
       if( nResult == ERROR_SUCCESS )
	{
	 if(value==1)
	  {
	   /* DHCP is used */
	   ip="DhcpIPaddress";
	   gateway="DhcpDefaultGateway";
	  }
	 else
	  {
	   ip="IPaddress";
	   gateway="DefaultGateway";
	  };
 	 type=REG_SZ;
	 size=100;

	 /* get our IP */
	 nResult=RegQueryValueEx(hKey,ip,0,&type,(LPBYTE)val,&size);	
	 if( nResult == ERROR_SUCCESS ) l->g_Info->LocalIp=inet_addr(val);
	 else sprintf(ebuf,"Error while getting own IP from registry\n");

 	 /* get gateway */
	 size=100;
	 nResult=RegQueryValueEx(hKey,gateway,0,&type,(LPBYTE)val,&size);	
	 if( nResult == ERROR_SUCCESS ) l->g_Info->DefaultGateway=inet_addr(val);
 	 else sprintf(ebuf,"Error while getting default gateway from registry\n");
	}
     }
   }
 }
return(ntohl(l->g_Info->LocalIp));	
#else
    struct ifreq ifr;
    register struct sockaddr_in *sin;
    int fd;
    FILE *froute;
    char route_elem0[32],route_elem1[32];     

    /*
     *  Create dummy socket to perform an ioctl upon.
     */
    fd = socket(PF_INET, SOCK_DGRAM, 0);
    if (fd < 0)
    {
        sprintf(ebuf, "socket: %s", strerror(errno));
        return (0);
    }

    memset(&ifr, 0, sizeof(ifr));
    sin = (struct sockaddr_in *)&ifr.ifr_addr;
    strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));

    ifr.ifr_addr.sa_family = AF_INET;

    if (ioctl(fd, SIOCGIFADDR, (char*) &ifr) < 0)
    {
        close(fd);
        return(0);
    }
    close(fd);
#if (__linux__)
    /*
     * 	Fill in the Default gateway info
     */
    froute=fopen("/proc/net/route","r");  /* Open file */
    l->g_Info->DefaultGateway=0;

    if (!froute) 
     {
 	sprintf(ebuf,"Error while getting default gateway from /proc/net/route \n");
	return (ntohl(sin->sin_addr.s_addr));
     };

    rewind(froute);
    memset(&route_elem0[0],'\0',32);

    while (fscanf(froute,"%32s",&route_elem1[0])!=EOF)
     {    
      if( (!strcmp(&route_elem0[0],device)) && (!strcmp(&route_elem1[0],"00000000")) )
       {
        if (fscanf(froute,"%32s",&route_elem1[0])!=EOF)
	   {
          l->g_Info->DefaultGateway=str_to_uint32(&route_elem1[0]);
	    break;	   	
	   }
        else
         { 
 	    sprintf(ebuf,"Error while reading gateway file \n");
	    break;	   	
         }
       }
      memcpy(&route_elem0[0],&route_elem1[0],32);
     }

    if (!l->g_Info->DefaultGateway)
 	sprintf(ebuf,"Error while getting default gateway, no match found \n");

    fclose(froute);
#endif /* Linux */
    return (ntohl(sin->sin_addr.s_addr));
#endif
}

/*
 *  get_hwaddr routine moved to arch specifc files (sockpacket.c, bpf.c, etc)
 */

/* EOF */
