#include <libnet.h>
#include <pcap.h>

#define IP_UCHAR_COMP(x, y) \
    (x[0] == y[0] && x[1] == y[1] && x[2] == y[2] && x[3] == y[3])


u_char enet_dst[6] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

int libnet_do_arp(struct libnet_link_int *, u_char *, struct ether_addr *, u_long);

void printHelp(void)
{
   printf(" <prg> <ip> <device> : get mac of ip via the selected device\n");
   printf(" ex : test3 192.168.0.1 \\Device\\Packet_{D3E44C52-B8E7-A4E3-A258-5F5ECEF1234}\n");
   exit(EXIT_FAILURE);
}

int main(int argc, char *argv[])
{
    int i;
    char errbuf[256];
    char *device;
    struct libnet_link_int *l;
    unsigned char *mac;
    u_long ip;

    if (argc<3) printHelp();
    else printf("resolving MAC for %s via %s \n",argv[1],argv[2]);

    if ((ip = libnet_name_resolve(argv[1], 1)) == -1)
        {
            fprintf(stderr, "Cannot resolve IP address\n");
            exit(EXIT_FAILURE);
        }
   
    device=argv[2];
    l = libnet_open_link_interface(device, errbuf);
    if (!l)
    {
        fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
        exit(EXIT_FAILURE);
    }
    else printf("Link opened \n");
		
    mac=libnet_get_remote_mac(ip,l);

    printf("Ip MAC : ");
        for (i = 0; i < 6; i++)
        {
            printf("%x", mac[i]);
            if (i != 5)
            {
                printf(":");
            }
        }
        printf("\n");

    return (mac == NULL ? EXIT_FAILURE : EXIT_SUCCESS);
}