/*
 * This file is part of the MGUI (MORELLO Graphic User Interface)
 * development tool.
 * Cointains all MGUI function prototypes
 */


#ifndef _MGUI_H
#define _MGUI_H

#include "mguidefs.h"

#ifdef __cplusplus
extern "C" {
#endif

void	MGUIMain(int argc, char **argv);

int	MPaletteMode(void);
int	MGetScreenWidth(void);
int	MGetScreenHeight(void);
int	MGetNPlanes(void);
long	MGetNColors(void);
MTColor	MBlackColor(void);
MTColor	MWhiteColor(void);

char	*MGetSysDir(void);

void	MEnableCustomizing(void);

char	*MGetStringOption(const char *obj_name, const char *opt_name);
char	*MGetTextOption(const char *obj_name);
int	MGetIntOption(const char *obj_name, const char *opt_name, int *ret);
int	MGetFontOption(const char *obj_name, MTFont *ret);
int	MGetBGColorOption(const char *obj_name, int *pr, int *pg, int *pb);
int	MGetFGColorOption(const char *obj_name, int *pr, int *pg, int *pb);
int	MGetShadowOption(const char *obj_name, int *shadow, int *i_t, int *o_t);

void	MSetTextOption(const char *obj_name, const char *text);
void	MSetIntOption(const char *obj_name, const char *rname, int val);
void	MSetFGColorOption(const char *obj_name, int r, int g, int b);
void	MSetBGColorOption(const char *obj_name, int r, int g, int b);
void	MSetShadowOption(const char *obj_name, int shadow, int in_t, int out_t);
void	MSetFontOption(const char *obj_name, MTFont font);
void	MSaveOptions(void);

void	MMainLoop(void);
void	MLoopWhileFlag(int *pflag, int value);
void	MLoopWhileEvents(int discard);
void	MNextEvent(MEvent *pe, int wait);
void	MProcessEvent(MEvent *pe);
void	MGUITerm(void);

MTCursor MCreateCursor(MIMAGE bits, int xs, int ys);
MTFont	MLoadFont(const char *family, int h, int bold, int italic);
void	MUnloadFont(MTFont font);

int     MTextCharX(const char *text, MTFont font, int x);
int     MTextHeight(const char *text, MTFont font);
int     MCharHeight(char car, MTFont font);
int     MTextWidth(const char *text, MTFont font);
int     MTextNWidth(const char *text, MTFont font, int len);
int     MCharWidth(char car, MTFont font);

void    MBeep(void);

MTColor	MAllocColor(int r, int g, int b);
MTColor	MAllocShiftColor(MTColor col, int shift);
void	MFreeColor(MTColor col);
MTColor	MAllocCell(int r, int g, int b);
void	MSetCellColor(MTColor c, int r, int g, int b);
void    MFreeCell(MTColor c);
void    MQueryColor(MTColor col, int *pr, int *pg, int *pb);

int	MGetKeyboardState(void);

void MGetDefaultBackgroundRGB(int *pr, int *pg, int *pb);
void MSetDefaultBackgroundRGB(int r, int g, int b);
void MGetDefaultForegroundRGB(int *pr, int *pg, int *pb);
void MSetDefaultForegroundRGB(int r, int g, int b);
MTColor  MAllocDefaultBackgroundColor(void);

/* MIMAGE */

MIMAGE MAllocImage(int img_w, int img_h, int nplanes);
MIMAGE MReadBMPFile(const char *fname);
MIMAGE MReadTIFFFile(const char *fname);
MIMAGE MReadJPEGFile(const char *fname);
MIMAGE MReadGIFFile(const char *fname);
int MWriteTIFFFile(MIMAGE img, const char *name, int compression);
int MWriteBMPFile(MIMAGE img, const char *fname);
int MWriteJPEGFile(MIMAGE img, const char *name, int quality);

void	MFreeImage(MIMAGE data);
void	MInstallImage(MIMAGE data);
void	MUninstallImage(MIMAGE data);
void	MImageGetInfo(MIMAGE pmi, int *pw, int *ph, int *pnplanes);
void	MImageGetPixelRGB(MIMAGE pmi, int x, int y, int *pr, int *pg, int *pb);
void	MImageSetPixelRGB(MIMAGE pmi, int x, int y, int r, int g, int b);
int	MImageGetPixelIndex(MIMAGE pmi, int x, int y);
void	MImageSetPixelIndex(MIMAGE pmi, int x, int y, int i);
void	MImageGetCMapEntry(MIMAGE pmi, int i, int *pr, int *pg, int *pb);
void	MImageSetCMapEntry(MIMAGE pmi, int i, int r, int g, int b);


/* MLOG */

void	MLogInit(int level, int nr, int nvr, int nc, int nvc, const char *fname);
void	MLog(int level, const char *fmt, ...);
void	MMaskedLog(int level, CARD32 mask, const char *fmt, ...);
void	MLogSetLevel(int level);
void	MLogSetMask(CARD32 a);
CARD32	MLogGetMask(void);
void	MLogSetMaskBits(CARD32 a);
void	MLogResetMaskBits(CARD32 a);
void	Trace(const char *fmt,...);

/* SPOOL */

int	MSpoolFile(const char *fname);
int	MSpoolTempFile(const char *fname);


void MDrawText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, MTColor fgc, int align);
void MDrawNText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, MTColor fgc, int align, int n);
void MDrawBGText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, MTColor bgc, MTColor fgc, int align);
void MDrawBGNText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, MTColor bgc, MTColor fgc, int align, int n);
void MDrawShadowedText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, int sh, MTColor fgc1, MTColor fgc2, int align);
void MDrawShadowedNText(MOBJECT p, int x, int y, int w, int h, const char *text,
		MTFont font, int sh, MTColor fgc1, MTColor fgc2, int align, int n);

void MDrawPoint(MOBJECT p, int x, int y, MTColor col);
void MDrawLine(MOBJECT p, int x1, int y1, int x2, int y2, MTColor col);
void MDrawPolyline(MOBJECT p, MPOINT *points, int n, MTColor col);
void MDrawFilledPolyline(MOBJECT p, MPOINT *points, int n, MTColor col);
void MDrawBox(MOBJECT p, int x, int y, int w, int h, MTColor bgc);
void MDrawFilledBox(MOBJECT p, int x, int y, int w, int h, MTColor bgc);
void MDrawCircle(MOBJECT p, int x, int y, int r, MTColor col);
void MDrawFilledCircle(MOBJECT p, int x, int y, int r, MTColor col);
void MDrawArc(MOBJECT p, int x, int y, int r, int a1, int a2, MTColor col);
void MDrawFilledArc(MOBJECT p, int x, int y, int r, int a1, int a2, MTColor c);
void MDrawImage(MOBJECT p, MIMAGE gi, int pm_x, int pm_y, int w, int h,
		int x, int y);
void MDrawXorLine(MOBJECT p, int x1, int y1, int x2, int y2);
void MDrawXorBox(MOBJECT p, int x, int y, int w, int h);

/* Generic Object routines */

void MObjectSetUnsensitive(MOBJECT obj);
void MObjectSetSensitive(MOBJECT obj);
void MObjectSetSensitivity(MOBJECT obj, int status);
int MObjectGetSensitivity(MOBJECT obj);

void MObjectSetUnselectable(MOBJECT obj);
void MObjectSetSelectable(MOBJECT obj);

char *MObjectGetText(MOBJECT obj, char *text);
void MObjectSetText(MOBJECT obj, const char *text);
char *MObjectGetName(MOBJECT obj);
void MObjectSetName(MOBJECT obj, const char *name);
void MObjectSetColor(MOBJECT obj, MTColor bgc, MTColor fgc);
MTColor MObjectBackgroundColor(MOBJECT obj);
MTColor MObjectForegroundColor(MOBJECT obj);
void MObjectSetBackgroundRGB(MOBJECT obj, int r, int g, int b);
void MObjectSetForegroundRGB(MOBJECT obj, int r, int g, int b);
MTFont	MObjectGetFont(MOBJECT obj);
void MObjectSetFont(MOBJECT obj, MTFont font, int resize);
void MObjectGetShadow(MOBJECT obj, int *type, int *in, int *out);
void MObjectSetShadow(MOBJECT obj, int type, int in, int out);
void MObjectSetResize(MOBJECT obj, int resize_w, int resize_h);
void MObjectSetCursor(MOBJECT obj, MTCursor cursor);
void MObjectEnableOptions(MOBJECT obj, const char *name, CARD32 mask);
void MObjectSaveOptions(MOBJECT obj);
CARD32 MObjectGetEnabledOptions(MOBJECT obj);

void MObjectRedraw(MOBJECT obj);
void MObjectMap(MOBJECT obj);
void MObjectUnmap(MOBJECT obj);
void MObjectResize(MOBJECT obj, int w, int h);
void MObjectDestroy(MOBJECT obj);

void MDispatchObjEvent(MOBJECT p, MEvent *pe);
void MObjectAddEventNotifyCallback(MOBJECT obj, OBJ_EVENT_CB cb, CARD32 event_mask, void *a_data);
void MObjectAddDestroyCallback(MOBJECT obj, MGUI_CB cb, void *a_data);
void MObjectRemoveEventNotifyCallback(MOBJECT obj, OBJ_EVENT_CB cb, void *a_data);
void MObjectRemoveDestroyCallback(MOBJECT obj, MGUI_CB cb, void *a_data);
void MObjectSetPopupHelp(MOBJECT obj, const char *str, int delay, int duration);
void MObjectSetLabelHelp(MOBJECT obj, const char *str, MOBJECT label);
void MObjectChangePopupHelpText(MOBJECT obj, const char *str);
void MObjectChangeLabelHelpText(MOBJECT obj, const char *str);

void *MObjectGetUserData(MOBJECT obj);
void MObjectSetUserData(MOBJECT obj, void *ud);
int  MObjectType(MOBJECT obj);
int  MObjectWidth(MOBJECT obj);
int  MObjectHeight(MOBJECT obj);
int  MObjectX(MOBJECT obj);
int  MObjectY(MOBJECT obj);
void MObjectSetWidth(MOBJECT obj, int w);
void MObjectSetHeight(MOBJECT obj, int h);
MOBJECT MObjectParent(MOBJECT obj);
MOBJECT MObjectGetVScrollBar(MOBJECT obj);
MOBJECT MObjectGetHScrollBar(MOBJECT obj);


/* PIXMAP */

MOBJECT MCreatePixmapFromData(MOBJECT parent, MIMAGE data);
MOBJECT MCreatePixmapFromFile(MOBJECT parent, const char *fname);
void	MPixmapSetImage(MOBJECT pixmap, MIMAGE gi);
void	MPixmapSetImageFile(MOBJECT pixmap, const char *fname);
MIMAGE  MPixmapGetImage(MOBJECT pixmap);


/* SHELL */

MOBJECT MCreateShell(const char *title, int flags);
MOBJECT MObjectShell(MOBJECT obj);
Window  MShellGetWindow(MOBJECT s);
void    MShellDestroy(MOBJECT obj);
void MShellSetTitle(MOBJECT obj, const char *title);
void MShellGetTitle(MOBJECT obj, char *title);
void MShellRealize(MOBJECT obj);
void MShellRealizeXY(MOBJECT obj, int x, int y);
void MShellRealizeXYWH(MOBJECT obj, int x, int y, int w, int h);
void MShellUnrealize(MOBJECT obj);
void MShellSetWMCloseCallback(MOBJECT p, WM_CLOSE_CB cb, void *a_data);
void MShellRaise(MOBJECT obj);
void MShellConfigure(MOBJECT obj, int x, int y, int w, int h);


/* FORM */

MOBJECT MCreateRowForm(MOBJECT parent);
MOBJECT MCreateColForm(MOBJECT parent);
MOBJECT MCreatePagedForm(MOBJECT parent, int npage);
MOBJECT MCreatePagedRowForm(MOBJECT parent, int npage);
MOBJECT MCreatePagedColForm(MOBJECT parent, int npage);
MOBJECT MCreatePagedFormExt(MOBJECT parent, int npage);
MOBJECT MCreatePagedRowFormExt(MOBJECT parent, int npage);
MOBJECT MCreatePagedColFormExt(MOBJECT parent, int npage);
MOBJECT MCreateScrolledForm(MOBJECT parent, int clip_w, int clip_h);
MOBJECT MCreateClippedForm(MOBJECT parent, int clip_w, int clip_h);
void    MFormSetSpacing(MOBJECT p, int offset);
void    MFormSetChildSelectCallback(MOBJECT p, OBJ_VALUE_CB cb, void *data);
void	MScrolledFormSetIncr(MOBJECT obj, int h_inc, int v_inc);
MOBJECT MGetSelectedObject(MOBJECT f);
void    MSelectObject(MOBJECT f);
int	MSelectFirstChild(MOBJECT f);
int	MSelectLastChild(MOBJECT f);
void	MSelectNextBrother(MOBJECT f);
void	MSelectPreviousBrother(MOBJECT f);
void	MSelectNextCousin(MOBJECT p);
void	MSelectPreviousCousin(MOBJECT p);
void    MFormSetPrefAtt(MOBJECT p, int pref_att);
void    MTopAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MBottomAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MRightAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MLeftAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MFormSetFocusWrap(MOBJECT f, int true_false);
void 	MFormSetFocusHighlight(MOBJECT f, int true_false);
void    MFormFocusLink(MOBJECT obj1, MOBJECT obj2);
void    MPagedFormSetActivePage(MOBJECT form, int page);
void    MFormSetClipX(MOBJECT obj, int clip_x);
void    MFormSetClipY(MOBJECT obj, int clip_y);
int	MFormGetClipX(MOBJECT obj);
int	MFormGetClipY(MOBJECT obj);
void    MFormAddKeyCallback(MOBJECT shell, int key, OBJ_VALUE_CB cb, void *ad);
MOBJECT MFormGetFirstChild(MOBJECT form);
MOBJECT MFormGetNextChild(MOBJECT form);
int     MFormGetNChildren(MOBJECT form);
void	MInsertObject(MOBJECT parent, MOBJECT obj, MOBJECT where, int resize);
void	MDeleteObject(MOBJECT obj, int resize);
void	MReparentObject(MOBJECT parent, MOBJECT obj, MOBJECT where);
void	MObjectSetAttachment(MOBJECT obj, int top, int bot, int left, int rig);
void	MObjectSetOffset(MOBJECT obj, int t_o, int b_o, int l_o, int r_o);
void	MObjectAlign(MOBJECT obj, int h_align, int v_align);

MOBJECT MCreateTableForm(MOBJECT parent, int n_cols);
void MTableFormShowGrid(MOBJECT form);
void MTableFormHideGrid(MOBJECT form);
void MTableFormSetRowHeight(MOBJECT form, int row, int h);
void MTableFormSetColWidth(MOBJECT form, int col, int w);
void MTableFormSetColFont(MOBJECT form, int col, MTFont f);
void MTableFormSetColAlign(MOBJECT form, int col, int al);
void MTableFormSetRowAlign(MOBJECT form, int row, int al);
void MTableFormSetColBackgroundRGB(MOBJECT form, int col, int r, int g, int b);
void MTableFormSetColForegroundRGB(MOBJECT form, int col, int r, int g, int b);
void MTableFormSetCellText(MOBJECT form, int x, int y, const char *text);
void MTableFormGetCellText(MOBJECT form, int x, int y, char *text);
void MTableFormSetCellFont(MOBJECT form, int x, int y, MTFont f);
void MTableFormSetCellAlign(MOBJECT form, int x, int y, int h_al, int v_al);
void MTableFormSetCellBackgroundRGB(MOBJECT form, int x, int y, int r, int g, int b);
void MTableFormSetCellForegroundRGB(MOBJECT form, int x, int y, int r, int g, int b);
MOBJECT MTableFormGetCellObject(MOBJECT form, int x, int y);
void MTableFormSetNCol(MOBJECT form, int nc);
int  MTableFormGetNCol(MOBJECT form);

/* DRAWAREA */

MOBJECT MCreateDrawArea(MOBJECT parent, int width, int height);
void    MDrawAreaSetExposeCallback(MOBJECT obj, OBJ_EVENT_CB cb, void *ad);
void    MDrawAreaSetInputCallback(MOBJECT obj, OBJ_EVENT_CB cb, void *ad);
void    MDrawAreaSetResizeCallback(MOBJECT obj, DRAWAREA_PREF_CB cb, void *ad);


/* LABEL */

MOBJECT MCreateLabel(MOBJECT parent, const char *text, MTFont font);
void	MLabelSetMargin(MOBJECT p, int wm, int hm);
void	MLabelSetHSpacing(MOBJECT p, int hs);
void	MLabelSetAlignment(MOBJECT p, int align);
const char *MLabelValue(MOBJECT label);


/* PBUTTON */

MOBJECT MCreateDrawnPButton(MOBJECT parent, MIMAGE pn, MIMAGE pa, MIMAGE pu);
MOBJECT MCreateImagePButton(MOBJECT parent, const char *npf, const char *apf, const char *upf);
MOBJECT MCreatePButton(MOBJECT parent, const char *text, MTFont font);
void    MPButtonSetCallback(MOBJECT button, MGUI_CB cb, void *data);
void    MPButtonSetAccelerator(MOBJECT button, int key);
void    MPButtonSetRepeatDelay(MOBJECT button, int first, int repeat);
void    MPButtonSetMargin(MOBJECT p, int wm, int hm);
void	MPButtonSetHSpacing(MOBJECT p, int hs);
void	MPButtonSetAlignment(MOBJECT p, int align);
void	MPButtonSetImage(MOBJECT obj, const char *npf, const char *apf, const char *upf);


/* RBUTTON */

MOBJECT MCreateDrawnRButton(MOBJECT parent, MIMAGE np, MIMAGE ap, MIMAGE up);
MOBJECT MCreateImageRButton(MOBJECT parent, const char *npf, const char *apf, const char *upf);
MOBJECT MCreateRButton(MOBJECT parent, const char *text, MTFont font);
void	MRButtonActivate(MOBJECT o);
void	MRButtonDeactivate(MOBJECT o);
void	MRButtonSetCallback(MOBJECT button, OBJ_VALUE_CB cb, void *data);
int	MRButtonGetActivationStatus(MOBJECT o);
void	MRButtonSetImage(MOBJECT obj, const char *npf, const char *apf, const char *upf);


/* TBUTTON */

MOBJECT MCreateDrawnTButton(MOBJECT parent, MIMAGE np, MIMAGE ap, MIMAGE up);
MOBJECT MCreateImageTButton(MOBJECT parent, const char *npf, const char *apf, const char *upf);
MOBJECT MCreateTButton(MOBJECT parent, const char *text, MTFont font);
void	MTButtonActivate(MOBJECT o);
void	MTButtonDeactivate(MOBJECT o);
void	MTButtonSetCallback(MOBJECT button, OBJ_VALUE_CB cb, void *data);
void	MTButtonSetActivationStatus(MOBJECT o, int status);
int	MTButtonGetActivationStatus(MOBJECT o);
void	MTButtonSetImage(MOBJECT obj, const char *npf, const char *apf, const char *upf);


/*STATUSBAR */

MOBJECT MCreateStatusBar(MOBJECT parent, const char *text, int max, MTFont font);
void    MStatusBarSetMax(MOBJECT p, int max);
void    MStatusBarSetWidth(MOBJECT p, int width);
void    MStatusBarSetPos(MOBJECT p, int pos);


/* SCROLLBAR */

MOBJECT MCreateScrollBar(MOBJECT parent, int type, long n, long max);
void    MScrollBarSetMax(MOBJECT p, long max);
void    MScrollBarSetPos(MOBJECT p, long pos);
void    MScrollBarSetN(MOBJECT p, long n);
void    MScrollBarSetIncr(MOBJECT p, int incr);
void    MScrollBarSetPosCallback(MOBJECT p, OBJ_VALUE_CB cb, void *data);
void	MScrollBarSetValues(MOBJECT p, long max, long n, long pos);
long    MScrollBarGetMax(MOBJECT p);
long    MScrollBarGetPos(MOBJECT p);
long    MScrollBarGetN(MOBJECT p);


/* SBLIST */

MOBJECT MCreateSText(MOBJECT parent, const char *text, MTFont font,
		int nrow, int ncol);
MOBJECT MCreateSTextClip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		MTFont font, int nrow, int ncol, int xc, long xn);
MOBJECT MCreateSFile(MOBJECT parent, const char *fname, MTFont font,
		int nrow, int ncol);
MOBJECT MCreateSList(MOBJECT parent, MTFont font, int row_len,
		int nrow, int ncol);
MOBJECT MCreateSListMultiSel(MOBJECT parent, MTFont font,
		int row_len, int nrow, int ncol);
MOBJECT MCreateSListClip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		ITEM_SEEK_CB is, void *isd, MTFont font,
		int nrow, int ncol, int xc, long xn);
MOBJECT MCreateSListSkip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		ITEM_SEEK_CB is, void *isd, MTFont font,
		int nrow, int ncol, int xc);

MOBJECT MCreateEditList(MOBJECT parent, MTFont font, EL_TEMPLATE *elt,
		int ne, int nrow, int ncol);

LIST_ACT *MSListGetFirstItem(MOBJECT p);
LIST_ACT *MSListGetFirstSelectedItem(MOBJECT p);
LIST_ACT *MSListGetNextItem(MOBJECT p);
LIST_ACT *MSListGetNextSelectedItem(MOBJECT p);
LIST_ACT *MSListGetFirstUnselectedItem(MOBJECT p);
LIST_ACT *MSListGetNextUnselectedItem(MOBJECT p);
long MSListGetNItem(MOBJECT p);

void MSListSelectItem(MOBJECT p, const char *item);
void MSListDeselectItem(MOBJECT p, const char *item);
void MSListSelectElement(MOBJECT p, long n);
void MSListDeselectElement(MOBJECT p, long n);
void    MSListClear(MOBJECT p);
int     MSListAddItem(MOBJECT p, const char *item, void *data);
int     MSListDelItem(MOBJECT p, const char *item);
int     MSListAddElement(MOBJECT p, long n, const char *item, void *data);
int     MSListDelElement(MOBJECT p, long n);
void    MSListChangeItem(MOBJECT p, const char *old, const char *new_item, void *u_data);
void    MSListChangeElement(MOBJECT p, long n, const char *new_item, void *u_data);
LIST_ACT *MSListGetItem(MOBJECT p, const char *item);
LIST_ACT *MSListGetElement(MOBJECT p, long n);
LIST_ACT *MSListGetSelected(MOBJECT p);
void    MSListSetCallback(MOBJECT obj, LIST_ACT_CB cb, void *data);
void	MSListSetPickCallback(MOBJECT obj, LIST_ACT_CB cb, void *value);
void    MSListSetSelectionCallback(MOBJECT obj, LIST_SEL_CB cb, void *data);
void    MSListSetSortCallback(MOBJECT obj, STRCMP_CB cb);
void    MSListFreeze(MOBJECT obj);
void    MSListThaw(MOBJECT obj);
void    MSBLSetHead(MOBJECT obj, const char *text);
void    MSBLGetHead(MOBJECT obj, char *buff);
void    MSBLHeadSetColor(MOBJECT obj, MTColor bgc, MTColor fgc);

void    MSTextSetString(MOBJECT p, const char *text);

void    MSFileSetFile(MOBJECT obj, const char *fname);

void    MSBLSetHMargin(MOBJECT p, int hm);

int     MEditListAddItem(MOBJECT p, char **argv, void *u_data);
void    MEditListChangeElement(MOBJECT p, long n, char **new_ele, void *data);
void    MEditListDelElement(MOBJECT p, long n);
void    MEditListSeekItem(MOBJECT p, char **argv, long *pos, void **u_data);
void    MEditListGetItemField(MOBJECT el, const char *item, int ii, char *buff);

int	MEditListAddItemFromEdits(MOBJECT p, void *u_data);
void	MEditListGetEditText(MOBJECT p, int n, char *buff);
void	MEditListSetEditText(MOBJECT p, int n, const char *buff);

int     MSListGetItemCheckStatus(MOBJECT p, const char *item);
void    MSListSetItemCheckStatus(MOBJECT p, const char *item, int status);
void	MSListReset(MOBJECT p);
void	MSListEnableMultiSel(MOBJECT obj);


/* EDIT */

MOBJECT MCreateClippedEdit(MOBJECT parent, const char *text, int len, int clip_len,
		MTFont font);
MOBJECT MCreateEdit(MOBJECT parent, const char *text, int len, MTFont font);
MOBJECT MCreateClippedHiddenEdit(MOBJECT parent, const char *text, int len, int clip_len,
		MTFont font, char shown_char);
MOBJECT MCreateHiddenEdit(MOBJECT parent, const char *text, int len, MTFont font,
		char shown_char);
void MEditSetMargin(MOBJECT edit, int w_margin, int h_margin);
void MEditSetFilter(MOBJECT edit, int filter, const char *extra_chars);

MOBJECT MCreateClippedMLEdit(MOBJECT parent, const char *text,
		int width, int height, MTFont font);
MOBJECT MCreateScrolledMLEdit(MOBJECT parent, const char *text,
		int width, int height, MTFont font);

void	MEditChangeText(MOBJECT edit, int off, int len, const char *new_t, int chg_len);
void	MEditGetSubString(MOBJECT edit, int start, int end, char *str);
int	MEditFindSubStringForward(MOBJECT edit, int off, const char *str, int icase);
int	MEditFindSubStringBackward(MOBJECT edit, int off, const char *str, int icase);
void	MEditSetSelection(MOBJECT edit, int start, int end);
void	MEditGetSelection(MOBJECT edit, int *pstart, int *pend);
void	MEditSetCursorPos(MOBJECT edit, int pos);
int	MEditGetCursorPos(MOBJECT edit);
void	MEditSetCursorXY(MOBJECT edit, int x, int y);
void	MEditGetCursorXY(MOBJECT edit, int *px, int *py);
void	MEditSetAutoIndent(MOBJECT edit, int on_off);
void	MEditSetTabSize(MOBJECT edit, int size);
void	MEditSetClipWindow(MOBJECT edit, int clip_w, int clip_h);

void	MEditSetCursorPosCallback(MOBJECT edit, EDIT_CURS_CB cb, void *data);

void MEditSetTextExt(MOBJECT edit, const char *text, int validated, int notify);
void MEditSetActCallback(MOBJECT edit, OBJ_STRING_CB cb, void *data);
void MEditSetValCallback(MOBJECT edit, EDIT_VAL_CB cb, void *data);
void MEditSetValueChangeCallback(MOBJECT edit, EDIT_CHANGE_CB cb, void *data);
void MEditSetNewValueCallback(MOBJECT edit, OBJ_STRING_CB cb, void *data);
void MEditSetHotKeyCallback(MOBJECT edit, int key, MGUI_CB cb, void *data);
void MEditSetValidatedColors(MOBJECT edit, MTColor bg_color, MTColor fg_color);
void MEditSetNotValidatedColors(MOBJECT edit, MTColor bgc, MTColor fgc);
void MEditSetValidationStatus(MOBJECT edit, int validated);
void MEditSetReplace(MOBJECT edit);
int MIsEditValidated(MOBJECT p);
int MEditGetFilter(MOBJECT p);
const char *MEditValue(MOBJECT edit);
void MEditHide(MOBJECT edit, char shown_char);
void MEditUnhide(MOBJECT edit);


/* OPTIONEDIT */

MOBJECT MCreateOptionEdit(MOBJECT parent, const char *text, int len, int clip_len,
		int nrow, MTFont font);
MOBJECT MOptionEditGetList(MOBJECT ce);


/* MENU */

MOBJECT MCreateMenuBar(MOBJECT parent, MTFont font);
MOBJECT MCreateMenu(MOBJECT menu, const char *text);
MOBJECT MCreateSubMenu(MENU_ITEM item);
MOBJECT MCreatePopupMenu(MTFont font);
void MDestroyMenu(MOBJECT menu);
MENU_ITEM MMenuAddItemObsolete(MOBJECT pd, const char *item, MGUI_CB cb, void *ad);
MENU_ITEM MMenuAddItem(MOBJECT pd, const char *item, MENU_ITEM_CB cb, void *ad);
MENU_ITEM MMenuAddRadioItem(MOBJECT pd, const char *item, MENU_ITEM_CB cb, void *ad);
MENU_ITEM MMenuAddToggleItem(MOBJECT pd, const char *item, MENU_ITEM_CB cb, void *ad);
MENU_ITEM MMenuAddSeparator(MOBJECT pd);
void MPopupMenu(MOBJECT pm, int x, int y);
void MMenuSetTitleText(MOBJECT pd, const char *text);
void MMenuItemSetText(MENU_ITEM item, const char *text);
void MMenuItemSetAccel(MENU_ITEM item, int acc, const char *at);
void MMenuItemSetSensitive(MENU_ITEM item);
void MMenuItemSetUnsensitive(MENU_ITEM item);
void MMenuItemSetSelectCB(MOBJECT p, MGUI_CB cb, void *ad);
void MMenuBarSetAcc(MOBJECT menu, int acc);
const char *MMenuItemGetText(MENU_ITEM item);
const char *MMenuGetTitleText(MOBJECT obj);
int     MMenuItemSetCheckStatus(MENU_ITEM item, int TrueFalse);
int     MMenuItemGetCheckStatus(MENU_ITEM item);
int     MMenuItemToggleCheckStatus(MENU_ITEM item);
MOBJECT MMenuItemGetMenu(MENU_ITEM item);


/* MGUIUTIL */

int MMessageDialog(const char *t, const char *msg, const char *btn1, const char *btn2, ...);
int MInputPrompt(const char *t, const char *msg, char *text, int len, const char *ok_btn,
	const char *canc_btn);
char *MTextPrompt(const char *t, const char *msg, const char *text, int w, int h, const char *ok,
	const char *cancel);

void	MSetInputPromptRGB(int r, int g, int b);
void	MSetMessageDialogRGB(int r, int g, int b);
void	MSetFileSelectionRGB(int r, int g, int b);
void	MGetInputPromptRGB(int *pr, int *pg, int *pb);
void	MGetMessageDialogRGB(int *pr, int *pg, int *pb);
void	MGetFileSelectionRGB(int *pr, int *pg, int *pb);

/* FSEL */

int MFileSelection(const char *title, char *filter, char *fname, char *dname,
		int change_cur_dir);
char *MGetCurrentDirectory(void);


/* Timeout */

TIMEOUT_ID MAddTimeout(CARD32 tmout, TIMEOUT_CB cb, void *ud);
void MRemoveTimeout(TIMEOUT_ID id);
void MCallAllTimeoutCallbacks(void);
void MRefreshTimeout(TIMEOUT_ID *pid, CARD32 msec, TIMEOUT_CB cb, void *ud);
void MClearTimeout(TIMEOUT_ID *pid);
void MCallExpiredTimeoutCallbacks(void);

/* File values read/write */

void MWriteCARD8(FILE *fp, CARD8 val);
void MWriteCARD16(FILE *fp, CARD16 val);
void MWriteCARD32(FILE *fp, CARD32 val);
CARD8 MReadCARD8(FILE *fp);
CARD16 MReadCARD16(FILE *fp);
CARD32 MReadCARD32(FILE *fp);

/*
 *  Graphic printing currently works only under Windows
 */

#ifdef WIN_MGUI

DOC_ID MOpenPrintDoc(char *doc_name, int open_dialog, int orientation, MPAGE_OPTIONS *pages);
void MClosePrintDoc(DOC_ID id);
void MPrintDocNextPage(DOC_ID id);
void MPrintObject(MOBJECT obj, DOC_ID id, MPRINT_OPTIONS *po);
void MPrintImage(MIMAGE mpm, int full);
int MPrintSetup(int orientation, int *xres, int *yres, int *pwidth, int *pheight, int *nplanes);

#endif /* WIN_MGUI */

/*
 * for backwards compatibility... (release > 1.8.0)
 */
#ifdef OLD_MGUI

#define PULLDOWN_ITEM	MENU_ITEM
#define OT_PULLDOWN	OT_MENU
#undef OT_MENU
#define OT_MENU		OT_MENUBAR

#define MCreatePullDown(menubar, text) \
	MCreateMenu(menubar, text)
#define MCreateSubPullDown(pd, item) \
	MCreateSubMenu(item)
#define MCreatePopupPullDown(font) \
	MCreatePopupMenu(font)
#define MPullDownAddItem(pm, t, c, d) \
	MMenuAddItemObsolete(pm, t, c, d)
#define MPopupPullDown(pm, x, y) \
	MPopupMenu(pm, x, y)
#define MPullDownSetTitleText(pd, text) \
	MMenuSetTitleText(pd, text)
#define MPullDownSetItemText(pd, item, text) \
	MMenuItemSetText(item, text)
#define MPullDownSetItemAccel(pd, item, acc, at) \
	MMenuItemSetAccel(item, acc, at)
#define MPullDownSetItemSensitive(pd, item) \
	MMenuItemSetSensitive(item)
#define MPullDownSetItemUnsensitive(pd, item) \
	MMenuItemSetUnsensitive(item)
#define MPullDownSetItemSelectCB(p, cb, ad) \
	MMenuItemSetSelectCB(p, cb, ad)
#define MMenuSetAcc(menu, acc) \
	MMenuBarSetAcc(menu, acc)
#define MPullDownSetItemCallback(pdm, id, cb, ad) \
	MMenuItemSetCallback(id, cb, ad)
#define MPullDownGetItemText(pd, item) \
	MMenuItemGetText(item)
#define MPullDownGetTitleText(obj) \
	MMenuGetTitleText(obj)
#define MSetItemCheckStatus(pd, item, TrueFalse) \
	MMenuItemSetCheckStatus(item, TrueFalse)
#define MGetItemCheckStatus(pd, item) \
	MMenuItemGetCheckStatus(item)
#define MToggleItemCheckStatus(pd, item) \
	MMenuItemToggleCheckStatus(item)
#define MDestroyPullDown(pd) \
	MDestroyMenu(pd)

#endif /* OLD_MGUI */

#ifdef __cplusplus
}
#endif

#endif
