/* Last Change: 20010429 - doe */
/*
 *  $Id: P54-06,v 1.16 1998/12/10 00:01:28 route Exp $
 *  Trusted path ACL syscall implementation for OpenBSD 2.4
 *
 *  Copyright (c) 1998 route|daemon9 and Mike D. Schiffman
 *  All rights reserved.
 *  Originally published in Phrack Magazine (http://www.phrack.com).
 *
 *  Thanks to nirva for helping me choose an ADT.
 *  See <sys/kern_tpe.h> for more info.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/kern_tpe.h>
#include <sys/systm.h>
#include <sys/errno.h>

#include <sys/mount.h>
#include <sys/syscallargs.h>


int
sys_tpe_adm(p, v, retval)
	struct proc    *p;
	void           *v;
	register_t     *retval;
{
	struct sys_tpe_adm_args	/* { 
		syscallarg(int) mode; 
		syscallarg(uid_t) candidate;
	    	syscallarg(uid_t *) list; 
	} */ *uap = v;
	register struct pcred *pc = p->p_cred;
	register int    i;
	register uid_t *lp;

	/* 
	 * The only thing a non root user can do with this system call is
	 * verify if a given uid is in the trusted list or not. This is 
	 * necessary for allowing trusted users normal access via kvm(3)
	 * and to ld.so environment variables. The status of ld.so is done
	 * via sysctl(3) now.  
	 */   

	if (suser(pc->pc_ucred, &p->p_acflag) && SCARG(uap, mode) != TPE_VERIFY)  
		return (EACCES);
	
	switch (SCARG(uap, mode)) {
	case TPE_ADD:
		if (tpe_add(SCARG(uap, candidate)) == ACK) {
			return (0);
		} else {
			return (EINVAL);	/* Ugh.  Best we can do. */
		}
	case TPE_REMOVE:
		if (tpe_remove(SCARG(uap, candidate)) == ACK) {
			return (0);
		} else {
			return (EINVAL);	/* Ugh. */
		}
	case TPE_SHOW:
		lp = SCARG(uap, list);
		if (lp == NULL) {
			return (EFAULT);
		} else {
			for (i = 0; i < TPE_ACL_SIZE; i++) {
				lp[i] = tpe_acl[i];
			}
			return (0);
		}
	case TPE_VERIFY:
		if (TRUSTED_USER(SCARG(uap, candidate))){
			return(1);
		} else {
			return(0);
		}
	default:
		return (EINVAL);	/* Ugh. */
	}
	return (EINVAL);
}
