/*
 * well, this code had two bugs, actually:
 * 1) the one from the man page (about not interpreting user names
 *    such as '31337one' right)
 * 2) a bug that allowed adding any arbitrary uid (withing the ranges
 *    of the 'long' data type) to the trusted list, even if it didnt
 *    exist (i dont know if you can call it a bug or just lack of
 *    error checking)
 * 
 * anyway, i fixed the first with a rather lame solution: a loop that
 * runs through 'optarg' and sets the variable 'g' according to the last
 * character it went through - 1 for character, 0 for digit. digit is 
 * determined if a character's ascii value is between 47 (0) and 58 (9).
 * 
 * the other bug just needed to add a getpwuid() call and check the
 * returned value for null. if its null, then an error message is 
 * printed to stderr, if not, uid is added to the trusted users list.
 * 
 * also i added a tiny cosmetic change - if you remove a user from the
 * system, and he/she is in the trusted users list, when tpe_adm outputs
 * the uid it puts it between square brackets ([]'s).. just thuoght it
 * makes stuff more clear :)
 * 
 * -brian (june 25th, 2001)
 */ 

/* Last Change: 20010429 - doe */
/*
 *  $Id: P54-06,v 1.16 1998/12/10 00:01:28 route Exp $
 *  Trusted path ACL userland administrative agent for OpenBSD 2.4
 *
 *  Copyright (c) 1998 route|daemon9 and Mike D. Schiffman
 *  All rights reserved.
 *  Originally published in Phrack Magazine (http://www.phrack.com).
 *
 *  Thanks to nirva for helping me choose an ADT.
 *  See <sys/kern_tpe.h> for more info.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <syslog.h>
#include <sys/syscall.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/kern_tpe.h>
void            usage();

int
main(int argc, char **argv)
{
	uid_t           list[TPE_ACL_SIZE];
	int             c, i, g;
	uid_t           candidate;
	int		mib[2], val, new;
	size_t 		len;
	struct passwd  *pwd;

	if (geteuid() && getuid()) {
		fprintf(stderr, "root access required\n");
		exit(1);
	}
	if (argc == 1 || argc > 3) {
		usage();
		exit(EXIT_SUCCESS);
	}

	openlog("tpe_adm", LOG_PID, LOG_AUTH);

	mib[0] = CTL_KERN;
	mib[1] = KERN_TPELDCHECK; 

	while ((c = getopt(argc, argv, "a:d:l:s")) != -1) {
		switch (c) {
		case 'a':
			for(i = 0; i < strlen(optarg); i++) {
				if((int)optarg[i] > 47 && (int)optarg[i] < 58)
					g = 0;
				else
					g = 1;
			}

			if(g == 0) {
				if (!(candidate = (uid_t) atol(optarg))) {
					fprintf(stderr, "Invalid UID: \"%s\"\n", optarg);
					exit(EXIT_FAILURE);
				}
				if((pwd = getpwuid(candidate)) == NULL) {
					fprintf(stderr, "Invalid UID: \"%d\"\n", candidate);
					exit(EXIT_FAILURE);
				}
			} else if(g == 1) {
				pwd = getpwnam(optarg);
				if (!pwd) {
					fprintf(stderr, "Unknown user: \"%s\"\n", optarg);
					exit(EXIT_FAILURE);
				}
				candidate = pwd->pw_uid;
			}				

			if (syscall(SYS_tpe_adm, TPE_ADD, candidate, NULL) == -1) {
				syslog(LOG_NOTICE, "Full trust list\n");
				printf("Full trust list\n");
				exit(EXIT_FAILURE);
			}
			syslog(LOG_NOTICE, "UID %d added to trust list\n", candidate);
			printf("UID %d added to trust list\n", candidate);
			break;
		case 'd':
			for(i = 0; i < strlen(optarg); i++) {
				if((int)optarg[i] > 47 && (int)optarg[i] < 58)
					g = 0;
				else
					g = 1;
			}

			if(g == 0) {
				if (!(candidate = (uid_t) atol(optarg))) {
					fprintf(stderr, "Invalid UID: \"%d\"\n", candidate);
					exit(EXIT_FAILURE);
				}
			} else if(g == 1) {
				pwd = getpwnam(optarg);
				if (!pwd) {
					fprintf(stderr, "Unknown user: \"%s\"\n", optarg);
					exit(EXIT_FAILURE);
				}
				candidate = pwd->pw_uid;
			}				

			if (syscall(SYS_tpe_adm, TPE_REMOVE, candidate, NULL) == -1) {
				printf("UID %d not found on trust list\n", candidate);
				exit(EXIT_FAILURE);
			}
			syslog(LOG_NOTICE, "UID %d removed from trust list\n", candidate);
			printf("UID %d removed from trust list\n", candidate);
			break;
		case 'l':
			if (optarg[0] == 'e') {
				new = 1;
				len = sizeof(val);
				if (sysctl(mib, 2, &val, &len, &new, len) < 0){
					perror("tpe_adm: sysctl");
					exit(EXIT_FAILURE);
				}  
				syslog(LOG_NOTICE, "ld.so environment protection enabled\n");
				printf("ld.so environment protection enabled\n");
			} else if (optarg[0] == 'd') {
				new = 0;
				len = sizeof(val);
				if (sysctl(mib, 2, &val, &len, &new, len) < 0){
					perror("tpe_adm: sysctl");
					exit(EXIT_FAILURE);
				}  
				syslog(LOG_NOTICE, "ld.so environment protection disabled\n");
				printf("ld.so environment protection disabled\n");
			} else if (optarg[0] == 's') {
				val = 0;
				len = sizeof(val);
				if (sysctl(mib, 2, &val, &len, NULL, 0) < 0){
					perror("tpe_adm: sysctl");
					exit(EXIT_FAILURE);
				}  
				printf("ld.so environment protection is currently %s\n",
				       val ? "on" : "off");
			} else {
				fprintf(stderr, "Huh?\n");
				exit(EXIT_FAILURE);
			}
			break;
		case 's':
			/*
	                 *  It is Very Important that `list` is an array of size
	                 *  TPE_ACL_SIZE.  The kernel expects this.  Failure to do
	                 *  so can result in a panic.  However, only root can issue
	                 *  the tpe_adm system call.
	                 */
			if (syscall(SYS_tpe_adm, TPE_SHOW, -1, list) == -1) {
				/*
	                         *  Should NOT fail.
	                         */
				printf("Hideous internal error\n");
				exit(EXIT_FAILURE);
			}
			printf("trusted users: ");
			for (i = 0; list[i] != TPE_INITIALIZER; i++) {
				pwd = getpwuid(list[i]);
				if (pwd) {
					printf("%s ", pwd->pw_name);
				} else {
					printf("[%d] ", (int) list[i]);
				}
			}
			printf("\n");
			break;
		default:
			usage();
			exit(EXIT_SUCCESS);
		}
	}
	closelog();
	return (0);
}


void
usage()
{
	fprintf(stderr, "usage: tpe_adm [-a UID]    Add a UID to the trust list\n"
		"[-d UID]    Delete a UID from the list\n"
		"[-l e|d]    Toggle LD_* usage\n"
		"[-l s]      Show status of ld.so protection\n"
		"[-s]        Show the current list\n");
}
