#!/usr/bin/perl 
#
#--------------------------------------
# The Slashdot headline grabber script.
#
# Written by Srijith.K 
# (http://www.srijith.net) (email : webmaster@srijith.net)
# 
# Proxy support sample code provided by Michael Schmitz. 
# 
# It would really boost me if you can drop me a mail if you are using this script.
#
# Last Modified : 29/09/2000 (dd/mm/yyyy)
# Version 2.2
#
#-------------------------------------- 
#
# Usage : (1) Change the first line of script to point to the perl interpreter. 
#         (2) Change the variables defined below IF REQUIRED
#	  (3) Enjoy.
#-------------------------------------- 

############# Modules used(to 'get' the backend file & for file manipulation) ########

use strict;
use LWP::UserAgent;
use CGI;


######################## Some initilisation needed for your comfort #################
my $updatefile="update.txt";     	# The file storing the time of last update
my $localfile = "slashdot.out";  	# The local file where the headlines are stored
my $update_interval=30;          	# The interval in minutes at which the file is fetched fresh from server
my $print_title_url=1;           	# Print Title & URL ?? 1=yes, 0=no
my $print_dept=1;                 	# Print Department  ?? 1=yes, 0=no
my $print_time=1;                	# Print Time of Sub.?? 1=yes, 0=no
my $print_supplier=1;            	# Print Supplier    ?? 1=yes, 0=no
my $print_topic=1;              	# Print Category    ?? 1=yes, 0=no
my $print_section=1;	        	# Print sections    ?? 1=yes, 0=no	
my $print_responses=1;           	# Print No. of responses ?? 1=yes, 0=no
my $print_image=1;			# Print images      ?? 1=yes, 0=no  Note that images are linked from /. site as of now.
my $use_proxy=0;                        # Proxy to connect to internet ?? 1=yes, 0=no
my $proxy_server="server:port";         # The proxy server. If $user_proxy is set to 0, leave this variable blank
######################################################################################



################ ~~~~~~~~ DON'T EDIT IF YOU DON'T KNOW WHAT YOU ARE DOING ~~~~~~~~ #############
############ ~~~ EDITING WITHOUT KNOWLEDGE OF PERL IS INJURIOUS TO SCRIPT HEALTH ~~~~ ###########

# Few intialisations
my $query=new CGI;
my $update_file_content="";
my $current_time=time;           # The current time


# Print the header
&print_header;

# Check the age of the local file
&check_localfile_age;

my $slashdot = $update_file_content->param('slashdot');
my $update_interval_sec=$update_interval*60;
my $new_update_time=$slashdot + $update_interval_sec;

if($current_time>$new_update_time)
{
  # Ok.. File is too old.. Fetch new file from server
  # and update the age of the local file
  &update_localfile;
  &update_localfile_age;
}

&print_news;
&print_footer;

exit(0);

#-------------------------- End of main code body --------------------

#-----------------------Below are the sub functions ------------------

# Function to check the local file's age
sub check_localfile_age
{
  open(UPDATE, $updatefile) || die "Error opening update log file!\n";
  flock(UPDATE,2);
  $update_file_content = new CGI("UPDATE");
  flock(UPDATE,8);
  close(UPDATE);
}


# Function to update local file 
sub update_localfile 
{
  # The $url points to the XML/text/anyother file that stores the headlines.
  my $url = 'http://www.slashdot.org/slashdot.xml';
  my $ua=new LWP::UserAgent;
  if($use_proxy)
  {
    $ua->proxy('http',$proxy_server);
  }
  my $request=new HTTP::Request('GET',$url);
  my $response=$ua->request($request);
  if(!$response->is_success)
  {
    # Trouble fetching file from server.. !!
    print "Can't get Slashdot backend file from the server.";
    exit (-1) ; 
  }

  my $document=$response->content;
  my @document = split /\n/, $document;
  
  # Save into local file
  open(LOCALFILE,">$localfile") || die "Cannot open the local file for write\n";
  flock(LOCALFILE,2);
  my $line="";
  foreach $line (@document)
  {
    print LOCALFILE "$line\n";
  } 
  flock(LOCALFILE,8);
  close(LOCALFILE);
}


# Function to update the local file's age
sub update_localfile_age
{
  # Update the update_time and save into file
  $update_file_content->param('slashdot',$current_time);
  open(UPDATE,">$updatefile") || die "Error opening counter file!\n";
  flock(UPDATE, 2);  # locks the file - 2 to lock, 8 to unlock
  $update_file_content->save("UPDATE");
  flock(UPDATE, 8); # unlock file
  close(UPDATE);
}


# Function to print the news grabbed
sub print_news
{
  #Open the local file and print the headlines
  open (LOCALFILE,"<$localfile");
  flock(LOCALFILE,2);
  <LOCALFILE>;
  <LOCALFILE>;
  <LOCALFILE>;
  while(<LOCALFILE>)
  {
    for(my $i=1;$i<11;$i++)
    {
      (my $title) = <LOCALFILE>=~ /\<title\>(.*)\<\/title\>/;
      (my $url) = <LOCALFILE>=~ /\<url\>(.*)\<\/url\>/;
      (my $time) = <LOCALFILE>=~ /\<time\>(.*)\<\/time\>/;
      (my $author)=<LOCALFILE> =~ /\<author\>(.*)\<\/author\>/;
      (my $department) = <LOCALFILE>=~ /\<department\>(.*)\<\/department\>/;
      (my $topic) = <LOCALFILE>=~ /\<topic\>(.*)\<\/topic\>/;
      (my $comments) = <LOCALFILE>=~ /\<comments\>(.*)\<\/comments\>/;
      (my $section) =<LOCALFILE> =~ /\<section\>(.*)\<\/section\>/;
      (my $image) = <LOCALFILE>=~ /\<image\>(.*)\<\/image\>/;
      <LOCALFILE>;
      <LOCALFILE>;
      <LOCALFILE>;
      if($print_title_url) 
      {
        print "Title = <a href=\"$url\">$title</a><br>\n";
      }
	
      if($print_time)
      {
        print "Time = $time\n<br>";
      }
      if($print_supplier)
      {
	print "Author = $author\n<br>";
      }
      if($print_dept)
      {
         print "Department = $department\n<br>";
      }
      if($print_topic)
      {
	print "Topic = $topic\n<br>";
      }
      if($print_responses)
      {
        print "Comments = $comments\n<br>";
      }
      if($print_section)
      {
        print "Section = $section\n<br><br>";
      }
      if($print_image)
      {
        print "Image = <img src=\"http://images.slashdot.org/topics/$image\">\n<br><br>";
      }
    }        
    
  }
  flock(LOCALFILE,8);
  close(LOCALFILE);
}


# Function to prin the header
sub print_header
{
    print $query->header;
    print $query->start_html(-title=>'News Grabber');
    print <<HTML;
      <BODY bgColor=#ffffff link=#000080 text=#000000 vLink=#000080><FONT face="Verdana, Arial" size=2>
      <TABLE border=0 cellPadding=0 cellSpacing=0 width="100%">
      <TBODY>
      <TR>
      <TD bgColor=#000000>
      <TABLE border=0 cellPadding=4 cellSpacing=1 width="100%">
      <TBODY>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B>Backend News Project</B></CENTER></FONT></TD></TR>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B><a href="http://www.slashdot.org">Slashdot</a> News</B></CENTER></FONT></TD></TR>
      <TR bgColor=#fffff>
      <TD><FONT face="Verdana, Arial" size=2>
HTML

}


# Function to print the footer
sub print_footer
{
    print <<HTML;
      </TD></TR>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B>THE END 
      </B></CENTER></FONT></TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE>
      <CENTER></CENTER></FONT></FONT></B>
      </CENTER></BODY></HTML>
HTML
}


# -------------------------------- END OF ALL THE SCRIPTS -----------------------
