<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Maintenance and configuration page for
 *          managing Alert Groups (AG)   
 *
 * Input GET/POST variables
 *   - ag_action:
 *   - action:
 *   - action_arg:
 *   - ag_id: 
 *   - submit:
 *   - current_view:
 *   - num_result_rows:
 *   - sort_order:
 */

  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_net.inc");
  include("acid_signature.inc");
  include("acid_action.inc");
  include("acid_db_common.php");
  include("acid_common.php");
  include("acid_pkt_common.php");
  include("acid_ag_common.php");

  RegisterGlobalState();
  ImportGlobalState();

  $ag_action = ImportHTTPVar("ag_action");
  $action = ImportHTTPVar("action");
  $ag_id = ImportHTTPVar("ag_id");
  $action_arg = ImportHTTPVar("action_arg");
  $submit = ImportHTTPVar("submit");
  $current_view = ImportHTTPVar("current_view");
  $num_result_rows = ImportHTTPVar("num_result_rows");
  $sort_order = ImportHTTPVar("sort_order");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Alert Group (AG) Maintenance</TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Alert Group Maintenance</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php
  if ( $debug_mode > 0 )  PrintPageHeader();

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $num_result_rows == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  else if ( $num_result_rows > 0 && 
            ord($submit) >= ord("0") && ord($submit) <= ord("9") )
  {
    $current_view = $submit;
    $ag_action = "view";
  }
?>

<CENTER>
 <A HREF="acid_ag_main.php?ag_action=list">list all</A> | 
 <A HREF="acid_ag_main.php?ag_action=create">create</A> |
 <A HREF="acid_ag_main.php?ag_action=view">view</A> |
 <A HREF="acid_ag_main.php?ag_action=edit">edit</A> |
 <A HREF="acid_ag_main.php?ag_action=delete">delete</A> |
 <A HREF="acid_ag_main.php?ag_action=clear">clear</A>
</CENTER>
<HR>

<FORM METHOD="POST" NAME="PacketForm" ACTION="acid_ag_main.php">

<?php
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>ag_action</TD><TD>submit</TD><TD>ag_id</TD></TR>
             <TR><TD>'.$ag_action.'</TD><TD>'.$submit.'</TD><TD>'.$ag_id.'</TD></TR>
           </TABLE>';

$valid_action = array ("del_alert", "clear_alert", "email_alert", "email_alert2");
$valid_action_op = array ("Selected", "ALL on Screen", "Entire Query");

$save_sql = "SELECT ag_sid, ag_cid FROM acid_ag_alert WHERE ag_id=".$ag_id;

ActOnSelectedAlerts($action, $valid_action, $submit, $valid_action_op, $ag_id,
                             4,
                             $action_chk_lst, $action_lst,
                             $show_rows, $num_result_rows,
                             $save_sql, $caller,
                             $db, $ag_id );

  if ( $ag_action == "create" )                                       echo '<H3>Create group</H3>';
  else if ($ag_action == "view" )                                     echo '<H3>View group</H3>';
  else if ($ag_action == "edit" || $ag_action == "save" )             echo '<H3>Edit group</H3>';
  else if ($ag_action == "delete" || $ag_action == "delete_confirm" ) echo '<H3>Delete group</H3>';
  else if ($ag_action == "clear" || $ag_action == "clear_confirm" )   echo '<H3>Clear group</H3>';
  else if ($ag_action == "list" )                                     echo '<H3>List groups</H3>';

  if ( $submit != "" )
  {
     if ( $ag_action == "create" )
     {
        $sql = "INSERT INTO acid_ag (ag_name, ag_desc) VALUES ('".$ag_name."','".$ag_desc."');";
        $db->acidExecute($sql, -1, -1, false);

        if ( $db->acidErrorMessage() != "" )
           FatalError("Error Inserting new AG");

        $ag_id = $db->acidInsertID();
        /* The following code is a kludge and can cause errors.  Since it is not possible
         * to determine the last insert ID of the AG, we requery the DB to ascertain the ID
         * by matching on the ag_name and ag_desc.  -- rdd (1/23/2001)
         *
         * Modified code to only run the kludge if the dbtype is postgres.  Created a function
         * to use the actual insertid function if availible and return -1 if no -- srh (02/01/2001)
         *
         * Transaction support is neccessary to get this absolutely correct, because using
         * an insert_id might break in a multi-user enviroment.  -- rdd (02/07/2001)
         */
         if ( $ag_id == -1 )
         {
            $tmp_result = $db->acidExecute("SELECT ag_id FROM acid_ag WHERE ag_name='".$ag_name."' AND ".
                                        "ag_desc='".$ag_desc."'");
            $myrow = $tmp_result->acidFetchRow();
            $ag_id = $myrow[0];
            $tmp_result->acidFreeRows();
         }
         $ag_action = "view";
     }
     else if ( $ag_action == "save" )
     {
        $sql = "UPDATE acid_ag SET ag_name='".$ag_name."', ag_desc='".$ag_desc."' ".
               "WHERE ag_id=".$ag_id;

        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error updating the AG");

        $ag_action = "view";
     }
     else if ( $ag_action == "delete_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting packet list for the AG: ".$sql);

        /* Delete the AG */
        $sql = "DELETE FROM acid_ag WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting the AG".$sql);
     }
     else if ( $ag_action == "clear_confirm" )
     {
        /* Delete the packet list associated with the AG */
        $sql = "DELETE FROM acid_ag_alert WHERE ag_id=".$ag_id;
        $db->acidExecute($sql, -1, -1, false);
        if ( $db->acidErrorMessage() != "" )
           FatalError("Error deleting packet list for the AG: ".$sql);
        
        $ag_action = "view";
     }

     if ( $ag_action == "delete_confirm" )
     {
        ErrorMessage("<B>DELETED successfully</B>");
        $ag_action = "view";
        $ag_name = $ag_desc = "<I>information deleted</I>";
     }
     else
     {
     /* Re-Query the information to print the AG info out */
     if ( $ag_id > 0)
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_id=".$ag_id;
     else
        $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag WHERE ag_name='".$ag_name."'";

     $result = $db->acidExecute($sql, -1, -1, false);
     if ( $db->acidErrorMessage() != "" )
     {
        ErrorMessage("The entered search criteria is invalid.  Try again!");
        $submit = "";
     }
     else if ( $result->acidRecordCount() < 1 )
     {
        ErrorMessage("No AG found with that criteria.".$sql);
        $submit = "";
     }
     else
     {
        $myrow = $result->acidFetchRow();
        $ag_id = $myrow[0];
        $ag_name = $myrow[1];
        $ag_desc = $myrow[2]; 
     }
     }
  }

  if ( $ag_action == "list" )
  {
     $sql = "SELECT ag_id, ag_name, ag_desc FROM acid_ag";

     $result = $db->acidExecute($sql);
     $num = $result->acidRecordCount();
     if ( $num < 1 )
     {
        echo "<CENTER><B>There are no Alert Groups</B></CENTER>";
     }
     else
     {
       echo '<TABLE BORDER=1 CELLSPACING=0 PADDING=0 WIDTH="100%">
`              <TR>
               <TD CLASS="plfieldhdr">ID</TD>
               <TD CLASS="plfieldhdr">Name</TD>
               <TD CLASS="plfieldhdr"># Alerts</TD>
               <TD CLASS="plfieldhdr">Description</TD>
               <TD CLASS="plfieldhdr">Actions</TD>
              </TR>';
        for ( $i = 0; $i < $num; $i++)
        {
           $myrow = $result->acidFetchRow();

           /* count the number of alerts in the AG */
           $result2 = $db->acidExecute("SELECT count(ag_cid) FROM acid_ag_alert WHERE ag_id=".$myrow[0]);
           $myrow2 = $result2->acidFetchRow();
           $num_alerts = $myrow2[0];
           $result2->acidFreeRows();

           echo '<TR><TD CLASS="plfield">
                     <A HREF="acid_ag_main.php?ag_action=view&ag_id='.$myrow[0].'&submit=x">'.$myrow[0].'</A></TD>
                     <TD CLASS="plfield">'.$myrow[1].'</TD>
                     <TD CLASS="plfield">'.$num_alerts.'</TD>
                     <TD CLASS="plfield">'.$myrow[2].'</TD>
                     <TD CLASS="plfield"> 
                       <A HREF="acid_ag_main.php?ag_action=edit&ag_id='.$myrow[0].'&submit=x">edit</A> |
                       <A HREF="acid_ag_main.php?ag_action=delete&ag_id='.$myrow[0].'&submit=x">delete</A> |
                       <A HREF="acid_ag_main.php?ag_action=clear&ag_id='.$myrow[0].'&submit=x">clear</A>
                     </TD>
                 </TR>';
        }
        echo '</TABLE>';
        $result->acidFreeRows();
     }
  }

  if ( $ag_action != "list" )
  {
     echo '<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
           <TR>
            <TD WIDTH="10%"><B>ID #</B></TD>
            <TD>';

            if ( $ag_action == "create" && $submit == "")
               echo '&nbsp;<I> not assigned yet </I>&nbsp';
            else if ( $submit == "" )
               echo '<INPUT TYPE="text" NAME="ag_id" VALUE="'.$ag_id.'">';
            else if ( ($ag_action == "view" || $ag_action == "edit" || 
                       $ag_action == "delete" || $ag_action == "clear") &&
                      $submit != "" )
            {
               echo '<INPUT TYPE="hidden" NAME="ag_id" VALUE="'.$ag_id.'">';
               echo $ag_id;
            }

     echo ' </TD>
           <TR>
            <TD VALIGN=TOP><B>Name</B></TD>
            <TD>';

            if ( $ag_action == "create" && $submit == "")
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40 VALUE="'.$ag_name.'">';
            else if ( $submit == "" )
            {
               echo '<SELECT NAME="ag_name">
                       <OPTION VALUE="">{ AG Name }';
               $sql = "SELECT ag_name FROM acid_ag;";
               $result = $db->acidExecute($sql);
               if ( $result )
               {
                  while ( $myrow = $result->acidFetchRow() )
                      echo '<OPTION VALUE="'.$myrow[0].'">'.$myrow[0];

                  $result->acidFreeRows();
               }

               echo '</SELECT>';
            }
            else if ( $ag_action == "edit" && $submit != "" )
               echo '<INPUT TYPE="text" NAME="ag_name" SIZE=40" VALUE="'.$ag_name.'">';
            else if ( ($ag_action == "view" || $ag_action == "delete" || 
                       $ag_action = "clear") && 
                      $submit != "" )
               echo $ag_name;

     echo ' </TD>';
     
     if ( ($ag_action == "create" && $submit == "") ||
          (($ag_action == "view" || $ag_action == "edit" || 
            $ag_action == "delete" || $ag_action == "clear") && 
          $submit != "" ) )
     {
       echo '
          <TR>
           <TD VALIGN=TOP><B>Description</B></TD>
           <TD>';

            if ( $ag_action == "create" && $submit == "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( $ag_action == "edit" && $submit != "" )
               echo '<TEXTAREA NAME="ag_desc" COLS=70 ROWS=4>'.$ag_desc.'</TEXTAREA>';
            else if ( ($ag_action == "view" || $ag_action == "delete" || 
                       $ag_action == "clear") && 
                      $submit != "" )
               echo $ag_desc;

       echo '
           </TD>
          </TR>';
     }

     echo '</TABLE>';
 
   /* Print the Appropriate button */
   if ( $submit == "" || $ag_action == "edit" || $ag_action == "delete" || $ag_action == "clear" )
   {
     echo '<CENTER> <FONT>';

     if ( $ag_action == "create" )      $button_text = "Create Alert Group";
     else if ( $ag_action == "view" )   $button_text = "View Alert Group";
     else if ( $ag_action == "edit" && $submit == "" )   $button_text = "Edit Alert Group";
     else if ( $ag_action == "edit" && $submit != "" )  
     {  $button_text = "Save Changes";  $ag_action = "save"; }
     else if ( $ag_action == "delete" && $submit == "" )  $button_text = "Delete Alert Group";
     else if ( $ag_action == "delete" && $submit != "" ) 
     {  $button_text = "Confirm Delete"; $ag_action = "delete_confirm";  }
     else if ( $ag_action == "clear" && $submit == "" )  $button_text = "Clear Alerts from Group";
     else if ( $ag_action == "clear" && $submit != "" ) 
     {  $button_text = "Confirm Clear"; $ag_action = "clear_confirm";  }

     echo '<INPUT TYPE="submit" NAME="submit" VALUE="'.$button_text.'">';

     echo '</FONT> </CENTER>';
   }

  echo '<INPUT TYPE="hidden" NAME="ag_action" VALUE="'.$ag_action.'">';

  if ( $ag_action == "view" && $submit != "" )
  {
     /* Calculate the Number of Alerts */
     $sql = "SELECT count(ag_sid) FROM acid_ag_alert WHERE ag_id=".$ag_id;

     /* Run the query to determine the number of rows (No LIMIT)*/
     if ( $num_result_rows == -1 )
     {
        $current_view = 0;
        $result = $db->acidExecute($sql);
        if ( $myrow = $result->acidFetchRow() )
        {
           $num_result_rows = $myrow[0];
           $result->acidFreeRows();
        }
        else
           $num_result_rows = 0;
     }

     $sql = "SELECT acid_event.sid, acid_event.cid, signature, timestamp, ".
                   "ip_src, ip_dst, ip_proto ".
            "FROM acid_event ".
            "LEFT JOIN acid_ag_alert ON acid_event.sid=ag_sid AND acid_event.cid=ag_cid ".
            "WHERE acid_event.cid > 0 AND ag_id = ".$ag_id." ORDER BY timestamp DESC";

     $save_sql = $sql;
     $printing_ag = true;
     $ag = $ag_id;
     include("acid_pkt_sqlcalls.php");

     echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
     echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';
  }
  }
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




