<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: status and event/dns/whois cache maintenance   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_db_common.php");
  include("acid_common.php");
  include("acid_stat_common.php");
  include("acid_net.inc");
  include("acid_cache.inc");

  $start = time();
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID: Maintinence</TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Setup</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<FORM METHOD="POST"
      ACTION="acid_maintenance.php">

<?php
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $debug_mode > 0 )
     echo "submit = '$submit'<P>";

  set_time_limit($max_script_runtime);

  if ( $submit == "Update Alert Cache" )
  {
     UpdateAlertCache($db);     
  }
  else if ( $submit == "Update IP Cache" )
  {
     UpdateDNSCache($db);     
  }
  else if ( $submit == "Update Whois Cache" )
  {
     UpdateWhoisCache($db);     
  }


  echo '<TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#669999">
         <TR><TD> 
           <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#FFFFFF">
              <TR><TD class="sectiontitle">PHP build</TD></TR>
              <TR><TD>
         <B>CLIENT:</B> '.$HTTP_USER_AGENT.'<BR>
         <B>SERVER:</B> '.$SERVER_SOFTWARE.'<BR> 
         <B>SERVER HW:</B> '.php_uname().'<BR>
         <B>PHP VERSION:</B> '.phpversion().'<BR>
         <B>PHP API:</B> '.php_sapi_name().'<BR>
         <B>PHP Logging level:</B> '.ini_get("error_reporting").'<BR>
         <B>Loaded Modules: </B> ';

         $module_lst = get_loaded_extensions();
         for ( $i = 0; $i < count($module_lst); $i++)
             echo " [ ".$module_lst[$i]." ]";

  echo '      </TD><TR>
           </TABLE>
         </TD></TR>
        </TABLE><P>';

  echo '<TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#669999">
         <TR><TD> 
           <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#FFFFFF">
              <TR><TD class="sectiontitle">Database</TD></TR>
              <TR><TD>';
     
  GLOBAL $ADODB_vers;

  echo "<B>DB Type:</B> $DBtype <BR>  
        <B>DB Abstraction Version:</B> $ADODB_vers <BR>
        <B>ALERT DB Name:</B> $alert_dbname <BR>
        <B>ARCHIVE DB Name:</B> $archive_dbname <BR>

             </TD><TR>
           </TABLE>
         </TD></TR>
        </TABLE><P>";

  echo '<TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#669999">
         <TR><TD> 
           <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#FFFFFF">
              <TR><TD class="sectiontitle">Alert Information Cache</TD></TR>
              <TR><TD>';

  $event_cnt_lst = $db->acidExecute("SELECT COUNT(*) FROM event");
  $event_cnt_row = $event_cnt_lst->acidFetchRow();
  $event_cnt = $event_cnt_row[0];
  $event_cnt_lst->acidFreeRows();

  $cache_event_cnt_lst = $db->acidExecute("SELECT COUNT(*) FROM acid_event");
  $cache_event_cnt_row = $cache_event_cnt_lst->acidFetchRow();
  $cache_event_cnt = $cache_event_cnt_row[0];
  $cache_event_cnt_lst->acidFreeRows();

  echo '<B>Total Events:</B> '.$event_cnt.'&nbsp&nbsp
        <B>Cached Events:</B> '.$cache_event_cnt.'
        &nbsp;&nbsp;
        <INPUT TYPE="submit" NAME="submit" VALUE="Update Alert Cache">';

  echo '   </TD><TR>
           </TABLE>
         </TD></TR>
        </TABLE><P>';

  echo '<TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#669999">
         <TR><TD> 
           <TABLE WIDTH="100%" CELLSPACING=0 CELLPADDING=2 BORDER=0 BGCOLOR="#FFFFFF">
              <TR><TD class="sectiontitle">IP Address Cache</TD></TR>
              <TR><TD>';

  $uncached_sip_cnt = UniqueSrcIPCnt($db);
  $uncached_dip_cnt = UniqueDstIPCnt($db);
  
  $ip_result = $db->acidExecute("SELECT COUNT(DISTINCT ip_src) FROM acid_event ".
                                "INNER JOIN acid_ip_cache ON ipc_ip = ip_src ".
                                "WHERE ipc_fqdn is not NULL");
  $row = $ip_result->acidFetchRow();
  $ip_result->acidFreeRows();
  $cached_sip_cnt = $row[0];

  $ip_result = $db->acidExecute("SELECT COUNT(DISTINCT ip_dst) FROM acid_event ".
                                "INNER JOIN acid_ip_cache ON ipc_ip = ip_dst ".
                                "WHERE ipc_fqdn is not NULL");
  $row = $ip_result->acidFetchRow();
  $ip_result->acidFreeRows();
  $cached_dip_cnt = $row[0];

  $ip_result = $db->acidExecute("SELECT COUNT(DISTINCT ip_src) FROM acid_event ".
                                "INNER JOIN acid_ip_cache ON ipc_ip = ip_src ".
                                "WHERE ipc_whois is not NULL");
  $row = $ip_result->acidFetchRow();
  $ip_result->acidFreeRows();
  $cached_swhois_cnt = $row[0];

  $ip_result = $db->acidExecute("SELECT COUNT(DISTINCT ip_dst) FROM acid_event ".
                                "INNER JOIN acid_ip_cache ON ipc_ip = ip_dst ".
                                "WHERE ipc_whois is not NULL");
  $row = $ip_result->acidFetchRow();
  $ip_result->acidFreeRows();
  $cached_dwhois_cnt = $row[0];

  echo '<B>Unique Src IP:</B> '.$uncached_sip_cnt.'&nbsp;&nbsp&nbsp;'.
       '<B>DNS Cached:</B> '.$cached_sip_cnt.'&nbsp;&nbsp;&nbsp;'.
       '<B>Whois Cached:</B> '.$cached_swhois_cnt.'<BR>'.
       '<B>Unique Dst IP:</B> '.$uncached_dip_cnt.'&nbsp;&nbsp&nbsp;'.
       '<B>DNS Cached:</B> '.$cached_dip_cnt.'&nbsp;&nbsp;&nbsp;'.
       '<B>Whois Cached:</B> '.$cached_dwhois_cnt.'<BR>
        <INPUT TYPE="submit" NAME="submit" VALUE="Update IP Cache">&nbsp;
        <INPUT TYPE="submit" NAME="submit" VALUE="Update Whois Cache">';       

  echo '   </TD><TR>
           </TABLE>
         </TD></TR>
        </TABLE><P>';

  $stop = time();
  if ( $debug_time_mode > 0 )
     echo "<H3>[Loaded in ".($stop-$start)." seconds]</H3>";

?>
</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>
