<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

function SensorCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM sensor");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function EventCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM acid_event");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

/*
 * Takes: Numeric sensor ID from the Sensor table (SID), and 
 *	  database connection.
 * 
 * Returns: The number of unique alert descriptions for the 
 * 	    given sensor ID. 
 *
 */
function UniqueCntBySensor($sensorID, $db)
{

  /* Calculate the Unique Alerts */
  $query = "SELECT COUNT(DISTINCT signature) FROM acid_event WHERE sid = " . $sensorID . ";";
  $result = $db->acidExecute($query);

  if ( $result ) 
  {
     $row = $result->acidFetchRow();
     $num = $row[0];
     $result->acidFreeRows();
  }
  else
     $num = 0;

  return $num;
}

/*
 * Takes: Numeric sensor ID from the Sensor table (SID), and 
 *        database connection.
 * 
 * Returns: The total number of alerts for the given sensor ID
 */ 
function EventCntBySensor($sensorID, $db)
{
   $query = "SELECT count(*) FROM acid_event where SID = " .$sensorID. ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function MinDateBySensor($sensorID, $db)
{
   $query = "SELECT min(timestamp) FROM acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}


function MaxDateBySensor($sensorID, $db)
{
   $query = "SELECT max(timestamp) FROM acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueDestAddrCntBySensor( $sensorID, $db )
{
   $query = "SELECT COUNT(DISTINCT ip_dst) from acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueSrcAddrCntBySensor( $sensorID, $db )
{
   $query = "SELECT COUNT(DISTINCT ip_src) from acid_event WHERE sid=" . $sensorID . ";";

   $result = $db->acidExecute($query);
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function TCPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM tcphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UDPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM udphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function ICMPPktCnt($db)
{
   $result = $db->acidExecute("SELECT count(*) FROM icmphdr;");
   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function PortscanPktCnt($db)
{
  GLOBAL $DBtype;

  if ( $db->acidGetDBVersion() >= 100 )
      $result = $db->acidExecute("SELECT count(event.sid) FROM event ".
                                 "LEFT JOIN signature ON event.signature=signature.sig_id ".
                                 "WHERE sig_name LIKE 'spp_portscan%'");
  else
      $result = $db->acidExecute("SELECT count(event.sid) FROM event ".
                                 "WHERE signature LIKE 'spp_portscan%'");
  //$result = $db->acidExecute("SELECT count(sid) FROM acid_event ".
  //                           "WHERE sig_name LIKE 'spp_portscan%'");  

   $myrow = $result->acidFetchRow();
   $num = $myrow[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueSrcIPCnt($db)
{
   $result = $db->acidExecute("SELECT COUNT(DISTINCT ip_src) FROM iphdr;");
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function UniqueDstIPCnt($db)
{
   $result = $db->acidExecute("SELECT COUNT(DISTINCT ip_dst) FROM iphdr;");
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

function StartStopTime(&$start_time, &$stop_time, $db)
{
   $result = $db->acidExecute("SELECT min(timestamp), max(timestamp) FROM acid_event");
   $myrow = $result->acidFetchRow();
   $start_time = $myrow[0];
   $stop_time = $myrow[1];
   $result->acidFreeRows();
}

function UniqueAlertCnt($db)
{
   //if ( $db->acidGetDBVersion() >= 100  )
   //   $result = $db->acidExecute("SELECT COUNT(*) FROM signature");
   //else
      $result = $db->acidExecute("SELECT COUNT(DISTINCT signature) FROM event");
   $row = $result->acidFetchRow();
   $num = $row[0];
   $result->acidFreeRows();

   return $num;
}

?>
