<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Original Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 * Additions by Stuart Stock <stuarts@hushmail.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Sensor statistics
 *
 * Input GET/POST variables
 *   - action:
 *   - submit:
 *   - action_arg:
 *   - caller:
 */
?>

<?php
  $start = time();

  include ("acid_conf.php");
  include ("acid_db.inc");
  include ("acid_net.inc");
  include ("acid_signature.inc");
  include ("acid_action.inc");
  include ("acid_db_common.php");
  include ("acid_common.php");
  include ("acid_stat_common.php");
  include ("acid_pkt_common.php");
  include ("acid_ag_common.php");
  include ("acid_cache.inc");

  $action = ImportHTTPVar("action");
  $submit = ImportHTTPVar("submit");
  $ag_add_key = ImportHTTPVar("action_arg");
  $caller = ImportHTTPVar("caller");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Sensor Details</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Sensor Details</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<?php
  if ( $debug_mode > 0 )  PrintPageHeader();

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $valid_action = array ("ag_by_id", "ag_by_name", "del_alert", "clear_alert", 
                         "email_alert", "email_alert2", 
                         "archive_alert", "archive_alert2");
  $valid_action_op = array ("Selected", "ALL on Screen");

  ActOnSelectedAlerts($action, $valid_action, $submit, $valid_action_op, $action_arg,
                      3,
                      $action_chk_lst, $action_lst,
                      $show_rows, $num_result_rows,
                      "", $caller,
                      $db );

  /* Initialized Data */
  if ( $submit == "" )
  {
     $num_result_rows = -1;
     $current_view = 0;
  }
  /* Moving among the views */
  else
    $current_view = $submit;

  /* Get total number of events */
  $event_cnt = EventCnt($db);

  /* Grab sensor count and create SID array */
  $sensor_cnt = SensorCnt($db);
  $sensor_ids = GetSensorIDs($db);

  for( $i = 0; $i < $sensor_cnt; $i++) {
     	$raw_sensor_events[ $sensor_ids[$i] ] = EventCntBySensor($sensor_ids[$i], $db); 
  }

  for( $i = 0; $i < $sensor_cnt; $i++) {
	$unique_sensor_events[ $sensor_ids[$i] ] = UniqueCntBySensor($sensor_ids[$i], $db);
  }

  if ( $debug_mode == 1 ){   
     for( $i = 0; $i < $sensor_cnt; $i++ ) {
        printf("i = %s: sensor %s raw events %s, unique events %s<BR>\n", 
              $i, $sensor_ids[$i], $raw_sensor_events[ $sensor_ids[$i] ],  
              $unique_sensor_events[ $sensor_ids[$i] ] );	
	}
  }

  $num_result_rows = $sensor_cnt;
  
  /* Print the current view number and # of rows */
  if ( $num_result_rows != 0 )
  {
     printf("<FONT><CENTER>Displaying sensors %d-%d of %d <BR> (Aggregating %d total events)</CENTER></FONT><BR>\n", 
            ($current_view * $show_rows)+1, 
            (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
            (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
            $num_result_rows,
            $event_cnt);
  }
  else
     printf("<P><B>No Sensors were found.  Is the database empty?</B><P>\n");

  echo '<FORM ACTION="acid_stat_sensor.php" METHOD="POST">';
  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 BGCOLOR="#000000">
        <TR><TD>
        <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 BGCOLOR="#FFFFFF">
        <TR>
           <TD></TD>
           <TD CLASS="plfieldhdr">Sensor</TD>
           <TD CLASS="plfieldhdr">Name</TD>
           <TD CLASS="plfieldhdr"> Total <BR> Events </TD>
           <TD CLASS="plfieldhdr"> Unique <BR> Events </TD>
           <TD CLASS="plfieldhdr"> Unique <BR> Src. Addr </TD>
           <TD CLASS="plfieldhdr"> Unique <BR> Dest. Addr </TD>
           <TD CLASS="plfieldhdr"> First <BR> Occurance </TD>
           <TD CLASS="plfieldhdr"> Last <BR> Occurance </TD>
        </TR>';

for ( $i = 0; $i < $sensor_cnt; $i++ )
{
     $num_src_ip = UniqueSrcAddrCntBySensor( $sensor_ids[$i], $db);
     $num_dst_ip = UniqueDestAddrCntBySensor( $sensor_ids[$i], $db);

     $start_time = MinDateBySensor( $sensor_ids[$i], $db );
     $stop_time = MaxDateBySensor( $sensor_ids[$i], $db );

     /* Print out */ 
     echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">';

     $tmp_rowid = $sensor_ids[$i];
     echo '    <TD><INPUT TYPE="checkbox" NAME="action_chk_lst['.$i.']" VALUE="'.$tmp_rowid.'"></TD>';
     echo '        <INPUT TYPE="hidden" NAME="action_lst['.$i.']" VALUE="'.$tmp_rowid.'">';

     printf("<TD ALIGN=CENTER>%s</TD>", $sensor_ids[$i]);
     echo '<TD ALIGN=CENTER> '.GetSensorName($sensor_ids[$i], $db).'</TD>';
     echo '<TD ALIGN=CENTER>&nbsp;&nbsp;
              <A HREF="acid_pkt_main.php?new=1&sensor='.$sensor_ids[$i].
                                        '&num_result_rows=-1'.
                                        '&submit=Query+DB">'.
              $raw_sensor_events[ $sensor_ids[$i] ].'</A>&nbsp;&nbsp;';

     if ( ($raw_sensor_events[ $sensor_ids[$i] ] != 0) && ($event_cnt > 0) )
           echo  ' ('.(round($raw_sensor_events[ $sensor_ids[$i] ]/$event_cnt*100)).'%)';

     echo '</TD>';
     echo '  <TD ALIGN=CENTER>'.
                BuildUniqueAlertLink("?sensor=".$sensor_ids[$i]).
                                    $unique_sensor_events[ $sensor_ids[$i] ].'</A>
                &nbsp;&nbsp;</TD>';
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;'.
               BuildUniqueAddressLink(1, "&sensor=".$sensor_ids[$i]).$num_src_ip.'</A>
               &nbsp;&nbsp;</TD>';
     echo '  <TD ALIGN=CENTER>'.
               BuildUniqueAddressLink(2, "&sensor=".$sensor_ids[$i]).$num_dst_ip.'</A></TD>';
     echo '  <TD ALIGN=CENTER>&nbsp;&nbsp;'.$start_time.'&nbsp;&nbsp;</TD>';
     echo '  <TD ALIGN=CENTER VALIGN=CENTER>&nbsp;&nbsp;'.$stop_time.'&nbsp;&nbsp;</TD>';
     echo '  </TR>';
}

echo "</TABLE>
      </TD></TR></TABLE>\n";

echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';

/* ****** Print out Browsing Buttons ********************************************/
PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);

PrintQueryResultAction($action, $ag_add_key, 5);

echo '</FORM>';

//  $db->acidClose();

  $stop = time();
  if ( $debug_time_mode > 0 )
    echo "<H3>[Loaded in ".($stop-$start)." seconds]</H3>";

?>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>
