#!/usr/bin/perl

# Ultimate Bulletin Board (UBB), Version 6
# Official Release Date for UBB6: March 15, 2001

# First version of UBB created May 7, 1996 (by Ted O'Neill).
# This entire program is copyright Infopop Corporation, 2001.
# For more info on the Ultimate Bulletin Board and other Infopop
# Products/Services, visit: http://www.infopop.com

# Program Author: Ted O'Neill, with assistance from Michael Farris, Dave Dreezer
# Special Thanks to: Rosemary O'Neill, Mark Badolato, Charles Capps, Graeme, Jesus de la Garza, Joe Siegler, Hal, Brett Harris, Kristi Miller, Celeste Combs, everyone who beta-tested, and all of our support moderators!

# UBB6 is dedicated to Edward Kriz.

# You may not distribute this program in any manner, modified or otherwise, without the express, written written consent from Infopop Corporation.

# You may make modifications, but only for your own use and within the confines of the UBB License Agreement (see our website for that).

# You may not distribute "hacks" for the UBB without approval from Infopop.

# Note: if you modify ANY code within the UBB, we at Infopop Corporation cannot offer you support-- thus modify at your own peril :)

#use strict;
use Fcntl ':flock';
use CGI::Carp qw(fatalsToBrowser carpout);
use CGI qw(:cgi-lib :standard);
#use vars qw(%vars_config %vars_display %vars_email %GotTime $status @memberslist %vars_wordlets_cp %vars_wordlets_email %vars_wordlets_err %vars_wordlets_img %vars_wordlets_date %template_match %vars_wordlets %vars_misc %vars_style %vars_search %vars_registration %vars_time @ubbadmin $username $password $InfopopCopyright $ThisHTML %in %ProfileNumber $memlistopen $CurrentTab %template $template $CPMenu $CPHeader $CPFooter $CPDropDown $Hiddens $public_name $LoginWording $admin_number $direct_to $version $version_number $cache_cookie %member_profile $selscript $exact_path);

undef($username); undef($password); undef(%ProfileNumber);
undef($memlistopen); undef($Hiddens); undef($public_name);
undef($admin_number); undef(%member_profile);
undef($selscript); undef(@ubbadmin); undef($ThisHTML); undef($CPMenu);
undef($CPHeader); undef($CPFooter); undef($LoginWording); undef($cache_cookie);
undef($status); undef(@memberslist); undef(%in); undef($exact_path);

eval {

# Get the script location: UNIX / or Windows /
($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");
# Get the script location: Windows \
($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

# modify the path for vars_config.cgi if VariablesPath differs from CGIPath:

require "vars_config.cgi";

# no need to touch there statements:

require "ubb_lib.cgi";
require "cp_lib.cgi";

};

if ($@) {
print qq%Content-type: text/html\n\n%;
print "Error including required files: $@\n";
print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
exit;
}

$cache_cookie = $vars_config{cache_pw};
$template = \%template;

unless (exists($vars_config{CachePath})) {
$vars_config{CachePath} = $vars_config{MembersPath};
}

ReadParse();

# is ubb6 configured yet/properly?
unless ((-e "$vars_config{MembersPath}/last_number.cgi") && (-e "$vars_config{VariablesPath}/vars_config.cgi") && (-e "$vars_config{CGIPath}/ultimatebb.cgi"))  {

# need to configure the UBB
require "ubb_setup.cgi";

if ($in{ubb} eq '') { &InitialConfig; exit; }
if ($in{ubb} eq 'env') { &DoEnv; exit; }
if ($in{ubb} eq 'set_initial') { &SetInitial; exit; }

exit;
}

# grab other required files
require "$vars_config{VariablesPath}/vars_display.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_cp.cgi";
require "$vars_config{VariablesPath}/vars_wordlets.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_err.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_img.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_date.cgi";
require "$vars_config{CGIPath}/ubb_lib_time.cgi";

# grab admin cookie
@ubbadmin = cookie("ubbadmin$vars_config{Cookie_Number}");

if ($in{ubb} eq 'logout') { &logout; exit; }  #end logout

# members area?
if ($in{ubb} eq 'members_area') {
print redirect('http://www.infopop.com/ubbmembers/ubbmembers.html'); exit;
}  #end members_area
# about_ot?
if ($in{ubb} eq 'about_ot') {
print redirect('http://www.infopop.com/services_ot/services_ot.html'); exit;
}  #end about_ot

# get current date/time
&GetDateTime;

# counter
&hit_me;

# is user logged in?
if (@ubbadmin) {
$username = $ubbadmin[0];
$password = $ubbadmin[1];
$status = $ubbadmin[2];
$public_name = $ubbadmin[3];
$admin_number = $ubbadmin[4];
chomp($username); chomp($password); chomp($status); chomp($public_name);
chomp($admin_number);

require "$vars_config{NonCGIPath}/Templates/cp_common.pl";
print qq%Content-type: text/html\n\n%;

# verify cookie id
my @this_admin = &verify_id_num($username, $password, $admin_number);

# is admin/mod?
my $is_one = &is_admin_or_mod("ALL", @this_admin);
$status = $this_admin[8]; chomp($status);
if ($is_one ne 'true') { &StandardHTML("$vars_wordlets_err{not_admin_or_mod}");
}

} else {

# not currently logged in---

if ($in{username}) {

$username = $in{username};
$password = $in{password};

# verify identity:
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
require "$vars_config{NonCGIPath}/Templates/cp_common.pl";

my @user_info = &verify_id($username, $password);
my $pn = $user_info[0];
my $admin_num = $user_info[2];
my @get_profile = &OpenProfile($admin_num);
$status = $get_profile[8]; chomp($status);

&CheckPermission_CP;
my $cookie = cookie(-name=> "ubbadmin$vars_config{Cookie_Number}", -value=> [$username, $password, $status, $pn, $admin_num], -path=> '/',);
print header(-cookie=>$cookie);

} else {

$LoginWording = qq%<FONT COLOR="Navy">&#187;</FONT> $vars_wordlets_cp{not_logged_in} <FONT COLOR="Navy">&#171;</FONT>%;
require "$vars_config{NonCGIPath}/Templates/cp_common.pl";
print qq%Content-type: text/html\n\n%;
&QueryLogin; exit;
}
}


$LoginWording = qq%<FONT COLOR="Navy">&#187;&#187;</FONT> $vars_wordlets_cp{welcome} $public_name &nbsp;&nbsp; [<A HREF="cp.cgi?ubb=logout">$vars_wordlets_cp{logout}</A>]%;

require "$vars_config{NonCGIPath}/Templates/cp_common.pl";

my $ubb = $in{ubb};

if ($ubb eq '') { $ubb = 'entry'; }

# Control Panel Options
if ($ubb eq 'entry') { &cp_entry_page; exit; } # end entry

if (($ubb eq 'vars_display') && ($status eq 'Administrator')) {
&view_vars("display"); exit;
}  #end vars_display

if (($ubb eq 'set_vars_display') && ($status eq 'Administrator')) {
&set_vars_display; exit;
}  #end set_vars_display

if (($ubb eq 'vars_email') && ($status eq 'Administrator')) {
&view_vars("email"); exit;
}  #end vars_email

if (($ubb eq 'vars_pm') && ($status eq 'Administrator')) {
&view_vars("pm"); exit;
}  #end vars_pm

if (($ubb eq 'set_vars_pm') && ($status eq 'Administrator')) {
&set_vars_pm; exit;
}  #end set_vars_pm

if (($ubb eq 'set_vars_email') && ($status eq 'Administrator')) {
&set_vars_email; exit;
}  #end set_vars_email

if (($ubb eq 'vars_time') && ($status eq 'Administrator')) {
&view_vars("time"); exit;
}  #end vars_time

if (($ubb eq 'set_vars_time') && ($status eq 'Administrator')) {
&set_vars_time; exit;
}  #end set_vars_time

if (($ubb eq 'email_members') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_email.cgi";
&email_members; exit;
}  #end email_members


if (($ubb eq 'email_type') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_email.cgi";
&email_type; exit;
}  #end email_type

if (($ubb eq 'send_email') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_email.cgi";
&send_email; exit;
}  #end send_email

if (($ubb eq 'vars_registration') && ($status eq 'Administrator')) {
&view_vars("registration"); exit;
}  #end vars_registration

if (($ubb eq 'set_vars_registration') && ($status eq 'Administrator')) {
&set_vars_registration; exit;
}  #end set_vars_registration

if (($ubb eq "vars_search") && ($status eq 'Administrator')) {
&view_vars("search"); exit;
}  #end vars_search

if (($ubb eq 'set_vars_search') && ($status eq 'Administrator')) {
&set_vars_search; exit;
}  #end set_vars_search

if (($ubb eq 'vars_misc') && ($status eq 'Administrator')) {
&view_vars("misc"); exit;
}  #end vars_misc

if (($ubb eq 'set_vars_misc') && ($status eq 'Administrator')) {
&set_vars_misc; exit;
}  #end set_vars_misc

if (($ubb eq 'vars_config') && ($status eq 'Administrator')) {
&view_vars("config"); exit;
}  #end vars_config

if (($ubb eq 'set_vars_config') && ($status eq 'Administrator')) {
&set_vars_config; exit;
}  #end set_vars_config

if (($ubb eq 'vars_style_temp_list') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&view_style_templates; exit;
}  #end vars_style_temp_list

if (($ubb eq 'vars_style') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&view_style; exit;
}  #end vars_style

if (($ubb eq 'templates_advanced') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&templates_advanced; exit;
}  #end templates_advanced

if (($ubb eq 'templates_advanced_forums') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&templates_advanced_forums; exit;
}  #end templates_advanced_forums

if (($ubb eq 'set_advanced_templates') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&set_advanced_templates("$in{type}"); exit;
}  #end set_advanced_templates

if (($ubb eq 'set_vars_style') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&set_vars_style; exit;
}  #end set_vars_style

if (($ubb eq 'add_style_template') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&add_style_template; exit;
}  #end add_style_template

if (($ubb eq "set_new_template") && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_styles.cgi";
&set_new_template; exit;
}  #end set_new_template

if (($ubb eq "do_add_forum") && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&do_add_forum; exit;
}  #end vars_forums

if ($ubb eq 'get_forum_details')  {
require "$vars_config{CGIPath}/cp_forums.cgi";
&get_forum_details; exit;
}  #end get_forum_details

if ($ubb eq 'update_forum') {
require "$vars_config{CGIPath}/cp_forums.cgi";
&update_forum; exit;
}  #end update_forum

if (($ubb eq 'delete_forum') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&delete_forum; exit;
}  #end delete_forum

if ($ubb eq 'vars_forums')  {
require "$vars_config{CGIPath}/cp_forums.cgi";
&view_forum_intro; exit;
}  #end vars_forums

if (($ubb eq 'set_vars_forums') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&set_vars_forums; exit;
}  #end set_vars_forums

if (($ubb eq 'cats') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&view_cats; exit;
}  #end view_cats

if (($ubb eq 'set_cats') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&set_cats; exit;
}  #end set_cats

if (($ubb eq 'addforums') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&add_forum; exit;
}  #end set_addforums

if (($ubb eq 'set_vars_mods') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_forums.cgi";
&set_mods; exit;
}  #end set_mods

if (($ubb eq 'ban_lists') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_bans.cgi";
&ban_lists; exit;
}  #end ban_lists

if (($ubb eq 'update_bans') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_bans.cgi";
&update_bans; exit;
}  #end update_bans

if (($ubb eq 'vars_mod') && ($status eq 'Administrator')) {
&view_vars("mods"); exit;
}  #end vars_mod

if (($ubb eq 'user_settings') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&user_settings; exit;
}  #end user_settings

if (($ubb eq 'search_members') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&search_members; exit;
}  #end search_members

if (($ubb eq 'update_members') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&update_members; exit;
}  #end update_members

if (($ubb eq 'get_profile_for_admin') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&get_profile_for_admin; exit;
}  #end get_profile_for_admin

if (($ubb eq 'edit_profile') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&edit_profile; exit;
}  #end edit_profile

if (($ubb eq 'new_members') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&new_members; exit;
}  #end new_members

if (($ubb eq 'reg_moderation') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&reg_moderation; exit;
}  #end reg_moderation

if (($ubb eq 'update_q') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_users.cgi";
&update_q; exit;
}  #end update_q

if (($ubb eq 'cache') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_cache.cgi";
&cache; exit;
}  #end cache

if (($ubb eq 'clear_cache') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_cache.cgi";
&clear_cache; exit;
}  #end clear_cache


if (($ubb =~ /wordlets/) && ($ubb ne "set_wordlets") && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_wordlets.cgi";
&view_wordlets($ubb); exit;
}  #end view_wordlets

if (($ubb eq 'set_wordlets') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_wordlets.cgi";
&set_wordlets; exit;
}  #end set_wordlets


if ($ubb eq 'license_check') {
require "$vars_config{CGIPath}/cp_license.cgi";
&license_check; exit;
}  #end license_check

if ($ubb eq 'version_check') {
require "$vars_config{CGIPath}/cp_license.cgi";
&version_check; exit;
}  #end version_check

if ($ubb eq 'prune') {
require "$vars_config{CGIPath}/cp_prune.cgi";
&prune; exit;
}  #end prune

if ($ubb eq 'prune_option') {
require "$vars_config{CGIPath}/cp_prune.cgi";
&prune_by; exit;
}  #end prune_option

if ($ubb eq 'prune_request') {
require "$vars_config{CGIPath}/cp_prune.cgi";
if ($in{prune_option} eq "DATE") {
&prune_by_date_request;
}  else {
&prune_by_user_request;
}
exit;
}  #end prune_request

if ($ubb eq 'prune_submit') {
require "$vars_config{CGIPath}/cp_prune.cgi";
&prune_submit; exit;
}  #end prune_submit

if ($ubb eq 'do_index') {
require "$vars_config{CGIPath}/cp_index.cgi";
&do_index; exit;
}
if ($ubb eq 'index') {
require "$vars_config{CGIPath}/cp_index.cgi";

if ($in{start} eq '') { $in{start} = 1; }
if ($in{thread_point} eq '') { $in{thread_point} = 0; }

&build_index($in{start}, $in{thread_point}); exit;

}  #end index

if (($ubb eq 'post_history') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_index.cgi";
&post_history; exit;
}  #end post_history

if (($ubb eq 'update_post_history') && ($status eq 'Administrator'))  {
require "$vars_config{CGIPath}/cp_index.cgi";

if ($in{start} eq '') { $in{start} = 1; }
if ($in{thread_point} eq '') { $in{thread_point} = 0; }

&build_history($in{start}, $in{thread_point}); exit;

}  #end update_post_history

# new:
if (($ubb eq 'rebuild_members') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_index.cgi";
&rebuild_members; exit;
}  #end post_history

if (($ubb eq 'do_rebuild_members') && ($status eq 'Administrator'))  {
require "$vars_config{CGIPath}/cp_index.cgi";

if ($in{start} eq '') { $in{start} = 0; }

&build_members($in{start}, $in{thread_point}); exit;

}  #end do_rebuild_members


if (($ubb eq 'forum_stats') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_index.cgi";
&forum_stats; exit;
}  #end forum_stats

if (($ubb eq 'build_forum_stats') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_index.cgi";
if ($in{build_forum} eq 'ALL') {
&all_build_forum_stats($in{build_forum});
} else {
&build_forum_stats($in{build_forum}, 1);
}
exit;
}  #end build_forum_stats

if (($ubb eq "all_build_forum_stats") && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_index.cgi";
&all_build_forum_stats($in{build_forum});
exit;
}  #end all_build_forum_stats

if (($ubb eq 'import_archives') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_import.cgi";
&import_archives; exit;
}  # end import_archives

if (($ubb eq 'get_archives') && ($status eq 'Administrator')) {
require "$vars_config{CGIPath}/cp_import.cgi";
&get_archives; exit;
}  # end get_archives

# default error-- obviously they do not have permission
&StandardHTML("$vars_wordlets_cp{no_access}");
exit(0);



