# Control Panel - Email Members Routines

require "$vars_config{VariablesPath}/vars_email.cgi";
require "$vars_config{VariablesPath}/vars_template_match.cgi";
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
require "$vars_config{VariablesPath}/vars_display.cgi";

sub email_members {
$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="email_type">
%;
$CurrentTab = qq%$vars_wordlets_cp{email_members}%;

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_email_intro.pl";
&CPBottom;
}

sub email_type {
local(@user_profile);
$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="send_email">
<INPUT TYPE="HIDDEN" NAME="email_option" VALUE="$in{email_option}">
%;


if ($in{email_option} eq 'list_only') {
$CurrentTab = "Prepare Email List";

}  else {
$CurrentTab = "Send Emails";

}

@user_profile = &OpenProfile($admin_number);
chomp($user_profile[2]);

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_email_type.pl";
&CPBottom;

} # end email_type


sub send_email {
local($one, @all_member_nums, @line, @this_member, @new_array, $bad, $list_served, $sender_included, %good_emails, $random, $message, $HTMLmessage, @user_profile);
local(*FILE);

# validate
if ($in{user_number_start} ne '') {
unless ($in{user_number_start} > 0) {
	&StandardHTML("$vars_wordlets_err{invalid_number} Low Member Number");
}
}
if ($in{user_number_end} ne '') {
unless ($in{user_number_start} > 0) {
	&StandardHTML("$vars_wordlets_err{invalid_number} High Member Number");
}
}
if ($in{Posts} ne '') {
unless ($in{Posts} >= 0) {
	&StandardHTML("$vars_wordlets_err{invalid_number} Number of Posts");
}
}

# filter list first:
my @all_members_list = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

foreach $one(@all_members_list) {
	@line = split(/\|\!\!\|/, $one); chomp($line[1]);
	push (@all_member_nums, $line[1]);
}

if (($in{user_number_start} ne '') && ($in{user_number_end} ne '')) {
foreach (@all_member_nums) {

if (($_ >= $in{user_number_start}) && ($_ <= $in{user_number_end}) ) {
push(@new_array, $_);
} # end unless
} # end foreach

@all_member_nums = @new_array;
} # end if

# clear working array
undef(@new_array);

foreach $one(@all_member_nums) {
$bad = 'no';
# open profile
@this_member = &OpenProfile($one);

# filter by member allow
chomp($this_member[14]);
if ($this_member[14] eq 'no') { $bad = 'yes'; }

# filter by status
if (($in{user_status} ne '') && ($bad ne 'yes')) {
chomp($this_member[8]);
if ($user_status eq 'admin') {
	unless ($this_member[8] eq 'Administrator') { $bad = 'yes'; }
}  else {
	unless (($this_member[8] eq 'Administrator') || ($this_member[8] eq 'Moderator')) {
	$bad = 'yes';
	}
}

} # end user status check

# posts filter
if (($in{Posts} ne '') && ($bad ne 'yes')) {
chomp($this_member[7]);
	if ($in{Math} eq 'GT') {
		unless ($this_member[7] >= $in{Posts}) { $bad = 'yes';  }
	}
	elsif ($in{Math} eq 'LT') {
		unless ($this_member[7] <= $in{Posts}) { $bad = 'yes';	}
	}  else {
		unless ($this_member[7] == $in{Posts}) { $bad = 'yes'; 	}
	}
} # end posts check

chomp($this_member[2]);
if ($bad ne 'yes')  {
unless (exists($good_emails{$this_member[2]})) {
$good_emails{$this_member[2]} = 'y';
push (@new_array, $this_member[2]);
}

}

} # end foreach one

@all_member_nums = @new_array;
my $total = @all_member_nums;

# now we have the complete filtered list-> @all_member_nums

# delimiter:
if ($in{email_option} eq 'list_only') {

if ($in{list_type} eq 'lr') {

if ($in{send_list} eq 'onscreen') {
$list_served = join("<BR>", @all_member_nums);
} else {
$list_served = join("\n", @all_member_nums);
}

}  else {
$list_served = join(", ", @all_member_nums);
}

$random = &GeneratePassword;

# choose formatting
if ($in{send_list} eq 'file') {

open (FILE, ">$vars_config{NonCGIPath}/email_members_$random.txt");
print FILE "$list_served\n";
close (FILE);

&cp_confirm("List Created", "Thank you.  We have created a file containing all matching email addresses.  There were $total unique email addresses.  This file is stored in your UBB NON CGI directory.  The file name is: email_members_$random.txt<P>We advise you to remove this file from your server after you have used it.");
exit;

}
elsif ($in{send_list} eq 'onscreen') {

&cp_confirm("List Created", "Thank you.  We have printed your entire list below.  There were $total unique email addresses that matched the criteria you provided.<P>$list_served<P>");
exit;


}  else {
# by email


do "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

$message = "$vars_wordlets_email{email_list}\n\r\n$list_served";

# get email address for logged in user
@user_profile = &OpenProfile($admin_number);
chomp($user_profile[2]);


# do not send as HTML email!
&ubb_mail("$user_profile[2]", "$vars_display{BBEmail}", "", "$vars_wordlets_email{email_list_subject}: $random", "$message", "", "");

&cp_confirm("List Created", "Thank you.  We have emailed your entire list to $user_profile[2].  There were $total unique email addresses that matched the criteria you provided.  The reference number for this email list is: $random.");
exit;
}


}  else {

# actually send emails
if ($total > 200) {
	&StandardHTML("$vars_wordlets_err{too_many_emails} $total");
}

# validate HTML form
my @ValidateArray = ("return_email", "subject", "message");
&Validate(@ValidateArray);

# get email address for logged in user- for BCC
@user_profile = &OpenProfile($admin_number);
chomp($user_profile[2]);

$list_served = join(", ", @all_member_nums);

# is HTML format to be sent?
if ($in{email_type} eq 'html') {

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
require "$vars_config{NonCGIPath}/Templates/public_common.pl";
&set_page_elements;
my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$in{message}" . qq!</FONT>!;

$HTMLmessage = "$EmailHeader $html_body $Footer";
}  else {
$HTMLmessage = '';
}

foreach (@all_member_nums) {
if ($_ eq "$user_profile[2]") { $sender_included = 'yes'; }

&ubb_mail("$_", "$in{return_email}", "", "$in{subject}", "$in{message}", "$HTMLmessage", "");

} # foreach

# send copy to sender:
if ($sender_included ne 'yes') {
&ubb_mail("$user_profile[2]", "$in{return_email}", "", "$in{subject}", "$in{message}", "$HTMLmessage", "");
}

&cp_confirm("Email Sent!", "Thank you.  We have sent an email to each member that matches the criteria you selected. We have also sent you a copy of this email.  There were $total unique email addresses that matched the criteria you provided.  Here is the complete list of email addresses:<P>$list_served");
exit;

} # end email option if/else


} # end send_email

# Danger- do not remove the following line!
1;