# Control Panel - Routines for setting, managing forums/categories

sub view_forum_intro {
local(@forums, $ForumTotal, @CATEGORIES, $SortByCateogry, $SortIt, $SortByNumber, $SortByAlpha, $check, @getalpha, $AlphaUC, $AlphaLine, @sortthis, @sorted, $uno, $j, $k, @final, @sortcat, $cat_type, $ThisCatNam, $ThisCanNumb, @catgroup, @sortrows, $sortline, @presort, @presort2, @subtotal, $Empties, @thisrow, $OrdIt, @nocat, $Whole, $Calibrate, $EndPoint, $CalibrateEnd, $NextLine, @thisfor, $ThisNum, $ThisCategory, $OrderNum, $OrderNumber, $StatusOn, $StatusOff, $ThisSelected, $StartPoint);
# do we have a categories file?
unless (-e "$vars_config{NonCGIPath}/categories.file") {
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&AssembleCats; 
}

@forums = &OpenForumsFile;
$ForumTotal = @forums;

# how are we sorting?
$SortByCategory = ''; $SortByNumber = ''; $SortByAlpha = '';
if ($in{sortby} eq 'Category') {
	$SortByCategory = 'SELECTED'; 	$SortIt = 'Category';
}
elsif (($in{sortby} eq '') || ($in{sortby} eq 'Number')) {
	$SortByNumber = 'SELECTED'; $SortIt = 'Number';
}
elsif ($in{sortby} eq 'AlphaForce') {

$SortByAlphaForce = 'SELECTED'; $SortIt = 'AlphaForce';
}  else {
	$SortByAlpha = 'SELECTED'; 	$SortIt = 'Alpha';
}


#retreive category list
@CATEGORIES = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

if (($SortIt eq 'Alpha') || ($SortIt eq 'AlphaForce'))  {
foreach $check(@forums) {
@getalpha = split(/\|\^\|/, $check);
$AlphaUC = uc($getalpha[1]);
$AlphaLine = "$AlphaUC||**||$check";
push(@sortthis, $AlphaLine);
}
@sorted = sort(@sortthis);
foreach $uno(@sorted) {
($j, $k) = split(/\|\|\*\*\|\|/, $uno);
chomp($k);
push(@final, $k);
}

} 
elsif ($SortIt eq 'Number') {
@final = @forums;
}  else {

@final =();
@sortcat = sort(@CATEGORIES);

if (@sortcat) {

foreach $cat_type(@sortcat) {

($j, $ThisCatNam, $ThisCatNumb) = split(/\|\^\|/, $cat_type);
chomp($ThisCatNumb);

@catgroup = (); @sortthis = ();

foreach $check(@forums) {
if ($check =~ /^$ThisCatNumb\|\^\|/) { push(@catgroup, $check); }
}

#now sort the subset
foreach $uno(@catgroup) {
	@sortrow = split(/\|\^\|/, $uno);
	chomp($sortrow[14]);
	$sortline = "$sortrow[14]||**||$uno";
	push(@sortthis, $sortline);
	}
	@presort = sort(@sortthis);
	@subtotal = (@subtotal, @presort);
}  #end cat loop

#check for forums witout cats

foreach $check(@forums) {
if ($check =~ /^\|/) {
	$Empties = "true";
	chomp($check);
		@thisrow = split(/\|\^\|/, $check);
		chomp($thisrow[14]);
		if ($thisrow[14]) {
			$OrdIt = $thisrow[14];
		} else {
			$OrdIt = $thisrow[8];
		}
		$sortline = "$OrdIt||**||$check";
		push(@nocat, $sortline);
}
}
if ($Empties eq 'true') {
	@presort2 = sort(@nocat);
	@subtotal = (@subtotal, @presort2);
}
	
	foreach $uno(@subtotal) {
	($j, $k) = split(/\|\|\*\*\|\|/, $uno);
	chomp($k);
	push(@final, $k);
	}
	
}  else {

#no cats
	foreach $uno(@forums) {
		@sortrow = split(/\|\^\|/, $ion);
		chomp($sortrow[14]);
		$sortline = "$sortrow[14]||**||$uno";
		push(@sortthis, $sortline);
	}
	@subtotal = sort(@sortthis);

	foreach $uno(@subtotal) {
	($j, $k) = split(/\|\|\*\*\|\|/, $uno);
	chomp($k);
	push(@final, $k);
	}
}
}

# now we have our sorted array of forums - @final
# limit array to max of 50 per page

my $MaxForumDisplay = 50;
if ($ForumTotal > $MaxForumDisplay) {
my $TotalPages = int ($ForumTotal / $MaxForumDisplay);
if ($ForumTotal % $MaxForumDisplay) {  $TotalPages++ };

if (($in{StartPoint} eq '') || ($in{StartPoint} == 0)){
	$StartPoint = 0;
} else {
	$StartPoint = $in{StartPoint};
	$StartPoint = $StartPoint + 0;
}

	$Calibrate = $StartPoint + 1;
	$EndPoint = $StartPoint + ($MaxForumDisplay - 1);
	$CalibrateEnd = $EndPoint + 1;
	if ($ForumTotal < $CalibrateEnd) {
		$CalibrateEnd = $ForumTotal;
		$EndPoint = $CalibrateEnd - 1;
	}

my $eachpage = 1;

$NextLine = "Forum Number Ranges: &nbsp;&nbsp;&nbsp;&nbsp;";
for ($eachpage == 1; $eachpage <= $TotalPages; $eachpage++) {
$EndHere = $eachpage * $MaxForumDisplay;
my $StartHere = $EndHere - ($MaxForumDisplay - 1);
my $ArrayStart = $StartHere - 1;
if ($ForumTotal < $EndHere) {
	$EndHere = $ForumTotal;
}
if ($Calibrate == $StartHere) {
$NextLine .= qq(&nbsp;$StartHere - $EndHere&nbsp;);
}  else {
$NextLine .= qq(&nbsp;<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_forums&StartPoint=$ArrayStart&sortby=$in{sortby}">$StartHere - $EndHere</A>&nbsp;)
}

}

@final = @final[$StartPoint...$EndPoint];



} else {
$NextLine = '';

} #if/else more than 30 forums

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_vars_forums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$StartPoint">
<INPUT TYPE="HIDDEN" NAME="sortby" VALUE="$in{sortby}">
%;
$CurrentTab = qq%$vars_wordlets_cp{forum_settings}%; 



&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_vars_forums.pl";
&CPBottom;
exit;
} #end view_vars

sub set_vars_forums {
local ($j, $key, $num, $number, $arrayrow, %order, %status, %name, %category, $fn, @this_row, $new_row);
local(*FILE);

# read current forum data
my @forums = &OpenForumsFile;

foreach $key (keys %in) {
	if ($key =~ /ForumName/) {
		($j, $number) = split(/\|\^\|/, $key);
		$name{$number} = $in{$key};
		$name{$number} =~ s/"/&quot\;/g;
	}
	if ($key =~ /ForumCategory/) {
		($j, $number) = split(/\|\^\|/, $key);
		$category{$number} = $in{$key};
	}
	if ($key =~ /ForumStatus/) {
		($j, $number) = split(/\|\^\|/, $key);
		$status{$number} = $in{$key};
	}
	if ($key =~ /ForumOrder/) {
		($j, $number) = split(/\|\^\|/, $key);
		$order{$number} = &Do6Digit($in{$key});
	}
}  #end keys loop

# write to forums file
open (FILE, ">$vars_config{VariablesPath}/vars_forums.cgi") || die ("Cannot open the vars_forums.cgi file for writing.<P>Here is the error:<p>$!"); 
&lock;
foreach (@forums) {

chomp($_);
@this_row = split(/\|\^\|/, $_);
$fn = $this_row[8];

if (exists($status{$fn})) {

$this_row[0] = $category{$fn};
$this_row[1] = $name{$fn};
$this_row[14] = $order{$fn};
$this_row[3] = $status{$fn};
if ($this_row[15] eq '') { $this_row[15] = 'date'; }

$new_row = join("|^|", @this_row);

print FILE "$new_row"; print FILE "\n";

}  else {

print FILE "$_"; print FILE "\n";
}

}
&unlock;
close (FILE);
chmod (0777, "$vars_config{VariablesPath}/vars_forums.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

# confirm:
&cp_confirm("Forums Updated");
exit;

} # end set vars forums

sub view_cats {
local(@CATEGORIES, $SortByCategory, $SortByNumber, $SortByAlpha, $SortIt, $check, @getalpha, $AlphaUC, $AlphaLine, @sortthis, @sorted, $j, $k, $uno, @catz, $CatOrder, $CatNumber, $CatName, $CatOrderSimp);

# set sort type
if ( ($in{sortby} eq '') || ($in{sortby} eq 'Category')) {
	$SortByCategory = 'SELECTED'; 	$SortIt = 'Category';
}
elsif ($in{'sortby'} eq "Number") {
	$SortByNumber = 'SELECTED'; 		$SortIt = 'Number';
}  else {
	$SortByAlpha = 'SELECTED'; 	$SortIt = 'Alpha';
}



#retreive category list
@CATEGORIES = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

# do the sort!
if ($SortIt eq 'Alpha') {
foreach $check(@CATEGORIES) {
@getalpha = split(/\|\^\|/, $check);
$AlphaUC = uc($getalpha[1]);
$AlphaLine = "$AlphaUC||**||$check";
push(@sortthis, $AlphaLine);
}
@sorted = sort(@sortthis);
foreach $uno(@sorted) {
($j, $k) = split(/\|\|\*\*\|\|/, $uno);
chomp($k);
push(@catz, $k);
}

} 
elsif ($SortIt eq 'Number') {
@catz = @CATEGORIES;
}  else {
@catz = sort(@CATEGORIES);
}

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_cats">
%;
$CurrentTab = qq%$vars_wordlets_cp{category_settings}%; 

&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_forums_cats.pl";
&CPBottom;


} #end view cats

sub set_cats {
local ($key, $j, $num, $CatNumber, @AdjustCats, $ThisName, $ThisOrder, $ThisOrderPre, $arrayrow, @thiscat, $TotalCats, $NextCat, $one, @matches, $NewOrder, $CatLine);
local(*FORUMS);

foreach $key (keys %in) {
if ($key =~ /CatName/) {
($j, $CatNumber) = split(/\|\^\|/, $key);
push(@AdjustCats, $CatNumber);
}
}  #end loop through hash

# now we have list of cat numbers to adjust

my @CATS = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

for $num(@AdjustCats) {
chomp($num);

foreach $key (keys %in) {

if ($key eq "CatName|^|$num") {
	$ThisName = $in{$key};
	$ThisName =~ s/"/&quot\;/g;
}

if ($key eq "CatOrder|^|$num") {
	$ThisOrderPre = $in{$key};
	$ThisOrder = &Do6Digit($ThisOrderPre);
}


}  #end loop through hash


$arrayrow = ($num - 1);

$CATS[$arrayrow] = ("$ThisOrder|^|$ThisName|^|$num\n");

}  #end for each @AdjustCats

$TotalCats = @CATS;
$NextCat = $TotalCats + 1;

#check for new cats
if ($in{NewCats} ne '') {
my $NewCats = $in{NewCats};
$_ = $NewCats;

while (m/(\[)(.*?)(\])/g) {  push(@matches, $2); }

foreach $one(@matches) {
if ($one !~ m/(\[|\])/) {
chomp($one);
$NewOrder = &Do6Digit($NextCat);
$CatLine = "$NewOrder|^|$one|^|$NextCat\n";
push(@CATS, $CatLine);
$NextCat++;
}
}
}

#write to cats file
open (FILE, ">$vars_config{NonCGIPath}/categories.file"); 
&lock;
print FILE (@CATS);
&unlock;
close (FILE);

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

&view_cats;
exit;
}  # end set cats

sub CatDropDown {

$CategoryDropDown = qq(<SELECT NAME="ForumCategory|^|$ThisNum">);
$Count = 0;
if ($ThisCategory eq '') {
	$ThisSelected = 'SELECTED';
} else {
	$ThisSelected = '';
}
$CategoryDropDown .= qq(<OPTION VALUE="" $ThisSelected>No Category);
foreach $uno(@CATEGORIES) {
($j, $ThisCatNam, $ThisCatNumb) = split(/\|\^\|/, $uno);
chomp($ThisCatNumb);
$ThisCatNumb = $ThisCatNumb + 0;
$Count++;
if ($ThisCatNumb == $ThisCategory) {
	$Selection = 'SELECTED';
} else {
	$Selection = '';
}
$CategoryDropDown .= qq(<OPTION VALUE="$ThisCatNumb" $Selection>$ThisCatNam);
}


if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value=''>No Categories Created Yet);
}
$CategoryDropDown .= '</SELECT>';

} #end cat drop down

sub add_forum {
local ($StyleDropDown, $CategoryDropDown, $cat, $Count, $j, $g, $CatName, $CatNumber, $thisname, $thisnum);

my @CATEGORIES = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");
$CategoryDropDown = qq(<SELECT NAME="Category">);
$CategoryDropDown .= qq(<OPTION Value='' SELECTED>Select One:);
$CategoryDropDown .= qq(<OPTION Value=''>No Category);
$Count = 0;
foreach $cat(@CATEGORIES) {
$Count++;
($j, $CatName, $CatNumber) = split(/\|\^\|/, $cat);
chomp($CatNumber);
$CategoryDropDown .= qq(<OPTION value="$CatNumber">$CatName);
}

if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value="">No Categories Created Yet);
}
$CategoryDropDown .= "</SELECT>";


# create style list drop down box
$StyleDropDown = qq!<SELECT NAME="template_number">!;
my @templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");
foreach $g(@templates) {
($thisname, $thisnum) = split(/\|\^\|/, $g);
chomp($thisnum);
$StyleDropDown .= qq!<OPTION value="$thisnum">$thisname</OPTION>!;
}
$StyleDropDown .= qq!</SELECT>!;

$CurrentTab = qq%<A HREF="cp.cgi?ubb=vars_forums">Forum Settings</A> &gt;&gt; Add New Forum%;
&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_forum_add.pl";
&CPBottom;

} #add forum

sub do_add_forum {
local ($ForumPermission, $key, $DIRPW, $Description, $DescLength);
local(*INDEX); local(*FILE);

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_forums">$vars_wordlets_cp{forum_settings}</A>%;

&CPHeader; &CPFooter;

# validate
my @ValidateArray = ("Namer", "template_number", "forum_sort");
&Validate(@ValidateArray);

#other checks
if ($in{Namer} =~ /\|\^/) {
&StandardHTML("$vars_wordlets_err{forum_name_badchar}");
}
if ($in{Description} =~ /\|\^/) {
&StandardHTML("$vars_wordlets_err{forum_desc_badchar}");
}
# get largest forum number
my @forums = &OpenForumsFile;
my @reverse_it = reverse(@forums);
my @last_forum = split(/\|\^\|/, $reverse_it[0]);
my $last_number = $last_forum[8];

# create new forum number
my $next_number = $last_number + 1;

#clean up forum description & more
$Description = $in{Description};
$Description =~ s/"/&quot\;/g; $Description =~ s/\n\r\n//g;
$Description =~ s/\n//g; $Description =~ s/\r//g;
$Description =~ s/  / /g;

# clean up forum intro/announcement
my $announcement = $in{announcement};
$announcement =~ s/\|/&#0124;/g;
$announcement = &ConvertReturns($announcement);

# make sure forum pw does not contain |^
if ($in{forum_pw} =~ /\|\^/) {
&StandardHTML($vars_wordlets_err{forum_pw_illegal});
}

my $Name = $in{Namer};
$Name =~ s/"/&quot\;/g;
my $Category = $in{Category};

#is this a private forum?
if ($in{Private} eq 'private') {
#create HTML directory alternate to keep contents hidden
$DIRPW = &GeneratePassword;
if ($Description ne '') {
$DescLength = length($Description);
}  else {
$DescLength = 6;
}
$DIRPW .= "$DescLength";
}  else {
$DIRPW = '';
}

if ($in{Private} eq 'private') {
	$ForumPermission = 'private';
}  else {
	$ForumPermission = "$in{TopicRestrict}&$in{ReplyRestrict}";
}
my $OrderNumber = &Do6Digit($next_number);


my $newforumline = ("$Category|^|$Name|^|$Description|^|$in{Status}|^|$in{HTML}|^|$in{UBB}|^|$ForumPermission|^|$DIRPW|^|$next_number|^||^|$in{UBBImages}|^|$in{ModNotify}|^|$in{forum_pw}|^||^|$OrderNumber|^|$in{forum_sort}|^|$announcement");

#write to vars_forums.cgi file
open (FILE, ">>$vars_config{VariablesPath}/vars_forums.cgi") || &StandardHTML("$vars_wordlets_err{cant_write_to_file}: vars_forums.cgi");
&lock;
print FILE ("$newforumline\n");
&unlock;
close (FILE);

#create new Forum Directory with permissions for UNIX servers
mkdir("$vars_config{NonCGIPath}/Forum$next_number", 0777);
chmod (0777, "$vars_config{NonCGIPath}/Forum$next_number");
mkdir("$ForumsPath/Forum$next_number/ANNC", 0777);
chmod (0777, "$vars_config{NonCGIPath}/Forum$next_number/ANNC");

# create private directories, if necessary
if ($DIRPW ne '') {
mkdir("$vars_config{NonCGIPath}/Forum$next_number/private-$DIRPW", 0777);
chmod (0777, "$vars_config{NonCGIPath}/Forum$next_number/private-$DIRPW");

open (INDEX, ">$vars_config{NonCGIPath}/Forum$next_number/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
}

# assign proper template for new forum
require "$vars_config{VariablesPath}/vars_template_match.cgi";
$thiskey = "forum_$next_number";
$template_match{$thiskey} = "$in{template_number}";

open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
print FILE qq!\%template_match = (\n!;
&lock;
foreach $key (keys %template_match) {
print FILE qq!$key => "$template_match{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);

# clear cache
&ClearSummaryCache;

# on screen display
&cp_confirm("Forum Added");
exit;

} # end: do add forum

sub get_forum_details {
local(@thisforum, $Count, $cat, $CatNumber, $CatName, $j, $g, $thisname, $thisnum, $TopicRestrict, $ReplyRestrict, $status_on, $status_off, $html_on, $html_off, $ubb_code_on, $ubb_code_off, $images_on, $images_off, $mod_notify_on, $mod_notify_off, $private_max_on, $private_max_off, $forum_pw, $topic_restrict_select, $topic_allreg_select, $topic_all_select, $reply_restrict_select, $reply_allreg_select, $reply_all_select, $reply_none_select, $private_checked, $number, $StyleDropDown, $CategoryDropDown);


# make sure user has authority
my @user_profile = &verify_id_num($username, $password, $admin_number);
my $user_perm = &is_admin_or_mod($in{number}, @user_profile);
unless ($user_perm eq 'true') {
&StandardHTML("$vars_wordlets_err{no_permission}");
}

@thisforum = &GetForumRecord($in{number});

my @CATEGORIES = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

$CategoryDropDown = qq(<SELECT NAME="Category">);
$CategoryDropDown .= qq(<OPTION Value="">$vars_wordlets_cp{select_one});
$CategoryDropDown .= qq(<OPTION Value="">$vars_wordlets_cp{no_category});
$Count = 0;

foreach $cat(@CATEGORIES) {
$Count++;
($j, $CatName, $CatNumber) = split(/\|\^\|/, $cat);
chomp($CatNumber);
if ($thisforum[0] eq "$CatNumber") {
$CategoryDropDown .= qq(<OPTION value="$CatNumber" SELECTED>$CatName);
} else {
$CategoryDropDown .= qq(<OPTION value="$CatNumber">$CatName);
}

}

if ($Count == 0) {
$CategoryDropDown .= qq(<OPTION value="" SELECTED>$vars_wordlets_cp{no_categories_created});
}
$CategoryDropDown .= '</SELECT>';


# get template match
require "$vars_config{VariablesPath}/vars_template_match.cgi";
my $thisone = "forum_$thisforum[8]";

# create style list drop down box
$StyleDropDown = qq!<SELECT NAME="template_number">!;
my @templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");
foreach $g(@templates) {
($thisname, $thisnum) = split(/\|\^\|/, $g);
chomp($thisnum);
if ($template_match{$thisone} eq "$thisnum") {
$StyleDropDown .= qq!<OPTION value="$thisnum" SELECTED>$thisname</OPTION>!;
} else {
$StyleDropDown .= qq!<OPTION value="$thisnum">$thisname</OPTION>!;
}

}
$StyleDropDown .= qq!</SELECT>!;

chomp($thisforum[15]); chomp($thisforum[16]);
if ($thisforum[15] eq '') { $thisforum[15] = 'date'; }

# on/off switches~~
if ($thisforum[3] eq 'On') { $status_on = 'CHECKED'; }
if ($thisforum[3] eq 'Off') { $status_off = 'CHECKED'; }
if ($thisforum[4] eq 'is') { $html_on = 'CHECKED'; }
if ($thisforum[4] eq 'is not') { $html_off = 'CHECKED'; }
if ($thisforum[5] eq 'is') { $ubb_code_on = 'CHECKED'; }
if ($thisforum[5] eq 'is not') { $ubb_code_off = 'CHECKED'; }
if ($thisforum[10] eq 'ON') { $images_on = 'CHECKED'; }
if ($thisforum[10] eq 'OFF') { $images_off = 'CHECKED'; }
if ($thisforum[11] eq 'yes') { $mod_notify_on = 'CHECKED'; }
if ($thisforum[11] eq "no") { $mod_notify_off = 'CHECKED'; }
if ($thisforum[15] eq 'date') { $forum_sort_date = 'CHECKED'; }
if ($thisforum[15] eq 'abc') { $forum_sort_abc = 'CHECKED'; }
if ($thisforum[15] eq '') { $forum_sort_date = 'CHECKED'; }

if (($thisforum[6] =~ /\&/) && ($thisforum[6] ne 'private')){
($TopicRestrict, $ReplyRestrict) = split(/\&/, $thisforum[6]);

if ($TopicRestrict eq 'restrict') {
	$topic_restrict_select = 'SELECTED';  }
elsif ($TopicRestrict eq 'allreg') {
	$topic_allreg_select = 'SELECTED'; }
elsif ($TopicRestrict eq 'none') {
	$topic_none_select = 'SELECTED';
} else  {
	$topic_all_select = 'SELECTED';
}

if ($ReplyRestrict eq 'restrict') {
	$reply_restrict_select = 'SELECTED'; }
elsif ($ReplyRestrict eq 'allreg') {
	$reply_allreg_select = 'SELECTED'; }
elsif ($ReplyRestrict eq 'all') {
	$reply_all_select = 'SELECTED';
}  else  {
	$reply_none_select = "SELECTED";
}

}  else {
	$private_checked = 'CHECKED';
	$reply_restrict_select = 'SELECTED';
	$topic_restrict_select = 'SELECTED';
}

$Hiddens = qq~
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$in{number}">
<INPUT TYPE="HIDDEN" NAME="old_sort" VALUE="$thisforum[15]%%">
~;

$CurrentTab = qq%<A HREF="cp.cgi?ubb=vars_forums">$vars_wordlets_cp{forum_settings}</A> &#187; $thisforum[1]%;
&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_edit_forum.pl";
&CPBottom;

exit;
} # end get_forum_details


sub update_forum {
local (@forums, @thisforum, $ForumPermission, $NewRow, @check, $one, $DIRPW);
local(*FILE);

# make sure user has authority
my @user_profile = &verify_id_num($username, $password, $admin_number);
my $user_perm = &is_admin_or_mod($in{number}, @user_profile);

unless ($user_perm eq 'true') {  &StandardHTML("$vars_wordlets_err{no_permission}");  }


# read current forum data
@forums = &OpenForumsFile;

@thisforum = &GetForumRecord($in{number});

$CurrentTab = qq%<A HREF="cp.cgi?ubb=vars_forums">$vars_wordlets_cp{forum_settings}</A>%;

&CPHeader; &CPFooter;

if ($in{delete_forum} eq 'yes') {

$Hiddens = qq~
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="delete_forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$in{number}">
~;

&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_delete_forum_check.pl";
&CPBottom;
exit;
} # end delete check



# validate
my @ValidateArray = ("Namer", "template_number");
&Validate(@ValidateArray);

#other checks
if ($in{Namer} =~ /\|\^/) {
&StandardHTML("$vars_wordlets_err{forum_name_badchar}");
}
if ($in{Description} =~ /\|\^/) {
&StandardHTML("$vars_wordlets_err{forum_desc_badchar}");
}

# clean up forum description & more
my $Description = $in{Description};
$Description =~ s/"/&quot\;/g;
$Description = &EliminateReturns($Description);

# clean up forum intro/announcement
my $announcement = $in{announcement};
$announcement =~ s/\|/&#0124;/g;
$announcement = &EliminateReturns($announcement);

my $Name = $in{Namer}; $Name =~ s/"/&quot\;/g;
my $Category = $in{Category};

# make sure forum pw does not contain |^
if ($in{forum_pw} =~ /\|\^/) {
&StandardHTML($vars_wordlets_err{forum_pw_illegal});
}

#is this a private forum?
if (($in{Private} eq 'private') && ($thisforum[7] eq '')){
#create HTML directory alternate to keep contents hidden
$DIRPW = &GeneratePassword;
if ($Description ne '') {
my $DescLength = length($Description);
}  else {
my $DescLength = 6;
}
$DIRPW .= "$DescLength";


mkdir("$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW");

open (INDEX, ">$vars_config{NonCGIPath}/Forum$thisforum[8]/index.html"); 
print INDEX '';
close (INDEX);


open (INDEX, ">$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX '';
close (INDEX);
}

elsif (($in{Private} eq 'private') && ($thisforum[7] ne '')) {

$DIRPW = "$thisforum[7]";

unless (-e "$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW") {

mkdir("$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW");

open (INDEX, ">$vars_config{NonCGIPath}/Forum$thisforum[8]/index.html"); 
print INDEX '';
close (INDEX);

open (INDEX, ">$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
} # check if exists


}  else {
$DIRPW = "$thisforum[7]";
}

if ($in{Private} eq 'private') {
	$ForumPermission = 'private';
}  else {
	$ForumPermission = "$in{TopicRestrict}&$in{ReplyRestrict}";
}

chomp($thisforum[14]);

$NewRow = ("$Category|^|$Name|^|$Description|^|$in{Status}|^|$in{HTML}|^|$in{UBB}|^|$ForumPermission|^|$DIRPW|^|$in{number}|^||^|$in{UBBImages}|^|$in{ModNotify}|^|$in{forum_pw}|^||^|$thisforum[14]|^|$in{forum_sort}|^|$announcement\n");


# revise forums variable file now

open(FILE, ">$vars_config{VariablesPath}/vars_forums.cgi");
&lock;
foreach $one(@forums) {
@check = split(/\|\^\|/, $one);
chomp($one);
if ($check[8] eq "$in{number}") {
print FILE "$NewRow";
}  else {
print FILE "$one\n";
}
}
&unlock;
close(FILE);

# assign proper template for new forum

require "$vars_config{VariablesPath}/vars_template_match.cgi";
my $thiskey = "forum_$in{number}";
$template_match{$thiskey} = "$in{template_number}";

open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
print FILE qq!\%template_match = (\n!;
&lock;
foreach $key (keys %template_match) {
print FILE qq!$key => "$template_match{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

# check for changing sort
if ($in{old_sort} ne "$in{forum_sort}") {

# determine proper path
if ($in{Private} eq 'private') {
	$exact_path = "Forum$in{number}/private-$DIRPW";
}  else {
	$exact_path = "Forum$in{number}";
}
unlink("$vars_config{NonCGIPath}/$exact_path/forum_$in{number}.threads");
}

# on screen display
&cp_confirm("Forum Updated!");
exit;

} #end update forum

sub delete_forum {
local(@forums, @check, $one, $DeleteRow, $key, %forum_number);

@forums = &OpenForumsFile;

my @this_forum = &GetForumRecord($in{number});
my $permission = $this_forum[6];

#set proper path if forum is private
$exact_path = "Forum$in{number}";

if ($permission eq 'private') { 	$exact_path .= "/private-$this_forum[7]"; }  


open(FILE, ">$vars_config{VariablesPath}/vars_forums.cgi");
&lock;
foreach $one(@forums) {
chomp($one);
@check = split(/\|\^\|/, $one);
unless (exists($forum_number{$check[8]})) {
	$forum_number{$check[8]} = 'y';

if ($check[8] eq "$in{number}") {
$DeleteRow = $one;
} else {
print FILE "$one\n";
}
} # end unless
} #forum loop
&unlock;
close(FILE);

#now we have removed the forum from the forums file

#need to delete directories
use File::Path;
rmtree("$vars_config{NonCGIPath}/Forum$in{number}");

# need to update template match hash
require "$vars_config{VariablesPath}/vars_template_match.cgi";
my $thiskey = "forum_$in{number}";

open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
print FILE qq!\%template_match = (\n!;
&lock;
foreach $key (keys %template_match) {
unless ($key eq "$thiskey") {
print FILE qq!$key => "$template_match{$key}",\n!;
}
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);

# clear cache
&ClearSingleForumTopicsCache($exact_path);
&ClearSingleForumPageCache($exact_path, $in{number});
&ClearSummaryCache;

# on screen display
&cp_confirm("Forum Deleted!");
exit;
} # end delete_forum

sub set_mods {
local(@mods, $Moderator, @GoodMods, @namecheck, $key, $CleanMod, $j, $ArrayNumber, $checker, $matcher, $nameok, @members, $ModName, $ProfileNumber, @modprof, $Status, $ThisTime, @alloldmods, $unomod, @OldMods, $oldie, $SaveOldie, $checkthis, @oldmod, $TotalPosts, $separate, $mod_number);
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{moderator_settings}%;

#@members = &GetMemberListArray;  

## now we have our current Member list (in filename format)
foreach $key (keys %in) {

if (($key =~ /NewMod/) && ($in{$key} ne "")) {
$mod_number = &Do8Digit($in{$key});

# make sure each member number is valid!
unless (-e "$vars_config{MembersPath}/$mod_number.cgi") {
&StandardHTML("$vars_wordlets_err{unregistered_moderator}<P><CENTER>$mod_number</CENTER>");
}

push(@namecheck, $mod_number);

#place name in goodmods array
($j, $ArrayNumber) = split(/Mod/, $key);

if ($GoodMods[$ArrayNumber] eq "") {
	$GoodMods[$ArrayNumber] = "$mod_number";
}  else {
	$GoodMods[$ArrayNumber] .= "||^||$mod_number";
} 

} # end if new mod key
} # foreach $key

#update vars_mods file
my $array_row = 0;

open (FILE, ">$vars_config{VariablesPath}/vars_mods.cgi") || &StandardHTML("$vars_wordlets_err{cant_write_to_file} vars_mods.cgi.<P>Error message: $!");
&lock;
for $eachrow(@GoodMods) {

if ($eachrow ne '') {
$modline = ('$Forum' . "$array_row" . 'Moderator = "' . "$eachrow" . '"' . ";\n");
print FILE "$modline";
}
$array_row++;

}  #end loop through hash

print FILE ("1;\n");
&unlock;
close(FILE);


# remove dupes from namecheck list-- move to goodlist array
my @goodlist = &RemoveDupes(@namecheck);

# Update Member Profiles for All Mods

foreach $ModName(@goodlist) {
	chomp($ModName);
	@modprof = &OpenProfile($ModName);

	$Status = $modprof[8]; chomp($Status);

	if ($Status ne 'Administrator') {
		$modprof[8] = 'Moderator';

		open (FILE, ">$vars_config{MembersPath}/$ModName.cgi");
		&lock;
			foreach $thisline(@modprof) {
				chomp($thisline);
				print FILE ("$thisline\n");
			}
			&unlock;
		close (FILE);

	}  ## END IF not admin
} # end for

# Delete Moderator status from users who are no longer Moderators
foreach $key (keys %in) {

if (($key =~ /OldMod/) && ($in{$key} ne '')) {

	@alloldmods = split(/\|\|\^\|\|/, $in{$key});
	foreach $unomod(@alloldmods) {
		chomp($unomod); 
		if ((-e "$vars_config{MembersPath}/$unomod.cgi") && ($unomod ne '')) {
		push (@OldMods, $unomod);
		}
	}
}

} # end foreach $key

#delete dupes from old mods
my @FinalOldMods = &RemoveDupes(@OldMods);

# need to grab misc vars
require "$vars_config{VariablesPath}/vars_misc.cgi";

for $oldie(@FinalOldMods) {
	$SaveOldie = 'no'; 	chomp($oldie);
	for $checkthis(@goodlist) {
		chomp($checkthis);
		if ($oldie eq "$checkthis") {
		$SaveOldie = 'yes';
		}
	}
	if (($SaveOldie ne 'yes') && ($oldie ne '')) {
		
		unless ($oldie eq '') {
		
		@oldmod = &OpenProfile("$oldie");  
			$Status = $oldmod[8]; chomp($Status);
			$TotalPosts = $oldmod[7]; chomp($TotalPosts);
		
			if ($Status ne "Administrator") {
				if ($TotalPosts < $vars_misc{MemberMinimum}) {
					$Status = 'Junior Member';
				}  else {
					$Status = 'Member';
				}
				$oldmod[8] = "$Status";

				open (FILE, ">$vars_config{MembersPath}/$oldie.cgi");
&lock;
				foreach $separate(@oldmod) {
					chomp($separate);
					print FILE ("$separate\n");
				}
				&unlock;
				close (FILE);

		}  ## END IF ADMIN status ne true
	}
}
} 

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

# display mods page again
&cp_confirm("Moderators Updated!");
exit;


} #end set mods

# Danger- do not remove the following line!
1;