# Import Archives from UBB5 to UBB6
# this script grabs old archives and imports them as read-only forums for UBB6

# make sure we have archives to grab:
unless (-e "$vars_config{NonCGIPath}/Archives/archives.pl") {
&StandardHTML("Sorry- there are no archives to import.  Are you sure the board you are upgrading from UBB5 contained archives?"); exit;
}

my @check_archives = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");
if ($check_archives[0] eq '') {
&StandardHTML("Sorry- there are no archives to import.  Are you sure the board you are upgrading from UBB5 contained archives?"); exit;
}

sub import_archives {

# we have archives, so create new forums:
$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="get_archives">
%;
$CurrentTab = qq%Import UBB5 Archives%; 

&CPHeader; &CPFooter; &CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_import_archives.pl";
&CPBottom;
}

sub get_archives {
local($one, @forums, $new_forum_line, $line, @archives, @cats, @archive_topics, $topic, @this_at, $total_posts, $archive_count, $total_cats, $this_post_count, @revised_archive, $revised_archive_count);
$total_posts = 0;

@archives = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");

# only update cats if beginning import process...
if ($in{next} eq '') {
# add category to category file:
if (-e "$vars_config{NonCGIPath}/categories.file") {
@cats = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");
}  else {
@cats = '';
}

$total_cats = @cats; $total_cats++;
my $new_order = &Do6Digit($total_cats);
my $new_cat_line = qq!$new_order|^|Our Archives|^|$total_cats\n!;
push (@cats, $new_cat_line);

open(FILE, ">$vars_config{NonCGIPath}/categories.file");
&lock;
print FILE @cats;
&unlock;
close(FILE);
} # if next eq ''


if ($in{next} ne '') { $total_cats = $in{next}; }

# now add new forums:
@forums = &OpenForumsFile;

# get last forum number
my @rev_forums = reverse(@forums);
my @last_forum = split(/\|\^\|/, $rev_forums[0]);
my $last_number = $last_forum[8];


# only do one archive at a time-- in case they are large
MYARCHIVE: foreach (@archives) {
chomp($_);
@this_archive = split(/\|\#\|/, $_);
$last_number++;

# create forum directory
mkdir ("$vars_config{NonCGIPath}/Forum$last_number", 0777);
chmod(0777, "$vars_config{NonCGIPath}/Forum$last_number");

$new_forum_line = "$total_cats|^|$this_archive[1]|^|$this_archive[2]|^|On|^|is not|^|is|^|none&none|^||^|$last_number|^||^|ON|^|no|^||^||^|$last_number|^|abc|^|\n";

push (@forums, $new_forum_line);

# import topics
if (-d "$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]") {

opendir(FILE, "$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]");
@archive_topics=grep(/.cgi$/,readdir(FILE));
closedir(FILE);

$archive_count = 0;
foreach $topic(@archive_topics) {
$archive_count++;
$archive_count = &Do6Digit($archive_count);
@this_at = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");

# print to new dir:
$this_post_count = 0;
open(FILE, ">$vars_config{NonCGIPath}/Forum$last_number/$archive_count.cgi");
&lock;
foreach $line(@this_at) {
$this_post_count++;
print FILE "$line";
}
&unlock;
close(FILE);
chmod (0777, "$vars_config{NonCGIPath}/Forum$last_number/$archive_count.cgi");

$this_post_count--;
$total_posts = $total_posts + $this_post_count;

# delete old archive record
chmod(0777, "$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");
unlink("$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");

}  # foreach topic

} # if archives exists

# update forum file
open(FILE, ">$vars_config{VariablesPath}/vars_forums.cgi");
&lock;
print FILE @forums;
&unlock;
close(FILE);
chmod (0777, "$vars_config{VariablesPath}/vars_forums.cgi");

# set stat files
open(FILE, ">$vars_config{NonCGIPath}/Forum$last_number/lastnumber.file");
&lock;
print FILE "$archive_count\n";
$archive_count = $archive_count + 0;
print FILE "$archive_count\n";
print FILE "$total_posts\n";
&unlock;
close(FILE);
chmod (0666, "$vars_config{NonCGIPath}/Forum$last_number/lastnumber.file");

# adjust old archive file:
open(FILE, ">$vars_config{NonCGIPath}/Archives/archives.pl");
&lock;
foreach $one(@archives) {
unless ($one =~ /^($this_archive[0])/) {
print FILE "$one";
} }
&unlock;
close(FILE);
chmod (0666, "$vars_config{NonCGIPath}/Archives/archives.pl");

last MYARCHIVE;
}  # foreach archive

# assign proper template for new forum
require "$vars_config{VariablesPath}/vars_template_match.cgi";
$thiskey = "forum_$last_number";
$template_match{$thiskey} = "2";

open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
print FILE qq!\%template_match = (\n!;
&lock;
foreach $key (keys %template_match) {
print FILE qq!$key => "$template_match{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);

# clear cache
&ClearSummaryCache;

# end/continue?
@revised_archives = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");
$revised_archive_count = @revised_archives;

if ($revised_archive_count > 0) {
&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=get_archives&next=$total_cats", "We are still importing your archives.  Please wait for the process to finish!", "Archive Importation In Progress");
}  else {
&cp_confirm("Archive Importation Completed!");
}


} # end get_archives

# DO NOT REMOVE THIS LINE:
1;