# Control Panel - Routines for indexing

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{VariablesPath}/vars_misc.cgi";


sub rebuild_members {

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="do_rebuild_members">
%;
$CurrentTab = qq%$vars_wordlets_cp{rebuild_members}%; 

# note: the wordlets are already required... no need to grab them

&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_rebuild_mems_intro.pl";
&CPBottom;
} # end rebuild members



sub build_members {
local(@all_members, $member_total, $lastnum, $thread_start, $end_here, $j, $board_off,  $end_of_line, $all_members_as_array, $array_max, @members_file, @email_file, @pubs_file, @this_member, $memnum, $memline, $emailline);
local(*FILE);

# subroutine parameters:
# $_[0]: start

# alter number for slower/faster servers:
my $increment = 400;

my $i_array = $increment - 1;

$board_off = $vars_misc{BBStatus};

my $start = $_[0]; 

if ($start == 0) { 
# turn off board while building!
&board_off;

# open members directory
opendir(MEMS, "$vars_config{MembersPath}");
my @total_members = grep(/\d\d\d\d\d\d\d\d\.cgi/, readdir(MEMS));
closedir(MEMS);

# make sure profile has size
@all_members = grep { (-s "$vars_config{MembersPath}/$_")  } @total_members;
@all_members = sort(@all_members);

$member_total = @all_members;

if (@all_members > $i_array) {

# print to temp file:
open(FILE, ">$vars_config{MembersPath}/temp_list.cgi");
&lock;
foreach (@all_members) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/temp_list.cgi");

}  # if array is $increment (default 400) or more

} else {

# get members list:
@all_members = &OpenFileAsArray("$vars_config{MembersPath}/temp_list.cgi");
$member_total = @all_members;

}  # if/else starting from 0

# limit to incrmemental members at a time to reduce server load
$start = $start + 0;
$array_max = $start + $i_array;


# ok-

$all_members_as_array = @all_members - 1;

if ($all_members_as_array < $increment) {
$end_here = $all_members_as_array;
$end_of_line = 'true';
} 
elsif (($all_members_as_array > $i_array) && ($array_max >= $all_members_as_array)) {
$end_here = $all_members_as_array;
$end_of_line = 'true';

}  else {
$thread_start = $array_max + 1;  #where to pick up next
$end_here = $array_max;
$end_of_line = 'false';
}

@all_members = @all_members[$start... $end_here];

# import temp info:
if ($in{start} > 0) {
if (-s "$vars_config{MembersPath}/members_file.cgi") {
@members_file = &OpenFileAsArray("$vars_config{MembersPath}/members_file.cgi");
}
if (-s "$vars_config{MembersPath}/email_file.cgi") {
@email_file = &OpenFileAsArray("$vars_config{MembersPath}/email_file.cgi");
}
if (-s "$vars_config{MembersPath}/pubs_file.cgi") {
@pubs_file = &OpenFileAsArray("$vars_config{MembersPath}/pubs_file.cgi");
}
}



# cycle thru:
foreach (@all_members) {

($memnum, $j) = split(/\./, $_);
@this_member = &OpenProfile($memnum);

chomp($this_member[0]); chomp($this_member[2]); chomp($this_member[15]);

# memberslist
$memline = ("$this_member[0]" . '|!!|' . "$memnum");
push(@members_file, "$memline");

# email file
$emailline = ("$this_member[2]" . '||' . "$memnum");
push(@email_file, $emailline);

# public names
if ($this_member[15] ne '') { push(@pubs_file, $this_member[15]); }

}


# are we finished?
if ($end_of_line eq 'true')  {

# print revised stat files

open(FILE, ">$vars_config{MembersPath}/memberslist.cgi");
&lock;
foreach (@members_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/memberslist.cgi");

open(FILE, ">$vars_config{MembersPath}/emailfile.cgi");
&lock;
foreach (@email_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/emailfile.cgi");

open(FILE, ">$vars_config{MembersPath}/public_names.cgi");
&lock;
foreach (@pubs_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/public_names.cgi");

open(FILE, ">$vars_config{MembersPath}/membertotal.cgi");
&lock;
print FILE "$member_total\n";
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/membertotal.cgi");

# get last number
my @reverse = reverse(@all_members);
($lastnum, $j) = split(/\./, $reverse[0]);

open(FILE, ">$vars_config{MembersPath}/last_number.cgi");
&lock;
print FILE "$lastnum\n";
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/last_number.cgi");

# turn board back on
&board_on;

# remove temp files
unlink("$vars_config{MembersPath}/temp_list.cgi");
unlink("$vars_config{MembersPath}/members_file.cgi");
unlink("$vars_config{MembersPath}/email_file.cgi");
unlink("$vars_config{MembersPath}/pubs_file.cgi");

&cp_confirm("Rebuild of Member Stat Files Completed");

}  else { 


# print updated temp files:

open(FILE, ">$vars_config{MembersPath}/members_file.cgi");
&lock;
foreach (@members_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/members_file.cgi");

open(FILE, ">$vars_config{MembersPath}/email_file.cgi");
&lock;
foreach (@email_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/email_file.cgi");

open(FILE, ">$vars_config{MembersPath}/pubs_file.cgi");
&lock;
foreach (@pubs_file) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/pubs_file.cgi");


&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=do_rebuild_members&start=$thread_start", "We are rebuilding member stat files.  Currently processing member <B>$end_here</B>... Please wait!", "Member Stat File Rebuild In Progress");

}  


} # end build_members

sub do_index {

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="index">
%;
$CurrentTab = qq%$vars_wordlets_cp{rebuild_index}%; 

# note: the wordlets are already required... no need to grab them

&CPHeader; &CPFooter; 
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_index_intro.pl";
&CPBottom;

} # end do index


sub all_build_forum_stats {
local(@all_forums, @rev_forums, @last_forum, $last_forum_number, @this_forum, @grab_forum, $next_forum, $thisforum);

# turn off board while building...
&board_off;

# get all forums
@all_forums = &OpenForumsFile;
@rev_forums = reverse(@all_forums);
@last_forum = split(/\|\^\|/, $rev_forums[0]);
$last_forum_number = $last_forum[8];

if ($in{build_forum} eq 'ALL') {
@this_forum = split(/\|\^\|/, $all_forums[0]);
$thisforum = $this_forum[8];
if (-d "$vars_config{NonCGIPath}/Forum$thisforum") {
&build_forum_stats($thisforum, "A");
}
$in{build_forum} = $thisforum;
$next_forum = $thisforum + 1;

}  else {

$thisforum = $in{build_forum};
if (-d "$vars_config{NonCGIPath}/Forum$thisforum") {
&build_forum_stats($thisforum, "A");
}  
$next_forum = $thisforum + 1;

}

if ($next_forum > $last_forum_number) {
# turn board back on
&board_on;
&cp_confirm("Forum Stats Rebuild Completed");
}  else {
&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum", "We are rebuilding forum stat files for each of your available forums.  We just updated forum <B>$in{build_forum}</B>... Please wait!", "Forum Stat File Rebuild In Progress");
}

} # all_build...

sub build_forum_stats {
local (@topics, %forum_topics, @theforummsgs, @threadinfo, @threadrev, $statline, $mostrecent, @statarray, @lastarray, $Notes, $closed, $month, $day, $year, $topic_num, $CheckThisYear, $j, $post_date_j, $post_dt_j, $get_hour, $get_min, $am_pm, $post_time, $military_time, $key, @forum_info, @stat_line, $lc_subject, $last_subject, @last_post, $total_posts, @sort_topics, @rev_topics, $total_topics);
local(*FILE);

# two parameters required:
my $thisnumber = $_[0];  # the forum number
# $_[1] : A or 1 : A, if building all forums; 1, if building 1

$total_posts = 0;

# get forum record
@forum_info = &GetForumRecord($_[0]);

# determine path for the forum files

$exact_path = "Forum$_[0]";
if ($forum_info[6] eq 'private') {
$exact_path .= "/private-$forum_info[7]";
}  

chomp($forum_info[15]); # <- sort option

opendir (FILE, "$vars_config{NonCGIPath}/$exact_path") || die (&StandardHTML("$vars_wordlets_err{cant_find_directory}: $exact_path<P>$!")); 
@theforummsgs = readdir(FILE);
closedir (FILE);

my @forummsgs = grep(/^\d{6}\.cgi$/, @theforummsgs);

# configure memo date to Julian
if ($forummsgs[0] ne '') {

foreach (@forummsgs) {
($topic_num, $j) = split(/\./, $_); 

@threadinfo = &OpenTopic("$topic_num", "$thisnumber");
@stat_line = split(/\|\|/, $threadinfo[0]);

$topic_posts = $stat_line[2]; $topic_posts++;
$total_posts = $total_posts + $topic_posts;

if ($forum_info[15] ne 'abc') {

@threadrev = reverse(@threadinfo);
$mostrecent = $threadrev[0];
@lastreply = split(/\|\|/, $mostrecent);
		
($month, $day, $year) = split(/\-/, $lastreply[3]);	

# in case we have some pre Y2K posts....
$year = &Y2K($year);

# create j date
$post_date_j = &jday($month, $day, $year);
# create j time
$post_time = $lastreply[4];
($get_hour, $get_min) = split(/:/, $post_time);
($get_min, $am_pm) = split(/ /, $get_min); chomp($am_pm);
$military_time = &ConvertTo24HourRunon("$get_hour", "$get_min", "$am_pm");

$post_dt_j = ($post_date_j + ($military_time * 0.0001));
$post_dt_j = sprintf("%7.4f", $post_dt_j);
$post_dt_j =~ tr/ /0/;

if (($post_dt_j > 0) && ($topic_num ne '')) {
$forum_topics{$topic_num} = "$post_dt_j";
}

}  else {

# grab topic stat line
$lc_subject = lc($stat_line[4]);
$forum_topics{$topic_num} = "$lc_subject";

} # if/else sort by date/alphabetical

} #end FOREACH $item


# compile lasttime.file:
if ($forum_info[15] eq 'abc') {
@topics = sort { $forum_topics{$a} cmp $forum_topics{$b} } keys %forum_topics;
} else {
@topics = sort { $forum_topics{$b} <=> $forum_topics{$a} } keys %forum_topics;
}

@last_post = &OpenTopic($topics[0], $thisnumber);
@threadrev = reverse(@last_post);
@lastreply = split(/\|\|/, $threadrev[0]);

@stat_line = split(/\|\|/, $last_post[0]);
$last_subject = $stat_line[4];

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lasttime.file") or die("Unable to open lasttime.file in $exact_path : $!");
&lock;
print FILE ("$lastreply[3]\n");
print FILE ("$lastreply[4]\n");
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lasttime.file");

# print lastnumber.file

@sort_topics = sort(@topics);
@rev_topics = reverse(@sort_topics);
$total_topics = @rev_topics;

# get pubname for last post
chomp($lastreply[11]);
if ($lastreply[11] eq '')  {  $lastreply[11] = &GetUserNumber($lastreply[2]); }

if ( (-e "$vars_config{MembersPath}/$lastreply[11].cgi") && ($lastreply[11] ne ''))   {
$pub_name = &GetPubName($lastreply[11]);
}  else {
chomp($lastreply[10]);
$pub_name = $lastreply[10];
if ($pub_name eq '') { $pub_name = $lastreply[2]; }

}

chomp($lastreply[9]);
if ($lastreply[9] eq '') { $lastreply[9] = '1'; }

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file"); 
&lock;
print FILE ("$rev_topics[0]\n"); 
print FILE ("$total_topics\n"); 
print FILE ("$total_posts\n");
print FILE ("$last_subject\n");
print FILE ("$pub_name\n"); 
print FILE ("$lastreply[9]\n"); 
print FILE ("$topics[0]\n"); 
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# unlink threads file
unlink("$vars_config{NonCGIPath}/$exact_path/forum_$thisnumber.threads");

# clear cache
&ClearSingleForumPageCache($exact_path, $_[0]);
&ClearSummaryCache;

} # if we have files!

if ($_[1] ne 'A') {
&cp_confirm("Forum Stats Rebuild Completed");
}

}  # end build_forum_stats

sub forum_stats {
local(@forums, $forum_options, @forum_info);
# forum options
@forums = &OpenForumsFile;

$forum_options = qq!
<OPTION VALUE="ALL">Rebuild All Forum Stat Files</OPTION>
!;

foreach (@forums) {

@forum_info = split(/\|\^\|/, $_);
$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">Rebuild Only: $forum_info[1]</OPTION>
!;

} # end forum loop



$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="build_forum_stats">
!;
$CurrentTab = qq%$vars_wordlets_cp{forum_stats}%; 
&CPHeader; &CPFooter; &CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_forum_stats.pl";
&CPBottom; exit;

} # end forum_stats


sub post_history {

$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_post_history">
!;
$CurrentTab = qq%$vars_wordlets_cp{post_history}%; 
&CPHeader; &CPFooter; &CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_post_history.pl";
&CPBottom; exit;

} # end post_history

sub append_post_history {
# $_[0] : user number
# $_[1] : post line
local(*FILE);
open(FILE, ">>$vars_config{MembersPath}/user_posts/$_[0].cgi");
&lock;
print FILE "$_[1]";
&unlock;
close(FILE);
chmod (0666, "$vars_config{MembersPath}/user_posts/$_[0].cgi");
} # end append_post_history


sub build_history {
local($thread_max, @forum_list, $forum_total, $subject, $max_forum_number, $next_forum, $this_line, $exact_path, @forum_line, @topics, $thread_start, $end_here, $start_here, @stat, $this, $forum_status, $topic, $subject, @stats, $checker, $j, @parseit, $thread_line, @forumindex, $board_off, $line, $random, $history_file, $forum_array_line, $end_of_line, $un, %user_number, %user_name, $post_line);
local(*FILE);
# used for one file index method

# subroutine parameters:
# $_[0]: start
# $_[1]: thread_point

# delete current histories
if (($_[0] == 1) && ($_[1] == 0)) {
&ClearUserPostHistories;
}

$board_off = $vars_misc{BBStatus};

my $start = $_[0]; my $thread_point = $_[1];

if (($start == 1) && ($thread_point == 0)) {
$random = &GeneratePassword;
$history_file = ("history" . "_$random" . ".cgi");
# turn off board while building!
&board_off;
}  else {
$history_file = $in{history_file};
}

# limit to 400 posts at a time to reduce server load
$thread_max = $thread_point + 299;
$start = $start + 0;

@forum_list = &OpenForumsFile;
$forum_total = @forum_list;

$forum_array_line = $start - 1;
$this_line = $forum_list[$forum_array_line];

@forum_line = split(/\|\^\|/, $this_line);
$forum_status = $forum_line[3]; $number = $forum_line[8];

$exact_path = "Forum$number";

if ($forum_line[6] eq 'private') {
# if private, do not add to history!
$next_forum = $start + 1;
if ($next_forum > $forum_total) { 	$end_of_line = 'true'; }

}  else {

#not private, so add...

if ($thread_point == 0) {
# open forum directory... read messages into array
opendir (FILE, "$vars_config{NonCGIPath}/$exact_path");
	@topics = grep(/\d\d\d\d\d\d\.cgi/, readdir(FILE));
closedir (FILE);

open(FILE, ">$vars_config{MembersPath}/user_posts/$history_file");
&lock;
foreach (@topics) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/user_posts/$history_file");
} else {

@topics = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$history_file");

} # end history file build/retrieve


$max_array_number = @topics - 1;

if ($max_array_number < 300) {
$next_forum = $start + 1;
$thread_start = 0; $start_here = 0;
$end_here = $max_array_number;
} 
elsif (($max_array_number > 299) && ($thread_max >= $max_array_number)) {
$next_forum = $start + 1;
$thread_start = 0;
$start_here = $thread_point;
$end_here = $max_array_number;

}  else {
$next_forum = $start;
$thread_start = $thread_max + 1;  #where to pick up next
$start_here = $thread_point;
$end_here = $thread_max;
}

# is this the last forum to check?
if ($next_forum > $forum_total) {
	$end_of_line = 'true';
}

	undef(@forumindex);
	
	@topics = @topics[$start_here... $end_here];

if ($forum_status eq 'On') {
undef(@forumindex);
for $this(@topics) {
($topic, $j) = split(/\./, $this);
@stat = &OpenTopic($topic, $number);

foreach $checker(@stat) {
	unless ($checker =~ /^A/) {
		@parseit = split(/\|\|/, $checker);
		$post_line = "$number|$topic|$parseit[1]\n";
		# attribute to author
		chomp($parseit[11]);
		if ($parseit[11] ne '') {
		
		  if (-e "$vars_config{MembersPath}/$parseit[11].cgi") {
			$user_number{$parseit[11]} .= "$post_line";
		 }
			
		}  else {
			if ($user_name{$parseit[2]}) {
				$un = $user_name{$parseit[2]};
			}  else {
				$un = &GetUserNumber($parseit[2]);
				$user_name{$parseit[2]} = $un;
			}
			
			if (($un ne '') && (-e "$vars_config{MembersPath}/$un.cgi") ) {
			 $user_number{$un} .= "$post_line"; 	
			 }
		}
	} # end unless
} # foreach checker
}  # end foreach $this
	
}  # end if status eq "ON"


# determine index method:
require "$vars_config{VariablesPath}/vars_wordlets_err.cgi";

# append user post records now
foreach $key (keys %user_number) {
&append_post_history("$key", "$user_number{$key}");
}

} # end if/else private


# are we finished?
if ($end_of_line eq 'true')  {

# clear cache
&ClearForumTopicsCache;

# turn board back on
&board_on;
# remove file containing all topics
unlink("$vars_config{MembersPath}/user_posts/$history_file");
&cp_confirm("Post History Build Completed");

}  else { 

&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=update_post_history&start=$next_forum&thread_point=$thread_start&history_file=$history_file", "We are rebuilding member post histories for each of your available forums.  Currently updating forum <B>$number</B>... Please wait!", "Post History Build In Progress");

}  


} # end build_history


sub build_index {
local($thread_max, @forum_list, $forum_total, $subject, $max_forum_number, $next_forum, $this_line, $exact_path, $forum_status, @forum_line, @topics, $thread_start, $end_here, $start_here, @stat, $this, $topic, $subject, @stats, @datearray, $checker, $YearCheck, $CheckThisYear, $board_off, $TheYear, $j, @parseit, $thread_line, @forumindex, $line, $forum_array_line, $end_of_line, $un);
local(*FILE);
# used for one file index method

# subroutine parameters:
# $_[0]: start
# $_[1]: thread_point

my $start = $_[0]; my $thread_point = $_[1];
$board_off = $vars_misc{BBStatus};

if (($start == 1) && ($thread_point == 0)) {
# turn off board while building!
&board_off;
}

# limit to 400 posts at a time to reduce server load
$thread_max = $thread_point + 399;
$start = $start + 0;

@forum_list = &OpenForumsFile;
$forum_total = @forum_list;

$forum_array_line = $start - 1;
$this_line = $forum_list[$forum_array_line];

@forum_line = split(/\|\^\|/, $this_line);
$forum_status = $forum_line[3]; $number = $forum_line[8];

$exact_path = "Forum$number";
if ($forum_line[6] eq 'private') { $exact_path .= "/private-$forum_line[7]"; }  

# open forum directory... read messages into array
opendir (FILE, "$vars_config{NonCGIPath}/$exact_path");
	@topics = grep(/\.cgi/, readdir(FILE));
closedir (FILE);

$max_array_number = @topics - 1;

if ($max_array_number < 400) {
$next_forum = $start + 1;
$thread_start = 0; $start_here = 0;
$end_here = $max_array_number;
} 
elsif (($max_array_number > 399) && ($thread_max >= $max_array_number)) {
$next_forum = $start + 1;
$thread_start = 0;
$start_here = $thread_point;
$end_here = $max_array_number;

}  else {
$next_forum = $start;
$thread_start = $thread_max + 1;  #where to pick up next
$start_here = $thread_point;
$end_here = $thread_max;
}

# is this the last forum to check?
if ($next_forum > $forum_total) {
	$end_of_line = 'true';
}

	@forumindex = @blank;
	
	@topics = @topics[$start_here... $end_here];

if ($forum_status eq 'On') {
@forumindex = @blank;
	for $this(@topics) {
		($topic, $j) = split(/\./, $this);
		@stat = &OpenTopic($topic, $number);
		@stats = split(/\|\|/, $stat[0]);
		$subject = $stats[4];
		$subject =~ s/\|/&#0124;/sg;
		$subject =~ s/<.+?>//g; chomp($subject);
		

		foreach $checker(@stat) {
			unless ($checker =~ /^A/) {
			@parseit = split(/\|\|/, $checker);
			my $Date = $parseit[3];
			@datearray = split(/-/, $Date); chomp($datearray[2]);

$YearCheck = $datearray[2]; $YearCheck = $YearCheck + 0;
$TheYear = &Y2K($YearCheck);
$Date = "$datearray[0]-$datearray[1]-$TheYear";


			chomp($parseit[6]);
			my $Text = &indexify($parseit[6]);
			my $thread_line .= ("$number" . "|" . "$topic" . "|"  . "$parseit[1]" . "|"  .  "$Date" . "|" . "$subject" . "|" . "$Text\n");
			push (@forumindex, $thread_line);
			} #end unless
		}
	}  # end foreach $this
	
}  # end if status eq "ON"


# determine index method:
require "$vars_config{VariablesPath}/vars_wordlets_err.cgi";
require "$vars_config{VariablesPath}/vars_search.cgi";

if ($vars_search{IndexMethod} eq "ONEFILE") {

$index_file = 'forumindex.cgi';

if (($start == 1) && ($thread_point == 0)) {
unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/$index_file");
}

}  else {

$index_file = "forumindex$number.cgi";

if ($thread_point == 0) { unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/$index_file");
}

}

# build directory if necessary!
unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index");
}

open (FILE, ">>$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/$index_file");
&lock;
for $line(@forumindex) {
chomp($line);
print FILE ("$line\n");
}
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/$index_file");

# are we finished?
if ($end_of_line eq 'true')  {
# turn board back on!
&board_on;
&cp_confirm("Index Updated");

}  else { 

&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=index&start=$next_forum&thread_point=$thread_start", "We are indexing each of your available forums.  Currently updating forum <B>$number</B>... Please wait!", "Index In Progress");

}  


}  #end build_index



# Danger- do not remove the following line!
1;