
sub Validate {
local($each); local(@splitter); local ($Redo); local($BadLine);
my $Redo = '';

foreach $each(@_) {
chomp($each);

if ($each !~ /\|/) {
if ($in{$each} eq '') {
$Redo = 'true';
$BadLine .= "You did not complete: $each<BR>";
}

}  else {
#this is an AND list
@splitter = split(/\|/, $each);
$ok = "false";
foreach $one(@splitter) {
chomp($one);
if ($in{$one}) { $ok = 'true'; }
}

if ($ok eq 'false') {
$Redo = 'true';
$BadLine .= "You must complete one of: $each<BR>";
}


} #end single/OR
}
if ($Redo eq 'true') {
&StandardHTML(qq%You did not complete all required fields.<P>$BadLine%);
}

} #end validate

sub CheckPermission_CP {
# verify that user is an admin!
$admin_number = &GetUserNumber($username);
#did we find the username?
if ($admin_number eq '') {
print qq%Content-type: text/html\n\n%;
&StandardHTML("Sorry, we have no one with that username.");
}
my @profile = &OpenProfile("$admin_number");
chomp($profile[1]);  chomp($profile[8]); chomp($profile[15]);
chomp($profile[0]);

$public_name = $profile[15];
if ($public_name eq "") {
	$public_name = $profile[0];
}

$lcpw = lc($password);
$lcprofpw = lc($profile[1]);

if ($lcpw ne "$lcprofpw") {
print qq%Content-type: text/html\n\n%;
&StandardHTML("Sorry, the password you entered does not match the password for that username.<P>You entered this password: $password.");
}
if (($profile[8] ne 'Administrator') && ($profile[8] ne 'Moderator')) {
print qq%Content-type: text/html\n\n%;
&StandardHTML("Sorry, you are not an administrator or moderator, so you may not gain access to the control panel.");
}
#return status
$status = $profile[8];
}

sub StandardHTML {
my $Text = shift;
$CurrentTab = "FYI";
&CPHeader; &CPFooter;
&CPTop;
print qq!<P><CENTER>
<table border="0" width="95%">
<TR><TD><font face="verdana, arial" size="2">
<B>$Text</B><P>&#187; Use your browser's back button to return.</font></TD></TR></TABLE></CENTER><P>!;
&CPBottom;
exit;
}

sub SetDefaults {

if ($_[0] eq "vars_display")  {
#test to see if this vars file has been populated yet
unless (exists $vars_display{AllowSignature}) {
$vars_display{DaysPruneDefault} = "20";
$vars_display{CategoryView} = "no";
$vars_display{CategoriesOnly} = "false";
$vars_display{ShowPrivacyLink} = "OFF";
$vars_display{ForumDescriptions} = "yes";
$vars_display{ContactLinkType} = "Email";
$vars_display{showcopytype} = "image";
$vars_display{AllowSignature} = "YES";
$vars_display{AllowSignatureImage} = "no";
$vars_display{ForumTotalOption} = "Posts";
$vars_display{ReverseThreads} = "FALSE";
$vars_display{DisplayMemberTotal} = "true";
$vars_display{NewestMemberWelcome} = "yes";
$vars_display{AllowIcons} = "TRUE";
$vars_display{InlineFrame} = "TRUE";
$vars_display{ForumDisplayMax} = "40";
$vars_display{HTMLDisplayMax} = "40";
$vars_display{HotIcons} = "ON";
$vars_display{HotCount} = "15";
$vars_display{MembersOnlyAccess} = "NO";
$vars_display{author_location} = "yes";
$vars_display{author_post_total} = "yes";
$vars_display{author_reg_date} = "yes";
$vars_display{ShowMods} = "yes";
$vars_display{homepage_icon_link} = "yes";
$vars_display{EmailBlock} = "OFF";
}


if ($vars_display{author_location} eq 'yes') { $author_location_select = 'CHECKED'; }
if ($vars_display{author_post_total} eq 'yes') { $author_post_total_select = 'CHECKED'; }
if ($vars_display{author_reg_date} eq 'yes') { $author_reg_date_select = 'CHECKED'; }

if ($vars_display{user_ratings} eq '') { $vars_display{user_ratings} = 'feature_top'; }

} #end vars_display default


if ($_[0] eq 'vars_email')  {

if ($vars_email{SMTPEmail} eq '') {
$vars_email{UseEmail} = 'ON';
$vars_email{UBBFriendUSE} = 'ON';
$vars_email{SMTPEmail} = 'Off';
$vars_email{email_format} = 'html';
}
if ($vars_email{SendMailLocation} eq '') {
# look for sendmail location in usual spots--
if (-e "/usr/bin/sendmail") {
$vars_email{SendMailLocation} = '/usr/bin/sendmail';
}
elsif (-e "/usr/sbin/sendmail") {
$vars_email{SendMailLocation} = '/usr/sbin/sendmail';
}
elsif (-e "/usr/lib/sendmail") {
$vars_email{SendMailLocation} = '/usr/lib/sendmail';
} else {
$vars_email{SendMailLocation} = '';
}
} #unless sendmail blank
} #end vars_email default

if ($_[0] eq 'vars_time')  {
unless (exists $vars_time{DateFormat}) {
$vars_time{DateFormat} = 'US';
$vars_time{TimeZone} = 'ET';
$vars_time{TimeZoneOffset} = '0';
$vars_time{TimeFormat} = 'AMPM';
}
} #end vars_time default

if ($_[0] eq 'vars_pm')  {
unless (exists $vars_pm{ubb_code}) {
$vars_pm{ubb_code} = 'on';
$vars_pm{html} = 'off';
$vars_pm{feature} = 'on';
}
} #end vars_pm default

if ($_[0] eq 'vars_registration')  {
unless (exists ($vars_registration{DisplayRegistration})) {
$vars_registration{location_field_use} = 'OPT';
$vars_registration{occupation_field_use} = 'OPT';
$vars_registration{interests_field_use} = 'OPT';
$vars_registration{picture_field_use} = 'DEL';
$vars_registration{icq_field_use} = 'OPT';
$vars_registration{aim_field_use} = 'OPT';
$vars_registration{homepage_field_use} = 'OPT';
$vars_registration{signature_field_use} = 'OPT';
$vars_registration{EmailVerify} = 'OFF';
$vars_registration{EmailCheck} = 'false';
$vars_registration{COPPACheck} = 'ON';
$vars_registration{COPPAType} = 'COPPADenied';
$vars_registration{ModerateRegs} = 'OFF';
$vars_registration{OnRegsNotifyAdmin} = 'COPPA';
$vars_registration{SuspendRegister} = 'false';
$vars_registration{allowHighBit} = 'YES';
$vars_registration{DisplayRegistration} = 'YES';
$vars_registration{BBRules} = q~Considering the real-time nature of this message board, it is impossible for us to review messages or confirm the validity of information posted.  Please remember that we do not actively monitor the contents of posted messages and are not responsible for any messages posted. We do not vouch for or warrant the accuracy, completeness or usefulness of any message, and are not responsible for the contents of any message. The messages express the views of the author of the message, not necessarily the views of this BB or any entity associated with this BB. Any user who feels that a posted message is objectionable is encouraged to contact us immediately by email.  We have the ability to remove objectionable messages and we will make every effort to do so, within a reasonable time frame, if we determine that removal is necessary.  This is a manual process, however, so please realize that we may not be able to remove or edit particular messages immediately.

You agree, through your use of this service, that you will not use this BB to post any material which is knowingly false and/or defamatory, inaccurate, abusive, vulgar, hateful, harassing, obscene, profane, sexually oriented, threatening, invasive of a person's privacy, or otherwise violative of any law. You agree not to post any copyrighted material unless the copyrighted material is owned by you.

Although we do not and cannot review the messages posted and are not responsible for the content of any of these messages, we reserve the right to delete any message for any reason whatsoever. You remain solely responsible for the content of your messages, and you agree to indemnify and hold us harmless with respect to any claim based upon transmission of your message(s).

We reserve the right to reveal your identity (or whatever information we know about you) in the event of a complaint or legal action arising from any message posted by you.~;
}
} #end vars_registration default


if ($_[0] eq 'vars_search')  {
unless (exists $vars_search{AllowSearch}) {
$vars_search{AllowSearch} = 'TRUE';
$vars_search{AllowTotalSearch} = 'TRUE';
$vars_search{IndexMethod} = 'ONEFILE';
}
} #end vars_search default

if ($_[0] eq 'vars_misc')  {
unless (exists $vars_misc{ReplyQuote}) {
$vars_misc{ReplyQuote} = 'YES';
$vars_misc{BBStatus} = 'ON';
$vars_misc{BBClosedMessage} = 'Sorry, this message board is temporarily closed while we do some routine maintenance.';
$vars_misc{MemberMinimum} = '31';
$vars_misc{AdminTitle} = 'Administrator';
$vars_misc{ModeratorTitle} = 'Moderator';
$vars_misc{MemberTitle} = 'Member';
$vars_misc{JrMemberTitle} = 'Junior Member';
$vars_misc{Censor} = 'ON';
$vars_misc{EditOption} = 'ON';
$vars_misc{EditWording} = 'yes';
$vars_misc{IP} = 'LOGONLY';
$vars_misc{EnglishSubjectCheck} = 'ON';
$vars_misc{FloodCheck} = 'ON';
$vars_misc{FloodCheckSpan} = '30';
$vars_misc{edit_public_names} = 'YES';
$vars_misc{BBStatus} = 'ON';
$vars_misc{use_cache} = 'yes';
}

if ($vars_misc{use_cache} eq '') { $vars_misc{use_cache} = 'yes'; }

} #end vars_misc default


if ($_[0] eq 'vars_config')  {

} #end vars_config default


if ($_[0] eq 'vars_style')  {
unless (exists ($vars_style{ubb_friend_mini})) {
$vars_style{ubb_friend_mini} = "ubb_friend_mini.gif";
}
unless (exists $vars_style{user_ratings_3}) {
$vars_style{BGColor} = '#FFFFFF';
$vars_style{TextColor} = '#000000';
$vars_style{LinkColor} = '#333333';
$vars_style{VisitedLinkColor} = '#330099';
$vars_style{ActiveLinkColor} = '#5d7790';
$vars_style{TableBorderColor} = '#000000';
$vars_style{TableStripTextColor} = '#FFFFFF';
$vars_style{TableColorStrip} = '#5d7790';
$vars_style{TimeColor} = '#333333';
$vars_style{AltColumnColor1} = '#f7f7f7';
$vars_style{AltColumnColor2} = '#dedfdf';
$vars_style{CategoryStripColor} = '#d0783f';
$vars_style{CategoryStripTextColor} = '#FFFFFF';
$vars_style{CopyrightTextColor} = '#5d7790';
$vars_style{BBTitleFontColor} = '#5d7790';
$vars_style{hr_color} = '#000000';
$vars_style{FontFace} = 'Arial, Helvetica, sans-serif';
$vars_style{TableWidth} = '95%';
$vars_style{TextSize} = '2';
$vars_style{FDTextSize} = '1';
$vars_style{BBTitle} = 'bbtitle.gif';
$vars_style{BBTopic} = 'topic_ot.gif';
$vars_style{BBReply} = 'reply_ot.gif';
$vars_style{search_graphic} = 'searchhead.gif';
$vars_style{profilegif} = 'profile_ubb6.gif';
$vars_style{edit_icon} = 'edit_ubb6.gif';
$vars_style{reply_with_quote_icon} = 'quote_ubb6.gif';
$vars_style{homepage_icon} = 'homepage.gif';
$vars_style{mailgif} = 'email_ubb6.gif';
$vars_style{forum_summ_on} = 'on.gif';
$vars_style{forum_summ_off} = 'off.gif';
$vars_style{new_topic_folder} = 'closedb.gif';
$vars_style{old_topic_folder} = 'closed.gif';
$vars_style{hot_new_topic_folder} = 'hotclosedb.gif';
$vars_style{hot_old_topic_folder} = 'hotclosed.gif';
$vars_style{old_locked_folder} = 'yellockfolder.gif';
$vars_style{new_locked_folder} = 'redlockfolder.gif';
$vars_style{ubb_friend} = 'ubbfriend.gif';
$vars_style{ubb_friend_mini} = 'ubb_friend_mini.gif';
$vars_style{close_topic} = 'close_topic.gif';
$vars_style{open_topic} = "open_topic.gif";
$vars_style{move_topic} = "move_topic.gif";
$vars_style{delete_topic} = "delete_topic.gif";
$vars_style{prev_topic} = "prev_topic.gif";
$vars_style{next_topic} = "next_topic.gif";
$vars_style{priv_message} = "priv_message.gif";
$vars_style{user_ratings_1} = "user_ratings_1.gif";
$vars_style{user_ratings_2} = "user_ratings_2.gif";
$vars_style{user_ratings_3} = "user_ratings_3.gif";
$vars_style{user_ratings_4} = "user_ratings_4.gif";
$vars_style{user_ratings_5} = "user_ratings_5.gif";
}
} #end vars_style default


} #end setdefaults

sub view_vars {
local (@forums, @check, @mods, $Moderator, $x, $REQ, $DEL, $OPT);
local($author_location_select, $author_reg_date_select, $author_post_total_select, @user_profile, @display_name, @blank);

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_vars_$_[0]">%;

#retrieve current vars
require "$vars_config{VariablesPath}/vars_$_[0].cgi";

# if these settings have not been set before,
# let's give UBBer some direction :)
&SetDefaults("vars_$_[0]");

#if doing mods, need to get forum file
if ($_[0] eq 'mods') { @forums = &OpenForumsFile; }

# Set the page title
if ($_[0] eq 'display') { $CurrentTab = qq%$vars_wordlets_cp{display_settings}%; }
elsif ($_[0] eq 'email') { $CurrentTab = qq%$vars_wordlets_cp{email_settings}%; }
elsif ($_[0] eq 'registration') { $CurrentTab = qq%$vars_wordlets_cp{registration_settings}%; }
elsif ($_[0] eq 'config') { $CurrentTab = qq%$vars_wordlets_cp{config_settings}%; }
elsif ($_[0] eq 'mods') { $CurrentTab = qq%$vars_wordlets_cp{moderator_settings}%; }
elsif ($_[0] eq 'misc') { $CurrentTab = qq%$vars_wordlets_cp{misc_settings}%; }
elsif ($_[0] eq 'pm') { $CurrentTab = qq%$vars_wordlets_cp{pm_settings}%; }
elsif ($_[0] eq 'search') { $CurrentTab = qq%$vars_wordlets_cp{search_settings}%;
} else {
$CurrentTab = qq%$vars_wordlets_cp{time_settings}%;
}

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_vars_$_[0].pl";
&CPBottom;
} #end view_vars


sub RemoveDupes {
local($unomas, $dupe, $duper);
my @dupecheckthis = @_;
my @goodones = ();

foreach $unomas(@dupecheckthis) {
if ($unomas ne '') {
chomp($unomas); $dupe = 'no';

foreach $duper(@goodones) {
if ($unomas eq "$duper")  { $dupe = 'yes'; }
}
if ($dupe ne 'yes')  { push(@goodones, $unomas); }

} }
return(@goodones);
}

sub cp_entry_page {
local(@the_members, @forums, $forum_total, $member_count, $bb_status, $monthly_hits);

# get member count
@the_members = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");
$member_count = @the_members;

# get forum count
@forums = &OpenForumsFile;
$forum_total = @forums;

# get page views for month
if (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi") {
$monthly_hits = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");
chomp($monthly_hits);
} else {
$monthly_hits = 0;
}

# is forum open?
require "$vars_config{VariablesPath}/vars_misc.cgi";
if ($vars_misc{BBStatus} eq 'ON') {
	$bb_status = 'OPEN';
}  else {
	$bb_status = 'CLOSED';
}

$CurrentTab = qq%Entry Page%;
&CPHeader; &CPFooter;

&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_entry.pl";
&CPBottom;

} # end entry page


sub QueryLogin {
#query user for identification!
local($new_admin_wording);
# have any members been created yet?
my $lastnum = &OpenFileAsVar("$vars_config{MembersPath}/last_number.cgi");
$lastnum = $lastnum + 0;
if ($lastnum == 0)  {
unless (-e "$vars_config{MembersPath}/memberslist.cgi") {
$new_admin_wording = qq~<P>Important Note: you need to create a new administrator account in order to access your UBB control panel.  Please set up your admin profile by <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=register_page" target=_new>clicking here</A>.  After you are done, return to this page and login!~;
}
}  else {
$new_admin_wording = '';

}

$Hiddens = qq!<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="entry">!;
$CurrentTab = qq!Login Request!;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_query_admin.pl";
&CPBottom;

exit;
}

sub set_vars_pm {
local(*FILE);
local($ubb_code_images, $welcome_message);

$CurrentTab = qq%$vars_wordlets_cp{pm_settings}%;
&CPHeader; &CPFooter;

#validate
my @ValidateArray = ("html", "ubb_code", "feature");
&Validate(@ValidateArray);


# clean welcome
if ($in{welcome_pm_message} ne '') {
$welcome_message = &SmallClean($in{welcome_pm_message});

## IF HTML is not allowed, render HTML useless
if ($in{html} eq 'off') {
		$welcome_message =~ s/</&lt;/g;
		$welcome_message =~ s/>/&gt;/g;
}  else {
# don't allow HTML SCRIPT TAGS
&check_html($welcome_message);
}

$welcome_message = &Smilies($welcome_message);

# UBB Code-ify
if ($in{ubb_code} ne 'off') {
if ($in{ubb_code} eq 'on') {
	$ubb_code_images = 'ON';
} else {
	$ubb_code_images = 'OFF';
}
$welcome_message = &UBBCode("$welcome_message", "$ubb_code_images");
} #end if UBB Code allowed

# convert newlines/carriage returns to <br> and <p> html tags
$welcome_message = &ConvertReturns("$welcome_message");
$welcome_message= &PipeCleaner("$welcome_message");
}  else {
$welcome_message = '';
}

# write to file!

open (FILE, ">$vars_config{VariablesPath}/vars_pm.cgi") or die("Unable to open vars_pm.cgi file for writing.");
&lock;
print FILE qq!\%vars_pm = (\n!;
print FILE qq!feature => "$in{feature}",\n!;
print FILE qq!welcome_pm_message => q~$welcome_message~,\n!;
print FILE qq!ubb_code => "$in{ubb_code}",\n!;
print FILE qq!html => "$in{html}",\n!;
print FILE qq!welcome_pm => "$in{welcome_pm}"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_pm.cgi");

# clear cache
&ClearForumTopicsCache;

&cp_confirm("$vars_wordlets_cp{pm_settings} Updated");
exit;

} #end set_vars_pm
sub set_vars_display {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{display_settings}%;
&CPHeader; &CPFooter;

# bug spray
&CheckBadChars("$in{VariablesPath} $in{MembersPath} $in{CGIPath} $in{NonCGIPath}"); # check for invalid chars

#validate
my @ValidateArray = ("HomePageURL", "MyHomePage", "BBEmail", "ContactLinkType", "DaysPruneDefault", "ShowMods", "CategoryView", "CategoriesOnly", "ForumDescriptions", "ForumDisplayMax", "HTMLDisplayMax", "NewestMemberWelcome", "homepage_icon_link", "AllowSignature", "HotIcons", "user_ratings", "DisplayMemberTotal");
&Validate(@ValidateArray);

# set/clean the vars ------------
my $HomePageURL = &SmallClean($in{HomePageURL});
my $PrivacyURL = &SmallClean($in{PrivacyURL});
my $MyHomePage = &SmallClean($in{MyHomePage});
my $BBEmail = &SmallClean($in{BBEmail});
my $ContactURL = &SmallClean($in{ContactURL});
my $YourCopyrightNotice = &SmallClean($in{YourCopyrightNotice});

# limit/eliminate/convert returns in some fields
$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
$BBEmail = &EliminateReturns($BBEmail);

# clean forum_intro
my $forum_intro = &SmallClean($in{forum_intro});
$forum_intro = &ConvertReturns($forum_intro);
$forum_intro = &Smilies($forum_intro);

# idiot-proof
if ($in{CategoriesOnly} eq "true") {
$in{CategoryView} = "yes";
}

# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_display.cgi") or die("Unable to open vars_display.cgi file for writing.");
&lock;
print FILE qq!\%vars_display = (\n!;
print FILE qq!HomePageURL => q~$HomePageURL~,\n!;
print FILE qq!PrivacyURL => q~$PrivacyURL~,\n!;
print FILE qq!MyHomePage => q~$MyHomePage~,\n!;
print FILE qq!BBEmail => q~$BBEmail~,\n!;
print FILE qq!ContactURL => q~$ContactURL~,\n!;
print FILE qq!forum_intro => q~$forum_intro~,\n!;
print FILE qq!ContactLinkType => "$in{ContactLinkType}",\n!;
print FILE qq!DaysPruneDefault => "$in{DaysPruneDefault}",\n!;
print FILE qq!YourCopyrightNotice => q~$YourCopyrightNotice~,\n!;
print FILE qq!CategoryView => "$in{CategoryView}",\n!;
print FILE qq!CategoriesOnly => "$in{CategoriesOnly}",\n!;
print FILE qq!ForumDescriptions => "$in{ForumDescriptions}",\n!;
print FILE qq!ShowPrivacyLink => "$in{ShowPrivacyLink}",\n!;
print FILE qq!showcopytype => "$in{showcopytype}",\n!;
print FILE qq!AllowSignature => "$in{AllowSignature}",\n!;
print FILE qq!AllowSignatureImage => "$in{AllowSignatureImage}",\n!;
print FILE qq!ForumTotalOption => "$in{ForumTotalOption}",\n!;
print FILE qq!ReverseThreads => "$in{ReverseThreads}",\n!;
print FILE qq!DisplayMemberTotal => "$in{DisplayMemberTotal}",\n!;
print FILE qq!NewestMemberWelcome => "$in{NewestMemberWelcome}",\n!;
print FILE qq!AllowIcons => "$in{AllowIcons}",\n!;
print FILE qq!InlineFrame => "$in{InlineFrame}",\n!;
print FILE qq!ForumDisplayMax => "$in{ForumDisplayMax}",\n!;
print FILE qq!HTMLDisplayMax => "$in{HTMLDisplayMax}",\n!;
print FILE qq!HotIcons => "$in{HotIcons}",\n!;
print FILE qq!HotCount => "$in{HotCount}",\n!;
print FILE qq!MembersOnlyAccess => "$in{MembersOnlyAccess}",\n!;
print FILE qq!author_location => "$in{author_location}",\n!;
print FILE qq!author_reg_date => "$in{author_reg_date}",\n!;
print FILE qq!author_post_total => "$in{author_post_total}",\n!;
print FILE qq!ShowMods => "$in{ShowMods}",\n!;
print FILE qq!user_ratings => "$in{user_ratings}",\n!;
print FILE qq!homepage_icon_link => "$in{homepage_icon_link}",\n!;
print FILE qq!EmailBlock => "$in{EmailBlock}",\n!;
print FILE qq!masterCharset => "$in{masterCharset}"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_display.cgi");


# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;
&ClearMiscCache;

&cp_confirm("Display Settings Updated");
exit;

} #end set_vars_display

sub logout {
my $cookie = cookie(-name=> "ubbadmin$vars_config{Cookie_Number}", -value=> [$username, $password, $status], -path=> '/', -expires=>'-1d');
print header(-cookie=>$cookie);

$username = '';
require "$vars_config{NonCGIPath}/Templates/cp_common.pl";
$CurrentTab = qq%Login%;
$LoginWording = qq%<FONT COLOR="Navy">&#187;</FONT> Not logged in! <FONT COLOR="Navy">&#171;</FONT>%;
&CPHeader; &CPFooter;
&QueryLogin;
exit;
}

sub set_vars_email {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{email_settings}%;
&CPHeader; &CPFooter;

# bug spray
&CheckBadChars("$in{SendMailLocation} $in{EmailServer}"); # check for invalid chars

#validate
my @ValidateArray = ("UseEmail", "SMTPEmail", "UBBFriendUSE", "email_format");
&Validate(@ValidateArray);

#also check--
if (($in{SMTPEmail} eq 'Off') && ($in{SendMailLocation} eq '')) {
&StandardHTML("Error!<P>You must provide a SendMail Location if you are using SendMail. Use you browser's back button to add.");
}
if (($in{SMTPEmail} eq 'On') && ($in{EmailServer} eq '')) {
&StandardHTML("Error!<P>You must provide an SMTP Server Name if you are using SMTP Email. Use you browser's back button to add.");
}

# set/clean the vars ------------
my $SendMailLocation = &SmallClean($in{SendMailLocation});
my $EmailServer = &SmallClean($in{EmailServer});

# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_email.cgi") or die("Unable to open vars_email.cgi file for writing.");
&lock;
print FILE qq!\%vars_email = (\n!;
print FILE qq!UseEmail => "$in{UseEmail}",\n!;
print FILE qq!SMTPEmail => "$in{SMTPEmail}",\n!;
print FILE qq!SendMailLocation => q~$SendMailLocation~,\n!;
print FILE qq!EmailServer => q~$EmailServer~,\n!;
print FILE qq!email_format => "$in{email_format}",\n!;
print FILE qq!UBBFriendUSE => "$in{UBBFriendUSE}"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_email.cgi");


# clear cache
&ClearForumTopicsCache;
&cp_confirm("Email Settings Updated");
exit;

} #end set_vars_email

sub set_vars_time {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{time_settings}%;
&CPHeader; &CPFooter;

# bug spray
&CheckBadChars("$in{TimeZone} $in{TimeZoneOffset}"); # check for invalid chars

#validate
my @ValidateArray = ("DateFormat", "TimeFormat");
&Validate(@ValidateArray);

# set/clean the vars ------------
my $TimeZone = &SmallClean($in{TimeZone});
my $TimeZoneOffset = &SmallClean($in{TimeZoneOffset});

# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_time.cgi") or die("Unable to open vars_time.cgi file for writing.");
&lock;
print FILE qq!\%vars_time = (\n!;
print FILE qq!TimeZone => q~$TimeZone~,\n!;
print FILE qq!TimeZoneOffset => q~$TimeZoneOffset~,\n!;
print FILE qq!DateFormat => "$in{DateFormat}",\n!;
print FILE qq!TimeFormat => "$in{TimeFormat}"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_time.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

&cp_confirm("Time Settings Updated");
exit;

} #end set_vars_time

sub set_vars_registration {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{registration_settings}%;
&CPHeader; &CPFooter;

#validate
my @ValidateArray = ("BBRules", "EmailVerify", "EmailCheck", "COPPACheck", "COPPAType", "ModerateRegs", "OnRegsNotifyAdmin", "SuspendRegister", "allowHighBit", "DisplayRegistration", "RegsAdminEmail");
&Validate(@ValidateArray);

# set/clean the vars ------------
my $RegsAdminEmail = &SmallClean($in{RegsAdminEmail});
my $BBRules = &SmallClean($in{BBRules});
my $COPPAWording = &SmallClean($in{COPPAWording});
my $COPPAInstructions = &SmallClean($in{COPPAInstructions});
my $CustomField1 = &SmallClean($in{customfield1});
my $CustomField2 = &SmallClean($in{customfield2});
my $CustomField3 = &SmallClean($in{customfield3});
my $CustomField4 = &SmallClean($in{customfield4});

# limit/eliminate/convert returns in some fields
$BBRules = &LimitReturns($BBRules);
$COPPAWording = &LimitReturns($COPPAWording);
$COPPAInstructions = &LimitReturns($COPPAInstructions);
$RegsAdminEmail = &EliminateReturns($RegsAdminEmail);


# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_registration.cgi") or die("Unable to open vars_registration.cgi file for writing.");
&lock;
print FILE qq!\%vars_registration = (\n!;
print FILE qq!location_field_use => "$in{location_field_use}",\n!;
print FILE qq!occupation_field_use => "$in{occupation_field_use}",\n!;
print FILE qq!picture_field_use => "$in{picture_field_use}",\n!;
print FILE qq!homepage_field_use => "$in{homepage_field_use}",\n!;
print FILE qq!interests_field_use => "$in{interests_field_use}",\n!;
print FILE qq!custom1_field_use => "$in{custom1_field_use}",\n!;
print FILE qq!custom2_field_use => "$in{custom2_field_use}",\n!;
print FILE qq!custom3_field_use => "$in{custom3_field_use}",\n!;
print FILE qq!custom4_field_use => "$in{custom4_field_use}",\n!;
print FILE qq!customfield1 => qq~$CustomField1~,\n!;
print FILE qq!customfield2 => qq~$CustomField2~,\n!;
print FILE qq!customfield3 => qq~$CustomField3~,\n!;
print FILE qq!customfield4 => qq~$CustomField4~,\n!;
print FILE qq!icq_field_use => "$in{icq_field_use}",\n!;
print FILE qq!aim_field_use => "$in{aim_field_use}",\n!;
print FILE qq!signature_field_use => "$in{signature_field_use}",\n!;
print FILE qq!EmailVerify => "$in{EmailVerify}",\n!;
print FILE qq!EmailCheck => "$in{EmailCheck}",\n!;
print FILE qq!COPPACheck => "$in{COPPACheck}",\n!;
print FILE qq!COPPAType => "$in{COPPAType}",\n!;
print FILE qq!ModerateRegs => "$in{ModerateRegs}",\n!;
print FILE qq!OnRegsNotifyAdmin => "$in{OnRegsNotifyAdmin}",\n!;
print FILE qq!SuspendRegister => "$in{SuspendRegister}",\n!;
print FILE qq!allowHighBit => "$in{allowHighBit}",\n!;
print FILE qq!DisplayRegistration => "$in{DisplayRegistration}",\n!;
print FILE qq!RegsAdminEmail => q~$RegsAdminEmail~,\n!;
print FILE qq!BBRules => q~$BBRules~,\n!;
print FILE qq!COPPAWording => q~$COPPAWording~,\n!;
print FILE qq!COPPAInstructions => q~$COPPAInstructions~\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_registration.cgi");


# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

&cp_confirm("Registration Settings Updated");
exit;

} #end set_vars_registration

sub set_vars_search {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{search_settings}%;
&CPHeader; &CPFooter;

#validate
my @ValidateArray = ("AllowSearch", "AllowTotalSearch", "IndexMethod");
&Validate(@ValidateArray);

# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_search.cgi") or die("Unable to open vars_search.cgi file for writing.");
&lock;
print FILE qq!\%vars_search = (\n!;
print FILE qq!AllowSearch => "$in{AllowSearch}",\n!;
print FILE qq!AllowTotalSearch => "$in{AllowTotalSearch}",\n!;
print FILE qq!IndexMethod => "$in{IndexMethod}"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_search.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;

&cp_confirm("Search Settings Updated");
exit;

} #end set_vars_search

sub set_vars_misc {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{misc_settings}%;
&CPHeader; &CPFooter;

#validate
my @ValidateArray = ("BBStatus", "BBClosedMessage", "MemberMinimum", "AdminTitle", "ModeratorTitle", "MemberTitle", "JrMemberTitle", "Censor", "EditOption", "IP", "EnglishSubjectCheck", "edit_public_names", "FloodCheck", "use_cache", "FloodCheckSpan", "EditWording");
&Validate(@ValidateArray);

# set/clean the vars ------------
my $FloodCheckSpan = &SmallClean($in{FloodCheckSpan});
my $runOnLimit = &SmallClean($in{runOnLimit});
my $censorwords = &SmallClean($in{censorwords});
my $BBClosedMessage = &SmallClean($in{BBClosedMessage});
my $AdminTitle = &LimitReturns($in{AdminTitle});
my $ModeratorTitle = &LimitReturns($in{ModeratorTitle});
my $MemberTitle = &LimitReturns($in{MemberTitle});
my $JrMemberTitle = &LimitReturns($in{JrMemberTitle});
$MemberTitle = &SmallClean($MemberTitle);
$JrMemberTitle = &SmallClean($JrMemberTitle);
$AdminTitle = &SmallClean($AdminTitle);
$ModeratorTitle = &SmallClean($ModeratorTitle);
$BBClosedMessage = &LimitReturns($BBClosedMessage);
$censorwords = &LimitReturns($censorwords);


#check censor words for parentheses!
if ($censorwords =~ m/(\,|\(|\)|\]|\[)/) {
&StandardHTML("ERROR<P>We cannot process this request because you have a censor word list that includes at least one illegal character.  You may not use any of the following characters in your censor word list:<P><center>, &nbsp; ( &nbsp; ) &nbsp; [ &nbsp; ]</center>");
}

# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_misc.cgi") or die("Unable to open vars_misc.cgi file for writing.");
&lock;
print FILE qq!\%vars_misc = (\n!;
print FILE qq!ReplyQuote => "$in{ReplyQuote}",\n!;
print FILE qq!BBStatus => "$in{BBStatus}",\n!;
print FILE qq!BBClosedMessage => q~$BBClosedMessage~,\n!;
print FILE qq!censorwords => q~$censorwords~,\n!;
print FILE qq!MemberMinimum => "$in{MemberMinimum}",\n!;
print FILE qq!AdminTitle => q~$AdminTitle~,\n!;
print FILE qq!ModeratorTitle => q~$ModeratorTitle~,\n!;
print FILE qq!MemberTitle => q~$MemberTitle~,\n!;
print FILE qq!JrMemberTitle => q~$JrMemberTitle~,\n!;
print FILE qq!Censor => "$in{Censor}",\n!;
print FILE qq!EditOption => "$in{EditOption}",\n!;
print FILE qq!EditWording => "$in{EditWording}",\n!;
print FILE qq!IP => "$in{IP}",\n!;
print FILE qq!EnglishSubjectCheck => "$in{EnglishSubjectCheck}",\n!;
print FILE qq!edit_public_names => "$in{edit_public_names}",\n!;
print FILE qq!FloodCheck => "$in{FloodCheck}",\n!;
print FILE qq!use_cache => "$in{use_cache}",\n!;
print FILE qq!FloodCheckSpan => q~$FloodCheckSpan~,\n!;
print FILE qq!runOnLimit => q~$runOnLimit~,\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod(0777, "$vars_config{VariablesPath}/vars_misc.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;
&ClearMiscCache;

&cp_confirm("Miscellaneous Settings Updated");
exit;

} #end set_vars_misc

sub set_vars_config {
local(*FILE);

$CurrentTab = qq%$vars_wordlets_cp{config_settings}%;
&CPHeader; &CPFooter;

# bug spray
&CheckBadChars("$in{CGIPath} $in{NonCGIPath} $in{MembersPath} $in{VariablesPath} $in{CGIURL} $in{NonCGIURL}"); # check for invalid chars

#validate
my @ValidateArray = ("CGIURL", "NonCGIURL", "CGIPath", "NonCGIPath", "MembersPath", "VariablesPath", "BBName");
&Validate(@ValidateArray);

# set/clean the vars ------------
my $CGIURL = &CleanVar2($in{CGIURL});
my $NonCGIURL = &CleanVar2($in{NonCGIURL});
my $CGIPath = &CleanVar2($in{CGIPath});
my $NonCGIPath = &CleanVar2($in{NonCGIPath});
my $MembersPath = &CleanVar2($in{MembersPath});
my $VariablesPath = &CleanVar2($in{VariablesPath});
my $BBName = &SmallClean($in{BBName});

# limit/eliminate/convert returns in some fields
$BBName = &LimitReturns($BBName);

# this one is important, let's make sure new paths are valid!

# make sure the info is pointing to the right places :)
unless (-e "$CGIPath/cp.cgi") {
&StandardHTML(qq%Error:<P>Your new CGI Directory Path is not correct. [There may be other errors, as well.]%);
}
unless (-e "$NonCGIPath/on.gif") {
&StandardHTML(qq%Error:<P>Your new UBB NonCGI Directory Path is not correct. You would also receive this error if you forgot to upload the on.gif file into your UBB NonCGI directory.  [There may be other errors, as well.]%);
}
unless (-d "$NonCGIPath/Templates") {
&StandardHTML(qq%Error:<P>We cannot find your Templates directory!  This means that either the NonCGI absolute path you entered is not correct, or that the Templates directory is not where it is supposed to be.  We cannot proceed with changes until this is corrected.  [There may be other errors, as well.]%);
}
unless (-e "$MembersPath/emailfile.cgi") {
&StandardHTML(qq%Error:<P>Your Members Directory Path is not correct. We looked for the standard emailfile.cgi file but could not find it in the path that you specified!  [There may be other errors, as well.]%);
}

# need to set cache pw? (for beta testers only)--
# Reinstated by CC
unless (exists($vars_config{cache_pw})) {
$vars_config{cache_pw} = &GeneratePassword2;
mkdir ("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
}	# No cache pw == first submit, so create

unless (-d "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}") {
$vars_config{cache_pw} = &GeneratePassword2;
mkdir ("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
}	# cache pw without directory == screwy setup, so create


unless (-d "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}") {
&StandardHTML(qq%Error:<P>The cache-$vars_config{cache_pw} directory does not exist or could not be created.  Please reset permissions on your noncgi directory then submit Configuration Settings again.  [There may be other errors, as well.]%);
}	# If it still didn't get created, our noncgi directory is screwy, so have user fix


# write to file!
open (FILE, ">$vars_config{VariablesPath}/vars_config.cgi") or die("Unable to open vars_config.cgi file for writing.");
&lock;
print FILE qq!\%vars_config = (\n!;
print FILE "CGIURL => q!$CGIURL!,\n";
print FILE "NonCGIURL => q!$NonCGIURL!,\n";
print FILE "CGIPath => q!$CGIPath!,\n";
print FILE "NonCGIPath => q!$NonCGIPath!,\n";
print FILE "MembersPath => q!$MembersPath!,\n";
print FILE "VariablesPath => q!$VariablesPath!,\n";
print FILE qq!cache_pw => "$vars_config{cache_pw}",\n!;
print FILE qq!Cookie_Number => "$vars_config{Cookie_Number}",\n!;
print FILE qq!BBName => q~$BBName~\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_config.cgi");


# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;
&ClearMiscCache;

&cp_confirm("Configuration Settings Updated");
exit;
} #end set_vars_config

sub cp_confirm {
local($go_to);

#$_[0]: title
#$_[1]: details
#$_[2]: back_to title
#$_[3]: back_to URL

if (($_[3] ne '') && ($_[2] ne '')) {
	$go_to = qq~&#187; <A HREF="$_[3]">$_[2]</A>~;
}

$CurrentTab = qq%$_[0]%;

&CPHeader; &CPFooter;
&CPTop;
print qq~
<center>
<TABLE WIDTH="95%" BORDER='0'>
<TR><TD>
<FONT size="2" face="Verdana, Arial"><B>
$_[0]<P>$_[1]<P>$go_to
</B>
</FONT>
</TD></TR></TABLE></center>
~;
&CPBottom;
exit;
} # end cp_confirm



sub cp_transition {

# $_[0]: URL to forward to
# $_[1]: Message to display
# $_[2]: Tab
$direct_to = qq!<meta http-equiv="refresh" content="2;URL=$_[0]">!;

$CurrentTab = qq%$_[2]%;

&CPHeader; &CPFooter;
&CPTop;
print qq!
<center>
<TABLE WIDTH="95%" BORDER='0'>
<TR><TD>
<FONT size="2" face="Verdana, Arial"><B>
$_[1]<P><A HREF="$_[0]">$_[0]</A>
</B>
</FONT>
</TD></TR></TABLE></center>
!;
&CPBottom;
exit;
} # end cp_transition

sub board_on {
# grab current misc vars
if($vars_misc{BBStatus} =~ /^(.+) - (.+)$/) { $vars_misc{BBStatus} = $2 }
# reset- turning board on
else { $vars_misc{BBStatus} = 'ON'; }

# print updated hash
open(FILE, ">$vars_config{VariablesPath}/vars_misc.cgi");
&lock;
print FILE qq!\%vars_misc = (\n!;

foreach $key (keys %vars_misc) {

print FILE qq!$key => q~$vars_misc{$key}~,\n!;

}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_misc.cgi");


} # end board on

sub board_off {

# reset- turning board off
my $was_status = $vars_misc{BBStatus};
if($vars_misc{BBStatus} =~ /^(.+) - (.+)$/) { $was_status = $2 }
$vars_misc{BBStatus} = "OFF - $was_status";

# print updated hash
open(FILE, ">$vars_config{VariablesPath}/vars_misc.cgi");
&lock;
print FILE qq!\%vars_misc = (\n!;

foreach $key (keys %vars_misc) {

print FILE qq!$key => q~$vars_misc{$key}~,\n!;

}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_misc.cgi");

} # end board off

1;