# Control Panel - Routines for Pruning Posts

sub prune {

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_option">
%;
$CurrentTab = qq%$vars_wordlets_cp{prune_option}%;

# note: the wordlets are already required... no need to grab them

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_prune_intro.pl";
&CPBottom;

} # end prune sr

sub prune_by {
local($forum_options, @forums, @user_profile, @forum_info, $all_forums);

if ($in{prune_option} eq 'USER') {
$all_forums = qq!<OPTION VALUE="ALL"> All Forums!;
}

# get user profile if a mod...
if ($status eq 'Moderator') {
@user_profile = &verify_id_num($username, $password, $admin_number);
$all_forums = '';
}

# forum options
@forums = &OpenForumsFile;
foreach (@forums) {

@forum_info = split(/\|\^\|/, $_);

if ($status ne 'Administrator') {

$is_forum_mod = &is_admin_or_mod($forum_info[8], @user_profile);
if ($is_forum_mod eq 'true') {
$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">$forum_info[1]</OPTION>
!;
}

}  else {
$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">$forum_info[1]</OPTION>
!;

}

}

# template
$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_request">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
%;
$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

# determine template
($in{prune_option} eq "DATE") ? ($get_file = "cp_prune_by_date.pl") : ($get_file = "cp_prune_by_user.pl");

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/$get_file";
&CPBottom;

}  # end prune_by


sub prune_by_date_request {
local(%forum_topics, @this_forum, @user_profile, $user_perm, $key, $value, $int_value, $prune_cutoff, @prunes, @this_topic, $topic_starter, $days_old, $stat_line);

# validate
my @ValidateArray = ("prune_forum", "prune_days");
&Validate(@ValidateArray);

# grab forum record
@this_forum = &GetForumRecord($in{prune_forum});

# set exact_path
if ($this_forum[6] eq "private") {
	$exact_path = "Forum$in{prune_forum}/private-$this_forum[7]";
}  else {
	$exact_path = "Forum$in{prune_forum}";
}

# grab user profile
@user_profile = &verify_id_num($username, $password, $admin_number);

# make sure user has authority
$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);
unless ($user_perm eq "true") {
&StandardHTML("$vars_wordlets_err{no_permission}");
}

# grab forum threads file - create it if necessary
unless (-e "$vars_config{NonCGIPath}/$exact_path/forum_$in{prune_forum}.threads") {
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&create_forum_summary($in{prune_forum});
}

require "$vars_config{NonCGIPath}/$exact_path/forum_$in{prune_forum}.threads";

# today's Jules date: $GotTime{LastLoginJulianDATE}
# prune date:
$prune_cutoff = $GotTime{LastLoginJulianDATE} - $in{prune_days};

# collect prunable topics
while (($key, $value) = each(%forum_topics)) {
$int_value = int($value);
	if ($int_value < $prune_cutoff) {
		push(@prunes, $key);
	}
}

# template
$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_submit">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
<INPUT TYPE="HIDDEN" NAME="prune_forum" VALUE="$in{prune_forum}">
%;
$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

# note: the wordlets are already required... no need to grab them

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_prune_submit.pl";
&CPBottom;


}  # end prune_by_date_request

sub prune_submit {
if ($in{prune_option} eq 'USER') {
&prune_user_submit;
}  else {
&prune_date_submit;
}
} # end prune submit sr

sub prune_date_submit {
local(@this_forum, @user_profile, $user_perm, $key, $value, @prunes, @this_topic, $stat_line, $topic_posts, $redo_last_time, @data);

# validate
my @ValidateArray = ("prune_forum");
&Validate(@ValidateArray);

# grab forum record
@this_forum = &GetForumRecord($in{prune_forum});

# set exact_path
if ($this_forum[6] eq "private") {
	$exact_path = "Forum$in{prune_forum}/private-$this_forum[7]";
}  else {
	$exact_path = "Forum$in{prune_forum}";
}

# grab user profile
@user_profile = &verify_id_num($username, $password, $admin_number);

# make sure user has authority
$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);

unless ($user_perm eq "true") {
&StandardHTML("$vars_wordlets_err{no_permission}");
}

while (($key, $value) = each(%in)) {
if ($value eq "prune") { push(@prunes, $key); }
}  #end %in loop

# grab lastnumber file
if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {

@data = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

chomp($data[0]); chomp($data[1]); chomp($data[2]); chomp($data[3]);
chomp($data[4]); chomp($data[5]); chomp($data[6]);

}

# need to count total topics/posts being deleted
my $minus_topics = 0; my $minus_posts = 0;

# iterate thru pruned topics
foreach (@prunes) {

# grab topic
@this_topic = &OpenTopic($_, $in{prune_forum});

# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

$minus_topics++;
$topic_posts = $stat_line[2] + 1;
$minus_posts = $minus_posts + $topic_posts;

# are we deleting the last posted-to topic? (just in case...)
if ($_ eq "$data[6]") {
$data[3] = ''; $data[4] = ''; $data[5] = ''; $data[6] = '';
}

# delete topic file
unlink("$vars_config{NonCGIPath}/$exact_path/$_.cgi");

# delete topic HTML file
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$_.cgi");

} # end loop thru topics to prune

# update last number file
my $updated_topic_count = $data[1] - $minus_topics;
my $updated_post_count = $data[2] - $minus_posts;

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$data[0]\n");
print FILE ("$updated_topic_count\n");
print FILE ("$updated_post_count\n");
print FILE ("$data[3]\n");
print FILE ("$data[4]\n");
print FILE ("$data[5]\n");
print FILE ("$data[6]\n");
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# update threads file
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&create_forum_summary($in{prune_forum});

# clear cache
&ClearSingleForumPageCache($exact_path, $in{prune_forum});
&ClearSummaryCache;

# confirm onscreen

&cp_confirm("Forum Pruned!");
exit;

} # end prune_submit


sub prune_user_submit {
local(%prune_post, @this_forum, @user_profile, $user_perm, $key, $value, @prunes, $topic_line, @this_topic, $stat_line, $topic_posts, $redo_last_time, @data, $f, $t, $r, @updated_topic, $post_match, @user_posts, $check, @updated_posts, $forum, @forums, @all_forums, @forum_line, %exact_path);
local(*FILE);

# validate
my @ValidateArray = ("prune_forum", "prune_reg_user");
&Validate(@ValidateArray);


# grab user profile
@user_profile = &verify_id_num($username, $password, $admin_number);

# make sure user has authority
$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);

unless ($user_perm eq "true") {
&StandardHTML("$vars_wordlets_err{no_permission}");
}

# grab user_posts file for member we are pruning
@user_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi");

# put posts into hash
while (($key, $value) = each(%in)) {
if ($value eq "prune") { $prune_post{$key} = 'y'; }
}  #end %in loop

# if deleting entire topic, remove associated replies in same topic
while (($key, $value) = each(%prune_post)) {

($f, $t, $r) = split(/\|/, $key);
if (($prune_post{"$f|$t|000000"} eq 'y') && ($r ne '000000')) {
delete($prune_post{$key});
}

}  #end %prune_post loop

# loop through forums
if ($in{prune_forum} eq 'ALL') {
@all_forums = &OpenForumsFile;
foreach (@all_forums) {
@forum_line = split(/\|\^\|/, $_);
push(@forums, $forum_line[8]);
}
}  else {
@forums = ("$in{prune_forum}");
}


foreach $forum(@forums) {

# grab forum record
@this_forum = &GetForumRecord($forum);

# set exact_path
if ($this_forum[6] eq 'private') {
	$exact_path = "Forum$forum/private-$this_forum[7]";
}  else {
	$exact_path = "Forum$forum";
}

# grab lastnumber file
if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {

@data = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

chomp($data[0]); chomp($data[1]); chomp($data[2]); chomp($data[3]);
chomp($data[4]); chomp($data[5]); chomp($data[6]);

}

# need to count total topics/posts being deleted
my $minus_topics = 0; my $minus_posts = 0;


# iterate thru pruned topics
while (($key, $value) = each(%prune_post)) {
undef(@updated_topic); undef($post_match);

($f, $t, $r) = split(/\|/, $key);

# make sure topic exists
unless (-e "$vars_config{NonCGIPath}/$exact_path/$t.cgi") {
next;
}

# grab topic
@this_topic = &OpenTopic($t, $f);

# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

# are we deleting entire topic or just one post w/in topic?
if ($r eq '000000') {

$minus_topics++;
$topic_posts = $stat_line[2] + 1;
$minus_posts = $minus_posts + $topic_posts;

# are we deleting the last posted-to topic? (just in case...)
if ($t eq "$data[6]") {
$data[3] = ''; $data[4] = ''; $data[5] = ''; $data[6] = '';
}

# delete topic file
unlink("$vars_config{NonCGIPath}/$exact_path/$t.cgi");

# delete topic HTML file
unlink("$vars_config{NonCGIPath}/ubbfiles/forums/$exact_path/$t.cgi");

 } else {

# remove post from topic file
foreach $topic_line(@this_topic) {
unless ($topic_line =~ /^Z\|\|$r/i) {
push(@updated_topic, $topic_line);
} else {
$post_match = 'true';
}
}

unless ($post_match eq 'true') {
next;
}

# delete from member posts file
push(@del_from_user_posts, $key);

# only delete one post in topic
$minus_posts++;

$stat_line[2]--;
$updated_topic[0] = join("||", @stat_line);

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$t.cgi");
&lock;
print FILE @updated_topic;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$t.cgi");

# delete topic HTML file
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$t.cgi");

}
} # end loop thru topics to prune

# update last number file
my $updated_topic_count = $data[1] - $minus_topics;
my $updated_post_count = $data[2] - $minus_posts;

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$data[0]\n");
print FILE ("$updated_topic_count\n");
print FILE ("$updated_post_count\n");
print FILE ("$data[3]\n");
print FILE ("$data[4]\n");
print FILE ("$data[5]\n");
print FILE ("$data[6]\n");
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# update threads file
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&create_forum_summary($forum);

# clear cache
&ClearSingleForumPageCache($exact_path, $forum);

}  # foreach forum



# update user_posts?
if ($del_from_user_posts[0] ne '') {

foreach(@del_from_user_posts) {
chomp($_);
foreach $check(@user_posts) {
chomp($check);
unless ($_ eq "$check") { push(@updated_posts, $check); }
}
}

# update user_posts file
open (FILE, ">$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi") or die("Can't open: $!" );
&lock;
foreach(@updated_posts) {
chomp($_); print FILE "$_\n";
}
&unlock;
close (FILE);

chmod (0777, "$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi");


} # if we have something to delete from user posts file



# clear summary cache
&ClearSummaryCache;

# confirm onscreen

&cp_confirm("Forum Pruned!");
exit;

} # end prune_user_submit

sub prune_by_user_request {
local(@this_forum, @user_profile, $user_perm, $user_number, @all_posts, @prunes, @this_topic, $topic_starter, $stat_line, $f, $t, $r, @req_profile, $reply_num, $reply_line, %exact_path, @forumfacts, $forum_line);

# validate
my @ValidateArray = ("prune_forum", "prune_reg_user");
&Validate(@ValidateArray);

# grab forum record
@this_forum = &GetForumRecord($in{prune_forum});

# grab user profile
@user_profile = &verify_id_num($username, $password, $admin_number);

# make sure user has authority
$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);
unless ($user_perm eq "true") {
&StandardHTML("$vars_wordlets_err{no_permission}");
}

$user_number = &Do8Digit($in{prune_reg_user});

# get profile name
@req_profile = &OpenProfile($user_number);
$member_name = $req_profile[15]; chomp($member_name);
if ($member_name eq '') { $member_name = $req_profile[0]; }
chomp($member_name);

# get user's posts
if (-e "$vars_config{MembersPath}/user_posts/$user_number.cgi") {
@all_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$user_number.cgi");
}

#foreach (@all_posts) { chomp }
#use Data::Dumper;
#print "<xmp>", Dumper @all_posts, "</xmp>";

# grep array
if ($in{prune_forum} eq 'ALL') {
@prunes = @all_posts;
$forum_line = 'ALL';
}  else {
@prunes = grep { /^$in{prune_forum}\|/ } @all_posts;

$forum_line = qq~<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{prune_forum}">$this_forum[1]</A>~;

}


# template
$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_submit">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
<INPUT TYPE="HIDDEN" NAME="prune_forum" VALUE="$in{prune_forum}">
<INPUT TYPE="HIDDEN" NAME="prune_reg_user" VALUE="$user_number">
%;
$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

# note: the wordlets are already required... no need to grab them

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_prune_u_submit.pl";
&CPBottom;


}  # end prune_by_user_request
# Danger- do not remove the following line!
1;