# Control Panel - Routines for setting, managing styles

sub set_new_template {
local ($LastOne, $j, $lastnum);
local(*FILE);

# assign number to template
my @temps = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");
my @reverseit = reverse(@temps);
$LastOne = $reverseit[0]; chomp($LastOne);
($j, $lastnum) = split(/\|\^\|/, $LastOne);
$ThisTemplateNumber = $lastnum + 1;

# set/clean the vars ------------
my $Header = &SmallClean($in{Header});
my $Footer = &SmallClean($in{Footer});
my $HeaderInsert = &SmallClean($in{HeaderInsert});
my $html_extra = &SmallClean($in{html_extra});
my $body_extra = &SmallClean($in{body_extra});
my $language_meta = &SmallClean($in{language_meta});

# limit/eliminate/convert returns in some fields
$HeaderInsert = &LimitReturns($HeaderInsert);
$Header = &LimitReturns($Header);
$Footer = &LimitReturns($Footer);
$html_extra = &EliminateReturns($html_extra);
$body_extra = &EliminateReturns($body_extra);
$language_meta = &EliminateReturns($language_meta);

$CurrentTab = qq%$vars_wordlets_cp{style_settings}%;
&CPHeader; &CPFooter;

#validate
my @ValidateArray = ("BGColor", "TextColor", "LinkColor", "ActiveLinkColor", "VisitedLinkColor", "TableStripTextColor", "TableColorStrip", "TimeColor", "AltColumnColor1", "AltColumnColor2", "CategoryStripColor", "CategoryStripTextColor", "CopyrightTextColor", "BBTitleFontColor", "FontFace", "TableWidth", "TextSize", "FDTextSize", "BBTitle", "BBTopic", "BBReply", "profilegif", "mailgif", "edit_icon", "reply_with_quote_icon", "homepage_icon", "forum_summ_on", "forum_summ_off", "TemplateName", "new_topic_folder", "old_topic_folder", "hot_new_topic_folder", "hot_old_topic_folder", "ubb_friend", "old_locked_folder", "hr_color", "TableBorderColor", "table_border_display", "new_locked_folder", "open_topic", "close_topic", "ubb_friend_mini", "move_topic", "delete_topic", "prev_topic", "next_topic", "user_ratings_1", "user_ratings_2", "user_ratings_3", "user_ratings_4", "user_ratings_5", "search_graphic", "priv_message");
&Validate(@ValidateArray);

# another check on name
if (($in{TemplateName} =~ /\|\^\|/)) {
&StandardHTML(qq%Your template name can not contain: |^|%);
}

# write to file!
open (FILE, ">$vars_config{NonCGIPath}/styles/vars_style_$ThisTemplateNumber.cgi") or die("Unable to open vars_style.cgi file for writing.");
&lock;
print FILE qq!\%vars_style = (\n!;
print FILE qq!BGColor => q^$in{BGColor}^,\n!;
print FILE qq!TextColor => q^$in{TextColor}^,\n!;
print FILE qq!LinkColor => q^$in{LinkColor}^,\n!;
print FILE qq!ActiveLinkColor => q^$in{ActiveLinkColor}^,\n!;
print FILE qq!VisitedLinkColor => q^$in{VisitedLinkColor}^,\n!;
print FILE qq!TableBorderColor => q^$in{TableBorderColor}^,\n!;
print FILE qq!TableStripTextColor => q^$in{TableStripTextColor}^,\n!;
print FILE qq!TableColorStrip => q^$in{TableColorStrip}^,\n!;
print FILE qq!TimeColor => q^$in{TimeColor}^,\n!;
print FILE qq!AltColumnColor1 => q^$in{AltColumnColor1}^,\n!;
print FILE qq!AltColumnColor2 => q^$in{AltColumnColor2}^,\n!;
print FILE qq!CategoryStripColor => q^$in{CategoryStripColor}^,\n!;
print FILE qq!CategoryStripTextColor => q^$in{CategoryStripTextColor}^,\n!;
print FILE qq!CopyrightTextColor => q^$in{CopyrightTextColor}^,\n!;
print FILE qq!BBTitleFontColor => q^$in{BBTitleFontColor}^,\n!;
print FILE qq!hr_color => q^$in{hr_color}^,\n!;
print FILE qq!FontFace => q^$in{FontFace}^,\n!;
print FILE qq!TableWidth => q^$in{TableWidth}^,\n!;
print FILE qq!TextSize => q^$in{TextSize}^,\n!;
print FILE qq!FDTextSize => q^$in{FDTextSize}^,\n!;
print FILE qq!PageBackground => q^$in{PageBackground}^,\n!;
print FILE qq!BBTitle => q^$in{BBTitle}^,\n!;
print FILE qq!BBTopic => q^$in{BBTopic}^,\n!;
print FILE qq!BBReply => q^$in{BBReply}^,\n!;
print FILE qq!search_graphic => q^$in{search_graphic}^,\n!;
print FILE qq!profilegif => q^$in{profilegif}^,\n!;
print FILE qq!edit_icon => q^$in{edit_icon}^,\n!;
print FILE qq!reply_with_quote_icon => q^$in{reply_with_quote_icon}^,\n!;
print FILE qq!homepage_icon => q^$in{homepage_icon}^,\n!;
print FILE qq!forum_summ_on => q^$in{forum_summ_on}^,\n!;
print FILE qq!forum_summ_off => q^$in{forum_summ_off}^,\n!;
print FILE qq!table_border_display => q^$in{table_border_display}^,\n!;
print FILE qq!new_topic_folder => q^$in{new_topic_folder}^,\n!;
print FILE qq!old_topic_folder => q^$in{old_topic_folder}^,\n!;
print FILE qq!hot_new_topic_folder => q^$in{hot_new_topic_folder}^,\n!;
print FILE qq!hot_old_topic_folder => q^$in{hot_old_topic_folder}^,\n!;
print FILE qq!old_locked_folder => q^$in{old_locked_folder}^,\n!;
print FILE qq!new_locked_folder => q^$in{new_locked_folder}^,\n!;
print FILE qq!ubb_friend => q^$in{ubb_friend}^,\n!;
print FILE qq!ubb_friend_mini => q^$in{ubb_friend_mini}^,\n!;
print FILE qq!close_topic => q^$in{close_topic}^,\n!;
print FILE qq!open_topic => q^$in{open_topic}^,\n!;
print FILE qq!move_topic => q^$in{move_topic}^,\n!;
print FILE qq!delete_topic => q^$in{delete_topic}^,\n!;
print FILE qq!prev_topic => q^$in{prev_topic}^,\n!;
print FILE qq!next_topic => q^$in{next_topic}^,\n!;
print FILE qq!priv_message => q^$in{priv_message}^,\n!;
print FILE qq!user_ratings_1 => q^$in{user_ratings_1}^,\n!;
print FILE qq!user_ratings_2 => q^$in{user_ratings_2}^,\n!;
print FILE qq!user_ratings_3 => q^$in{user_ratings_3}^,\n!;
print FILE qq!user_ratings_4 => q^$in{user_ratings_4}^,\n!;
print FILE qq!user_ratings_5 => q^$in{user_ratings_5}^,\n!;
print FILE qq!Header => q~$Header~,\n!;
print FILE qq!Footer => q~$Footer~,\n!;
print FILE qq!HeaderInsert => q~$HeaderInsert~,\n!;
#print FILE qq!language_meta => q~$language_meta~,\n!;
print FILE qq!html_extra => q~$html_extra~,\n!;
print FILE qq!body_extra => q~$body_extra~,\n!;
print FILE qq!mailgif => q^$in{mailgif}^,\n!;
print FILE qq!thisCharset => q^$in{thisCharset}^\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{NonCGIPath}/styles/vars_style_$ThisTemplateNumber.cgi");

# update style sets file!
open (FILE, ">>$vars_config{VariablesPath}/vars_style_sets.cgi") or die("Unable to open vars_style.sets.cgi file for appending.");
&lock;
print FILE qq!$in{TemplateName}|^|$ThisTemplateNumber\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_style_sets.cgi");

#display template list page
&cp_confirm("Template Added");
exit;

} # end set new template

sub add_style_template {

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_new_template">%;

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list">$vars_wordlets_cp{style_settings}</A> &#187; Add New Template%;

# get standard settings to use as placeholders in form!
require "$vars_config{NonCGIPath}/styles/vars_style_1.cgi";

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_add_new_template.pl";
&CPBottom;

} # add_style_template


sub view_style {
local (@availstyles, $name, $num, $ThisName, $ThisNumber, $File, $DeleteWording);
#retrieve template info
@availstyles = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

FINDIT: foreach (@availstyles) {
($name, $num) = split(/\|\^\|/, $_); chomp($num);
if ($num eq "$in{template_choice}") {
	$ThisName = "$name";
	$ThisNumber = $num;
	last FINDIT;
}
}

# delete wording!
if ($in{template_choice} ne '1') {
# we can't allow the standard template to be deleted
$DeleteWording = qq!<INPUT TYPE="CHECKBOX" NAME="delete" VALUE="yes">&nbsp;&nbsp; Delete this style template? (check if desired)
!;
}  else {
$DeleteWording = qq!Note: You can not delete the Standard Template.!;
 }

$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_vars_style">
<INPUT TYPE="HIDDEN" NAME="template_choice" VALUE="$ThisNumber">
%;

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list">$vars_wordlets_cp{style_settings}</A> &#187; Template: $ThisName%;

# grab proper style settings!
require "$vars_config{NonCGIPath}/styles/vars_style_$ThisNumber.cgi";

&SetDefaults("vars_style");

&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_vars_style.pl";
&CPBottom;
} #end view_vars

sub view_style_templates {
local ($name, $num, $TemplateChoices);
$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="vars_style">%;

my @template_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

# assemble TemplateChoices

$TemplateChoices = qq!<SELECT NAME="template_choice">!;


foreach (@template_list) {
($name, $num) = split(/\|\^\|/, $_); chomp($num);
$TemplateChoices .= qq!<OPTION VALUE="$num">$name</OPTION>!;
}

$TemplateChoices .= qq!</SELECT>!;


$CurrentTab = qq%$vars_wordlets_cp{style_settings}%;


&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_vars_template_list.pl";
&CPBottom;
} #end view_style_templates



sub set_vars_style {
local(*FILE);
local($j, $number, @revised,, $key);
my $TemplateNumber = $in{template_choice};

# set/clean the vars ------------
my $Header = &SmallClean($in{Header});
my $Footer = &SmallClean($in{Footer});
my $HeaderInsert = &SmallClean($in{HeaderInsert});
my $html_extra = &SmallClean($in{html_extra});
my $body_extra = &SmallClean($in{body_extra});
my $language_meta = &SmallClean($in{language_meta});

# limit/eliminate/convert returns in some fields
$HeaderInsert = &LimitReturns($HeaderInsert);
$Header = &LimitReturns($Header);
$Footer = &LimitReturns($Footer);
$html_extra = &EliminateReturns($html_extra);
$body_extra = &EliminateReturns($body_extra);
$language_meta = &EliminateReturns($language_meta);

$CurrentTab = qq%$vars_wordlets_cp{style_settings}%;
&CPHeader; &CPFooter;

# delete it?
if ($in{delete} eq "yes") {

# change template match file
require "$vars_config{VariablesPath}/vars_template_match.cgi";
foreach $key (keys %template_match) {

if ($template_match{$key} == $TemplateNumber) { $template_match{$key} = '1'; }

}

# print updated hash
open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
&lock;
print FILE qq!\%template_match = (\n!;

foreach $key (keys %template_match) {

print FILE qq!$key => "$template_match{$key}",\n!;

}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_template_match.cgi");


my @temp_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

foreach (@temp_list) {
($j, $number) = split(/\|\^\|/, $_);  chomp($number);
unless ($number eq "$TemplateNumber") {
push(@revised, $_);
}
}
open(FILE, ">$vars_config{VariablesPath}/vars_style_sets.cgi");
&lock;
foreach $j(@revised) {
chomp($j);
print FILE "$j\n";
}
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_style_sets.cgi");

# delete old template
unlink("$vars_config{NonCGIPath}/styles/vars_style_$TemplateNumber.cgi");

#display template page
&view_style_templates;
exit;
} # end delete option


#validate
my @ValidateArray = ("BGColor", "TableBorderColor", "TextColor", "LinkColor", "ActiveLinkColor", "VisitedLinkColor", "TableStripTextColor", "TableColorStrip", "TimeColor", "AltColumnColor1", "AltColumnColor2", "CategoryStripColor", "CategoryStripTextColor", "CopyrightTextColor", "BBTitleFontColor", "FontFace", "TableWidth", "TextSize", "FDTextSize", "BBTitle", "BBTopic", "BBReply", "profilegif", "mailgif", "edit_icon", "reply_with_quote_icon", "homepage_icon",  "forum_summ_on", "forum_summ_off", "new_topic_folder", "old_topic_folder", "hot_new_topic_folder", "hot_old_topic_folder", "hr_color", "TableBorderColor", "table_border_display", "ubb_friend", "old_locked_folder", "new_locked_folder", "ubb_friend_mini", "open_topic", "close_topic", "move_topic", "delete_topic", "prev_topic", "next_topic", "user_ratings_1", "user_ratings_2", "user_ratings_3", "user_ratings_4", "user_ratings_5", "search_graphic", "priv_message");
&Validate(@ValidateArray);


# write to file!
open (FILE, ">$vars_config{NonCGIPath}/styles/vars_style_$TemplateNumber.cgi") or die("Unable to open vars_style.cgi file for writing.");
&lock;
print FILE qq!\%vars_style = (\n!;
print FILE qq!BGColor => q^$in{BGColor}^,\n!;
print FILE qq!TextColor => q^$in{TextColor}^,\n!;
print FILE qq!LinkColor => q^$in{LinkColor}^,\n!;
print FILE qq!ActiveLinkColor => q^$in{ActiveLinkColor}^,\n!;
print FILE qq!VisitedLinkColor => q^$in{VisitedLinkColor}^,\n!;
print FILE qq!TableBorderColor => q^$in{TableBorderColor}^,\n!;
print FILE qq!TableStripTextColor => q^$in{TableStripTextColor}^,\n!;
print FILE qq!TableColorStrip => q^$in{TableColorStrip}^,\n!;
print FILE qq!TimeColor => q^$in{TimeColor}^,\n!;
print FILE qq!AltColumnColor1 => q^$in{AltColumnColor1}^,\n!;
print FILE qq!AltColumnColor2 => q^$in{AltColumnColor2}^,\n!;
print FILE qq!CategoryStripColor => q^$in{CategoryStripColor}^,\n!;
print FILE qq!CategoryStripTextColor => q^$in{CategoryStripTextColor}^,\n!;
print FILE qq!CopyrightTextColor => q^$in{CopyrightTextColor}^,\n!;
print FILE qq!BBTitleFontColor => q^$in{BBTitleFontColor}^,\n!;
print FILE qq!hr_color => q^$in{hr_color}^,\n!;
print FILE qq!FontFace => q^$in{FontFace}^,\n!;
print FILE qq!TableWidth => q^$in{TableWidth}^,\n!;
print FILE qq!TextSize => q^$in{TextSize}^,\n!;
print FILE qq!FDTextSize => q^$in{FDTextSize}^,\n!;
print FILE qq!PageBackground => q^$in{PageBackground}^,\n!;
print FILE qq!BBTitle => q^$in{BBTitle}^,\n!;
print FILE qq!BBTopic => q^$in{BBTopic}^,\n!;
print FILE qq!BBReply => q^$in{BBReply}^,\n!;
print FILE qq!search_graphic => q^$in{search_graphic}^,\n!;
print FILE qq!profilegif => q^$in{profilegif}^,\n!;
print FILE qq!edit_icon => q^$in{edit_icon}^,\n!;
print FILE qq!table_border_display => q^$in{table_border_display}^,\n!;
print FILE qq!reply_with_quote_icon => q^$in{reply_with_quote_icon}^,\n!;
print FILE qq!homepage_icon => q^$in{homepage_icon}^,\n!;
print FILE qq!forum_summ_on => q^$in{forum_summ_on}^,\n!;
print FILE qq!forum_summ_off => q^$in{forum_summ_off}^,\n!;
print FILE qq!new_topic_folder => q^$in{new_topic_folder}^,\n!;
print FILE qq!old_topic_folder => q^$in{old_topic_folder}^,\n!;
print FILE qq!hot_new_topic_folder => q^$in{hot_new_topic_folder}^,\n!;
print FILE qq!hot_old_topic_folder => q^$in{hot_old_topic_folder}^,\n!;
print FILE qq!old_locked_folder => q^$in{old_locked_folder}^,\n!;
print FILE qq!new_locked_folder => q^$in{new_locked_folder}^,\n!;
print FILE qq!ubb_friend => q^$in{ubb_friend}^,\n!;
print FILE qq!ubb_friend_mini => q^$in{ubb_friend_mini}^,\n!;
print FILE qq!close_topic => q^$in{close_topic}^,\n!;
print FILE qq!open_topic => q^$in{open_topic}^,\n!;
print FILE qq!move_topic => q^$in{move_topic}^,\n!;
print FILE qq!delete_topic => q^$in{delete_topic}^,\n!;
print FILE qq!prev_topic => q^$in{prev_topic}^,\n!;
print FILE qq!next_topic => q^$in{next_topic}^,\n!;
print FILE qq!priv_message => q^$in{priv_message}^,\n!;
print FILE qq!user_ratings_1 => q^$in{user_ratings_1}^,\n!;
print FILE qq!user_ratings_2 => q^$in{user_ratings_2}^,\n!;
print FILE qq!user_ratings_3 => q^$in{user_ratings_3}^,\n!;
print FILE qq!user_ratings_4 => q^$in{user_ratings_4}^,\n!;
print FILE qq!user_ratings_5 => q^$in{user_ratings_5}^,\n!;
print FILE qq!Header => q~$Header~,\n!;
print FILE qq!Footer => q~$Footer~,\n!;
print FILE qq!HeaderInsert => q~$HeaderInsert~,\n!;
print FILE qq!body_extra => q~$body_extra~,\n!;
print FILE qq!html_extra => q~$html_extra~,\n!;
#print FILE qq!language_meta => q~$language_meta~,\n!;
print FILE qq!mailgif => q^$in{mailgif}^,\n!;
print FILE qq!thisCharset => q^$in{thisCharset}^\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$vars_config{NonCGIPath}/styles/vars_style_$TemplateNumber.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;
&ClearMiscCache;

# display tempate page
&cp_confirm("Style Settings Updated");
exit;

} #end set_vars_style

sub templates_advanced {
local (@templates, $key, $j, $k, $uno, $num, $Type, @thisforum);

$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_advanced_templates">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="misc">
%;

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list">$vars_wordlets_cp{style_settings}</A> &gt;&gt; Template Associations%;
&CPHeader; &CPFooter;

# get template list
@templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

require "$vars_config{VariablesPath}/vars_template_match.cgi";

&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_templates_advanced.pl";
&CPBottom;


} # end templates_advanced


sub templates_advanced_forums {
local (@templates, $key, $j, $k, $uno, $num, $Type, @all_forums, @this_forum, $this_template, $temp_num);

$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_advanced_templates">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="forums">
%;

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list">$vars_wordlets_cp{style_settings}</A> &gt;&gt; Template Associations%;
&CPHeader; &CPFooter;

@all_forums = &OpenForumsFile;
# get template list
@templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

require "$vars_config{VariablesPath}/vars_template_match.cgi";

&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_templates_advanced_f.pl";
&CPBottom;


} # end templates_advanced_forums


sub set_advanced_templates {

local(*FILE); local ($key, @this_forum, $ft);

require "$vars_config{VariablesPath}/vars_template_match.cgi";

if ($_[0] eq "misc") {

$template_match{registration} = "$in{registration}";
$template_match{search} = "$in{search}";
$template_match{transition} = "$in{transition}";
$template_match{summary_page} = "$in{summary_page}";
$template_match{profile} = "$in{profile}";
$template_match{ubb_code} = "$in{ubb_code}";
$template_match{faq} = "$in{faq}";
$template_match{email} = "$in{email}";
if ($in{private_message} eq '') { $in{private_message} = '1'; }
$template_match{private_message} = "$in{private_message}";


}  else {

# do forums

foreach $key (keys %in) {

if ($key =~ /forum/) { $template_match{$key} = $in{$key}; }
}

} # end if/else misc

# make sure all forums are accounted for: (probably overkill... but for the paranoid)--
my @forums = &OpenForumsFile;
foreach (@forums) {
@this_forum = split(/\|\^\|/, $_);
$ft = ("forum_". "$this_forum[8]");
unless(exists($template_match{$ft})) {
	$template_match{$ft} = '1';
}
}


# print updated hash
open(FILE, ">$vars_config{VariablesPath}/vars_template_match.cgi");
&lock;
print FILE qq!\%template_match = (\n!;

foreach $key (keys %template_match) {

print FILE qq!$key => "$template_match{$key}",\n!;

}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{VariablesPath}/vars_template_match.cgi");

# clear cache
&ClearForumTopicsCache;
&ClearForumPageCache;
&ClearSummaryCache;
&ClearMiscCache;

# view advanced template controls
&cp_confirm("Template Assignments Updated");

} # end set_adv templates

# Danger- do not remove the following line!
1;