# Control Panel - Routines for setting, managing users

sub user_settings {
local($private_forum_options, @forums, $one, @this_one);

# need to compile list of private forums
@forums = &OpenForumsFile;

# start line...
$private_forum_options = '';

foreach $one(@forums) {
@this_one = split(/\|\^\|/, $one);
if ($this_one[6] eq 'private') {
$private_forum_options .= qq!
<option value="$this_one[8]">$this_one[1]</option>
!;
}
} # each forum loop

$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="search_members">
!;
$CurrentTab = qq%$vars_wordlets_cp{search_users_header}%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_user_search_form.pl";
&CPBottom;

}  # end user_settings

sub search_members {
local($profile_index, $alt_color, $match, @matches, @user_profile, $title, $admin_yes, $admin_no, $write_yes, $write_no, %vars_misc, $start, $end, $total, @the_members, $one, $j, $member, $profile_opened, $bad, @search_file, $clean_name, $arraycount, $search_count, $search_email, $member_number, @searchfile, $line, @sort_mems, $thenum, $thename, $theemail, @the_emails, @sort_emails, $this_email_row, $this_email, $status_type, $more, $previous, $current, $search_record, $sp, $ep);

#initialize...
$alt_color = '';

# need to access user titles
require "$vars_config{VariablesPath}/vars_misc.cgi";

unless ( ($in{status} eq 'COPPA') || ($in{private_forum} ne '') ){
	$profile_index = 8; # status
}else {
	$profile_index = 4; # perms
}

# if search is by member number, this is easy, so let's keep it simple
if ($in{user_number} ne '') {
my $user_number = &Do8Digit($in{user_number});

#make sure profile number exists
if (-s "$vars_config{MembersPath}/$user_number.cgi") {
@user_profile = &OpenProfile("$user_number");
@matches = "$user_number";
$search_count = 1;
}  else {
@matches = '';
$search_count = 0;
}


$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_members">
!;
$CurrentTab = qq%$vars_wordlets_cp{search_users_header}%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_user_search_results.pl";
&CPBottom;
exit;

} # end member number search

# view all members?

if ($in{sr} ne '') {
@matches = &OpenFileAsArray("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search/$in{sr}.cgi");
$search_count = @matches;
$search_record = $in{sr};
}

elsif ($in{ViewEntire} eq 'Yes') {

my @the_members = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

foreach $j(@the_members) {
($j, $thenum) = split(/\|\!\!\|/, $j); chomp($thenum);
push(@matches, $thenum);
}

$search_count = @the_members;

} else {

@matches = &do_search;

}


# limit to no more than 50 matches per page
my $page_limit = 50;
my $array_limit = $page_limit - 1;

$current = "$vars_wordlets_cp{additional_members}";


if (($in{start_point} eq '') || ($in{start_point} == 0)) {

if ($search_count <= $page_limit) {
$current = ''; $more = ''; $previous = '';
$ep = $search_count; if($ep > 0) { $sp = '1' } else { $sp = '0' }
}  else {

# record these matches in a file
if ($in{sr} eq '') {
$search_record = &make_search_file(@matches);
}

@matches = @matches[0..$array_limit];
$more = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=search_members&start_point=$page_limit&sr=$search_record">&#187;&#187;</A>!;
$previous = '';
$sp = '1'; $ep = $page_limit;
}

}  else {

# make sure startpoint input is a number!
unless ($in{start_point} >= 0) { &StandardHTML("$vars_wordlets_err{start_point_number}");
}

my $end_point = $in{start_point} + $array_limit;
my $back = $in{start_point} - $page_limit;

if ($search_count <= ($end_point +1)) {
$end_point = $search_count -1;
$more = "";
$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=search_members&sr=$search_record&start_point=$back">&#171;&#171;</A>!;
$sp = $in{start_point} + 1;  $ep = $search_count;

}  else {

my $next = $in{start_point} + $page_limit;
$more = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=search_members&sr=$search_record&start_point=$next">&#187;&#187;</A>!;
$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=search_members&sr=$search_record&start_point=$back">&#171;&#171;</A>!;

$sp = $in{start_point} + 1;  $ep = $sp + $array_limit;
}

@matches = @matches[$in{start_point}..$end_point];

}


$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_members">
!;
$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A>%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_user_search_results.pl";
&CPBottom;
exit;

} # end search_members


sub do_search {
# set some vars
$search_email = $in{email}; $search_count = 0; $arraycount = 0; @matches = ();

my @the_members = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

foreach $j(@the_members) {
($thename, $thenum) = split(/\|\!\!\|/, $j); chomp($thenum);
$line = ("$thenum" . "|||" .  "$thename");
push(@sort_mems, $line);
}

if ($search_email ne '') {
@the_emails = &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");

foreach $j(@the_emails) {
($theemail, $thenum) = split(/\|\|/, $j); chomp($thenum);
$Line = ("$thenum" . "|||" . "$theemail");
push(@sort_emails, $Line);
}
}  # if we need to search by email

SEARCHLIST: foreach $one(@sort_mems) {
($member_number, $member) = split(/\|\|\|/, $one); chomp($member);

undef(@search_file); $profile_opened = ''; $bad = 'no';

#start login name check block
	if ($in{login_name} ne '') {
		$clean_name = quotemeta($in{login_name});
		unless ($member =~ /$clean_name/i) {
			$bad = 'yes';
		}
	}

# do email check?
	if (($search_email ne '') && ($bad ne 'yes')) {

	$this_email_row = $sort_emails[$arraycount];
	($j, $this_email) = split(/\|\|\|/, $this_email_row);
		chomp($this_email);
		unless ($this_email =~ /$search_email/i) {
			$bad = 'yes';
		}
	} #end if doing check of email

# Check number of posts?

if (($in{Posts} ne '') && ($bad ne 'yes')) {
if (-s "$vars_config{MembersPath}/$member_number.cgi") {
		@search_file = &OpenProfile($member_number);
}  else {
$bad = 'yes';
next SEARCHLIST;
}
		$profile_opened = 'y';
		chomp($search_file[7]);

		if ($in{Math} eq 'GT') {
			unless ($search_file[7] >= $in{Posts}) {
				$bad = 'yes';
			}
		}
		elsif ($in{Math} eq 'LT') {
			unless ($search_file[7] <= $in{Posts}) {
				$bad = 'yes';
			}
		}  else {
			unless ($search_file[7] == $in{Posts}) {
				$bad = 'yes';
			}
		}
}

# status check:

if (($in{user_status} ne '') && ($bad ne 'yes')) {
	if ($profile_opened ne 'y') {


	if (-s "$vars_config{MembersPath}/$member_number.cgi") {
		@search_file = &OpenProfile($member_number);
}  else {
$bad = 'yes';
next SEARCHLIST;
}
		$profile_opened = 'y';
	}
	$status_type = $search_file[$profile_index];
	chomp($status_type);

		unless ($status_type =~ m/$in{user_status}/io) {
			$bad = 'yes';
		}
}

# private forum check

if (($in{private_forum} ne '') && ($bad ne 'yes')) {
	if ($profile_opened ne 'y')  {

	if (-s "$vars_config{MembersPath}/$member_number.cgi") {
		@search_file = &OpenProfile($member_number);
}  else {
$bad = 'yes';
next SEARCHLIST;
}

	}
	chomp($search_file[4]);
	unless ($search_file[4] =~ m/\D$in{private_forum}/) {
		$bad = 'yes';
	}

}

# start validation block

$arraycount++;
if ($bad ne 'yes')  {
$search_count++;
push (@matches, $member_number);
}

# close validation block

}  # end foreach member

return(@matches);

}  # end do_search


sub make_search_file {
local($search_file_name);

# parameter: array of member numbers (matches)
&GetDateTime;

# remove old search files
&clean_search_files;

$search_file_name = $GotTime{SearchJulian};

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search");
}

open (FILE, ">$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search/$search_file_name.cgi");
&lock;
foreach $j(@_) {
print FILE "$j\n";
}
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search/$search_file_name.cgi");

return($search_file_name);
}

sub clean_search_files {
local(*FILE);
local($j, $dfile, $dfiledate, @searchies);
opendir(FILE,"$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search");
@dailies=grep(/.+-\.cgi/,readdir(FILE));
closedir(FILE);
 foreach $dfile (@searchies) {
	($dfiledate, $j)=split(/\-/,$dfile);
	$dfiledate = $dfiledate + 2; # delete if 2 days old
	if ($dfiledate < $GotTime{LastLoginJulianDATE}) {
		unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search/$dfile");
	}
 }

} # end clean_search_files


sub update_members {
local(%user_change, %user_delete, $key, $j, $user_number, $delete, @updated_mems, @updated_emails, $one, $delete_count, @mod_profile, $perms, $new_perms, $forums);

$delete_count = 0;
foreach $key (keys %in) {

if ($key =~ /Admin/i) {
($j, $user_number) = split(/::/, $key);
$user_change{$user_number} .= "$in{$key}";
}

if ($key =~ /Write/i) {
($j, $user_number) = split(/::/, $key);
$user_change{$user_number} .= "$in{$key}";
}

if ($key =~ /Delete/i) {
$delete = 'true';
$delete_count++;
($j, $user_number) = split(/::/, $key);
$user_change{$user_number} .= "$in{$key}";
}

} # end %in loop

# create user_delete hash, if any are being deleted
if ($delete eq 'true') {

foreach $key(keys %user_change) {

if ($user_change{$key} =~ /D/i) {
$user_delete{$key} = 'Y';
delete($user_change{$key});
unlink("$vars_config{MembersPath}/$key.cgi");
}

} # end user_change hash loop

# will need to update memberslist and emailfile
my @the_members = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

my @the_emails = &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");

my $member_total = &OpenFileAsVar("$vars_config{MembersPath}/membertotal.cgi");

$member_total = $member_total - $delete_count;

# amend memberslist
MEMBERCHECK: foreach $one(@the_members) {
chomp($one);
foreach $key(keys %user_delete) {
if ($one =~ /$key$/) {
 next MEMBERCHECK;
}
}
push(@updated_mems, $one);
}


# amend emailfile
EMAILCHECK: foreach $one(@the_emails) {
chomp($one);
foreach $key(keys %user_delete) {
if ($one =~ /$key$/) {
 next EMAILCHECK;
}
}
push(@updated_emails, $one);
}


open (FILE, ">$vars_config{MembersPath}/memberslist.cgi");
&lock;
foreach(@updated_mems) {
print FILE "$_\n";
}
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/memberslist.cgi");

open (FILE, ">$vars_config{MembersPath}/emailfile.cgi");
&lock;
foreach(@updated_emails) {
print FILE "$_\n";
}
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/emailfile.cgi");


open (FILE, ">$vars_config{MembersPath}/membertotal.cgi");
&lock;
print FILE "$member_total\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/membertotal.cgi");


} # if delete = true

# update files not being deleted now
foreach $key(keys %user_change) {
undef($new_perms);
@mod_profile = &OpenProfile($key);
chomp($mod_profile[4]); chomp($mod_profile[8]);

($perms, $forums) = split(/&/, $mod_profile[4]);

if ($user_change{$key} =~ /A/i) {
$mod_profile[8] = 'Administrator';
$new_perms .= 'Admin';
} else {
$mod_profile[8] = &determine_status;
}

if ($user_change{$key} =~ /W/i) { $new_perms .= 'Write'; }

$mod_profile[4] = ("$new_perms" . "&" . "$forums");

open (FILE, ">$vars_config{MembersPath}/$key.cgi");
&lock;
foreach(@mod_profile) {
chomp($_);
print FILE "$_\n";
}
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/$key.cgi");

} # end user_change loop

# clear cache
&ClearForumTopicsCache;

&cp_confirm("Members Updated");
exit;

} # end update_members sr


sub determine_status {
local(@mods_list, $status);
@mods_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_mods.cgi");
undef($mod);
foreach $j(@mods_list) {
if ($j =~ /$key/) {
	$status = 'Moderator';
}
}

if ($status ne 'Moderator')	 {
require "$vars_config{VariablesPath}/vars_misc.cgi";
chomp($mod_profile[7]);
	if ($mod_profile[7] < $vars_misc{MemberMinimum}) {
		$status = 'Junior Member';
	}  else {
		$status = 'Member';
	}
}
return($status);
}  # end determine_status

sub get_profile_for_admin {
local(@user_profile, $chompee, $count, $user_public_name, $user_status, %select_list, $days, $mm_yes, $mm_no, $ev_yes, $ev_no, $Signature, @explicit, $j, $perms, @mods, $mod, $Moderator, $is_mod, @forum_line, %forum_names, %forum_status, %forum_rights, $key, $overall_rating, %vars_style, $pm_yes, $pm_no, $pm_notify_yes, $pm_notify_no, $lock_check, $total_votes, $pm_lock_check);

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{VariablesPath}/vars_registration.cgi";
require "$vars_config{VariablesPath}/vars_misc.cgi";

# get requested profile
@user_profile = &OpenProfile($in{u});
$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]);
$count++;
}

# set custom status title
require "$vars_config{VariablesPath}/vars_misc.cgi";
$user_status = &CustomTitle($user_profile[8]);

# set public_name
if ($user_profile[15] eq '') {
$user_public_name = $user_profile[0];
} else {
$user_public_name = $user_profile[15];
}

# calibrate topic view
require "$vars_config{VariablesPath}/vars_display.cgi";
$days = $user_profile[21];
if ($days eq '') { $days = $vars_display{DaysPruneDefault}; }

foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)){
$select_list{$_}='';
}
$select_list{$days} = "SELECTED";

# calibrate mass mail
$mm_yes = ''; $mm_no = '';
if ($user_profile[14] eq "yes") { $mm_yes = "CHECKED"; }
else { $mm_no = "CHECKED"; }

# calibrate user ratings
$ratings_yes = ''; $ratings_no = '';
if ($user_profile[25] eq 'no') { $ratings_no = 'CHECKED'; }
else { $ratings_yes = 'CHECKED'; }

# calibrate email view mail
if ($user_profile[11] eq "yes") { $ev_yes = "CHECKED"; }
else {$ev_no = "CHECKED"; }

# calibrate pm option
if ($user_profile[27] eq 'no') { $pm_no = 'CHECKED';  $pm_yes = ''; }
else {$pm_yes = 'CHECKED'; $pm_no = ''; }

# calibrate pm notify option
if ($user_profile[28] eq 'no') { $pm_notify_no = 'CHECKED';  $pm_notify_yes = ''; }
else {$pm_notify_yes = 'CHECKED'; $pm_notify_no = ''; }

# get user rating?
if ($vars_display{user_ratings} ne 'off') {
($overall_rating, $total_votes) = &get_rating($in{u});
}
if ($overall_rating ne '') {
	$overall_rating = ("user_ratings_" . "$overall_rating");
}
require "$vars_config{NonCGIPath}/styles/vars_style_1.cgi";

# convert signature
$Signature = &reverse_ubb_code("$user_profile[12]");
$Signature =~ s/<p>/\n\r\n/isg;
$Signature =~ s/<br>/\n/isg;

# prepare forum permissions array, if not an admin
if ($user_profile[8] ne "Administrator") {

# get user perms
($j, $perms) = split(/&/, $user_profile[4]);
@explicit = split(/,/, $perms);

# sort forums
my @forums = &OpenForumsFile;
my @sortfor = sort(@forums);
my @sortforums = reverse(@sortfor);

# find restricted forum
for (@sortforums) {
	@forum_line = split(/\|\^\|/, $_);
	if ($forum_line[6] eq "private") {
		$forum_names{$forum_line[8]} = $forum_line[1];
		$forum_status{$forum_line[8]} = "Private";
	} elsif ($forum_line[6] =~ /restrict/) {
		$forum_names{$forum_line[8]} = $forum_line[1];
		$forum_status{$forum_line[8]} = "Posting Restrictions";
	}  else {
		# don't add to hashes
	}
}

# we have all forums with restrictions now
foreach $key(keys %forum_names) {

if ($user_profile[8] eq 'Moderator') {

require "$vars_config{VariablesPath}/vars_mods.cgi";

$Moderator = ("Forum" . "$key" . "Moderator");
$Moderator = $$Moderator;
@mods = split(/\|\|\^\|\|/, $Moderator);

undef($is_mod);
foreach $mod(@mods) {
if ($mod =~ /\|\^\|$key/) { $is_mod = "true"; }
}

if ($is_mod eq "true") {
$forum_rights{$key} = "$vars_misc{ModeratorTitle}";
}  else {
&check_explicit_perm;
}

}  else {

&check_explicit_perm;

}


unless ($forum_rights{$key} ne "") {
$forum_rights{$key} = qq!
<INPUT TYPE="CHECKBOX" NAME="explicit:$key" VALUE="yes"> $vars_wordlets_cp{grant_permission}
!;
}

} # hash loop



} # if not an admin

# do profile lock check
$lock_check = '';
if ($user_profile[24]) {
$lock_check = 'CHECKED' if ($user_profile[24] eq 'yes');
} else {
$lock_check = '';
}

# do pm lock check
$pm_lock_check = '';
if ($user_profile[29]) {
$pm_lock_check = 'CHECKED' if ($user_profile[29] eq 'no');
} else {
$pm_lock_check = '';
}


if ( ($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator') ) {
$user_profile[1] = 'Admin and Moderator Passwords Are Not Viewable';
}

# display profile info
$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="edit_profile">
<INPUT TYPE="HIDDEN" NAME="u" VALUE="$in{u}">
!;
$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{edit_profile}%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_edit_profile.pl";
&CPBottom;
} # end get_profile_for_admin


sub check_explicit_perm {
foreach (@explicit) {
chomp($_);
if ($key == $_) {
$forum_rights{$key} = qq!<INPUT TYPE="CHECKBOX" NAME="explicit:$key" VALUE="yes" CHECKED> $vars_wordlets_cp{grant_permission}
!;
}
}
} # end check_explicit sr

sub edit_profile {
local($key, $sig, $sig_html, $chompee, $count, @user_profile, $j, $f, $perm, @explicit, $new_explicit);
local(*FILE);

# clean up, validate, & ensure that this profile can be updated

foreach $key (keys %in) {
# rem HTML and unclosed tags
$in{$key} =~ s/<.*?>//sg;
$in{$key} =~ s/</&lt;/sg;
unless ($key eq "signature") {
$in{$key} =~ s/\s+/ /sg;
$in{$key} =~ s/"/&quot\;/sg;
}
} # foreach key


# validate
my @VA = ("u");

if ($vars_registration{location_field_use} eq 'REQ') { push(@VA, "location"); }
if ($vars_registration{occupation_field_use} eq 'REQ') { push(@VA, "occupation"); }
if ($vars_registration{picture_field_use} eq 'REQ') { push(@VA, "picture"); }
if ($vars_registration{homepage_field_use} eq 'REQ') { push(@VA, "homepage"); }
if ($vars_registration{interests_field_use} eq 'REQ') { push(@VA, "interests"); }
if ($vars_registration{signature_field_use} eq 'REQ') { push(@VA, "signature"); }
if ($vars_registration{icq_field_use} eq 'REQ') { push(@VA, "icq"); }
if ($vars_registration{aim_field_use} eq 'REQ') { push(@VA, "aim"); }


if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push(@VA, "customfield1"); }
if (($vars_registration{custom2_field_use} eq 'REQ') && ($vars_registration{customfield2} ne '')) { push(@VA, "customfield2"); }
if (($vars_registration{custom3_field_use} eq 'REQ') && ($vars_registration{customfield3} ne '')) { push(@VA, "customfield3"); }
if (($vars_registration{custom4_field_use} eq 'REQ') && ($vars_registration{customfield4} ne '')) { push(@VA, "customfield4"); }

&Validate(@VA);

# get user profile
@user_profile = &OpenProfile($in{u}); $count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]); $count++;
}

# add explicit permissions?
if ($user_profile[8] ne 'Administrator') {
foreach $key (keys %in) {
if (($key =~ /explicit/) && ($in{$key} eq 'yes')) {
($j, $f) = split(":", $key); chomp($f);
push(@explicit, $f);
}
} # foreach key

# assemble user permissions line
($perm, $j) = split("&", $user_profile[4]);
$new_explicit = join(",", @explicit);
$user_profile[4] = ("$perm" . "&" . "$new_explicit");

} # if not an admin/ end explicit array build

# prep sig - prevent HTML, strip returns, do UBB Code
$sig = &CensorCheck($in{signature});
$sig =~ s/(<IMG SRC)(.*?)(>)//isg;
$sig =~ s/</&lt;/sg;
$sig =~ s/>/&gt;/sg;
# remove leading/trainling whitespace
$sig =~ s/^\s+//; $sig =~ s/\s+$//;

$sig_html = &ConvertReturns($sig);
if ($vars_display{AllowSignatureImage} eq 'no'){
$ubb_code_images = 'no';
} else {
$ubb_code_images = 'yes';
}
$sig_html = &UBBCode("$sig_html");

if ($in{allow_pm} eq '') { $in{allow_pm} = 'yes'; }

# update registration file

open (FILE, ">$vars_config{MembersPath}/$in{u}.cgi") or die("Unable to open Members directory.");
&lock;
	print FILE ("$user_profile[0]\n");
	print FILE ("$user_profile[1]\n");
	print FILE ("$user_profile[2]\n");
	print FILE ("$in{homepage}\n");
	print FILE ("$user_profile[4]\n");
	print FILE ("$in{occupation}\n");
	print FILE ("$in{location}\n");
	print FILE ("$user_profile[7]\n");
	print FILE ("$user_profile[8]\n");
	print FILE ("$in{interests}\n");
	print FILE ("$user_profile[10]\n");
	print FILE ("$in{EmailView}\n");
	print FILE ("$sig_html\n");
	print FILE ("$in{icq}\n");
	print FILE ("$in{AllowMassMail}\n");
	print FILE ("$user_profile[15]\n");
	print FILE ("$in{customfield1}\n");
	print FILE ("$in{customfield2}\n");
	print FILE ("$in{customfield3}\n");
	print FILE ("$in{customfield4}\n");
	print FILE ("$in{picture}\n");
	print FILE ("$in{DaysPrune}\n");
	print FILE ("$in{aim}\n");
	print FILE ("$public_name|^|$admin_number|^|$GotTime{HyphenDate}\n");
	print FILE ("$in{lock_profile}\n");
	print FILE ("$in{user_ratings}\n");
	print FILE ("$user_profile[26]\n");
	print FILE ("$in{private_message}\n");
	print FILE ("$in{private_message_notify}\n");
	print FILE ("$in{allow_pm}\n");
&unlock;
close (FILE);

chmod (0777, "$vars_config{MembersPath}/$in{u}.cgi");

# clear cache
&ClearForumTopicsCache;


# onscreen confirm
&cp_confirm("Profile Updated", "The member's profile has been updated.", "View Profile", "$vars_config{CGIURL}/cp.cgi?ubb=get_profile_for_admin&u=$in{u}");
exit;

}  # end edit_profile

sub new_members {
local(@new_members, $total_members, @user_profile, $match, $j, $un, $current, $more, $previous);

# need to access user titles
require "$vars_config{VariablesPath}/vars_misc.cgi";

# grab members file
@new_members = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

#flip array
@new_members = reverse(@new_members);

# total member count
$total_members = @new_members;

# truncate list, if necessary (only want last 50)
if ($total_members > 50) { @new_members = @new_members[0..49]; }

$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{new_members}%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_new_members.pl";
&CPBottom;

} # end new_members

sub reg_moderation {
local(@the_q, @total_q, $alt_color, $q_count, $match, $deleted);
undef($alt_color); undef($deleted);

# grab the queue
@total_q = &OpenFileAsArray("$vars_config{MembersPath}/moderation_q.cgi");

# make sure all profiles are still valid
foreach (@total_q) {
chomp($_);
if (-s "$vars_config{MembersPath}/$_.cgi") {
push(@the_q, $_);
}  else {
$deleted = 'true';
}
}

# if any were not valid- republish queue
if ($deleted eq 'true') {
# print updated_q
open (FILE, ">$vars_config{MembersPath}/moderation_q.cgi");
&lock;
foreach (@the_q) { 	print FILE "$_\n"; }
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/moderation_q.cgi");
}


# total in the queue
$q_count = @the_q;

# limit to no more than 50 matches per page

if (($in{start_point} eq '') || ($in{start_point} == 0)) {

if ($q_count <= 50) {
$current = ''; $more = ''; $previous = '';
}  else {

@the_q = @the_q[0..49];
$more = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=50">&gt;&gt;</A>!;
$previous = ""; $current = "$vars_wordlets_cp{additional_members}";
}

}  else {

# make sure startpoint input is a number!
unless ($in{start_point} >= 0) {
&StandardHTML("$vars_wordlets_err{start_point_number}");
}

my $end_point = $in{start_point} + 49;
my $back = $in{start_point} - 50;

if ($q_count <= ($end_point +1)) {
$end_point = $q_count -1;
$more = '';
$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$back">&lt;&lt;</A>!;


}  else {

my $next = $in{start_point} + 50;
$more = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$next">&gt;&gt;</A>!;
$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$back">&lt;&lt;</A>!;

}

@the_q = @the_q[$in{start_point}..$end_point];
$current = "$vars_wordlets_cp{additional_members}";
}

$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_q">
!;
$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{registration_q}%;
&CPHeader; &CPFooter;
&CPTop;
do "$vars_config{NonCGIPath}/Templates/cp_registration_q.pl";
&CPBottom;


} # end reg_moderation


sub update_q {
local($key, $j, %queue, $un, @the_q, @this_profile, $perms, $explicit, $remove, $sendto, $subject, $from, $html_body, @updated_q, $message, $HTMLMessage, $last_approved);
local(*FILE);

require "$vars_config{VariablesPath}/vars_email.cgi";
require "$vars_config{VariablesPath}/vars_registration.cgi";
require "$vars_config{VariablesPath}/vars_display.cgi";
require "$vars_config{VariablesPath}/vars_template_match.cgi";
require "$vars_config{NonCGIPath}/Templates/public_common.pl";

undef(%queue);

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";

&set_page_elements;

# assemble queue action list
foreach $key (keys %in) {
if ($key =~ /^Q/) {
($j, $un) = split(/:/, $key);
unless ($in{$key} eq 'K') {
$queue{$un} = $in{$key};
}
}
} # end %in loop


# update member files
QMAN: foreach $key (keys %queue) {
undef(%vars_wordlets_email);
undef($message); undef($HTMLMessage);
@this_profile = &OpenProfile($key);

if ($queue{$key} eq 'A') {
$last_approved = $key;
($perms, $explicit) = split("&", $this_profile[4]);
$perms .= "Write";
$this_profile[4] = ("$perms" . "&" . "$explicit");
$this_profile[26] = '';

# update registration file
open (FILE, ">$vars_config{MembersPath}/$key.cgi") or die("Unable to open Members directory.");
&lock;
print FILE @this_profile;
&unlock;
close (FILE);

chmod (0777, "$vars_config{MembersPath}/$key.cgi");

} # only need to update approved members

# send email to registrant!

if ($vars_email{UseEmail} eq 'ON')  {

require "$vars_config{CGIPath}/ubb_lib_mail.cgi";

$sendto = "$this_profile[2]"; chomp($sendto);

#make sure email is valid format:
if (($sendto =~ m/\s/) || ($sendto !~ /\S+\@\S+\.\S+/)  ||  ($sendto =~ /^\./)   ||  ($sendto =~ /\.$/)  ||  ($sendto =~ /\.\@/) ||  ($sendto =~ /\@\./) || ($sendto =~ /;/) ) {
next QMAN;
}

$from = "$vars_registration{RegsAdminEmail}";

if ($vars_registration{RegsAdminEmail} eq '') {
	$from = $vars_display{BBName};
}

$subject = "$vars_wordlets_email{mod_queue_decision} $vars_config{BBName}";

do "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

$subject = "$vars_wordlets_email{mod_queue_decision} $vars_config{BBName}";

if ($queue{$key} eq 'A') {

$message = "$vars_wordlets_email{mod_queue_approve}";

$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_queue_approve_html}" . qq!</FONT>!;

}  else {

$message = "$vars_wordlets_email{mod_queue_decline}";

$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_queue_decline_html}" . qq!</FONT>!;

}


# is HTML format to be sent?
if ($vars_email{email_format} ne 'ascii') {
$HTMLMessage = "$EmailHeader $html_body $Footer";
}  else {
$HTMLMessage = '';
}

# in case only HTML format is to be sent:
if ($vars_email{email_format} eq 'html') {
$message = '';
}


&ubb_mail("$sendto", "$from", "$from", "$subject", "$message", "$HTMLMessage", "");


} # if email is activated



} # end loop through the queue

# grab queue file
@the_q = &OpenFileAsArray("$vars_config{MembersPath}/moderation_q.cgi");

foreach $j(@the_q) {
chomp($j); undef($remove);

foreach $key(keys %queue) {
if ($key == $j) { $remove = 'true'; }
}

unless ($remove eq 'true') { push(@updated_q, $j); }

}

# print last_approved file
if ($last_approved ne '') {
open (FILE, ">$vars_config{MembersPath}/last_approved.cgi");
&lock;
print FILE "$last_approved\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/last_approved.cgi");

&ClearSummaryCache;
}

# print updated_q
open (FILE, ">$vars_config{MembersPath}/moderation_q.cgi");
&lock;
foreach (@updated_q) {
	print FILE "$_\n";
}
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/moderation_q.cgi");



# onscreen display
&cp_confirm("Registration Queue Updated! (members notifed by email)");
exit;
}  # end update_q sr


# Danger- do not remove the following line!
1;