# UBB New Topic Routines : Perl Code

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{CGIPath}/ubb_lib_2.cgi";

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";

&set_page_elements;

sub edit_post {
local(@this_topic, @stat_line, @post_line, @post_info, @user_profile, $permission, @this_forum, $delete_warning, $warning_words, $message, $is_one, $is_admin_mod, $this_subject, $icon_field, $close_option, $profile_number, $show_sig, $sigcheck, $permit_delete, $category, $cat_name, $cat_line1, $ubb_code_buttons, $is_html, $is_ubb, $ubb_images_wording);

# make sure we have someone logged in
if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# get forum info
@this_forum = &GetForumRecord($in{f});


if ($reply_restrict eq 'none') {
&StandardHTML("$vars_wordlets_err{no_one_can_post}");
}

# if forum is private, make sure user has access
if ($this_forum[6] eq 'private') { &check_private_access($in{f}, $this_forum[12]); }

# grab topic
@this_topic = &OpenTopic($in{t}, $in{f});

# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

# find particular post within topic
@post_line = grep(/^Z\|\|$in{reply_num}/, @this_topic);
@post_info = split(/\|\|/, $post_line[0]);

# get profile for poster to confirm identity
if ($post_info[8] eq 'reg') {
if ($post_info[11] ne '') {
$profile_number = $post_info[11];
}  else {
$profile_number = &GetUserNumber($post_info[2]);
if ($profile_number eq '') { $profile_number = 'NONE'; }
}
#@post_user = &OpenProfile($profile_number);
}  else {
$profile_number = 'NONE';
}


# permission to edit?

if ( ($user_number == $profile_number)  && ($vars_misc{EditOption} ne 'OFF') && ($stat_line[1] !~ /X/i) ) {
$permission = 'true';
}

# if not poster, need to be admin or forum moderator...
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);
# make sure user is an admin or moderator of this forum
$is_one = &is_admin_or_mod($in{f}, @user_profile);

if ($is_one eq 'true')  { $permission = 'true'; }

if ($permission ne 'true') { &StandardHTML("$vars_wordlets_err{not_admin_or_mod}"); }

# is editor an admin or mod of this forum?
chomp($user_profile[8]);
if ($is_one eq 'true') { $is_admin_mod = 'true'; }

# can user delete?
if ($vars_misc{EditOption} ne 'ON') {

if ($is_one eq 'true') { $permit_delete = 'true'; }

}  else {

$permit_delete = 'true';

}

# grab category
if ($vars_display{CategoryView} eq 'yes') {

$category = $this_forum[0];
$cat_name = &GetCatName($category);

$cat_line1 = qq!
&nbsp;
&#187;  <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?&category=$category">
<B>$cat_name</B></A>
!;
}  else {
$cat_line1 = '';
}


# ok, this person has permission to edit!

&CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");
# -> is_html, is_ubb, ubb_images_wording

if ($this_forum[5] eq 'is') {
$ubb_code_buttons = &instant_ubb_code;
}  else {
$ubb_code_buttons = "$is_ubb";
}

# prepare the post for display
$message = $post_info[6];

# remove signature, if this is an old format post
chomp($post_info[12]);
if ($post_info[12] eq '') {
$message =~ s/------------------(.*)//isg; # old sig standard
}

$message = &prep_for_edit("$message", "$this_forum[5]", "$this_forum[10]");


# check for ability to delete post
if ($vars_misc{EditOption} eq 'NODELETE') {
$delete_warning = qq%$vars_wordlets{edit_without_delete}%;
}  else {
$delete_warning = qq%$vars_wordlets{edit_with_delete}%;
}

if ($in{reply_num} eq '000000') {
$warning_words = qq!$vars_wordlets{warn_delete_entire_topic}!;
$this_subject = $stat_line[4]; $this_subject =~ s/&#0124;/\|/sg;
}

if ($vars_display{AllowIcons} eq 'TRUE') {
$icon_field = &create_icon_field("$post_info[9]");
}

# disable smilies?
$disable_smilies =  qq(<BR><INPUT TYPE="CHECKBOX" NAME="disable_smilies" VALUE="yes"> $vars_wordlets{disable_smilies});

# show signature?
if ( ($vars_display{AllowSignature} eq 'YES') && ($username ne '')  && ($profile_number ne 'NONE') ) {
if ($post_info[12] eq 'yes') { $sigcheck = 'CHECKED'; }
$show_sig = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes" $sigcheck> $vars_wordlets{show_signature});
}

# allow closing of topic?
# only admins or mods can close topics
if (($username ne '') && ($stat_line[1] !~ /X/i)) {
if ($user_profile[0] eq '') {
@user_profile = &verify_id_num($username, $password, $user_number);
}
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq "true") {
$close_option = qq(<BR><INPUT TYPE="CHECKBOX" NAME="close_topic" VALUE="yes"> <B>$vars_wordlets{close_topic}</B>);
}
}

# pull in instant smilie/ubb code javascript
$direct_to = $instant_jscript;
&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_edit_post.pl";

} # end edit_post sr

sub submit_edit {
local(@this_topic, @stat_line, @post_user, @post_line, @post_info, @user_profile, $permission, @this_forum, $delete_warning, $warning_words, $message, $is_admin_mod, $this_subject, $icon_field, $post_total, $profile_number);

# make sure we have someone logged in
if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# get forum details
@this_forum = &GetForumRecord($in{f});

# grab topic
@this_topic = &OpenTopic($in{t}, $in{f});
# this also sets $exact_path

$post_total = @this_topic;
$post_total--;


# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

# find particular post within topic
@post_line = grep(/^Z\|\|$in{reply_num}/, @this_topic);
@post_info = split(/\|\|/, $post_line[0]);

# get profile for poster to confirm identity
if ($post_info[8] eq 'reg') {
if ($post_info[11] ne '') {
$profile_number = $post_info[11];
}  else {
$profile_number = &GetUserNumber($post_info[2]);
if ($profile_number eq '') { $profile_number = 'NONE'; }
}
# @post_user = &OpenProfile($profile_number);
}  else {
$profile_number = 'NONE';
}

# permission to edit?

if ( ($user_number == $profile_number) && ($vars_misc{EditOption} ne 'OFF') && ($stat_line[1] !~ /X/i) ) {
$permission = 'true';
if (($vars_misc{EditOption} eq 'NODELETE') && ($in{delete_post} eq 'yes')) {
$permission = '';
}

}

# if not poster, need to be admin or forum moderator...
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);
# make sure user is an admin or moderator of this forum
my $is_one = &is_admin_or_mod($in{f}, @user_profile);

if ($is_one eq 'true') { $permission = 'true'; }

if ($permission ne 'true') { &StandardHTML("$vars_wordlets_err{not_admin_or_mod}"); }

# request to delete?
if ($in{delete_post} eq 'yes') {

&perform_delete;

}  else {

# simple edit
&perform_edit;

}

} # end submit_edit

sub perform_delete {

local(@user_posts, @updated_topic, $update_threads_file, @rev_topic);


# get lastnumber.file info
@last_numbers = &grab_last_numbers;

chomp($last_numbers[0]); chomp($last_numbers[1]); chomp($last_numbers[2]); chomp($last_numbers[3]); chomp($last_numbers[4]); chomp($last_numbers[5]);
chomp($last_numbers[6]);

if ($in{reply_num} eq '000000') {

# delete topic file
unlink ("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

#delete HTML file for topic
unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# update lastnumber.file
if ($last_numbers[0] == $in{t}) {
undef($last_numbers[3]); undef($last_numbers[4]); undef($last_numbers[5]);
}

$last_numbers[1] = $last_numbers[1] - 1;
$last_numbers[2] = $last_numbers[2] - $post_total;

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$last_numbers[0]\n");
print FILE ("$last_numbers[1]\n");
print FILE ("$last_numbers[2]\n");
print FILE ("$last_numbers[3]\n");
print FILE ("$last_numbers[4]\n");
print FILE ("$last_numbers[5]\n");
print FILE ("$last_numbers[6]\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# update threads file
&unlink_topic_from_forum_summary($in{f}, $in{t});

# clear cache
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{f});

# transition
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{f}", "$vars_wordlets{thanks_for_topic_delete}", "$this_forum[1]");
exit;
}  else {

# only delete particular post within topic

# adjust reply total & stat_line
$stat_line[2]--;
# adjust @this_topic
$this_topic[0] = join("||", @stat_line);


# remove post from topic file
foreach (@this_topic) {
unless ($_ =~ /^Z\|\|$in{reply_num}/) {
push(@updated_topic, $_);
}
}

# update topic file
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");
&lock;
print FILE @updated_topic;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

# update lastnumber.file
$last_numbers[2]--;

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$last_numbers[0]\n");
print FILE ("$last_numbers[1]\n");
print FILE ("$last_numbers[2]\n");
print FILE ("$last_numbers[3]\n");
print FILE ("$last_numbers[4]\n");
print FILE ("$last_numbers[5]\n");
print FILE ("$last_numbers[6]\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# delete HTML file for topic - it will be recreated when needed
unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# update user_posts file
# need to do this when deleting single posts w/in topics

@user_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$profile_number.cgi");

foreach (@user_posts) {
chomp($_);
unless ($_ eq "$in{f}|$in{t}|$in{reply_num}") { push(@updated_posts, $_); }
}


# update user_posts file
open (FILE, ">$vars_config{MembersPath}/user_posts/$profile_number.cgi") or die("Can't open: $!" );
&lock;
foreach(@updated_posts) {
chomp($_); print FILE "$_\n";
}
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/user_posts/$profile_number.cgi");

# clear cache
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{f});

# transition
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{f}", "$vars_wordlets{thanks_for_topic_delete}", "$this_forum[1]");
exit;
}

} # end perform_delete

sub perform_edit {
local($count, $message, $ip_number, @post_data, $edit_date, @last_numbers);

# clean up edited post
$message = $in{message};

## if HTML is not allowed, render HTML useless
if ($this_forum[4] eq 'is not') {
	$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
}

$message = &CensorCheck("$message");
$message = &Truncate("$message");


# do graemlins--
if ($in{disable_smilies} ne 'yes') { $message = &Smilies("$message"); }

#UBB Code-ify (if allowed)
if ($this_forum[5] eq 'is') {
$message = &UBBCode("$message", "$this_forum[10]");
} #end if UBB Code allowed

#convert newlines/carriage returns to <br> and <p> html tags
$message = &ConvertReturns("$message");

$message= &PipeCleaner("$message");

# check for excess images-
&excess_smilies_check($message);

# don't allow HTML SCRIPT tags
&check_html($message);

# append edit note to the message
if ($vars_misc{EditWording} eq 'yes') {
&GetDateTime;

$edit_date = &DateFormat($GotTime{HyphenDate});

$message .= qq(<p>[ $edit_date: $vars_wordlets{edit_wording} $pubname ]);


} # end "edited by" message

# post icons idea provided by KOMBAT03...
unless ($in{msg_icon} >= 0) { 	$in{msg_icon} = '1'; }


# topic subject checks, if this is the first post
if ($in{reply_num} == 0) {

# require english letter/number in subject?
if (($in{topic_subject} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq 'ON')){
&StandardHTML("$vars_wordlets_err{subject_deficient}");
}

# make sure subject is not blank
if ($in{topic_subject} eq '') {
&StandardHTML("$vars_wordlets_err{subject_deficient}");
}

# check for HTML tags in subject
if ( ($in{topic_subject} =~ /<.*>/) || ($in{topic_subject} =~ /</) ) {
&StandardHTML("$vars_wordlets_err{subject_with_html}");
}

$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};
# other subject checks/clean-ups
if ($in{topic_subject} =~ /\S{$vars_misc{runOnLimit}}/)  {
&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{topic_subject}");
}	#test before trying to expand special characters

$in{topic_subject} = FixSubjectEncoding($in{topic_subject});

# censor check the subject
$in{topic_subject} = &CensorCheck("$in{topic_subject}");
} # end topic subject checks

# is user banned?
$ip_number = $ENV{'REMOTE_ADDR'};
&check_ip_bans;

# stat_line changes necessary?
if ($in{reply_num} == 0)  {

# need to update stat_line
$stat_line[4] = $in{topic_subject};
$stat_line[6] = $in{msg_icon};

} # end stat_line changes

# close topic?
# only admins or mods can close topics
if ($in{close_topic} eq 'yes') {
if ($user_profile[0] eq '') {
@user_profile = &verify_id_num($username, $password, $user_number);
}
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq 'true')  { $stat_line[1] .= 'X'; }
}

foreach(@stat_line) { chomp }

# update stat line
$this_topic[0] = join("||", @stat_line);
#chomp($this_topic[0]);
#$this_topic[0] .= "\n";

# update post in topic file
$count = 0;
foreach (@this_topic) {
if ($_ =~ /^Z\|\|$in{reply_num}/) {
@post_data = split(/\|\|/, $_);
$post_data[9] = $in{msg_icon};
$post_data[6] = $message;
$post_data[12] = $in{Signature};
chomp($post_data[7], $post_data[8], $post_data[10], $post_data[11]);
$this_topic[$count] = join("||", @post_data);
}
chomp($this_topic[$count]);
$this_topic[$count] .= "\n";
$count++;
}

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");
&lock;
print FILE @this_topic;
&unlock;
close (FILE);

# delete HTML file for topic - it will be recreated when needed
unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# update lastnumber.file, if necessary
@last_numbers = &grab_last_numbers;

chomp($last_numbers[0]); chomp($last_numbers[1]); chomp($last_numbers[2]); chomp($last_numbers[3]); chomp($last_numbers[4]); chomp($last_numbers[5]);
chomp($last_numbers[6]);

if ($last_numbers[6] eq "$in{t}") {

if ($in{reply_num} eq '000000') {
$last_numbers[3] = $in{topic_subject};
}

# is this the last post in the topic- if so, update icon
my @rev_topic = reverse(@this_topic);
my @last_post = split(/\|\|/, $rev_topic[0]);
if ($last_post[1] == $in{reply_num}) {
$last_numbers[5] = $in{msg_icon};
}

#need to update lastnumbers file then
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$last_numbers[0]\n");
print FILE ("$last_numbers[1]\n");
print FILE ("$last_numbers[2]\n");
print FILE ("$last_numbers[3]\n");
print FILE ("$last_numbers[4]\n");
print FILE ("$last_numbers[5]\n");
print FILE ("$last_numbers[6]\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# clear cache
&ClearSummaryCache;

}  # end lastnumbers check

if ($in{reply_num} == 0) {
&ClearSingleForumPageCache($exact_path, $in{f});
}

# transition
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}", "$vars_wordlets{thanks_for_edit}", "$stat_line[4]");
exit;
}  # end perform_edit sr

# DANGER: Do not remove the next line!
1;