# UBB Public Forum Summary Page : Perl Code

# get assigned style template!
unless (exists($template_match{summary_page})) { $template_match{summary_page} = 1; }
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{summary_page}.cgi";

&set_page_elements;

sub forum_summary { 
local($file_name, $RegisteredMemberLine, @CATEGORIES, @sortedforums);
local(*MEM);

if ($in{category} eq '') {
if ( ($vars_misc{use_cache} ne 'no') && (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/summary.html")) {
$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/summary.html");
print "$ThisHTML";
exit;
}  
}  else {
if ($vars_display{CategoriesOnly} ne 'false') {
# if this is a category-only view & specific category is selected
if (($vars_misc{use_cache} ne 'no') && (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/summary-$in{category}.html") && ($in{category} > 0)) {
$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/summary-$in{category}.html");
print "$ThisHTML";
exit;
}  
}
}

# page is not available in cache, so we need to create it now

# do we have a categories file?
unless (-e "$vars_config{NonCGIPath}/categories.file") {
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&AssembleCats; 
}

@CATEGORIES = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

# exceptions
if ($in{category} ne '') { $vars_display{CategoriesOnly} = 'false'; }

# sort the forums
@sortedforums = &SortForums; 	#returns @sortedforums

# get top of page from public_common.pl
$ThisHTML = $Header;

# show registered members count?
if ($vars_display{DisplayMemberTotal} eq 'true') {
open (MEM, "$vars_config{MembersPath}/membertotal.cgi");
my $TotalMembers = <MEM>;
close (MEM);
$RegisteredMemberLine = qq~$vars_wordlets{reg_members_total} $TotalMembers~;
} 
if ($vars_display{NewestMemberWelcome} eq 'yes') {
my @newbie = &GetNewestMember; 
if ($newbie[0] ne '') {
if ($RegisteredMemberLine ne '') { $RegisteredMemberLine .= '<BR>'; }
$RegisteredMemberLine .= qq!$vars_wordlets{new_member_welcome} <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$newbie[1]">$newbie[0]</A>!;
}
}


# get HTML bits for this page
require "$vars_config{NonCGIPath}/Templates/public_forum_summary.pl";

# which view is it?
if ($vars_display{CategoriesOnly} eq 'true') {
&CatOnlyView(@sortedforums);
}  else {
&NormalView(@sortedforums);
}

# get bottom of page from public_common.pl
$ThisHTML .= $Footer;

if ($in{category} eq '') {
$file_name = 'summary';
}  else {
$file_name = "summary-$in{category}";

unless ($in{category} > 0) {
&StandardHTML("$vars_wordlets_err{invalid_category_number}");
}

}

# print to file
open(FILE, ">$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$file_name.html");
&lock;
print FILE "$ThisHTML";
&unlock;
close(FILE);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$file_name.html");


#display onscreen
print "$ThisHTML"; exit;
}  # end forum_summary


# SUBROUTINES :

sub NormalView {
my @forumlist = @_;

local ($each, @thisforuminfo, $x, $GetHour, $GetMinute, $MilHour, $GetMonth, $GetYear, $GetDate, $LastTime, $LastDate, $AMpm, @lasttime, $LatestTime, $TheDate, $forumcategory, $thisforumcategory, $CategoryName, $ExactPath, @data, $TotalTopics, $TotalPosts, @lasttime, $ForumName, $Moderator, $TheDate, $DateWording, @mods, $Breaker, $ForumDesc, $ForumCoded, $JYear, $NewStuffIcon, $LPTime, $LPMonth, $LastPostJulian, $alt_color, $MilHour, $j, $ColSpan, $private, $last_author, $last_subject, $msg_icon, $last_post_number, $msg_icon2);

$ThisHTML .= &PageTop;  			# some HTML
$ThisHTML .= &Normal_Table_Top;  # more HTML

undef($forumcategory);

# determine colspan
$ColSpan = 3;
if ($vars_display{ShowMods} eq 'yes') { $ColSpan++; }
if ($vars_display{ForumTotalOption} eq 'Both') {
	$ColSpan = $ColSpan + 2;
	} else {
	$ColSpan++;
}

for $each(@forumlist) {
undef($msg_icon2); undef($msg_icon);

@thisforuminfo = split(/\|\^\|/, $each);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

$exact_path = "Forum$x";
if ($thisforuminfo[6] eq 'private') { 	$exact_path .= "/private-$thisforuminfo[7]"; }  

undef($GetHour); undef($GetMinute);
undef($MilHour); undef($TheDate); undef($LatestTime);


if ($vars_display{CategoryView} eq 'yes') {
$thisforumcategory = $thisforuminfo[0];

if ($thisforumcategory ne "$forumcategory") {

$CategoryName = &GetCatName($thisforumcategory);
# print category strip
$ThisHTML .= &CategoryStrip;

}
$forumcategory = "$thisforumcategory";
} # end if categoryview eq yes

#  Get Forum Data from lastnumber.file(s)
if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {
@data = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
$last_topic_number = $data[6]; chomp($last_topic_number);
$TotalTopics = $data[1]; chomp($TotalTopics);
$TotalPosts = $data[2]; chomp($TotalPosts);
$last_subject = $data[3]; chomp($last_subject);

if (length($last_subject) > 35) {
$last_subject = substr($last_subject, 0, 34);
$last_subject .= ' ...';
}

$last_author = $data[4]; chomp($last_author);
$msg_icon = $data[5]; chomp($msg_icon);
$last_post_number = $data[6]; chomp($last_post_number);

if ($msg_icon ne '') {
$msg_icon = qq!<IMG SRC="$vars_config{NonCGIURL}/icons/icon$msg_icon.gif" ALIGN="ABSCENTER" BORDER="0">&nbsp;!;
}  else {
$msg_icon = qq!<IMG SRC="$vars_config{NonCGIURL}/icons/icon1.gif" ALIGN="ABSCENTER" BORDER="0">&nbsp;!;
}

if ($last_author ne '') { $last_author = "($last_author)<BR>"; }

# make sure topic has not been deleted--
unless (-e "$vars_config{NonCGIPath}/$exact_path/$last_topic_number.cgi") {
$last_author = ''; $last_subject = ''; $msg_icon = '';
}

}  else {
$TotalTopics = 0;
$TotalPosts = 0;
$last_author = ''; $last_subject = ''; $msg_icon = ''; $last_post_number = '';
$msg_icon2 = qq!<IMG SRC="$vars_config{NonCGIURL}/icons/icon1.gif" ALIGN="ABSCENTER" BORDER="0">&nbsp;!;
}

# don't show last message for private forums!
if ($thisforuminfo[6] eq 'private') {
$last_author = ''; $last_subject = ''; $msg_icon = '';
$msg_icon2 = qq!<IMG SRC="$vars_config{NonCGIURL}/icons/icon1.gif" ALIGN="ABSCENTER" BORDER="0">&nbsp;!;
}

if ($TotalTopics eq '') { 	$TotalTopics = 0;	}
if ($TotalPosts eq '') { $TotalPosts = 0; 	}

if ($TotalTopics > 0) {

@lasttime = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lasttime.file");

$LastDate = $lasttime[0]; chomp($LastDate);
$LastTime = $lasttime[1]; chomp ($LastTime);
$LatestTime = &TimeFormat($LastTime);

# grab mil hour, minutes for jtime indicators!
($GetHour, $GetMinute) = split(/:/, $LastTime);
($GetMinute, $AMpm) = split(/ /, $GetMinute); chomp($AMpm);
($GetMonth, $GetDate, $GetYear) = split(/-/, $LastDate);
chomp($GetMinute);
$GetYear = &Y2K($GetYear);
$LastDate = ("$GetMonth" . "-" . "$GetDate" . "-" . "$GetYear");
$TheDate = &DateFormat($LastDate);

$MilTime = &ConvertTo24Hour($GetHour, $GetMinute, $AMpm);
($MilHour, $j) = split(":", $MilTime);
	
}  else {
$GetMonth = ''; $GetDate= '';
$GetYear = ''; $LatestTime = '';
$TheDate = ''; $msg_icon2 = '';
}

$ForumName = $thisforuminfo[1];

$Moderator = &GetModLine("$x");

$ForumDesc = $thisforuminfo[2]; $ForumDesc =~ s/&quot\;/"/g;
$ForumName =~ s/\/\\//g;
		
if ($vars_display{ForumDescriptions} eq 'no') { $ForumDesc = ''; }

#default light bulb to off
$NewStuffIcon = qq!<IMG src=\"$vars_config{NonCGIURL}/$vars_style{forum_summ_on}" border="0">!;

if ($GetMonth ne '') {

# Compare Last Login Time to Last Post Time.. 
$LPMonth = $GetMonth;
$JYear = &Y2K($GetYear);
$LastPostJulian = &jday($LPMonth, $GetDate, $JYear);

$LPTime = ("$MilHour" . "$GetMinute");

$LastPostJulian = ($LastPostJulian + ($LPTime * 0.0001));


}  else {

$LastPostJulian = '0';
} # end if/else month ne ''

# what-ifs
if ($LatestTime eq '') { 	$LatestTime = '&nbsp;'; }
if ($Moderator eq '') { 	$Moderator = '&nbsp;'; }


if ($thisforuminfo[6] eq 'none&none') {
$TheDate = "$vars_wordlets{read_only_forum}";
$LatestTime = ''; $last_author = ''; $last_subject = ''; $msg_icon = ''; 
if ($TotalTopics > 0) {
$msg_icon2 = qq!<IMG SRC="$vars_config{NonCGIURL}/icons/icon1.gif" ALIGN="ABSCENTER" BORDER="0">&nbsp;!;
}
}

if ($msg_icon2 eq '') { $msg_icon2 = '&nbsp;'; }

$ThisHTML .= &Normal_Table_Row;  # THE HTML TABLE ROW

}

$ThisHTML .= &PageBottom;


}  #end NormalView

sub SortForums {
#this returns @sortforums, a sorted list based on display requirements

local (%forum_order_list, %forum_name_list, %cat_list, %forum_line_list, @sorted_forums, @sortit, $key, @checkit, @forums, @sortforums, $sort, $cat_type, $j, $k);

my @allforums = &OpenForumsFile;
$sort = '';

# make sure only open forums are listed
foreach $j(@allforums) {
chomp($j); @checkit = split(/\|\^\|/, $j);
if ($checkit[3] eq 'On') {
$forum_order_list{$checkit[8]} = "$checkit[14]";
$forum_name_list{$checkit[8]} = "$checkit[1]";
$forum_line_list{$checkit[8]} = "$j";

# create cat list:
if ($checkit[0] > 0) { $cat_list{$checkit[8]} = "$checkit[0]"; }

} # end if forum is ON
} # end foreach allforums

# sort forum list:
@sorted_forums = sort { $forum_order_list{$a} <=> $forum_order_list{$b} } keys %forum_order_list;

# sort based on requirements -> get @sortforums
if ($in{category} ne '') {

foreach (@sorted_forums) {
if ($in{category} eq "$cat_list{$_}") { push(@sortforums, $forum_line_list{$_}); }
}


}  else {

if ($vars_display{CategoryView} eq 'yes') {

# for categories view--

@sortit = sort(@CATEGORIES);

my ($ThisCatNam, $ThisCatNumb);

foreach $cat_type(@sortit) {
($j, $ThisCatNam, $ThisCatNumb) = split(/\|\^\|/, $cat_type);
chomp($ThisCatNumb);

foreach $key(@sorted_forums) {

if (exists($cat_list{$key})) {
if ($cat_list{$key} eq "$ThisCatNumb") {
push(@sortforums, $forum_line_list{$key});
} # end exists
} # end cat list key match

} # end foreach sorted forum

} # end foreach cat type

}  else {

# for no categories view--

foreach (@sorted_forums) {
push(@sortforums, $forum_line_list{$_});
}

} # end if/else category view

} # end if category-specific

return(@sortforums);
} # end sort forums

sub GetNewestMember {
local($last, @last, @newbie_profile);

if (-e "$vars_config{MembersPath}/last_approved.cgi") {
$last = &OpenFileAsVar("$vars_config{MembersPath}/last_approved.cgi");
} else {
$last = &OpenFileAsVar("$vars_config{MembersPath}/last_number.cgi");
}

chomp($last);
if ($last ne '') { $last = &Do8Digit($last); }
if ((-e "$vars_config{MembersPath}/$last.cgi") && ($last ne ''))  {
@newbie_profile = &OpenProfile($last);
chomp($newbie_profile[15]); chomp($newbie_profile[0]);
if ($newbie_profile[15] eq '') {
$newbie_profile[15] = "$newbie_profile[0]";
}
$last[0] = $newbie_profile[15]; $last[1] = $last;
}
return(@last);
}

sub CatOnlyView {
local(@cats, $cat_color, $cat_line, $cat_name, $cat_number, $cat_order, $forum_count, $k, @this_match);
my @forum_list = @_;

$ThisHTML .= &PageTop;  # some HTML
$ThisHTML .= &Cat_Table_Top;  # more HTML

#sort categories
@cats = sort(@CATEGORIES);

# set row color
$cat_color = "$vars_style{AltColumnColor1}";

foreach $cat_line(@cats) {
($cat_order, $cat_name, $cat_number) = split(/\|\^\|/, $cat_line);
chomp($cat_number);
$forum_count = 0;

#sift forums
foreach $k(@forum_list) {
if ($k =~ /^$cat_number\|/) {
	@this_match = split(/\|\^\|/, $k);
	if ($this_match[3] eq 'On') {
		$forum_count++;
	}
}
}
if ($forum_count > 0) {

$ThisHTML .= &Cat_Row;

}
} #each cat
$ThisHTML .= &Cat_Page_Bottom;
} #end cat only view



# DANGER: Do not remove the next line!
1;