# UBB Get (View) Topic : Perl Code

require "$vars_config{VariablesPath}/vars_mods.cgi";

sub get_topic {
local(@forum_info, @this_forum);
# $_[0] = forum number, $_[1] = topic number

if ($in{p} eq '') {
$in{p} = 1;
} else {
unless ($in{p} > 0) { &StandardHTML("$vars_wordlets_err{invalid_page_number}"); }
}

# is input topic valid
unless ($_[1] =~ /^\d{6}$/) {
&StandardHTML("$vars_wordlets_err{invalid_topic_number}");
}
# is input forum number valid
unless ($_[0] =~ /^\d{1,}$/) {
&StandardHTML("$vars_wordlets_err{invalid_forum_number}");
}

#get forum details
@this_forum = &GetForumRecord($_[0]);

# determine exact path & check permission if necessary
my $permission = $this_forum[6];
$exact_path = "Forum$_[0]";
if ($permission eq 'private') {

$exact_path .= "/private-$this_forum[7]";

# does user have permission to enter?
&check_private_access($_[0], $this_forum[12]);

}  

# does topic exist?
unless (-e "$vars_config{NonCGIPath}/$exact_path/$_[1].cgi") {
&StandardHTML("$vars_wordlets_err{topic_doesnt_exist}");
}

# is the page available?
if (($vars_misc{use_cache} ne 'no') && (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$_[1].cgi") ) {
# multi-pages?
if ($in{p} > 1) { $_[1] = "$_[1]-$in{p}"; }

$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$_[1].cgi");

print "$ThisHTML";
exit;
}  else {

# which forum number is this?
my $this_forum = ("forum_" . "$_[0]");
# get assigned style template!
unless (exists($template_match{$this_forum})) { $template_match{$this_forum} = 1; }
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";

$direct_to = qq!<BASE HREF="$vars_config{NonCGIURL}/">!;

&set_page_elements;

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
&create_topic($_[0], $_[1], 0, 1);
&get_new_topic;
}

} # end get_topic

sub get_new_topic {

if ($in{p} > 1) { $_[1] = "$_[1]-$in{p}"; }
$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$_[1].cgi");
print "$ThisHTML"; exit;

} # end get_new_topic

sub get_ip {
local(@user_profile, @topic_file, @this_row, $this_user, $ip_number, $this_pub_name, $this_message);

# f = forum number
# t = topic number
# reply_num = post number within topic

# make sure we have someone logged in
if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# user must be an admin or mod
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);

# make sure user is an admin or moderator of this forum
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one ne 'true') {
&StandardHTML($vars_wordlets_err{not_admin_or_mod});
}

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";
$direct_to = qq!<BASE HREF="$vars_config{NonCGIURL}/">!;

&set_page_elements;

# retrieve ip and post info

#get topic file
@topic_file = &OpenTopic("$in{t}", "$in{f}");

foreach (@topic_file) {
@this_row = split(/\|\|/, $_);
if ($this_row[1] eq "$in{reply_num}") {
$ip_number = $this_row[7]; 
$this_user = $this_row[2];
$this_pub_name = $this_row[10]; chomp($this_pub_name);
$this_message = $this_row[6];
}
}

if ($this_pub_name eq '') { $this_pub_name = "$this_user"; }
if ($ip_number eq '') {
&StandardHTML("$vars_wordlets_err{cant_find_ip}");
}

do "$vars_config{NonCGIPath}/Templates/public_show_ip.pl";
}  # end get_ip

sub next_topic {
local(@this_forum, %forum_topics, $topic);

#get forum details
@this_forum = &GetForumRecord($in{f});

# determine exact path
$exact_path = "Forum$in{f}";
if ($this_forum[6] eq 'private') {
$exact_path .= "/private-$this_forum[7]";
} 

# check for threads file
unless (-e "$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads") {
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
&create_forum_summary("$in{f}");
}  # end unless .threads summary exists

# grab forum threads file
require "$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads";

# sort the forum_topics hash

my $next_topic = ''; my $next = '';


if ($in{go} eq 'older') {

# get older

NEXTONE: foreach $topic (sort { $forum_topics{$b} <=> $forum_topics{$a} } keys %forum_topics) {

if ($next eq 'true') {
$next_topic = "$topic";
last NEXTONE;
}

if ($topic == $in{t}) { $next = 'true'; }


} # end sort

}  else {

# get newer

NEXTONE: foreach $topic (sort { $forum_topics{$a} <=> $forum_topics{$b} } keys %forum_topics) {

if ($next eq 'true') {
$next_topic = "$topic";
last NEXTONE;
}

if ($topic == $in{t}) { $next = 'true'; }

} # end sort

}


# deliver next topic
if ($next_topic ne '') {
&get_topic($in{f}, $next_topic);
} else {
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}", "$vars_wordlets{no_next_topic}", "Referring topic.");
exit;
}

} # end next_topic

# DANGER: Do not remove the next line!
1;