$version = "6.04a";
$version_number = "6R0R4RA";

if ($vars_display{showcopytype} eq 'image') {

$InfopopCopyright = qq!<img src="$vars_config{NonCGIURL}/powered_by2.gif" width="144" height="16" border="0">!;
}  else {
$InfopopCopyright = qq!Powered by Infopop Corporation!;

}

$InfopopCopyright .= qq%<BR>Ultimate Bulletin Board $version%;

# The board needs to run right if the board admin did **NOT** define a
# character set properly in Display Settings.  We'll use ISO-8859-1.
# If you're trying to find where to define a custom character set, don't
# alter this setting, as it's later overridden in the custom style templates
$masterCharset = $vars_display{masterCharset};
$masterCharset = "ISO-8859-1" unless $masterCharset;


# weights: used for member ratings
%weights = (
0 => "0.15",
1 => "0.05",
2 => "0.08",
3 => "0.12",
4 => "0.25",
5 => "0.35"
);

sub list_check {
# $_[0]: user number of member you are checking

# used to see if particular member
# is on ignore or buddy list
$_[0] = &Do8Digit($_[0]);
local($list_add);

if (-e "$vars_config{MembersPath}/pm_ignore/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_ignore/$user_number.cgi";
}

if (-e "$vars_config{MembersPath}/pm_buddy/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_buddy/$user_number.cgi";
}

unless (exists($pm_ignore{$_[0]})) {
$list_add = qq~<a href="javascript:ignore();">$vars_wordlets{ignore_user}</A>~;

}  else {
$list_add = "$vars_wordlets{user_on_ignore}";
}

unless (exists($pm_buddy{$_[0]})) {
if ($list_add ne '') { $list_add .= ' | '; }
$list_add .= qq~<a href="javascript:buddy();">$vars_wordlets{make_buddy}</A>~;
} else {
if ($list_add ne '') { $list_add .= ' | '; }
$list_add .= "$vars_wordlets{user_on_buddy}";
}

return($list_add);
} # end list check

sub get_public_name {
my @this_user = &OpenProfile($_[0]);
chomp($this_user[15]); chomp($this_user[0]);
my $this_public_name = $this_user[15];
if ($this_public_name eq '') { $this_public_name = $this_user[0]; }
return($this_public_name);
}

sub get_rating {
# %votes, %total, %avg, %weighted_avg should be prevously declared
local($the_rating);
my $this_member = &Do8Digit($_[0]);
undef(%weighted_avg); undef(%votes);
if ((-s "$vars_config{MembersPath}/user_ratings/$this_member.cgi") && ($this_member ne '')) {
do "$vars_config{MembersPath}/user_ratings/$this_member.cgi";
$the_rating = $weighted_avg{total};
$the_rating = &round_up($the_rating);
}  else {
$the_rating = '';
}
return($the_rating, $votes{total});
} # end get_rating

sub round_up {
my ($whole, $dec) = split(/\./, $_[0]);
if ($dec > 49) { $whole++; }
return($whole);
}

sub Do2Decimal {
$_[0] = sprintf("%3.2f", $_[0]); return($_[0]);
}

sub user_access {
local($f, @profile, $this_user_access, $j, $perms, @permitted);
($f, @profile) = @_;

($j, $perms) = split(/&/, $profile[4]); chomp($perms);
@permitted = split(/\,/, $perms);

foreach(@permitted) {
if ($_ eq "$f") {
$this_user_access = 'true';
last;
}  else {
$this_user_access = 'false';
}
}
return($this_user_access);
}  # end user_access

sub is_admin_or_mod {
local($f, @profile, $Moderator, @mods, $mod_name, $mod_num, $mod_match, $is_one, @mod_profile);
($f, @profile) = @_;
chomp($profile[8]); chomp($profile[0]);

if ($profile[8] eq 'Administrator') {
	$is_one = 'true';
}
elsif ($profile[8] eq 'Moderator') {

if ($f ne 'ALL') {

# check to see if user is moderator of particular forum

# check if moderator
require "$vars_config{VariablesPath}/vars_mods.cgi";

$Moderator = ("Forum" . "$f" . "Moderator");
$Moderator = $$Moderator;

#split up Mod var
@mods = split(/\|\|\^\|\|/, $Moderator);

@mod_profile = ();
foreach (@mods) {
	chomp($_);
	if (-s "$vars_config{MembersPath}/$_.cgi") {
		@mod_profile = &OpenProfile($_);
		chomp($mod_profile[0]);
		if ($mod_profile[0] eq $profile[0]) {
			$mod_match = 'true';
		}
	}
}

if ($mod_match ne 'true') {
$is_one = 'false';
}  else {
$is_one = 'true';
}

}  else {

# this is just to see if user is a mod of any forum
$is_one = 'true';

}

} else {

$is_one = 'false';
}

return($is_one);
} # is_admin_or_mod


sub Smilies {
# $_[0] : message to smilie-fy
$_[0] =~ s/\:\)/ <IMG SRC="smile.gif" border="0">/isg;
$_[0] =~ s/\:\(/ <IMG SRC="frown.gif" border="0">/isg;
$_[0] =~ s/lto\:D/mailto\:d/sg;
$_[0] =~ s/lto\:o/mailto\:O/sg;
$_[0] =~ s/lto\:p/mailto\:P/sg;
$_[0] =~ s/\:D/ <IMG SRC="biggrin.gif" border="0">/sg;
$_[0] =~ s/\&lt\;\)/\&lt\; \)/isg;
$_[0] =~ s/\&gt\;\)/\&gt\; \)/isg;
$_[0] =~ s/\;\)/ <IMG SRC="wink.gif" border="0">/isg;
$_[0] =~ s/\:o/ <IMG SRC="redface.gif" border="0">/sg;
$_[0] =~ s/\:p/ <IMG SRC="tongue.gif" border="0">/sg;
$_[0] =~ s/\:cool:/ <IMG SRC="cool.gif" border="0">/isg;
$_[0] =~ s/\:rolleyes:/ <IMG SRC="rolleyes.gif" border="0">/sg;
$_[0] =~ s/\:mad:/ <IMG SRC="mad.gif" border="0">/sg;
$_[0] =~ s/\:eek:/ <IMG SRC="eek.gif" border="0">/sg;
$_[0] =~ s/\:confused:/ <IMG SRC="confused.gif" border="0">/sg;
return ($_[0]);
}

sub Template {
local(*FILE);
local($HTML);
local ($ThisFile) = shift;

if ($in{ubb} eq 'set_initial') { $vars_config{NonCGIPath} = $in{NonCGIPath}; }
my $ThisPath = "$vars_config{NonCGIPath}/Templates/";
$HTML = &OpenFileAsVar("$ThisPath$ThisFile");
$HTML =~ s/\%\%(.*?)\%\%/$template->{$1}/xeg;
return($HTML);
exit;
}

sub check_html {
if ($_[0] =~ /\/\s*SCRIPT\s*>/i)  { &StandardHTML("$vars_wordlets_err{illegal_html_tag}: SCRIPT"); exit;
}
if  ($_[0] =~ /<\s*EMBED\s*?>/i) {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} EMBED"); exit;
}
if ($_[0] =~ /<\s*OBJECT\s*?>/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} OBJECT"); exit;
}
if ($_[0] =~ /<\s*IFRAME\s*?>/i) {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} IFRAME"); exit;
}
if  ($_[0] =~ /<\s*XMP\s*?>/i) {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} XMP"); exit;
}
if ($_[0] =~ /<\s*APPLET\s*?>/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} APPLET"); exit;
}
if ($_[0] =~ /<\s*BODY\s*?>/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} BODY"); exit;
}
if ($_[0] =~ /<\s*HEAD\s*?>/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} HEAD"); exit;
}
if ($_[0] =~ /<\s*HTML\s*?>/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} HTML"); exit;
}
if ($_[0] =~ /ONLOAD\s*=/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} ONLOAD"); exit;
}
if ($_[0] =~ /MOUSEOVER\s*=/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} MOUSEOVER"); exit;
}
if ($_[0] =~ /ONERROR\s*=/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} ONERROR"); exit;
}
if ($_[0] =~ /\.cookie/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} COOKIE"); exit;
}
if ($_[0] =~ /getcookie/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} GETCOOKIE"); exit;
}
if ($_[0] =~ /(<)([^>]*?)(\()/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} Parenthesis in HTML tag"); exit;
}
if ($_[0] =~ /eval\s*\(/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} EVAL"); exit;
}

} # end check for script

sub Truncate {
$_[0] =~ s/(\S{180})/$1 /isg; return ($_[0]);
}

sub PipeCleaner {
$_[0] =~ s/\|\|/&#0124;&#0124;/sg; return($_[0]);
}

sub sh_lock {
flock(FILE,LOCK_SH);
} #end shared lock sr

sub lock {
flock(FILE,LOCK_EX);
} #end lock sr

sub unlock {
flock(FILE,LOCK_UN);
} # end unlock sr

sub OpenFileAsVar {
local(*FILE); local($str);
if (-e "$_[0]") {
open(FILE, "$_[0]") || die &StandardHTML("Error: couldn't open $_[0] : $!");
&sh_lock;
while (<FILE>) { $str .= $_; }
&unlock;
close(FILE);
}
chomp($str);
return($str);
}

sub OpenFileAsArray {
local(*FILE); local(@thisarray);
if (-e "$_[0]") {
open(FILE, "$_[0]") || &StandardHTML("Error: couldn't open $_[0] : $!");
&sh_lock;
@thisarray = <FILE>;
&unlock;
close(FILE);
}
return(@thisarray);
}

sub GetPubName {
local(@user_p);
@user_p = &OpenProfile($_[0]);
chomp($user_p[15]); chomp($user_p[0]);
if ($user_p[15] eq'') { $user_p[15] = $user_p[0]; }
return($user_p[15]);
} # get pub name

sub GetUserNumber {
local ($MatchName, $ProfileNumber);
# $_[0] : Member Login Name

my $GetNameClean = quotemeta($_[0]);

# Note: %ProfileNumber hash declared in use vars (ultimatebb.cgi)
# memberlist_array declaed in use vars too
# memlistopen also use vars

if ($ProfileNumber{$GetNameClean}) { # check if it's already found
	return $ProfileNumber{$GetNameClean};
}  else {
	unless($memlistopen){ # only open once

	@memberslist_array = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");
		@memberslist_array = reverse(@memberslist_array);
		$memlistopen++;
	}
	undef($ProfileNumber);
	FINDNUMBER: foreach (@memberslist_array) {
		if (/^$GetNameClean\|\!\!\|/i) {
			chomp;
			($MatchName, $ProfileNumber) = split /\|\!\!\|/;
			last FINDNUMBER;
		}
	}
	$ProfileNumber{$GetNameClean} = $ProfileNumber;
	return($ProfileNumber);
}# end else

}  #end GetUserNumber

sub OpenProfile {
local(@got_profile);
# $_[0] : member profile number
chomp($_[0]); # just in case :)

# thanks to Leshrac for the %member_profile hash idea!
if ($member_profile{"$_[0]"}) {
return @{ $member_profile{"$_[0]"} };
 }   else {

# make sure no lf bumping is going on
my $maxmemfields = 29; #total fields permitted in member file

# make sure input is a number
if ($_[0] > 0) { @got_profile = &OpenFileAsArray("$vars_config{MembersPath}/$_[0].cgi"); }

if ($got_profile[0] eq '') { &StandardHTML("$vars_wordlets_err{no_member_number} $_[0]"); }

if ($#got_profile > $maxmemfields) {  &PostHackDetails("$vars_wordlets_err{hack_attempt_member_file}");
}

$member_profile{"$_[0]"} = [ @got_profile ];
return(@got_profile);
}

} # end Open Profile


sub PostHackDetails {
local(*FILE);
open(FILE, ">>$vars_config{NonCGIPath}/hacklog.cgi");
&lock;
print FILE "HACK ATTEMPT DATE: $GotTime{LastLoginDT}\nHackDetails\n\n:";
foreach (sort keys %ENV) {
	print FILE "$ENV{$_}\n"
}
&unlock;
close(FILE);
&StandardHTML("$_[0]");
}

sub CheckBadChars { # check for | , ;, .. or >< character hack attempts
my $checkthis = shift;
	if($checkthis =~ /\||\;|<|>|\.\.|\*/){ #
		&PostHackDetails("$vars_wordlets_err{hack_attempt_bad_char}");
	}
return 1;
} # end SR

sub name_clean {
$_[0] = &strip_lead_trail_space($_[0]);
$_[0] =~ s/\s{2,}/ /g;
$_[0] =~ s/</&lt;/g; $_[0] =~ s/>/&gt;/g;
return($_[0]);
}

sub CleanVar2 {
$_[0] =~ s/!/\\!/g; return($_[0]);
}

sub SmallClean {
$_[0] =~ s/~/\\~/g; return($_[0]);
}
sub ConvertReturns {
$_[0] = &strip_lead_trail_space($_[0]);
$_[0] =~ s/\n\r\n/<P>/ig;
$_[0] =~ s/\n/<BR>/ig;
$_[0] =~ s/\r//g;
$_[0] =~ s/(<P>){2,}/<P>/ig;
$_[0] =~ s/(<BR><BR>){2,}/<BR>/ig;
$_[0] =~ s/<!/< !/ig;
$_[0] =~ s/(<UL.*?>)(<BR>)/$1/ig;
return ($_[0]);
}
sub LimitReturns {
$_[0] =~ s/\s+$//;
$_[0] =~ s/\n{2,}/\n/ig;
$_[0] =~ s/(\n\r\n){2,}/\n\r\n/ig;
$_[0] =~ s/\r{2,}/\r/g;
return ($_[0]);
}

sub EliminateReturns {
$_[0] =~ s/\s{2,}/ /g; $_[0] =~ s/\n\r\n//g;
$_[0] =~ s/\n//g; $_[0] =~ s/\r//g;
return ($_[0]);
}

sub OpenForumsFile {
my @theforums = &OpenFileAsArray("$vars_config{VariablesPath}/vars_forums.cgi");
my @forumsfile = grep(/\|\^\|/, @theforums);
return(@forumsfile);
}

sub Do2Digit {
my $ExpandIt = sprintf ("%2d", $_[0]);
$ExpandIt =~tr/ /0/; return($ExpandIt);
}
sub Do6Digit {
my $ExpandIt = sprintf ("%6d", $_[0]);
$ExpandIt =~tr/ /0/; return($ExpandIt);
}
sub Do8Digit {
my $ExpandIt = sprintf ("%8d", $_[0]);
$ExpandIt =~tr/ /0/; return($ExpandIt);
}

sub MainButtonOptions {
local ($RegisterLink, $SearchLink, $MainButtons, $this_forum);
if ($in{f} ne '') { $this_forum = "&search_forum=$in{f}"; }

if ($vars_registration{DisplayRegistration} ne 'NO') {
$RegisterLink = qq(| <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree"><ACRONYM TITLE="$vars_wordlets{register_acronym}">$vars_wordlets{register_link}</ACRONYM></A>);
}

if ($vars_search{AllowSearch} ne 'FALSE') {
$SearchLink = qq(| <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=search$this_forum"><ACRONYM TITLE="$vars_wordlets{search}">$vars_wordlets{search_link}</ACRONYM></A>);
}

$MainButtons = qq!
<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile"><ACRONYM TITLE="$vars_wordlets{profile_acronym}">$vars_wordlets{profile_link}</ACRONYM></A> $RegisterLink $SearchLink | <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=faq"><ACRONYM TITLE="$vars_wordlets{faq_acronym}">$vars_wordlets{faq_link}</ACRONYM></A> | <A HREF="$vars_config{CGIURL}/ultimatebb.cgi"><ACRONYM TITLE="$vars_wordlets{forum_acronym}">$vars_wordlets{forum_home_link}</ACRONYM></A>
!;
return($MainButtons);
}  # end mainbuttonoptions

sub GetCatName {
# $_[0] : category number
local($j, $CName, $CNum, $one, $ThisCatName);
my @catlist = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

FINDIT: foreach $one(@catlist) {
($j, $CName, $CNum) = split(/\|\^\|/, $one);
chomp($CNum);
if ($CNum == $_[0]) { $ThisCatName = "$CName"; last FINDIT; }
}
return($ThisCatName);
}

sub Validate {
local($each); local(@splitter); local ($Redo); local($BadLine);
my $Redo = '';

foreach $each(@_) {
chomp($each);

if ($each !~ /\|/) {
if ($in{$each} eq '') {
$Redo = 'true';
if ($each =~ /custom/) {
 if ($each eq 'customfield1') { $each = $vars_registration{customfield1}; }
 if ($each eq 'customfield2') { $each = $vars_registration{customfield2}; }
 if ($each eq 'customfield3') { $each = $vars_registration{customfield3}; }
 if ($each eq 'customfield4') { $each = $vars_registration{customfield4}; }
}
$BadLine .= "You did not complete: $each<BR>";
}

}  else {
# this is an AND list
@splitter = split(/\|/, $each);
$ok = 'false';
foreach $one(@splitter) {
chomp($one);
if ($in{$one}) { $ok = 'true'; }
}

if ($ok eq 'false') {
$Redo = 'true';
$BadLine .= "$vars_wordlets{missing_input_line} $each<BR>";
}

} #end single/OR
}
if ($Redo eq 'true') {
if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile')) {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

}
&StandardHTML("$vars_wordlets_err{missing_fields_intro}<P>$BadLine");
}
}  #end validate sr

sub GetForumRecord {
# $_[0] : forum number
local($one, @for, @check, $goodline, @got_it);
my @for = &OpenForumsFile;
CHECK: foreach $one(@for) {
@check = split(/\|\^\|/, $one);
if ($check[8] eq "$_[0]") {
$goodline = $one; last CHECK;
}
}
chomp($goodline);
@got_it = split(/\|\^\|/, $goodline);
return (@got_it);
}

sub GetMemberListArray {
local ($thisline, @profiles, @members);
my @themembers = &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");

foreach $thisline(@themembers) {
	@profiles = split(/\|\!\!\|/, $thisline); chomp($profiles[1]);
	push (@members, $profiles[0]);
}

return(@members);
}  # end Get Member List Array sr

sub GetEmails {
local ($dos, $EmailHere, $MemNum, $EmailLine, @EmailList);
my @theemails = &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");

foreach $dos(@theemails) {
	($EmailHere, $MemNum) = split(/\|\|/, $dos); chomp($MemNum);
	$EmailLine = "$EmailHere??$MemNum";
	push (@EmailList, $EmailLine);
}
return (@EmailList);
}

sub GeneratePassword {
my @digit = ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9');
srand(time);
my $num1 = rand(@digit);  my $num2 = rand(@digit);
my $num3 = rand(@digit);  my $num4 = rand(@digit);
my $num5 = rand(@digit);  my $num6 = rand(@digit);
my $RandomPassword = ("$digit[$num1]" . "$digit[$num2]" . "$digit[$num3]" . "$digit[$num4]" . "$digit[$num5]" . "$digit[$num6]");
return($RandomPassword);
}

sub GeneratePassword2 {
my @digit = ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9');
srand(time);
my $num1 = rand(@digit); my $num2 = rand(@digit);
my $num3 = rand(@digit); my $num4 = rand(@digit);
my $num5 = rand(@digit);  my $num6 = rand(@digit);
my $num7 = rand(@digit);  my $num8 = rand(@digit);
my $RandomPassword = ("$digit[$num1]" . "$digit[$num2]" . "$digit[$num3]" . "$digit[$num4]" . "$digit[$num5]" . "$digit[$num6]" . "$digit[$num7]" . "$digit[$num8]");
return($RandomPassword);
}

sub hit_me {
local(*FILE);

unless (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter");
}

unless (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi") {
open (FILE, ">$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");
&lock;
print FILE "0";
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");
}

open (FILE, "+< $vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");
&lock;
my $hits = <FILE>;
chomp($hits); $hits++;
seek (FILE, 0,0);
print FILE $hits;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");

} # end hit_me

sub auto_url {
local($check); $check = shift;
$check =~ s/(^|\s)(http:\/\/\S+)/ <A HREF="$2" TARGET=_blank>$2<\/A> /isg;
$check =~ s/(^|\s)(www\.\S+)/ <A HREF="http:\/\/$2" TARGET=_blank>$2<\/A> /isg;
return($check);
} # end auto_url

sub UBBCode {
$_[0] =~ s/(\[URL|(^|\s)http:\/\/|(^|\s)www\.)(\S*?)([".]+?)(\]|\[\/URL\]|\s|$)/$1$4$5$6/isg;
$_[0] =~ s/(\[URL|(^|\s)https:\/\/|(^|\s)www\.)(\S*?)([".]+?)(\]|\[\/URL\]|\s|$)/$1$4$5$6/isg;


$_[0] = &auto_url($_[0]);

unless ($_[0] =~ /\[\/.+]/) {
return ($_[0]);
} # only process if there are ubbcode tags

if ($_[0] =~ /\.cookie/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} COOKIE"); exit;
}
if ($_[0] =~ /\ONERROR\s*=/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} ONERROR"); exit;
}
if ($_[0] =~ /\getcookie/i)  {
&StandardHTML("$vars_wordlets_err{illegal_html_tag} GETCOOKIE"); exit;
}

$_[0] =~ s/(\[URL\])(http|https|ftp)(:\/\/\S+?)(\[\/URL\])/ <A HREF="$2$3" TARGET=_blank>$2$3<\/A> /isg;
$_[0] =~ s/(\[URL\])(\S+?)(\[\/URL\])/ <A HREF="http:\/\/$2" TARGET=_blank>$2<\/A> /isg;
$_[0] =~ s/(\[URL=)(http|https|ftp)(:\/\/\S+?)(\])(.+?)(\[\/URL\])/<A HREF="$2$3" TARGET=_blank>$5<\/A>/isg;
$_[0] =~ s/(\[URL=)(\S+?)(\])(.+?)(\[\/URL\])/<A HREF="http:\/\/$2" TARGET=_blank>$4<\/A>/isg;
$_[0] =~ s/(\[EMAIL\])(\S+\@\S+?)(\[\/EMAIL\])/ <A HREF="mailto:$2">$2<\/A> /isg;
$_[0] =~ s,(\[code\])(.+?)(\[/code\]),<BLOCKQUOTE><font size="1" face="$vars_style{FontFace}">code:<\/font><HR><pre>$2</pre><HR><\/BLOCKQUOTE>,isg;

if ($_[1] eq 'ON') {
$_[0] =~ s/(\[IMG\])(\S+?)(\[\/IMG\])/ <IMG SRC="$2"> /isg;
}

$_[0] =~ s/(\[QUOTE\])(.+?)(\[\/QUOTE\])/ <BLOCKQUOTE><font size="1" face="$vars_style{FontFace}">quote:<\/font><HR>$2<HR><\/BLOCKQUOTE>/isg;
$_[0] =~ s/(\[i\])(.+?)(\[\/i\])/<I>$2<\/I>/isg;
$_[0] =~ s/(\[b\])(.+?)(\[\/b\])/<B>$2<\/B>/isg;
$_[0] =~ s/(\[qb\])(.+?)(\[\/qb\])/<STRONG>$2<\/STRONG>/isg;
$_[0] =~ s/(\[list\])(.+?)(\[\/list\])/<UL TYPE=SQUARE>$2<\/UL>/isg;
$_[0] =~ s/(\[list=)(A|1)(\])(.+?)(\[\/list\])/<OL TYPE=$2>$4<\/OL>/isg;
$_[0] =~ s/(\[\*\])/<LI>/isg;
return ($_[0]);
}

sub CensorCheck {
local ($ThisWord, $wordlength, $replaceword, $WordCheck);
my $WordCheck = shift;
my @censored = split(/ /, $vars_misc{censorwords});
if ($vars_misc{Censor} eq 'ON') {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$ThisWord = ("$2");
			$wordlength = length($ThisWord);
			$wordlength = $wordlength;
			$replaceword = '*' x $wordlength;
			$replaceword = "$replaceword ";
			$WordCheck =~ s/\b$ThisWord\b/$replaceword/isg;
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		$WordCheck =~ s/$_/$replaceword/isg;
		}
	}
}
return($WordCheck);
}  # end CensorCheck


sub ClearUserPostHistories {
use File::Path;
rmtree("$vars_config{MembersPath}/user_posts");
mkdir ("$vars_config{MembersPath}/user_posts", 0777);
chmod(0777, "$vars_config{MembersPath}/user_posts");
}

sub ClearSummaryCache {
opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
my @summs = readdir(FILE);
closedir(FILE);

foreach(@summs) {
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$_");
}

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}
unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
}
}

sub ClearMiscCache {
opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
my @summs = readdir(FILE);
closedir(FILE);

foreach(@summs) {
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/$_");
}

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}
unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
}
}

sub ClearForumPageCache {
use File::Path;
rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page");

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page");
}

sub ClearSingleForumPageCache {
# $_[0] : $the path for the forum page to be removed from cache
# $_[1] : forum number

unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-1.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-2.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-5.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-10.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-20.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-30.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-45.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-60.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-75.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-100.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-365.cgi");
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]/forum$_[1]-1000.cgi");

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]");
}
}

sub ClearForumTopicsCache {
use File::Path;
rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums");

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}

mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums");
}

sub ClearSingleForumTopicsCache {
use File::Path;
# $_[0] : $the path for the forum for which topics are to be removed from cache
rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]");

unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
}
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]");
}

sub GetModLine {
local(@mod_profile);

require "$vars_config{VariablesPath}/vars_mods.cgi";

local ($Moderator, @mods, @mod_links, $mod_name, $mod_num, $mod_line);

$Moderator = ("Forum" . "$_[0]" . "Moderator");
$Moderator = $$Moderator;

#split up Mod var
@mods = split(/\|\|\^\|\|/, $Moderator);

@mod_links = ();
foreach (@mods) {
chomp($_);

if ((-e "$vars_config{MembersPath}/$_.cgi") && ($_ ne '')) {
@mod_profile = &OpenProfile($_);
chomp($mod_profile[15]); chomp($mod_profile[0]);
if ($mod_profile[15] eq '') {
$mod_profile[15] = "$mod_profile[0]";
}
$mod_line = qq!<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$_">$mod_profile[15]</A>!;
push (@mod_links, $mod_line);
}
} # if member exists!

$Moderator = join(", ", @mod_links);
if ($Moderator eq '') { $Moderator = "$vars_wordlets{no_mods}"; }
return($Moderator);
}  # end get mod line

sub OpenTopic {
# $_[0] : topic number
# $_[1] : forum number
local(*FILE);

if ($exact_path eq '') {
my @forumfacts = &GetForumRecord($_[1]);

$exact_path = "Forum$_[1]";
if ($forumfacts[6] eq 'private') {
	$exact_path .= "/private-$forumfacts[7]";
}

} # if we need to get exact_path

unless  ($_[0] =~ /^\d{6}$/)  {

&PostHackDetails("$vars_wordlets_err{hack_attempt_open_topic}");
}

my @mess = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/$_[0].cgi");
my @topic_guts = sort(@mess);

#CC Cleanup Code 01 03 22
#Some users managed to have living pre-Y2K UBBs with new threads, resulting
#in malformated date strings.  This routine attempts to fix the string.
#It's a class A kuldge, but it does the job for the time being.

my @clean_topic_guts = ();

foreach (@topic_guts) {
	#Z||000000||User||03-26-99||02:01 PM||
	my @cleanup = split(/\|\|/) if m/^Z/;	#only Z lines have dates
	unless(@cleanup) { push(@clean_topic_guts, $_); next; }	#so skip non-Z lines
	$cleanup[3] =~ m/^(\d\d)\-(\d\d)\-(\d\d)$/;	#only catch two digit years
	if($1 && ($3 > 90)) { my $three = $3; $three += 1900; $cleanup[3] = "$1-$2-$3"; }
	if($1 && ($3 < 90)) { my $three = $3; $three += 2000; $cleanup[3] = "$1-$2-$3"; }
	my $line = join("||", @cleanup);
	push(@clean_topic_guts, $line);
} # end foreach

@topic_guts = @clean_topic_guts;
@clean_topic_guts = undef;
#CC Cleanup Code END

return(@topic_guts);
} # end OpenTopic


sub illegal_name_check {
#if (($_[0] =~ m/^(\s|\#\!|\|)/) ||
#($_[0] =~ m/(\&nbsp|\|\!|\|\||\"|;|memberslist|emailfile)/) ||
#($_[0] =~ m/(\s|\|)$/) ||
#($_[0] =~ m/\s{2,}/) ||
#($_[0] =~ m/>|</) ||
#($_[0] !~ /^[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\~\:\]\[\']/) ||
#($_[0] !~ /[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\~\:\]\[\']$/) ||
#($_[0] =~  m/__\w+__/) ) {

# thanks to ajmanlover for inspiring the high bit character regexes
if (($_[0] =~ m/^[\s\#\!\|]/) ||
($_[0] =~ m/[!"`\;~><]/) ||
($_[0] =~ m/\|+/) ||
($_[0] =~ m/\&(nbsp|amp|gt|lt|\#\d+)/) ||
($_[0] =~ m/[\s\|]$/) ||
($_[0] =~ m/\s{2,}/) ||
(($_[0] !~ m/^[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\'\x80-\xFF]/) && ($vars_registration{allowHighBit} eq "YES")) ||
(($_[0] !~ m/[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\'\.\x80-\xFF]$/) && ($vars_registration{allowHighBit} eq "YES")) ||
(($_[0] !~ m/^[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\']/) && ($vars_registration{allowHighBit} ne "YES")) ||
(($_[0] !~ m/[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\'\.]$/) && ($vars_registration{allowHighBit} ne "YES")) ||
($_[0] =~ m/[\x00-\x1f]/) ||
($_[0] =~ m/__\w+__/) ) {

# Sorry, your name is illegal for one of the following reasons:
#  - Start your name with a space, a #, or a !
#  - Use the following characters: ! " ` ; ~ | < >
#  - End your name with a space or a |
#  - Use HTML characters in your name, such as &amp;nbsp;
#  - Have more than one consecutive underscore
#  - Have more than one consecutive space

if ( ($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile') ) {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

}
&StandardHTML("$vars_wordlets_err{bad_reg_chars}");
}  # end name tripwire
}

sub verify_id_num {

# used for verifying all cookie user info
my $un = shift; my $pw = shift; my $user_num = shift;
chomp($user_num);
local ($lcpw, $lc_un, $lc_pw_in, $lc_un_in);

#do we have a user number?
if (($user_num eq '') || ($user_num !~ /^\d{8}$/)) {
&StandardHTML("$vars_wordlets_err{invalid_username}");
}

my @profile = &OpenProfile("$user_num");
chomp($profile[0]);  chomp($profile[1]);

#lowercase everything
$lcpw = lc($profile[1]); $lc_un = lc($profile[0]);
$lc_pw_in = lc($pw); $lc_un_in = lc($un);

# check password
if ($lcpw ne "$lc_pw_in") {
&StandardHTML("$vars_wordlets_err{invalid_password}");
}
# check username
if ($lc_un ne "$lc_un_in") {
&StandardHTML("$vars_wordlets_err{invalid_username}");
}
return(@profile);
} #end verify_id_num


sub verify_id_num_2 {

# verify_id_num_2 is the same as verify_id_num,
# except that we need to print the header here if there
# is a problem!

# used for verifying all cookie user info
my $un = shift; my $pw = shift; my $user_num = shift;
chomp($user_num);
local ($lcpw, $lc_un, $lc_pw_in, $lc_un_in);

#do we have a user number?
if (($user_num eq '') || ($user_num !~ /^\d{8}$/)) {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{invalid_username}");
}

my @profile = &OpenProfile("$user_num");
chomp($profile[0]);  chomp($profile[1]);

#lowercase everything
$lcpw = lc($profile[1]); $lc_un = lc($profile[0]);
$lc_pw_in = lc($pw); $lc_un_in = lc($un);

# check password
if ($lcpw ne "$lc_pw_in") {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{invalid_password}");
}
# check username
if ($lc_un ne "$lc_un_in") {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{invalid_username}");
}
return(@profile);
} #end verify_id_num_2


sub hop_to_list {
local(%forum_order_list, %forum_name_list, %cat_list, @all_forums, @sorted_forums, @sortrow, $j, @checkit, $ok, $uno, $key, $cat_type, $ThisCatNam, $ThisCatNumb, @catgroup, $cat_name, $select_list);

@all_forums = &OpenForumsFile;

undef(%forum_order_list); undef(%forum_name_list);
undef(%cat_list); undef(@sortcat); undef(@cats);

# make sure only open forums are listed
foreach $j(@all_forums) {
chomp($j); @checkit = split(/\|\^\|/, $j);
if ($checkit[3] eq 'On') {
$forum_order_list{$checkit[8]} = "$checkit[14]";
$forum_name_list{$checkit[8]} = "$checkit[1]";

# create cat list:
if ($checkit[0] > 0) { $cat_list{$checkit[8]} = "$checkit[0]"; }
}
}

# sort forum list:
@sorted_forums = sort { $forum_order_list{$a} <=> $forum_order_list{$b} } keys %forum_order_list;

$select_list = qq~
<OPTION value=''>$vars_wordlets{select_a_forum}
<OPTION value=''>
~;

if ($vars_display{CategoryView} ne 'yes') {

foreach (@sorted_forums) {
if ($in{f} eq "$_") {

$select_list .= qq~<OPTION value="$_" SELECTED>$forum_name_list{$_}
~;

}  else {

$select_list .= qq~<OPTION value="$_">$forum_name_list{$_}
~;

}
}

}  else {

my @cats = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");
my @sortcat = sort(@cats);

CATLOOP: foreach $cat_type(@sortcat) {

$ok = '';
($j, $ThisCatNam, $ThisCatNumb) = split(/\|\^\|/, $cat_type);
chomp($ThisCatNumb);

# grab cat name:
$cat_name = &GetCatName($ThisCatNumb);

# make sure there are forums in this category:
foreach $key(keys %cat_list) {
if ($cat_list{$key} eq "$ThisCatNumb") { $ok = 'y'; }
}
unless ($ok eq 'y') { next CATLOOP; }

# print cat name in select list:
$select_list .= qq~
<OPTION value="">
<OPTION value="CAT:$ThisCatNumb">$vars_wordlets{category_header_hopto} $cat_name
<OPTION VALUE="">--------------------
~;

# get all forums in category, sorted:
foreach $key(@sorted_forums) {

if (exists($cat_list{$key})) {
if ($cat_list{$key} eq "$ThisCatNumb") {

if ($in{f} eq "$key") {
$select_list .= qq~<OPTION value="$key" SELECTED>$forum_name_list{$key}
~;

}  else {
$select_list .= qq~<OPTION value="$key">$forum_name_list{$key}
~;
} # end if/else f = key

} # if cat list key exists
} # end if cat list check

} # end foreach forum order list
} # end foreach sortcat

} # end if/else cat view

return($select_list);
}  ## end hop_to_list


sub check_email_bans {
# parameter:
# $_[0] : email

local(@banlist, $banword, $banword2);

if (-e "$vars_config{NonCGIPath}/BanLists/EmailBan.cgi") {
@banlist = &OpenFileAsArray("$vars_config{NonCGIPath}/BanLists/EmailBan.cgi");
}

if ($banlist[0] ne '') {
CheckBanList: for $banword(@banlist) {
	chomp($banword);
	$banword2 = quotemeta($banword);
		if ($_[0] =~ m/$banword2/i) {
			if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile')) {
				#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

			}
			&StandardHTML("$vars_wordlets_err{banned_email}");
			last CheckBanList;
		}
	}
} #if EmailBan list is not empty
}  # end check_email_bans


sub check_ip_bans {

local(@ip_ban_list, $ip_number, $bannum, $bannum2);
$ip_number = $ENV{'REMOTE_ADDR'};

# Check IP Ban List--
if (-e "$vars_config{NonCGIPath}/BanLists/IPBan.cgi") {
@ip_ban_list = &OpenFileAsArray("$vars_config{NonCGIPath}/BanLists/IPBan.cgi");
}

if ($ip_ban_list[0] ne '') {
CheckIPBanList: for $bannum(@ip_ban_list) {
	chomp($bannum);
	$bannum2 = quotemeta($bannum);
		if ($ip_number =~ m/^$bannum2/i) {
			if ($in{ubb} eq 'submit_registration') {
				#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

			}
			&StandardHTML("$vars_wordlets_err{ip_banned}");
	last CheckIPBanList;
		}
	}
} #if ip_ban_list is not empty
} # end ip ban check


sub make_random_number {
local(@digit, $rn, @nums); @digit = (1..9); srand(time);
$nums[0] = rand(@digit); $nums[1] = rand(@digit);
$nums[2] = rand(@digit); $nums[3] = rand(@digit);
$nums[4] = rand(@digit); $nums[5] = rand(@digit);
$rn = ("$digit[$nums[0]]" . "$digit[$nums[1]]" . "$digit[$nums[2]]" . "$digit[$nums[3]]" . "$digit[$nums[4]]" . "$digit[$nums[5]]");
return($rn);
} # end make_random_number


sub check_private_access {
local(@profile, $Moderator);
# since forum is private, user must be logged in

# $_[0]: forum number
# $_[1]: forum password (blank, if none)

if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# user is logged in, so get profile
@profile = &verify_id_num($username, $password, $user_number);
chomp($user_number); chomp($profile[8]); chomp($profile[4]);

unless ($profile[8] eq 'Administrator') {

	if ($profile[8] eq 'Moderator') {
		require "$vars_config{VariablesPath}/vars_mods.cgi";

		$Moderator = ("Forum" . "$_[0]" . "Moderator");
		$Moderator = $$Moderator;

		$user_number = &Do8Digit($user_number);

		my($forumnum, $forumpass) = @_;

		foreach my $moddy (split(/\|\|\^\|\|/, $Moderator)) {
			if(($moddy eq $user_number) && (&is_admin_or_mod($in{f}, $moddy) ne "false")) {
				return;
			}
		}

	}  else {
		&check_explicit($profile[4], $_[0], $_[1]);
	} #endif

} # if not an admin

} # end check private access

sub check_explicit {
local($j, $perms, @explicit, $access_rights, $forum_name, %pwhash, $forumpw);
# one argument:
# $_[0] : user permissions (from profile[4])
# $_[1] : forum number
# $_[2] : forum password (blank, if none)

($j, $perms) = split(/&/, $_[0]);
@explicit = split(/,/, $perms);

foreach (@explicit) {
chomp($_);
if ($_[1] == $_) { $access_rights = 'true'; }
}

unless ($access_rights eq 'true') {

if ($_[2] ne '') {

# check to see if forumpw cookie set:
$forumpw = cookie("forumpw$vars_config{Cookie_Number}");
%pwhash = split(/\|\^\|/, $forumpw);

# pw hash check
unless ((exists($pwhash{$_[1]})) && ($pwhash{$_[1]} eq "$_[2]")) {

my @forum_line = &GetForumRecord($_[1]);
$forum_name = $forum_line[1];
&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_query_forum_pw.pl";
exit;


}

}  else {
&StandardHTML("$vars_wordlets_err{no_access}");
} # end if forum pw exists

} # end access right ne true



} # end check_explicit sr


sub Y2K {
local($check_length, $year);
$check_length = length($_[0]);
if ($check_length < 4)  {
	if ($check_length  == 2) {
		$year = ("19" . "$_[0]");
	}  else {
		$year = $_[0] - 100; $year = sprintf("%2d", $year);
		$year =~tr/ /0/; $year = ("20" . "$year");
	}
} else  {
	$year = $_[0];
}
return($year);
} # end Y2K sr


sub TimeFormat {
local($time_formatted, @timearray, $get_hour, $get_minute);

if ($vars_time{TimeFormat} eq '24HR')  {
@timearray = split(/ /, $_[0]); chomp($timearray[1]);
($get_hour, $get_minute) = split(/:/, $timearray[0]);
chomp($get_minute);
if ($timearray[1] eq 'PM') {
		if ($get_hour < 12) { $get_hour = ($get_hour  + 12); }
} else {
		if ($get_hour == 12) { 	$get_hour = '0'; }
}
$get_hour = &Do2Digit($get_hour);
$get_minute = &Do2Digit($get_minute);
$time_formatted = "$get_hour:$get_minute";
} else {
	$time_formatted = "$_[0]";
}
return($time_formatted);
}  # end TimeFormat

sub strip_lead_trail_space {
$_[0] =~ s/^\s+//; $_[0] =~ s/\s+$//; return($_[0]);
}

sub CustomTitle {
local($custom_title);

if ($_[0] eq 'Administrator') {
	$custom_title = "$vars_misc{AdminTitle}";
}
elsif ($_[0] eq 'Moderator') {
	$custom_title = "$vars_misc{ModeratorTitle}";
}
elsif ($_[0] eq 'Member') {
	$custom_title = "$vars_misc{MemberTitle}";
}  elsif ($_[0] eq 'Junior Member') {
	$custom_title = "$vars_misc{JrMemberTitle}";
}

return($custom_title);
} # end customer title sr

sub email_test {
local($t);
if (($_[0] =~ m/\s/) ||
($_[0] !~ /\S+\@\S+\.\S+/)  ||
($_[0] =~ /^\./)   ||
($_[0] =~ /\.{2,}/)   ||
($_[0] =~ /\.$/)  ||
($_[0] =~ /\.\@/) ||
($_[0] =~ /\@\./) ||
($_[0] =~ /;/) ) {
$t = 'n';
} else {
$t = 'y';
}
return($t);
}


sub build_mod_emails {
require "$vars_config{VariablesPath}/vars_mods.cgi";
local($Moderators, $mod_emails, @mods, @mod_profile, @mod_email);

# $_[0] : forum number

$Moderators = ("Forum" . "$_[0]" . "Moderator");
$Moderators = $$Moderators;

# ZeR0 split up Mod var
@mods = split(/\|\|\^\|\|/, $Moderators);

foreach (@mods) {
if (-s "$vars_config{MembersPath}/$_.cgi") {
@mod_profile = &OpenProfile($_);  chomp($mod_profile[2]);
push (@mod_email, $mod_profile[2]);
}
}
# combine emails
$Moderators = join(", ", @mod_email);

return($Moderators);

}


# do not remove:
1;
