# Miscellaneous UBB routines

sub lost_password {
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";

&set_page_elements;

do "$vars_config{NonCGIPath}/Templates/public_lost_pw.pl";
}  # end lost_password

sub find_lost {
local($row_email, $lc_row_email, $row_un, @matches, $match_total, $html_message, $confirm, $email_message, @user_profile, $match_results, $match_results_html);

#validate
my @ValidateArray = ("email"); &Validate(@ValidateArray);

# get list of registered emails
my @email_list = &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");

#lowercase the input
my $lc_email = lc($in{email});

# find matches
foreach (@email_list) {
	($row_email, $row_un) = split(/\|\|/, $_);
	$lc_row_email = lc($row_email);
	if ($lc_row_email eq "$lc_email") {
		chomp($row_un);
		push(@matches, $row_un);
	}
}

# now we have matches
$match_total = @matches;

# prepare for onscreen display & possible email display
&set_page_elements;

# email confirmation- if we have a match
if ($match_total > 0) {

# require mail routines--
require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";

# onscreen wording
$confirm = "$vars_wordlets{lost_pw_match} $in{email}";

# assemble match data
foreach (@matches) {
@user_profile = &OpenProfile("$_");
chomp($user_profile[0]); chomp($user_profile[1]);

$match_results .= qq!
$vars_wordlets{login_name}: $user_profile[0]
$vars_wordlets{password_field}: $user_profile[1]

!;

$match_results_html .= qq!
$vars_wordlets{login_name}: <B>$user_profile[0]</B><BR>
$vars_wordlets{password_field}: <B>$user_profile[1]</B>
<P>
!;

}


if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{lost_pw_intro}\n\r\n$match_results$vars_wordlets_email{signature_text}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne "ascii") {
my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{lost_pw_intro_html}" . "<P>$match_results_html<P>". "$vars_wordlets_email{signature_html}" . qq!</FONT>!;

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
&set_page_elements;

$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}

&ubb_mail("$in{email}", "$vars_display{BBEmail}", "", "$vars_wordlets_email{lost_pw_subject}", "$email_message", "$html_message", "");
} else {
# onscreen wording
$confirm = "$vars_wordlets{lost_pw_no_match}";

}

# send onscreen confirmation
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";

&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_found_pw.pl";

} # end find_lost

sub ubb_code_page {
local(*FILE);
# is the page available?
if (  ($vars_misc{use_cache} ne 'no') &&  (-s "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi")) {

$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi");

print "$ThisHTML";
exit;

}  else {


# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{ubb_code}.cgi";

&set_page_elements;


require "$vars_config{NonCGIPath}/Templates/public_ubb_code_page.pl";

$ThisHTML = $Header;

$ThisHTML .= &ubb_code_body;
$ThisHTML .= $Footer;


# is ubb_files/misc directory created?
unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc") {

mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");

}

unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi") {
unlink "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi";
}

open (FILE, ">$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi");
&lock;
print FILE ("$ThisHTML");
&unlock;
close (FILE);

chmod (0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi");

print "$ThisHTML"; exit;
}
} # end ubb code page

sub faq {

# is the page available?
if (($vars_misc{use_cache} ne 'no') &&  (-e "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi")) {

$ThisHTML = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi");

print "$ThisHTML"; exit;

}  else {

# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{faq}.cgi";


&set_page_elements;
require "$vars_config{NonCGIPath}/Templates/public_faq.pl";

$ThisHTML = $Header;

$ThisHTML .= &faq;
$ThisHTML .= $Footer;


# is ubb_files/misc directory created?
unless (-d "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc") {
mkdir ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
}

unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi") {
unlink "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi";
}

open (FILE, ">$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi");
&lock;
print FILE ("$ThisHTML");
&unlock;
close (FILE);
chmod (0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi");

print "$ThisHTML"; exit;
}

} # end faq page

sub clear_cookies {
local(@all_cookies, @cookies, $counter);

@all_cookies = cookie();

$counter = 0;
foreach (@all_cookies) {
$counter++;
$cookies[$counter] = cookie(-name=> "$_", -value=> [''], -path=> '/', -expires=> '-3y');
}

print header(
	-cookie=>[@cookies],
	-charset => "",
	-type => "text/html",
	);



do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";

&set_page_elements;


# take viewer back to topic
&StandardHTML(qq!$vars_wordlets{cookies_cleared}<P><A HREF="$vars_config{CGIURL}/ultimatebb.cgi">$vars_config{BBName}</A>!);

exit;
} # end clear_cookies


# DANGER: Do not remove the next line!
1;