# UBB LIBRARY - DATE/TIME FUNCTIONS
sub GetDateTime  {
local ($adjustTime, $JSTime, $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst); 

if ($vars_time{TimeZoneOffset}) {
if (($vars_time{TimeZoneOffset} ne '') || ($vars_time{TimeZoneOffset} ne '0')) {
$adjustTime = time() + ($vars_time{TimeZoneOffset} * 3600);
}  else {
$adjustTime = time();
}

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime ($adjustTime);
} else {
($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);
}

$mon++;
$GotTime{JSMonth} = $mon;
$GotTime{JSYear} = $year + 1900;
$GotTime{LastLoginJulianDATE} = &jday($GotTime{JSMonth}, $mday, $GotTime{JSYear});
$hour = sprintf ("%2d", $hour); $hour =~tr/ /0/; $min = sprintf ("%2d", $min); $min =~tr/ /0/; $sec = sprintf ("%2d", $sec); $sec =~tr/ /0/;
$GotTime{sec} = $sec;
$JSTime = ("$hour" . "$min");
$GotTime{LastLoginJulian} = ($GotTime{LastLoginJulianDATE} + ($JSTime * 0.0001));
$GotTime{SearchJulian} = ("$GotTime{LastLoginJulianDATE}" . "-$JSTime$GotTime{sec}");
($GotTime{ampmhour}, $GotTime{AMPM}) = &NormalTime($hour);
$GotTime{min} = sprintf ("%2d", $min);
$GotTime{min} =~tr/ /0/;
$GotTime{mon} = sprintf ("%2d", $mon);
$GotTime{mon} =~tr/ /0/;
$GotTime{mday} = sprintf ("%2d", $mday);
$GotTime{mday} =~tr/ /0/;
$GotTime{HyphenDate} = ("$GotTime{mon}" . "-" . "$GotTime{mday}" . "-" . "$GotTime{JSYear}");
$GotTome{RunonDate} = ("$GotTime{mon}$GotTime{mday}$year");
$GotTime{Time} = ("$GotTime{ampmhour}" . ":" . "$GotTime{min}" . " " . "$GotTime{AMPM}");
$GotTime{LastLoginDT} = ("$GotTime{HyphenDate} $GotTime{Time}");
}  #end GetDateTime sr

sub ConvertTo24Hour {
local ($thishr, $thismin, $thisampm);
if ($_[2] eq 'PM') {		
	if ($_[0] < 12) { $thishour = ($_[0] + 12);
	}  else {
	$thishour = $_[0];
	}
}
if ($_[2] eq 'AM') {		
	if ($_[0] == 12) { $thishour = '0';
	}  else {
	$thishour = $_[0];
	}
}
$thishour = sprintf ("%2d", $thishour);
$thishour =~tr/ /0/;
$thismin = sprintf ("%2d", $thismin);
$thismin =~tr/ /0/;
return("$thishour:$thismin");
} # end convert to 24 hour format sr

sub ConvertTo24HourRunon {
local ($thishr, $thismin, $thisampm);
if ($_[2] eq 'PM') {		
	if ($_[0] < 12) { $thishour = ($_[0] + 12);
	}  else {
	$thishour = $_[0];
	}
}
if ($_[2] eq 'AM') {		
	if ($_[0] == 12) { $thishour = '0';
	}  else {
	$thishour = $_[0];
	}
}
$thishour = sprintf ("%2d", $thishour);
$thishour =~tr/ /0/;
$thismin = sprintf ("%2d", $_[1]);
$thismin =~tr/ /0/;
return("$thishour$thismin");
} # end convert to 24 hour runon format sr


sub NormalTime {
local $AMPM; local $hour;		
if ($_[0] < 12) { $AMPM = 'AM'; $hour = $_[0]; }
elsif ($_[0] > 12) { $hour = $_[0] - 12; $AMPM = 'PM';
} else  {
$AMPM = 'PM'; $hour = $_[0];
}  	
if ($hour == 0) { $hour = '12'; }
$hour = sprintf ("%2d", $hour); $hour =~tr/ /0/;
return($hour, $AMPM);
}

sub DateFormat {
# $_[0] (thedate) is a hyphenated MM-DD-YYYY format

local ($mon, $mday, $year, $CheckLength, $FormattedDate);

#prepare alternate formats
my ($mon, $mday, $year) = split(/-/, $_[0]);

# make sure we don't have any old pre-Y2K dates
$CheckLength = length($year);
if ($CheckLength < 4)  {
	if ($CheckLength  == 2) {
		$year = ("19" . "$year");
		}  else {
		$year = $year - 100; $year = sprintf ("%2d", $year);
		$year =~tr/ /0/; $year = ("20" . "$year");
		}
}

my @months = ("blank" , "$vars_wordlets_date{month_1}", "$vars_wordlets_date{month_2}", "$vars_wordlets_date{month_3}", "$vars_wordlets_date{month_4}", "$vars_wordlets_date{month_5}", "$vars_wordlets_date{month_6}", "$vars_wordlets_date{month_7}", "$vars_wordlets_date{month_8}", "$vars_wordlets_date{month_9}", "$vars_wordlets_date{month_10}", "$vars_wordlets_date{month_11}", "$vars_wordlets_date{month_12}");

#date format options
if ($vars_time{DateFormat} eq "US") {
	$FormattedDate = $_[0];
}
elsif ($vars_time{DateFormat} eq "Euro") {
	$FormattedDate = "$mday-$mon-$year";
}  
elsif ($vars_time{DateFormat} eq "USX") {
$FormattedDate = "$months[$mon] $mday, $year";
}  else {
$FormattedDate = "$mday $months[$mon] $year";
}
return($FormattedDate);
}

		
# FROM OLD DATE.PL FILE:

# The following defines the first day that the Gregorian calendar was used
# in the British Empire (Sep 14, 1752).  The previous day was Sep 2, 1752
# by the Julian Calendar.  The year began at March 25th before this date.

$brit_jd = 2361222;

sub jdate
# Usage:  ($month,$day,$year,$weekday) = &jdate($julian_day)
{
	local($jd) = @_;
	local($jdate_tmp);
	local($m,$d,$y,$wkday);

#	warn("warning:  pre-dates British use of Gregorian calendar\n")
#		if ($jd < $brit_jd);

	$wkday = ($jd + 1) % 7;       # calculate weekday (0=Sun,6=Sat)
	$jdate_tmp = $jd - 1721119;
	$y = int((4 * $jdate_tmp - 1)/146097);
	$jdate_tmp = 4 * $jdate_tmp - 1 - 146097 * $y;
	$d = int($jdate_tmp/4);
	$jdate_tmp = int((4 * $d + 3)/1461);
	$d = 4 * $d + 3 - 1461 * $jdate_tmp;
	$d = int(($d + 4)/4);
	$m = int((5 * $d - 3)/153);
	$d = 5 * $d - 3 - 153 * $m;
	$d = int(($d + 5) / 5);
	$y = 100 * $y + $jdate_tmp;
	if($m < 10) {
		$m += 3;
	} else {
		$m -= 9;
		++$y;
	}
	($m, $d, $y, $wkday);
}


sub jday
# Usage:  $julian_day = &jday($month,$day,$year)
{
	local($m,$d,$y) = @_;
	local($ya,$c);

	$y = (localtime(time))[5] + 1900  if ($y eq '');

	if ($m > 2) {
		$m -= 3;
	} else {
		$m += 9;
		--$y;
	}
	$c = int($y/100);
	$ya = $y - (100 * $c);
	$jd =  int((146097 * $c) / 4) +
		   int((1461 * $ya) / 4) +
		   int((153 * $m + 2) / 5) +
		   $d + 1721119;
#	warn("warning:  pre-dates British use of Gregorian calendar\n")
#		if ($jd < $brit_jd);
	$jd;
}

sub is_jday
{
# Usage:  if (&is_jday($number)) { print "yep - looks like a jday"; }
	local($is_jday) = 0;
	$is_jday = 1 if ($_[0] > 1721119);
}

sub monthname
# Usage:  $month_name = &monthname($month_no)
{
	local($n,$m) = @_;
	local(@names) = ('January','February','March','April','May','June',
	                 'July','August','September','October','November',
	                 'December');
	if ($m ne '') {
		substr($names[$n-1],0,$m);
	} else {
		$names[$n-1];
	}
}

sub monthnum
# Usage:  $month_number = &monthnum($month_name)
{
	local($name) = @_;
	local(%names) = (
		'JAN',1,'FEB',2,'MAR',3,'APR',4,'MAY',5,'JUN',6,'JUL',7,'AUG',8,
		'SEP',9,'OCT',10,'NOV',11,'DEC',12);
	$name =~ tr/a-z/A-Z/;
	$name = substr($name,0,3);
	$names{$name};
}

sub weekday
# Usage:  $weekday_name = &weekday($weekday_number)
{
	local($wd) = @_;
	("Sun","Mon","Tue","Wed","Thu","Fri","Sat")[$wd];
}

sub today
# Usage:  $today_julian_day = &today()
{
	local(@today) = localtime(time);
	local($d) = $today[3];
	local($m) = $today[4];
	local($y) = $today[5];
	$m += 1;
	$y += 1900;
	&main'jday($m,$d,$y);
}
	
sub yesterday
# Usage:  $yesterday_julian_day = &yesterday()
{
	&main'today() - 1;
}
	
sub tomorrow
# Usage:  $tomorrow_julian_day = &tomorrow()
{
	&main'today() + 1;
}

## END OLD DATE.PL FILE

# DANGER: do note remove the next line!
1;