# UBB New Reply Routines : Perl Code

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
require "$vars_config{VariablesPath}/vars_mods.cgi";


#unescapeHTML courtesy CGI.pm
#included here because some users are using aincient CGI.pm copies that don't have this.
sub unescapeHTML {
    my $string = shift;
    # thanks to Randal Schwartz for the correct solution to this one
    $string=~ s[&(.*?);]{
	local $_ = $1;
	/^amp$/i	? "&" :
	/^quot$/i	? '"' :
        /^gt$/i		? ">" :
	/^lt$/i		? "<" :
	$_
	}gex;
    return $string;
}


# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";

$direct_to = qq!
<BASE HREF="$vars_config{NonCGIURL}/">
!;
&set_page_elements;

sub reply_page {
local(@this_forum, @this_topic, $ubb_images, $post_permiss, $reply_restrict, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $show_sig, $disable_smilies, @reply_to, @stat_line, $clean_reply_to_message, $reply_to_message, $reply_to_author, $insert_reply_to, $i_frame, $i_frame_alt, @post_line, $go_to, $close_option, @user_profile, $ubb_code_buttons);

# validate replyto=> reply with quote
if ($in{replyto} ne '') {
unless ($in{replyto} >= 0) {
&StandardHTML("$vars_wordlets_err{reply_to}");
}}

# get forum details
@this_forum = &GetForumRecord($in{f});
$post_permiss = $this_forum[6]; chomp($post_permiss);

# check forum posting rules
if ($post_permiss eq 'private') {
	$reply_restrict = 'restrict';
}  else {
($j, $reply_restrict) = split(/\&/, $post_permiss);
}

if ($reply_restrict eq 'none') {
&StandardHTML("$vars_wordlets_err{no_one_can_post}");
}

# make sure we have someone logged in - unless unreg users allowed
if (($username eq '') && ($reply_restrict ne 'all')) {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!); }

# check to make sure user has access/permission to post!
if (($post_permiss eq 'private') || ($reply_restrict eq 'restrict')) {
&check_private_access($in{f}, $this_forum[12]);
}

# grab topic
@this_topic = &OpenTopic($in{t}, $in{f});

# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

# is topic closed?
if ($stat_line[1] =~ /X/i) {
&StandardHTML("$vars_wordlets_err{topic_closed}");
}

# don't display if this forum status is off and forum is private
if (($post_permiss eq 'private') && ($this_forum[3] ne 'On')) {
&StandardHTML("$vars_wordlets_err{private_forum_off}");
}

# if unreg users not permitted to post, check to make user has write permissions
if ($reply_restrict ne 'all') {
my @profile = &verify_id_num($username, $password, $user_number);
chomp($profile[4]);
if ($profile[4] !~ /Write/i) {
&StandardHTML("$vars_wordlets_err{user_cant_write}"); }
}

&CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");
# -> is_html, is_ubb, ubb_images_wording, html_allowed, ubb_allowed

if ($this_forum[5] eq 'is') {
$ubb_code_buttons = &instant_ubb_code;
}  else {
$ubb_code_buttons = "$is_ubb";
}

if ($vars_display{AllowIcons} eq 'TRUE') {
$icon_field = &create_icon_field("1");
}

# show signature?
if (($vars_display{AllowSignature} eq 'YES') && ($username ne '')) {
$show_sig = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes" CHECKED> $vars_wordlets{show_signature});
}

# disable smilies?
$disable_smilies =  qq(<BR><INPUT TYPE="CHECKBOX" NAME="disable_smilies" VALUE="yes"> $vars_wordlets{disable_smilies});

# allow closing of topic?
# only admins or mods can close topics
if ($username ne "") {
@user_profile = &verify_id_num($username, $password, $user_number);
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq 'true') {
$close_option = qq(<BR><INPUT TYPE="CHECKBOX" NAME="close_topic" VALUE="yes"> <B>$vars_wordlets{close_topic}</B>);
}
}

# reply with quote?
$insert_reply_to  = '';
if ($in{replyto} ne '') {

# find particular post within topic
@post_line = grep(/^Z\|\|$in{replyto}/, @this_topic);
@reply_to = split(/\|\|/, $post_line[0]);

$reply_to_message = $reply_to[6];

if ($reply_to[10] ne '') {
$reply_to_author = $reply_to[10];
}  else {
$reply_to_author = $reply_to[2];
}

# prepare replyto post for form
$clean_reply_to_message = &prep_for_edit("$reply_to_message", "$this_forum[5]", "$this_forum[10]");
$clean_reply_to_message =~ s/(\[QUOTE\])(.*)(\[\/QUOTE\]\n\r\n)//isg;

# strip off sig (if old UBB5 message)
chomp($reply_to[12]);
if ($reply_to[12] eq '') {
$clean_reply_to_message =~ s/------------------(.*)//isg;
}
chomp($clean_reply_to_message);

$insert_reply_to = "\[QUOTE\]$vars_wordlets{reply_to_lead} $reply_to_author:\n\[QB\]$clean_reply_to_message\[/QB\]\[/QUOTE\]"."\n\n";

} # end replyto get

# set topic viewer:
$go_to = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}";


$i_frame_alt = &build_topic_review;

if ($vars_display{InlineFrame} eq 'TRUE')  {
$i_frame = qq(<IFRAME FRAMEBORDER="1" ALIGN="center" width="$vars_style{TableWidth}" HEIGHT="200" SCROLLING="YES" SRC="$go_to">
$i_frame_alt
</IFRAME>);
} else {
$i_frame = $i_frame_alt;
}

# pull in instant smilie/ubb code javascript
$direct_to .= $instant_jscript;
&set_page_elements;

do "$vars_config{NonCGIPath}/Templates/public_new_reply_form.pl";

} # end new_reply_page

sub submit_new_reply {
local(@this_forum, $ip_number, $permission, $reply_restrict, $j, $lc_your_name, $reg_name, $lc_reg_name, $lc_it, $status, $total_post_count, $last_topic_number, $total_topic_count, @user_profile, $post_email, $message_ascii, @stat_line, $post_number, @ip_banlist, @this_topic, $total_replies, @rev_this_topic, @last_post, $last_post_num, @get_email, $notify_email, $notify_user_number, $get_profile, $get_un, @notify_profile, $message, $mess_truncated, $this_subject, $this_subject_also, $email_message, $html_message);
local(*FILE);

# make sure hiddens are cool
unless (($in{t} =~ /^\d{6}$/) && ($in{f} > 0)) {
&StandardHTML("$vars_wordlets_err{invalid_input}");
}

# is user banned?
$ip_number = $ENV{'REMOTE_ADDR'};
&check_ip_bans;

#validate
my @ValidateArray = ("message");

# in case this is an unreg user
if ($username eq '') {
push(@ValidateArray, "your_name");
}
&Validate(@ValidateArray);

@this_forum = &GetForumRecord($in{f});
$permission = $this_forum[6];

#set proper path if forum is private
if ($permission eq 'private') {
	$exact_path = "Forum$in{f}/private-$this_forum[7]";
	$reply_restrict = 'restrict';
}  else {
	$exact_path = "Forum$in{f}";
	($j, $reply_restrict) = split("&", $permission);
}

if ($reply_restrict eq 'none') {
&StandardHTML("$vars_wordlets_err{no_one_can_post}");
}

# make sure we have someone logged in - unless unreg users allowed
if (($username eq '') && ($reply_restrict ne 'all')) {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# check to make sure user has access/permission to post!
if (($permission eq 'private') || ($reply_restrict eq 'restrict')) {
&check_private_access($in{f}, $this_forum[12]);
}


# we will need to timestamp this baby
&GetDateTime;

if (($reply_restrict eq 'all') && ($in{your_name} ne '')) {

# user is not registered, so...
$username = "&lt;$in{your_name}&gt;";
$pubname = "&lt;$in{your_name}&gt;";
# brackets differentiate from registered members
} else {

# user is saying he is registered so...
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);
chomp($user_number);

# does this person have permission to write?
if ($user_profile[4] !~ /Write/i) {
&StandardHTML("$vars_wordlets_err{user_cant_write}");
}

} # if/else unregistered name

if ($vars_misc{FloodCheck} eq 'ON') {
# floodcheck courtesy of Michael Farris
chomp($user_profile[8]);
   &floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
   }

# get forum post count
if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {
   my @forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
$last_topic_number = $forumcounter[0]; chomp($last_topic_number);
$total_topic_count = $forumcounter[1]; chomp($total_topic_count);
$total_post_count = $forumcounter[2]; chomp($total_post_count);

}  else {
$total_post_count = 0; $last_topic_number = 0; $total_topic_count = 0;
}

# update post count
$total_post_count++;

# grab topic
@this_topic = &OpenTopic($in{t}, $in{f});

# grab topic stat line
@stat_line = split(/\|\|/, $this_topic[0]);

# is topic closed?
if ($stat_line[1] =~ /X/i) {
&StandardHTML("$vars_wordlets_err{topic_closed}");
}

# need to update total replies
$stat_line[2]++;

# close topic?
# only admins or mods can close topics
if (($in{your_name} eq '') && ($in{close_topic} eq 'yes')) {
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq 'true')  { $stat_line[1] .= 'X'; }
}

# grab subject
$this_subject = $stat_line[4];
$this_subject_also = unescapeHTML($stat_line[4]);

# reassemble stat_line for @this_topic
$this_topic[0] = join("||", @stat_line);

# grab last post
@rev_this_topic = reverse(@this_topic);
@last_post = split(/\|\|/, $rev_this_topic[0]);
$last_post_num = $last_post[1];
$last_post_num++;

# format new post number
$post_number = &Do6Digit($last_post_num);

# now we have to add the post to the topic
$message = $in{message};

## if HTML is not allowed, render HTML useless
if ($this_forum[4] eq 'is not') {
	$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
}

$message = &CensorCheck("$message");
$message = &Truncate("$message");

$message_ascii = $message;

# do graemlins--
if ($in{disable_smilies} ne "yes") { $message = &Smilies("$message"); }

# UBB Code-ify (if allowed)
if ($this_forum[5] eq 'is') {
$message = &UBBCode("$message", "$this_forum[10]");
} #end if UBB Code allowed

# convert newlines/carriage returns to <br> and <p> html tags
$message = &ConvertReturns("$message");
$message= &PipeCleaner("$message");

# check for excess images-
&excess_smilies_check($message);

# security checks:
&check_html($message);

## if email should not be displayed, don't
chomp($user_profile[11]); chomp($user_profile[2]);
if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no') || ($in{your_name} ne '')) {
$post_email = '';
}  else {
$post_email = "$user_profile[2]";
}

# we have IP, need to erase if we are not supposed to be keeping
if ($vars_misc{IP} eq 'OFF') {
	$ip_number = '';
}

# post icons idea provided by KOMBAT03...
unless ($in{msg_icon} >= 0) { 	$in{msg_icon} = '1'; }

#create topic post line
my $reg_status = 'reg';
if ($in{your_name} ne '') { $reg_status = 'unreg'; }

if ($in{Signature} eq '') { $in{Signature} = 'no'; }

my $topic_line = "Z||$post_number||$username||$GotTime{HyphenDate}||$GotTime{Time}||$post_email||$message||$ip_number||$reg_status||$in{msg_icon}||$pubname||$user_number||$in{Signature}\n";

# append new reply to @this_topic
push(@this_topic, $topic_line);

# test to make sure member file is writeable!
if ($reg_status eq 'reg') {
unless (-w "$vars_config{MembersPath}/$user_number.cgi") {
chmod (0777, "$vars_config{MembersPath}/$user_number.cgi");
}
}

#update threads summary file
if (-e "$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads") {
&update_forum_summary($in{f}, $in{t}, $this_subject);
} else {
&create_forum_summary($in{f});
}

# make sure that threads file was created:
# this is in case disk quota is exceeded, to limit damage--
if (-z "$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads") {

# alert admin!
if ($vars_email{UseEmail} eq 'ON')  {

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";
my $this_message = qq!$vars_wordlets_email{post_alert_cant_write}!;

&ubb_mail("$vars_registration{RegsAdminEmail}", "$vars_registration{RegsAdminEmail}", "", "$vars_wordlets_err{post_no_write_subject} : $vars_config{BBName}", "$this_message", "", "$vars_display{BBEmail}");
}

&StandardHTML("$vars_wordlets_err{post_no_write}");
} # unless threads file is blank

# no problem, so proceed
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");
&lock;
print FILE @this_topic;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

# update member file?
if ($reg_status eq 'reg') {
$user_profile[7]++;
# bump user up to Member if total posts reaches MemberMinimum
if (($user_profile[7] >= $vars_misc{MemberMinimum})  && ($user_profile[8] eq 'Junior Member')) {
$user_profile[8] = 'Member';
}

# update user_posts file
if ($permission ne 'private') {
open (FILE, ">>$vars_config{MembersPath}/user_posts/$user_number.cgi") or die("Can't open: $!" );
&lock;
print FILE "$in{f}|$in{t}|$post_number\n";
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/user_posts/$user_number.cgi");
}

open (FILE, ">$vars_config{MembersPath}/$user_number.cgi") or die("Can't open Members file: $!" );
&lock;
foreach $j(@user_profile) {
	chomp($j);
	print FILE ("$j\n");
}
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/$user_number.cgi");
}  # end update user profile

#update last time file
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lasttime.file") or die("Unable to open lasttime.file in $exact_path : $!");
&lock;
print FILE ("$GotTime{HyphenDate}\n");
print FILE ("$GotTime{Time}\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lasttime.file");

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$last_topic_number\n");
print FILE ("$total_topic_count\n");
print FILE ("$total_post_count\n");
print FILE ("$this_subject\n");
print FILE ("$pubname\n");
print FILE ("$in{msg_icon}\n");
print FILE ("$in{t}\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# index---
$in{topic_subject} = $this_subject;
# create promo edition of message
$mess_truncated = &promo($message);
&append_index($in{f}, $in{t}, $this_forum[6], $post_number);

# create promo edition of message
$mess_truncated = &promo($message);

# unlink old topic page
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# lc the logged in user-- for comparisons below
my $lc_un = lc($username);

# take viewer back to topic
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}", "$vars_wordlets{thanks_for_posting}", "$this_subject");

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
&set_page_elements;

# notify moderator?
if (($this_forum[11] eq 'yes') && ($vars_email{UseEmail} eq 'ON')) {

local ($Moderator);

# $Moderator contains list of email addresses for modderators, separated by commas
$Moderator = &build_mod_emails($in{f});

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

if ($Moderator ne '') {

if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{mod_notify_post}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne 'ascii') {
my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_notify_post_html}" . qq!</FONT>!;
$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}

require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
&ubb_mail("$Moderator", "$vars_display{BBEmail}", "", "$vars_wordlets_email{mod_notify_subject} : $this_forum[1]", "$email_message", "$html_message", "");
}

} #end mod notify block

# notify topic starter?
my $lc_topic_starter = lc($stat_line[3]);

if (($stat_line[1] =~ /N/i)  && ($vars_email{UseEmail} eq 'ON') && ($lc_un ne "$lc_topic_starter") ) {

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

# get topic writer email:
chomp($stat_line[9]);
if ($stat_line[9] ne '') {
@get_profile = &OpenProfile($stat_line[9]);
}  else {
$get_un = &GetUserNumber($stat_line[3]);
@get_profile = &OpenProfile($get_un);
}

$notify_email = @get_profile[2]; chomp($notify_email);

if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{topic_notify}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne 'ascii') {
my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{topic_notify_html}" . qq!</FONT>!;

$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
&ubb_mail("$notify_email", "$vars_display{BBEmail}", "", "$vars_wordlets_email{topic_notify_subject}", "$email_message", "$html_message", "");

} #end topic starter notify block

# clear cache- we have new data!
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{f});

} # end submit new reply


# DANGER: Do not remove the next line!
1;