# UBB New Topic Routines : Perl Code

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{CGIPath}/ubb_lib_2.cgi";
require "$vars_config{VariablesPath}/vars_mods.cgi";

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";

&set_page_elements;

sub new_topic_page {
local(@this_forum, $ubb_images, $post_permiss, $topic_restrict, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $email_notify, $show_sig, $disable_smilies, @user_profile, $close_option, $ubb_code_buttons);

@this_forum = &GetForumRecord($in{f});
$post_permiss = $this_forum[6];

if ($post_permiss eq 'private') {
	$topic_restrict = "restrict";
}  else {
($topic_restrict, $j) = split(/\&/, $post_permiss);
}

if ($topic_restrict eq 'none') {
&StandardHTML("$vars_wordlets_err{no_one_can_post}");
}

# make sure we have someone logged in - unless unreg users allowed
if (($username eq '') && ($topic_restrict ne 'all')) {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
}

# check to make sure user has access/permission to post!
if (($post_permiss eq 'private') || ($topic_restrict eq 'restrict')) {
&check_private_access($in{f}, $this_forum[12]);
}

# if unreg users not permitted to post, check to make user has write permissions
if ($topic_restrict ne 'all') {
my @profile = &verify_id_num($username, $password, $user_number);
chomp($profile[4]);
if ($profile[4] !~ /Write/i) {
&StandardHTML("$vars_wordlets_err{user_cant_write}"); }
}

# don't display if this forum status is off and forum is private
if (($post_permiss eq 'private') && ($this_forum[3] ne 'On')) {
&StandardHTML("$vars_wordlets_err{private_forum_off}");
}

&CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");
# -> is_html, is_ubb, ubb_images_wording

if ($this_forum[5] eq 'is') {
$ubb_code_buttons = &instant_ubb_code;
}  else {
$ubb_code_buttons = "$is_ubb";
}

if ($vars_display{AllowIcons} eq 'TRUE') {
$icon_field = &create_icon_field("1");
}

# email notify on?
if (($vars_email{UseEmail} eq 'ON') && ($username ne ''))  {
$email_notify = qq(<INPUT TYPE="CHECKBOX" NAME="email_notification" VALUE="yes"> $vars_wordlets{email_notify});
}

# show signature?
if (($vars_display{AllowSignature} eq 'YES') && ($username ne '')) {
$show_sig = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes" CHECKED> $vars_wordlets{show_signature});
}

# disable smilies?
$disable_smilies =  qq(<BR><INPUT TYPE="CHECKBOX" NAME="disable_smilies" VALUE="yes"> $vars_wordlets{disable_smilies});

# allow closing of topic?
# only admins or mods can close topics
if ($username ne '') {
@user_profile = &verify_id_num($username, $password, $user_number);
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq "true") {
$close_option = qq(<BR><INPUT TYPE="CHECKBOX" NAME="close_topic" VALUE="yes"> <B>$vars_wordlets{close_topic}</B>);
}
}
# pull in instant smilie/ubb code javascript
$direct_to = $instant_jscript;
&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_new_topic_form.pl";

} # end new_topic_page

sub submit_new_topic {
local(@this_forum, $ip_number, $permission, $topic_restrict, $j, $lc_your_name, $reg_name, $lc_reg_name, $lc_it, $status, $last_topic_number, $total_topic_count, $total_post_count, $Notes, $new_topic_number, @user_profile, $post_email, $message_ascii, @ip_banlist, $message, $mess_truncated, $email_message, $html_message, $this_subject);
local(*FILE);

# require english letter/number in subject?
if (($in{topic_subject} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq 'ON')){
&StandardHTML("$vars_wordlets_err{subject_deficient}");
}

# check for HTML tags in subject
if ( ($in{topic_subject} =~ /<.*>/) || ($in{topic_subject} =~ /</) ) {
&StandardHTML("$vars_wordlets_err{subject_with_html}");
}

$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};
# other subject checks/clean-ups
if ($in{topic_subject} =~ /\S{$vars_misc{runOnLimit}}/)  {
&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{topic_subject}");
}	#test before trying to expand special characters

$in{topic_subject} = FixSubjectEncoding($in{topic_subject});

# censor check the subject
$in{topic_subject} = &CensorCheck("$in{topic_subject}");

# is user banned?
$ip_number = $ENV{'REMOTE_ADDR'};
&check_ip_bans;

#validate
my @ValidateArray = ("topic_subject", "message");

# in case this is an unreg user
if ($username eq '') {
push(@ValidateArray, "your_name");
}
&Validate(@ValidateArray);

@this_forum = &GetForumRecord($in{f});
$permission = $this_forum[6];

#set proper path if forum is private
if ($permission eq 'private') {
	$exact_path = "Forum$in{f}/private-$this_forum[7]";
	$topic_restrict = 'restrict';
}  else {
	$exact_path = "Forum$in{f}";
	($topic_restrict, $j) = split("&", $permission);
}

if ($topic_restrict eq 'none') {
&StandardHTML("$vars_wordlets_err{no_one_can_post}");
}

# make sure we have someone logged in - unless unreg users allowed
if (($username eq '') && ($topic_restrict ne 'all')) {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# check to make sure user has access/permission to post!
if (($permission eq 'private') || ($topic_restrict eq 'restrict')) {
&check_private_access($in{f}, $this_forum[12]);
}

if (($topic_restrict eq 'all') && ($in{your_name} ne '')) {

# user is not registered, so...
$username = "&lt;$in{your_name}&gt;";
$pubname = "&lt;$in{your_name}&gt;";
# brackets differentiate from registered members
} else {

# user is saying he is registered so...
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);


# does this person have permission to write?
if ($user_profile[4] !~ /Write/i) {
&StandardHTML("$vars_wordlets_err{user_cant_write}");
}

} # if/else unregistered name


   if ($vars_misc{FloodCheck} eq 'ON') {
#floodcheck courtesy of Michael Farris
chomp($user_profile[8]);
   &floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
   }

# determine last topic number and increment by 1
if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {
   my @forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
$last_topic_number = $forumcounter[0]; chomp($last_topic_number);
$total_topic_count = $forumcounter[1]; chomp($total_topic_count);
$total_post_count = $forumcounter[2]; chomp($total_post_count);
}  else {
$last_topic_number = 0; $total_topic_count = 0; $total_post_count = 0;
}

if (($in{email_notification} eq 'yes')  && ($in{your_name} eq '')) {
$Notes = 'N';
}


# close topic?
# only admins or mods can close topics
if (($in{your_name} eq '') && ($in{close_topic} eq 'yes')) {
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one eq 'true')  { $Notes .= 'X'; }
}

if ($last_topic_number > 0) {
$last_topic_number++;
$new_topic_number = sprintf("%6d", $last_topic_number);
$new_topic_number =~tr/ /0/;
}  else {
$new_topic_number = '000001';
}

#now we have to add the topic to the forum directory
$message = $in{message};

## IF HTML is not allowed, render HTML useless
if ($this_forum[4] eq 'is not') {
		$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
}


$message = &CensorCheck("$message");
$message = &Truncate("$message");

$message_ascii = $message;

# do graemlins--
if ($in{disable_smilies} ne 'yes') {
$message = &Smilies("$message");
}

# UBB Code-ify (if allowed)
if ($this_forum[5] eq 'is') {
$message = &UBBCode("$message", "$this_forum[10]");
} #end if UBB Code allowed


#convert newlines/carriage returns to <br> and <p> html tags
$message = &ConvertReturns("$message");
$message= &PipeCleaner("$message");

#check for excess images-
# check for excess images-
&excess_smilies_check($message);

# don't allow HTML SCRIPT TAGS
&check_html($message);

## if email should not be displayed, don't
chomp($user_profile[11]); chomp($user_profile[2]);
if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no') || ($in{your_name} ne '')) {
$post_email = '';
}  else {
$post_email = "$user_profile[2]";
}

# we have IP, need to erase if we are not supposed to be keeping
if ($vars_misc{IP} eq 'OFF') {
	$ip_number = '';
}

# post icons idea provided by KOMBAT03...
unless ($in{msg_icon} >= 0) { 	$in{msg_icon} = '1'; }

#create file lines
my $stat_line = "A||$Notes||0||$username||$in{topic_subject}||||$in{msg_icon}||||$pubname||$user_number";

my $reg_status = 'reg';
if ($in{your_name} ne '') { $reg_status = 'unreg'; }
if ($in{Signature} eq '') { $in{Signature} = 'no'; }

my $topic_line = "Z||000000||$username||$GotTime{HyphenDate}||$GotTime{Time}||$post_email||$message||$ip_number||$reg_status||$in{msg_icon}||$pubname||$user_number||$in{Signature}";

# test to make sure member file is writeable!
if ($reg_status eq 'reg') {
unless (-w "$vars_config{MembersPath}/$user_number.cgi") {
chmod (0777, "$vars_config{MembersPath}/$user_number.cgi");
}
}


# perform disk space test:
# this is in case disk quota is exceeded, to limit damage--

open (FILE, ">$vars_config{NonCGIPath}/test.file");
print FILE "test";
close(FILE);
chmod (0666, "$vars_config{NonCGIPath}/test.file");

if (-z "$vars_config{NonCGIPath}/test.file") {

# alert admin!
if ($vars_email{UseEmail} eq 'ON')  {

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";
my $this_message = qq!$vars_wordlets_email{post_alert_cant_write}!;

&ubb_mail("$vars_registration{RegsAdminEmail}", "$vars_registration{RegsAdminEmail}", "", "$vars_wordlets_err{post_no_write_subject} : $vars_config{BBName}", "$this_message", "", "$vars_display{BBEmail}");
}

&StandardHTML("$vars_wordlets_err{post_no_write}");
} # unless threads file is blank

# delete test file now!
unlink("$vars_config{NonCGIPath}/test.file");

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$new_topic_number.cgi");
&lock;
print FILE ("$stat_line\n");
print FILE ("$topic_line\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$new_topic_number.cgi");

# update member file
if ($reg_status eq 'reg') {
$user_profile[7]++;
# bump user up to Member if total posts reaches MemberMinimum
if (($user_profile[7] >= $vars_misc{MemberMinimum})  && ($user_profile[8] eq 'Junior Member')) {
$user_profile[8] = 'Member';
}

open (FILE, ">$vars_config{MembersPath}/$user_number.cgi") or die("Can't open Members directory: $!" );
&lock;
foreach $j(@user_profile) {
	chomp($j);
	print FILE ("$j\n");
}
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/$user_number.cgi");
}  # end update user profile

# update last time file
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lasttime.file") or die("Unable to open lasttime.file : $!");
&lock;
print FILE ("$GotTime{HyphenDate}\n");
print FILE ("$GotTime{Time}\n");
&unlock;
close (FILE);

chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lasttime.file");

#update last number file for forum
$total_topic_count++;
$total_post_count++;

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$new_topic_number\n");
print FILE ("$total_topic_count\n");
print FILE ("$total_post_count\n");
print FILE ("$in{topic_subject}\n");
print FILE ("$pubname\n");
print FILE ("$in{msg_icon}\n");
print FILE ("$new_topic_number\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# update user_posts file
if (($reg_status eq 'reg') && ($permission ne 'private'))  {
open (FILE, ">>$vars_config{MembersPath}/user_posts/$user_number.cgi") or die("Can't open: $!" );
&lock;
print FILE "$in{f}|$new_topic_number|000000\n";
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/user_posts/$user_number.cgi");
} # if user is registered & forum is not private

# update threads summary file
if (-e "$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads") {
&update_forum_summary($in{f}, "$new_topic_number", "$in{topic_subject}");
} else {
&create_forum_summary($in{f});
}

# index:
# create promo edition of message
$mess_truncated = &promo($message);
&append_index($in{f}, $new_topic_number, $this_forum[6], "000000");

# take viewer back to forum
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{f}", "$vars_wordlets{thanks_for_posting}", "$this_forum[1]");

$in{t} = $new_topic_number;
$this_subject = $in{topic_subject};
#strip UBBCode for moderator notification email
$message =~ s/\[\/?(b|i|url|img|email|quote|code|list|\*)\]//gi;
$message =~ s/\[\/?url=(.+)\]/($1) /;

# notify moderator?
if (($this_forum[11] eq 'yes') && ($vars_email{UseEmail} eq 'ON')) {

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
&set_page_elements;

require "$vars_config{CGIPath}/ubb_lib_mail.cgi";

local ($Moderator);

# $Moderator contains list of email addresses for modderators, separated by commas
$Moderator = &build_mod_emails($in{f});

if ($Moderator ne '') {

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{mod_notify_post}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne 'ascii') {
my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_notify_post_html}" . qq!</FONT>!;
$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}

&ubb_mail("$Moderator", "$vars_display{BBEmail}", '', "$vars_wordlets_email{mod_notify_subject} : $this_forum[1]", "$email_message", "$html_message", '');
}


} #end mod notify block

# clear cache- we have new data!
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{f});

} # end submit new topic


# DANGER: Do not remove the next line!
1;