# UBB Private Message Routines : Perl Code

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
require "$vars_config{CGIPath}/ubb_lib_2.cgi";

# get assigned style template!
unless (exists($template_match{private_message})) {
$template_match{private_message} = 1;
}

require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{private_message}.cgi";

$direct_to = qq!
<BASE HREF="$vars_config{NonCGIURL}/">
!;
&set_page_elements;

# make sure pm is enabled
if ($vars_pm{feature} eq 'off') {
&StandardHTML("$vars_wordlets_err{pm_off}");
}


# make sure we have someone logged in
# (only registered members can pm)

if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
}

# can remove this line after beta--
&make_pm_dirs;

sub pm_update_list {
# $_[0] : ignore or buddy
local(%pm_ignore, %pm_buddy, $key, $this_username);

# collect all...
foreach $key(keys %in) {
if ($in{$key} eq 'include') {
$pm_ignore{$key} = 'I';
}
}

if ($_[0] eq 'ignore') {

# collect all...
foreach $key(keys %in) {
if ($in{$key} eq 'include') {
$this_username = &get_public_name($key);
$this_username =~ s/\|/&#0124;/sg;
if ($this_username =~ /\\$/) { 	$this_username .= ' '; }
$pm_ignore{$key} = $this_username;
}
}

# write to file
open (FILE, ">$vars_config{MembersPath}/pm_ignore/$user_number.cgi");
&lock;
print FILE qq!\%pm_ignore = (\n!;

foreach $key (keys %pm_ignore) {
print FILE qq!"$key" => q|$pm_ignore{$key}|,\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/pm_ignore/$user_number.cgi");


}  else {


# collect all...
foreach $key(keys %in) {
if ($in{$key} eq 'include') {
$this_username = &get_public_name($key);
$this_username =~ s/\|/&#0124;/sg;
if ($this_username =~ /\\$/) { 	$this_username .= ' '; }
$pm_buddy{$key} = "$this_username";
}
}

# write to file
open (FILE, ">$vars_config{MembersPath}/pm_buddy/$user_number.cgi");
&lock;
print FILE qq!\%pm_buddy = (\n!;

foreach $key (keys %pm_buddy) {
print FILE qq!"$key" => q|$pm_buddy{$key}|,\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/pm_buddy/$user_number.cgi");

}

do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile", "$vars_wordlets{thanks_for_updating_list}", "$vars_wordlets{my_profile_header}");

} # end pm_update_list

sub pm_do_list {
# $_[0] : ignore or buddy

local(%pm_ignore, %pm_buddy, $key, $list_count, $this_username);
$list_count = 0;

# retrieve list
if (-e "$vars_config{MembersPath}/pm_$_[0]/$user_number.cgi")  {
require "$vars_config{MembersPath}/pm_$_[0]/$user_number.cgi";
}

my $list_add = &Do8Digit($in{u});


$ThisHTML = qq~<HTML><HEAD><TITLE>$vars_config{BBName}</TITLE>
<script LANGUAGE="javascript">
<!--
function closeWindow() {
		window.close();
}
//-->
</script>

</HEAD><BODY>
<FONT FACE="$vars_style{FontFace}" SIZE="$vars_style{TextSize}"><center>
<FORM>~;

# can't send pm to self
if ($list_add eq "$user_number") {
$ThisHTML .= qq~$vars_wordlets_err{pm_list_add_self}<P></FONT>
<INPUT TYPE="button" VALUE="$vars_wordlets{close_window}" onClick="closeWindow()"></center>
</FORM>
<P></BODY></HTML>~;
print "$ThisHTML"; exit;
}

if ($_[0] eq 'ignore') {

foreach $key(keys %pm_ignore) {
$list_count++;
}

if ($list_count >= 100) {
$ThisHTML .= qq~$vars_wordlets_err{list_count_limit}~;
}  else {

if (exists($pm_ignore{$list_add})) {

$ThisHTML .= qq~$vars_wordlets{already_ignored}~;

} else {
$this_username = &get_public_name($list_add);
$this_username =~ s/\|/&#0124;/sg;
if ($this_username =~ /\\$/) { 	$this_username .= ' '; }
$pm_ignore{$list_add} = $this_username;

$ThisHTML .= qq~$vars_wordlets{ignore_added}~;

# update ignore list

open (FILE, ">$vars_config{MembersPath}/pm_ignore/$user_number.cgi");
&lock;
print FILE qq!\%pm_ignore = (\n!;
foreach $key (keys %pm_ignore) {
print FILE qq!"$key" => q|$pm_ignore{$key}|,\n!;
}
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_ignore/$user_number.cgi");

}
}

}  else {


foreach $key(keys %pm_buddy) {
$list_count++;
}

if ($list_count >= 100) {

$ThisHTML .= qq~$vars_wordlets_err{list_count_limit}~;

}  else {

if (exists($pm_buddy{$list_add})) {

$ThisHTML .= qq~$vars_wordlets{already_buddy}~;

} else {

$this_username = &get_public_name($list_add);
$this_username =~ s/\|/&#0124;/sg;
if ($this_username =~ /\\$/) { 	$this_username .= ' '; }
$pm_buddy{$list_add} = "$this_username";

$ThisHTML .= qq~$vars_wordlets{buddy_added}~;

# update buddy list

open (FILE, ">$vars_config{MembersPath}/pm_buddy/$user_number.cgi");
&lock;
print FILE qq!\%pm_buddy = (\n!;

foreach $key (keys %pm_buddy) {
print FILE qq!"$key" => q|$pm_buddy{$key}|,\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_buddy/$user_number.cgi");

}
}
}

$ThisHTML .= qq~
<P></FONT>
<INPUT TYPE="button" VALUE="$vars_wordlets{close_window}" onClick="closeWindow()"></center>
</FORM>
<P>
~;

print "$ThisHTML"; exit;
} # end pm_do_list

sub pm_list {
# $_[0] : ignore or buddy

local(%pm_ignore, %pm_buddy, %pm_list, $key, $this_name, $count, $this_list, $list_explained, @pm_list);
$count = 0;

# retrieve list
if (-e "$vars_config{MembersPath}/pm_$_[0]/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_$_[0]/$user_number.cgi";
}

$this_list = ucfirst($_[0]);
if ($_[0] eq 'ignore') {
	$list_explained = $vars_wordlets{ignore_explained};
	%pm_list = %pm_ignore;
}  else {
	$list_explained = $vars_wordlets{buddy_explained};
	%pm_list = %pm_buddy;
}

# sort alphabetically
@pm_list = sort { $pm_list{$a} cmp $pm_list{$b} } keys %pm_list;

&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_pm_list.pl";

} # end pm_list

sub pm_check_full {
if ((-e "$vars_config{MembersPath}/pm_users/$_[0].cgi") && ($_[0] ne '')) {
require "$vars_config{MembersPath}/pm_users/$_[0].cgi";
}
my $index_count = 0;
foreach $key(keys %pm_user_index) {
$index_count++;
}
if ($index_count > 59) {
	&StandardHTML("$vars_wordlets_err{pm_user_max}");
}
} # end check full

sub pm_reply {
local(%pm_user_index, %pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_to, %pm_from, %pm_signature, @pm_profile, $ubb_images, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $show_sig, $disable_smilies, $close_option, @user_profile, $ubb_code_buttons, $pm_to_name, $page_title, $form_hiddens, $breadcrumb, $subject_field);

# page title:
$page_title = "$vars_wordlets{pm_reply}";

# get pm topic!
if (-e "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi") {
require "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi";
}  else {
	&StandardHTML("$vars_wordlets_err{no_such_pm}");
}

# are add'l replies allowed?
if ($pm_topic_data{replies} == 20) {
	&StandardHTML("$vars_wordlets{pm_full_explained}");
}

# can't reply to self
if ($user_number eq "$pm_topic_data{from}") {
	&StandardHTML("$vars_wordlets{cant_reply_to_self}");
}

# is recipient's pm box full?
&pm_check_full($pm_topic_data{from});

# subject field:
$subject_field = qq~$pm_topic_data{subject}~;


# is user on ignore?
&check_ignore($pm_topic_data{from});

# get profile for recipient
@pm_profile = &OpenProfile($pm_topic_data{from});
chomp($pm_profile[15]); chomp($pm_profile[0]);
$pm_to_name = $pm_profile[15];
if ($pm_to_name eq '') { $pm_to_name = $pm_profile[0]; }

chomp($pm_profile[27]);
if ($pm_profile[27] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_off_for_member}");
}

# are only forum leaders permitted to receive pm?
if (($vars_pm{feature} eq 'leaders_only') && (($pm_profile[8] ne 'Administrator') && ($pm_profile[8] ne 'Moderator'))) {
	&StandardHTML("$vars_wordlets_err{pm_only_leaders}");
}

# has admin disabled PM for sender?
@user_profile = &verify_id_num($username, $password, $user_number);
chomp($user_profile[29]);
if ($user_profile[29] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_ban}");
}

if ($vars_pm{html} eq 'on') {
	$is_html = "$vars_wordlets{html_is_on}"; 	$html_allowed = "yes";
}  else {
	$is_html = "$vars_wordlets{html_is_off}"; 	$html_allowed = "no";
}

if ($vars_pm{ubb_code} ne 'off') {
	$is_ubb = "$vars_wordlets{ubbcode_is_on}"; 	$ubb_allowed = 'yes';
}  else {
	$is_ubb = "$vars_wordlets{ubbcode_is_off}"; 	$ubb_allowed = 'no';
}

if ($vars_pm{ubb_code} eq 'images_off')  {
	$ubb_images_wording = "$vars_wordlets{ubbcode_images_banned}";
}  else {
	$ubb_images_wording = '';
}

if ($vars_pm{ubb_code} ne 'off') {
$ubb_code_buttons = &instant_ubb_code;
}  else {
$ubb_code_buttons = "$is_ubb";
}

if ($vars_display{AllowIcons} eq 'TRUE') {
$icon_field = &create_icon_field("1");
}

# show signature?
if ($vars_display{AllowSignature} eq 'YES') {
$show_sig = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes" CHECKED> $vars_wordlets{show_signature});
}

# disable smilies?
$disable_smilies =  qq(<BR><INPUT TYPE="CHECKBOX" NAME="disable_smilies" VALUE="yes"> $vars_wordlets{disable_smilies});

# close PM?
$close_option = qq(<BR><INPUT TYPE="CHECKBOX" NAME="close_pm" VALUE="yes"> <B>$vars_wordlets{close_pm}</B>);

# breadcrumb
$breadcrumb = qq~<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile">$vars_wordlets{my_profile_header}</A> &#187;<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_pm&d=$in{d}&t=$in{t}">$pm_topic_data{subject}</A> &#187; $vars_wordlets{pm_reply}~;

# hiddens
$form_hiddens = qq~
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="submit_pm_reply">
<INPUT TYPE="HIDDEN" NAME="d" VALUE="$in{d}">
<INPUT TYPE="HIDDEN" NAME="t" VALUE="$in{t}">
~;

# pull in instant smilie/ubb code javascript
$direct_to .= $instant_jscript;
&set_page_elements;

do "$vars_config{NonCGIPath}/Templates/public_pm_form.pl";

} # end pm_reply

sub pm_delete {
local(%pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_to, %pm_from, %pm_signature, %pm_user_index);

# make sure pm topic exists!
if (-e "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi") {

require "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi";

if ($user_number ne "$pm_topic_data{to}") {
	&StandardHTML("$vars_wordlets_err{not_pm_recipient}");
}

}  else {
	&StandardHTML("$vars_wordlets_err{no_such_pm}");
}

# delete topic file
unlink("$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi");

# update user pm file
if (-e "$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi") {

require "$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi";

open (FILE, ">$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi");
&lock;
print FILE qq!\%pm_user_index = (\n!;

foreach $key (keys %pm_user_index) {
unless ($key eq "$in{d}-$in{t}") {
print FILE qq!"$key" => "$pm_user_index{$key}",\n!;
}
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi");
}

&StandardHTML(qq~$vars_wordlets{thanks_for_topic_delete}. <P>View <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile">$vars_wordlets{my_profile_header}</A>.~);

} # end pm_close

sub get_pm {
local(%pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_to, %pm_from, %pm_signature, $alt_color, $topic_closed, $topic_wording, $reply_wording, $this_icon, $ThisDate, $FormatTime, $profile_link, $homepage_link, $email_link, $post_body, $AuthorExtra, $user_status, $member_number, $show_public_name, $RegDate, $RegMonth, $RegDay, $RegMon, $RegYear, @themonths, $u, $post_total_line, $location_line, $regdate_line, @author_extra, $allow_images, $key, $topic_full, $pipestem, $to_name, $add_user_2_list);
local(*FILE);

# for registration date...
@themonths = ('', "$vars_wordlets_date{month_1_abbrev}", "$vars_wordlets_date{month_2_abbrev}", "$vars_wordlets_date{month_3_abbrev}", "$vars_wordlets_date{month_4_abbrev}", "$vars_wordlets_date{month_5_abbrev}", "$vars_wordlets_date{month_6_abbrev}", "$vars_wordlets_date{month_7_abbrev}", "$vars_wordlets_date{month_8_abbrev}", "$vars_wordlets_date{month_9_abbrev}", "$vars_wordlets_date{month_10_abbrev}", "$vars_wordlets_date{month_11_abbrev}", "$vars_wordlets_date{month_12_abbrev}");

# make sure user requesting pm is the recipient!
if (-e "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi") {

require "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi";

if ($user_number ne "$pm_topic_data{to}")  {
	&StandardHTML("$vars_wordlets_err{not_pm_recipient}");
}

}  else {
	&StandardHTML("$vars_wordlets_err{no_such_pm}");
}

# is pm topic closed?
if ($pm_topic_data{close} eq 'yes') {
$pipestem = '';
$topic_closed = qq(<br clear=all><font size=1><IMG SRC="$vars_config{NonCGIURL}/lock.gif" BORDER="0" ALT="$vars_wordlets{topic_closed}">&nbsp;&nbsp;$vars_wordlets{topic_closed}</font>);
$reply_wording = '';
} else {
$pipestem = ' | ';
$topic_closed = qq~&#171; <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=pm_delete&d=$in{d}&t=$in{t}">$vars_wordlets{pm_delete}</A> &#187;~;

# max: 20 replies
if ($pm_topic_data{replies} == 20) {
$reply_wording = qq!$vars_wordlets{pm_full}!;
$topic_full = qq!$vars_wordlets{pm_full_explained}!;
}  else {
$reply_wording = qq!<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=pm_reply&d=$in{d}&t=$in{t}"><ACRONYM TITLE="$vars_wordlets{pm_reply_explained}">$vars_wordlets{send_pm_reply}</ACRONYM></a>!;
}

}

$topic_wording = qq!$pipestem<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=private_message&u=$pm_topic_data{from}"><ACRONYM TITLE="$vars_wordlets{new_pm_explained}">$vars_wordlets{new_private_message}</acronym></a>!;

# get public name of Sender
$to_name = &get_public_name($pm_topic_data{from});

$direct_to .= qq~

<script LANGUAGE="javascript">
<!--
function ignore()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_ignore&u=$pm_topic_data{from}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=275,height=200,top=200,left=200');
}
function buddy()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_buddy&u=$pm_topic_data{from}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=275,height=200,top=200,left=200');
}
//-->
</script>
~;

&set_page_elements;
require "$vars_config{NonCGIPath}/Templates/public_pm_topic.pl";

$add_user_2_list = &list_check("$pm_topic_data{from}");

$ThisHTML = $Header;
$ThisHTML .= &topic_top;

$alt_color = $vars_style{AltColumnColor2};
# loop through all posts in pm
foreach(0..$pm_topic_data{replies}) {
undef($show_public_name);
undef($user_status); undef($email_link); undef($AuthorExtra);
undef($member_number); undef(@user_profile);
undef($profile_link);

# format date
$ThisDate = &DateFormat($pm_date{$_});

# format time
$FormatTime = &TimeFormat($pm_time{$_});

# grab post message
$post_body = $pm_post{$_};

# get user profile
@user_profile = &OpenProfile($pm_from{$_});
chomp($user_profile[0]); chomp($user_profile[15]);
chomp($user_profile[2]); chomp($user_profile[6]);
chomp($user_profile[7]); chomp($user_profile[10]);
chomp($user_profile[12]); chomp($user_profile[8]);

# get public name
$show_public_name = $user_profile[15];
if ($show_public_name eq '') { $show_public_name = $user_profile[0]; }

# do some cleaning---
$user_profile[6] =~ s/<.+?>//g;
$user_profile[6] =~ s/<.*//g; # delete unclosed HTML tags

# user_status:
$user_status = &CustomTitle($user_profile[8]);

# registration date for user
$RegDate = $user_profile[10];

if ($RegDate eq '') {
$RegDate = "$vars_wordlets{pre_reg_date_wording}";
}  else {
($RegMon, $RegDay, $RegYear) = split(/-/, $RegDate);
$RegMonth = $themonths[$RegMon];
$RegDate = "$RegMonth $RegYear";
}

# member_number:
$u = $pm_from{$_} + 0; # rid extra zeros from member no.
$member_number = "$vars_wordlets{user_number_abbrev} $u";

# author info options
undef($post_total_line); undef($location_line); undef($regdate_line);
undef(@author_extra);

if ($vars_display{author_post_total} eq 'yes') {
$post_total_line = qq( $vars_wordlets{author_posts} <B>$user_profile[7]</B> );
push(@author_extra, $post_total_line);
}

if ($vars_display{author_location} eq 'yes') {
$location_line = qq( $vars_wordlets{author_from} <B>$user_profile[6]</B> );
push(@author_extra, $location_line);
}

if ($vars_display{author_reg_date} eq 'yes') {
$regdate_line = qq( $vars_wordlets{author_registered} <B>$RegDate</B> );
push(@author_extra, $regdate_line);
}

if ($author_extra[0]) {
$AuthorExtra = join("|",  @author_extra);
}  else {
$AuthorExtra = '';
}


$profile_link = qq(<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$pm_from{$_}" target=_blank>
<IMG SRC="$vars_config{NonCGIURL}/$vars_style{profilegif}" BORDER="0" ALT="$vars_wordlets{view_profile_for} $show_public_name"></A>);


if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no')) {
$email_link = '&nbsp;';
}  else {

$email_link = qq(&nbsp;&nbsp;<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=email&ToWhom=$pm_from{$_}" target=_blank><IMG SRC="$vars_config{NonCGIURL}/$vars_style{mailgif}" BORDER="0" ALT="$vars_wordlets{send_email_to} $show_public_name"></A>&nbsp;&nbsp;);
}

# add signature, if necessary
if ($pm_signature{$_} eq 'yes') {

# new format! - signature is not included in message
if (($vars_display{AllowSignature} eq 'YES') && ($user_profile[12] ne '')) {

if ($vars_display{AllowSignatureImage} eq 'YES') {
$allow_images = 'ON';
} else {
$allow_images = 'OFF';
}

$user_profile[12] = &UBBCode($user_profile[12], $allow_images);
$post_body .= ("<P>$vars_wordlets{signature_break}<P>$user_profile[12]");
}
}

# message icons?
if ($vars_display{AllowIcons} eq 'TRUE') {
	$icon_number = $pm_icon{$_};
	if ($icon_number eq '') {  $icon_number = '1'; 	}
		unless (-e "$vars_config{NonCGIPath}/icons/icon$icon_number.gif") {
	$icon_number = '1';
	}
	$this_icon = qq(<IMG SRC="$vars_config{NonCGIURL}/icons/icon$icon_number.gif" BORDER="0" ALIGN="ABSCENTER">);
}  else {
	$this_icon = qq(<IMG SRC="$vars_config{NonCGIURL}/posticon.gif" BORDER="0" ALIGN="ABSCENTER">);
}

$ThisHTML .= &topic_row;
}

$ThisHTML .= &topic_bottom;

$ThisHTML .= $Footer;
print "$ThisHTML";

# mark pm as read, if not already so marked!
if ($pm_topic_data{read} eq 'no') { &mark_read($in{d}, $in{t}); }

} # end get_pm

sub mark_read {

$pm_topic_data{read} = "yes";

# post to pm_topics directory
&update_pm_topic($in{d}, $in{t});

}  # end mark_read


sub update_pm_topic {
# $_[0]: pm directory
# $_[1}: pm topic
local(*FILE);

open (FILE, ">$vars_config{MembersPath}/pm_topics/$_[0]/$_[1].cgi");
print FILE qq!\%pm_topic_data = (\n!;
&lock;

foreach $key (keys %pm_topic_data) {
print FILE qq!$key => q|$pm_topic_data{$key}|,\n!;
}

print FILE qq!);\n!;

print FILE qq!\%pm_date = (\n!;

foreach $key (keys %pm_date) {
print FILE qq!$key => "$pm_date{$key}",\n!;
}

print FILE qq!);\n!;

print FILE qq!\%pm_time = (\n!;

foreach $key (keys %pm_time) {
print FILE qq!$key => "$pm_time{$key}",\n!;
}

print FILE qq!);\n!;

print FILE qq!\%pm_post = (\n!;

foreach $key (keys %pm_post) {
print FILE qq!$key => q|$pm_post{$key}|,\n!;
}
print FILE qq!);\n!;

print FILE qq!\%pm_to = (\n!;

foreach $key (keys %pm_to) {
print FILE qq!$key => q~$pm_to{$key}~,\n!;
}
print FILE qq!);\n!;

print FILE qq!\%pm_from = (\n!;

foreach $key (keys %pm_from) {
print FILE qq!$key => q~$pm_from{$key}~,\n!;
}
print FILE qq!);\n!;

print FILE qq!\%pm_icon = (\n!;

foreach $key (keys %pm_icon) {
print FILE qq!$key => q~$pm_icon{$key}~,\n!;
}
print FILE qq!);\n!;

print FILE qq!\%pm_signature = (\n!;

foreach $key (keys %pm_signature) {
print FILE qq!$key => q~$pm_signature{$key}~,\n!;
}
print FILE qq!);\n!;

print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_topics/$_[0]/$_[1].cgi");

} #end update_pm_topic

sub check_ignore {
# $_[0]: user number of potential recipient
if ((-e "$vars_config{MembersPath}/pm_ignore/$_[0].cgi") && ($_[0] ne '')) {
require "$vars_config{MembersPath}/pm_ignore/$_[0].cgi";
}
if (exists($pm_ignore{$user_number})) {
	&StandardHTML("$vars_wordlets_err{pm_ignore_ban}");
}
}  # end check_ignore

sub private_message {
local(@pm_profile, $ubb_images, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $show_sig, $disable_smilies, $close_option, @user_profile, $ubb_code_buttons, $pm_to_name, $page_title, $form_hiddens, $breadcrumb, $subject_field, %pm_ignore);


# can't send pm to self
if ($in{u} eq "$user_number") {
&StandardHTML("$vars_wordlets_err{pm_to_self}");
}


# make sure that user allows pm
unless ($in{u} =~ /\d$/) {
&StandardHTML("$vars_wordlets_err{no_member_number} $in{u}");
}

# page title:
$page_title = "$vars_wordlets{send_private_message}";

# subject_field:
$subject_field = q~<INPUT TYPE="TEXT" NAME="topic_subject" VALUE='' SIZE="40" MAXLENGTH="85">~;
# breadcrumb
$breadcrumb = "$vars_wordlets{send_private_message}";

@pm_profile = &OpenProfile($in{u});

chomp($pm_profile[27]);
if ($pm_profile[27] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_off_for_member}");
}

# are only forum leaders permitted to receive pm?
if (($vars_pm{feature} eq 'leaders_only') && (($pm_profile[8] ne 'Administrator') && ($pm_profile[8] ne 'Moderator'))) {
	&StandardHTML("$vars_wordlets_err{pm_only_leaders}");
}

# is sender on ignore list?
# retrieve list
&check_ignore($in{u});

# get name of person sending PM to:
chomp($pm_profile[0]); chomp($pm_profile[15]);
$pm_to_name = $pm_profile[15];
if ($pm_to_name eq '') { $pm_to_name = $pm_profile[0]; }

# has admin disabled PM for sender?
@user_profile = &verify_id_num($username, $password, $user_number);
chomp($user_profile[29]);
if ($user_profile[29] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_ban}");
}

if ($vars_pm{html} eq 'on') {
	$is_html = "$vars_wordlets{html_is_on}"; 	$html_allowed = "yes";
}  else {
	$is_html = "$vars_wordlets{html_is_off}"; 	$html_allowed = "no";
}

if ($vars_pm{ubb_code} ne 'off') {
	$is_ubb = "$vars_wordlets{ubbcode_is_on}"; 	$ubb_allowed = 'yes';
}  else {
	$is_ubb = "$vars_wordlets{ubbcode_is_off}"; 	$ubb_allowed = 'no';
}

if ($vars_pm{ubb_code} eq 'images_off')  {
	$ubb_images_wording = "$vars_wordlets{ubbcode_images_banned}";
}  else {
	$ubb_images_wording = '';
}

if ($vars_pm{ubb_code} ne 'off') {
$ubb_code_buttons = &instant_ubb_code;
}  else {
$ubb_code_buttons = "$is_ubb";
}

if ($vars_display{AllowIcons} eq 'TRUE') {
$icon_field = &create_icon_field("1");
}

# show signature?
if ($vars_display{AllowSignature} eq 'YES') {
$show_sig = qq(<BR><INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes" CHECKED> $vars_wordlets{show_signature});
}

# disable smilies?
$disable_smilies =  qq(<BR><INPUT TYPE="CHECKBOX" NAME="disable_smilies" VALUE="yes"> $vars_wordlets{disable_smilies});

# close PM?
$close_option = qq(<BR><INPUT TYPE="CHECKBOX" NAME="close_pm" VALUE="yes"> <B>$vars_wordlets{close_pm}</B>);

# hiddens
$form_hiddens = qq~
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="submit_private_message">
<INPUT TYPE="HIDDEN" NAME="u" VALUE="$in{u}">
~;


# pull in instant smilie/ubb code javascript
$direct_to .= $instant_jscript;
&set_page_elements;

do "$vars_config{NonCGIPath}/Templates/public_pm_form.pl";

} # end new_reply_page

sub submit_pm {
local(@pm_profile, @user_profile, $ip_number, $j, $pm_to_name, @ip_banlist, %pm_user_index, $html_body, $last_num, $email_message, $html_message, $ubb_images);
local(*FILE);

# require english letter/number in subject?
if (($in{topic_subject} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq "ON")){
&StandardHTML("$vars_wordlets_err{subject_deficient}");
}

# check for HTML tags in subject
if ( ($in{topic_subject} =~ /<.*>/) || ($in{topic_subject} =~ /</) ) {
&StandardHTML("$vars_wordlets_err{subject_with_html}");
}

$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};
# other subject checks/clean-ups
if ($in{topic_subject} =~ /\S{$vars_misc{runOnLimit}}/)  {
&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{topic_subject}");
}	#test before trying to expand special characters

$in{topic_subject} = FixSubjectEncoding($in{topic_subject});

# make sure hiddens are cool
unless ($in{u} =~ /^\d{8}$/) {
&StandardHTML("$vars_wordlets_err{invalid_input}");
}

# can't send pm to self
if ($in{u} eq "$user_number") {
&StandardHTML("$vars_wordlets_err{pm_to_self}");
}

# is user banned?
$ip_number = $ENV{'REMOTE_ADDR'};
&check_ip_bans;

# is user on ignore?
&check_ignore($in{u});

#validate
my @ValidateArray = ("message", "u", "topic_subject");
&Validate(@ValidateArray);

# get profile for PM Sender
@user_profile = &verify_id_num($username, $password, $user_number);

# get profile for PM Receiver
@pm_profile = &OpenProfile($in{u});

# does receiver want to receive PM?
chomp($pm_profile[27]);
if ($pm_profile[27] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_off_for_member}");
}

# get name of person sending PM to:
chomp($pm_profile[0]); chomp($pm_profile[15]);
$pm_to_name = $pm_profile[15];
if ($pm_to_name eq '') { $pm_to_name = $pm_profile[0]; }

# check to see if PM set to leaders_only
if (($vars_pm{feature} eq 'leaders_only') && (($pm_profile[8] ne 'Administrator') && ($pm_profile[8] ne 'Moderator')))  {
	&StandardHTML("$vars_wordlets_err{pm_only_leaders}");
}

# has admin disabled PM for sender?
chomp($user_profile[29]);
if ($user_profile[29] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_ban}");
}

# floodcheck
if ($vars_misc{FloodCheck} eq 'ON') {
#floodcheck courtesy of Michael Farris
chomp($user_profile[8]);
   &floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
}

# determine last PM number and increment by 1
if (-e "$vars_config{MembersPath}/pm_info/pm_last_number.cgi") {
  $last_num = &OpenFileAsVar("$vars_config{MembersPath}/pm_info/pm_last_number.cgi");

}  else {
$last_num = 0;
}

my $pm_topic = $last_num + 1;
$pm_topic = &Do8Digit($pm_topic);
my $topic_directory = &random_directory;

$message = $in{message};

# if HTML is not allowed, render it useless
if ($vars_pm{html} eq 'off') {
		$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
}  else {
# don't allow HTML SCRIPT TAGS
&check_html($message);
}

$message = &CensorCheck("$message");
$message = &Truncate("$message");

$message_ascii = $message;

# do graemlins--
if ($in{disable_smilies} ne 'yes') { $message = &Smilies("$message"); }

# UBB Code-ify (if allowed)
if ($vars_pm{ubb_code} ne 'off') {

if ($vars_pm{ubb_code} eq 'images_off')  {
	$ubb_images = 'OFF';
}  else {
	$ubb_images = 'ON';
}
$message = &UBBCode("$message", "$ubb_images");
} #end if UBB Code allowed

#convert newlines/carriage returns to <br> and <p> html tags
$message = &ConvertReturns("$message");

# check for excess images-
&excess_smilies_check($message);

# escape pipestems
$message =~ s/\|/&#0124;/sg;
$in{topic_subject} =~ s/\|/&#0124;/sg;

# escape ending backslashes
if ($message =~ /\\$/) {
	$message .= ' ';
}
if ($in{topic_subject} =~ /\\$/) {
	$in{topic_subject} .= ' ';
}

# set post icon
unless ($in{msg_icon} >= 0) { 	$in{msg_icon} = '1'; }

# need to send message, subject, to, from, icon,
unless (-d "$vars_config{MembersPath}/pm_topics/$topic_directory") {
mkdir ("$vars_config{MembersPath}/pm_topics/$topic_directory", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_topics/$topic_directory");
}

# post to pm_topics directory
open (FILE, ">$vars_config{MembersPath}/pm_topics/$topic_directory/$pm_topic.cgi");
&lock;
print FILE qq!\%pm_topic_data = (\n!;
print FILE qq!subject => q|$in{topic_subject}|,\n!;
print FILE qq!replies => "0",\n!;
print FILE qq!close => "$in{close_pm}",\n!;
print FILE qq!to => "$in{u}",\n!;
print FILE qq!from => "$user_number",\n!;
print FILE qq!read => "no",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_date = (\n!;
print FILE qq!"0" => "$GotTime{HyphenDate}",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_time = (\n!;
print FILE qq!"0" => "$GotTime{Time}",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_post = (\n!;
print FILE qq!"0" => q|$message|,\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_to = (\n!;
print FILE qq!"0" => "$in{u}",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_from = (\n!;
print FILE qq!"0" => "$user_number",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_icon = (\n!;
print FILE qq!"0" => "$in{msg_icon}",\n!;
print FILE qq!);\n!;
print FILE qq!\%pm_signature = (\n!;
print FILE qq!"0" => "$in{Signature}",\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_topics/$topic_directory/$pm_topic.cgi");

# update Receiver pm_user file
# is recipient's pm box full? - also grabs %pm_user_index
&pm_check_full($in{u});

# set this for pm notify:
$in{t} = $pm_topic;
$in{d} = $topic_directory;

# %pm_user_index grabbed
my $index_number = ("$topic_directory-$pm_topic");
$pm_user_index{$index_number} = $GotTime{LastLoginJulian};

open (FILE, ">$vars_config{MembersPath}/pm_users/$in{u}.cgi");
&lock;
print FILE qq!\%pm_user_index = (\n!;

foreach $key (keys %pm_user_index) {
print FILE qq!"$key" => "$pm_user_index{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_users/$in{u}.cgi");


# update last number file:
open (FILE, ">$vars_config{MembersPath}/pm_info/pm_last_number.cgi");
&lock;
print FILE qq!$pm_topic!;
print FILE qq!\n!;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/pm_info/pm_last_number.cgi");

# update pm counter file:
if (-e "$vars_config{MembersPath}/pm_info/pm_counter.cgi") {
my $pm_counter = &OpenFileAsVar("$vars_config{MembersPath}/pm_info/pm_counter.cgi");
}  else {
$pm_counter = 0;
}
$pm_counter++;

open (FILE, ">$vars_config{MembersPath}/pm_info/pm_counter.cgi");
&lock;
print FILE qq!$pm_counter!;
print FILE qq!\n!;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/pm_info/pm_counter.cgi");

# send email notification to receiver?
chomp($pm_profile[28]);
if (($pm_profile[28] ne 'no') && ($vars_email{UseEmail} eq 'ON')) {

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";

require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{pm_notify}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne 'ascii') {
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{pm_notify_html}" . qq!</FONT>!;
$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}

chomp($pm_profile[2]);

&ubb_mail("$pm_profile[2]", "$vars_display{BBEmail}", "", "$vars_wordlets_email{pm_notify_subject} : $in{topic_subject} : $pubname", "$email_message", "$html_message", '');

}

require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{private_message}.cgi";

# no cache to clear!
# on screen
if ($in{refer} eq '') { $in{refer} = "$vars_config{CGIURL}/ultimatebb.cgi"; }
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$in{refer}", "$vars_wordlets{thanks_for_pm}", "$in{refer}");
exit;
} # end submit pm


sub submit_pm_reply {
local(%pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_to, %pm_from, %pm_signature, @pm_profile, @user_profile, $ip_number, $j, $pm_to_name, @ip_banlist, %pm_user_index, $html_body, $last_num, $email_message, $html_message, $ubb_images);
local(*FILE);

# is user banned?
$ip_number = $ENV{'REMOTE_ADDR'};
&check_ip_bans;

#validate
my @ValidateArray = ("d", "t", "message");
&Validate(@ValidateArray);


# get pm topic!
if (-e "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi") {
require "$vars_config{MembersPath}/pm_topics/$in{d}/$in{t}.cgi";
}  else {
	&StandardHTML("$vars_wordlets_err{no_such_pm}");
}

# are add'l replies allowed?
if ($pm_topic_data{replies} == 20) {
	&StandardHTML("$vars_wordlets{pm_full_explained}");
}

# can't reply to self
if ($user_number eq "$pm_topic_data{from}") {
	&StandardHTML("$vars_wordlets{cant_reply_to_self}");
}

# is user on ignore?
&check_ignore($pm_topic_data{from});

# get profile for PM Sender
@user_profile = &verify_id_num($username, $password, $user_number);

# get profile for PM Receiver
@pm_profile = &OpenProfile($pm_topic_data{from});

# does receiver want to receive PM?
chomp($pm_profile[27]);
if ($pm_profile[27] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_off_for_member}");
}

# get name of person sending PM to:
chomp($pm_profile[0]); chomp($pm_profile[15]);
$pm_to_name = $pm_profile[15];
if ($pm_to_name eq '') { $pm_to_name = $pm_profile[0]; }

# check to see if PM set to leaders_only
if (($vars_pm{feature} eq 'leaders_only') && (($pm_profile[8] ne 'Administrator') && ($pm_profile[8] ne 'Moderator')))  {
	&StandardHTML("$vars_wordlets_err{pm_only_leaders}");
}

# has admin disabled PM for sender?
chomp($user_profile[29]);
if ($user_profile[29] eq 'no') {
&StandardHTML("$vars_wordlets_err{pm_ban}");
}

# is topic closed?
if ($pm_topic_data{close} eq 'yes') {
&StandardHTML("$vars_wordlets_err{topic_closed}");
}

# floodcheck
if ($vars_misc{FloodCheck} eq 'ON') {
#floodcheck courtesy of Michael Farris
chomp($user_profile[8]);
   &floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
}

# determine last PM number and increment by 1
if (-e "$vars_config{MembersPath}/pm_info/pm_last_number.cgi") {
  $last_num = &OpenFileAsVar("$vars_config{MembersPath}/pm_info/pm_last_number.cgi");

}  else {
$last_num = 0;
}

$message = $in{message};

# if HTML is not allowed, render it useless
if ($vars_pm{html} eq 'off') {
		$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
}  else {
# don't allow HTML SCRIPT TAGS
&check_html($message);
}

$message = &CensorCheck("$message");
$message = &Truncate("$message");

$message_ascii = $message;

# do graemlins--
if ($in{disable_smilies} ne 'yes') { $message = &Smilies("$message"); }

# UBB Code-ify (if allowed)
if ($vars_pm{ubb_code} ne 'off') {

if ($vars_pm{ubb_code} eq 'images_off')  {
	$ubb_images = 'OFF';
}  else {
	$ubb_images = 'ON';
}
$message = &UBBCode("$message", "$ubb_images");
} #end if UBB Code allowed

#convert newlines/carriage returns to <br> and <p> html tags
$message = &ConvertReturns("$message");

# check for excess images-
&excess_smilies_check($message);
# escape pipestems
$message =~ s/\|/&#0124;/sg;
if ($message =~ /\\$/) {  $message .= ' '; }

# set post number
my $thispost = $pm_topic_data{replies} + 1;
$pm_post{$thispost} = $message;

# set post icon
unless ($in{msg_icon} >= 0) { 	$in{msg_icon} = '1'; }
$pm_icon{$thispost} = $in{msg_icon};

# set to/from
$pm_to{$thispost} = $pm_topic_data{from};
$pm_from{$thispost} = $pm_topic_data{to};
$pm_topic_data{to} = $pm_to{$thispost};
$pm_topic_data{from} = $pm_from{$thispost};

# other fields...
$pm_signature{$thispost} = $in{Signature};
$pm_date{$thispost} = $GotTime{HyphenDate};
$pm_time{$thispost} = $GotTime{Time};
$pm_topic_data{replies} = $thispost;

# make sure topic dir exists
unless (-d "$vars_config{MembersPath}/pm_topics/$in{d}") {
mkdir ("$vars_config{MembersPath}/pm_topics/$in{d}", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_topics/$in{d}");
}

# is recipient's pm box full? - also grabs %pm_user_index
&pm_check_full($pm_topic_data{to});

# update pm topic file
&update_pm_topic($in{d}, $in{t});

# update Receiver pm_user file
# %pm_user_index grabbed
my $index_number = ("$in{d}-$in{t}");
$pm_user_index{$index_number} = $GotTime{LastLoginJulian};

open (FILE, ">$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi");
&lock;
print FILE qq!\%pm_user_index = (\n!;

foreach $key (keys %pm_user_index) {
print FILE qq!"$key" => "$pm_user_index{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_users/$pm_topic_data{to}.cgi");

# update sender's user index - remove this topic
undef(%pm_user_index);
if (-e "$vars_config{MembersPath}/pm_users/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_users/$user_number.cgi";
}

open (FILE, ">$vars_config{MembersPath}/pm_users/$user_number.cgi");
&lock;
print FILE qq!\%pm_user_index = (\n!;

foreach $key (keys %pm_user_index) {
unless ($key eq "$index_number") {
print FILE qq!"$key" => "$pm_user_index{$key}",\n!;
}
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_users/$user_number.cgi");


# update pm counter file:
if (-e "$vars_config{MembersPath}/pm_info/pm_counter.cgi") {
my $pm_counter = &OpenFileAsVar("$vars_config{MembersPath}/pm_info/pm_counter.cgi");
}  else {
$pm_counter = 0;
}
$pm_counter++;
open (FILE, ">$vars_config{MembersPath}/pm_info/pm_counter.cgi");
&lock;
print FILE qq!$pm_counter!;
print FILE qq!\n!;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/pm_info/pm_counter.cgi");

# send email notification to receiver?
chomp($pm_profile[28]);
if (($pm_profile[28] ne 'no') && ($vars_email{UseEmail} eq 'ON')) {

$in{topic_subject} = $pm_topic_data{subject};

require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

if ($vars_email{email_format} ne 'html') {
$email_message = qq!$vars_wordlets_email{pm_notify}!;
} else {
$email_message = '';
}

if ($vars_email{email_format} ne 'ascii') {
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{pm_notify_html}" . qq!</FONT>!;
$html_message = "$EmailHeader $html_body $Footer";
} else {
$html_message = '';
}

chomp($pm_profile[2]);
&ubb_mail("$pm_profile[2]", "$vars_display{BBEmail}", '', "$vars_wordlets_email{pm_notify_subject} : $pm_topic_data{subject} : $pubname", "$email_message", "$html_message", '');

}


# no cache to clear!

# on screen
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile", "$vars_wordlets{thanks_for_pm}", "$vars_wordlets{my_profile_header}");
} # end submit_pm_reply

sub random_directory {
my @letters = ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'Y', 'Z');
srand(time);
my $num1 = rand(@letters);
return($letters[$num1]);
}

sub make_pm_dirs {
unless (-d "$vars_config{MembersPath}/pm_users") {
mkdir ("$vars_config{MembersPath}/pm_users", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_users");
}
unless (-d "$vars_config{MembersPath}/pm_topics") {
mkdir ("$vars_config{MembersPath}/pm_topics", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_topics");
}
unless (-d "$vars_config{MembersPath}/pm_info") {
mkdir ("$vars_config{MembersPath}/pm_info", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_info");
}
unless (-d "$vars_config{MembersPath}/pm_ignore") {
mkdir ("$vars_config{MembersPath}/pm_ignore", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_ignore");
}
unless (-d "$vars_config{MembersPath}/pm_buddy") {
mkdir ("$vars_config{MembersPath}/pm_buddy", 0777);
chmod(0777, "$vars_config{MembersPath}/pm_buddy");
}
} # end make_pm_dirs


sub pm_prune {
local($key, %pm_user_index, $pm_dir, $pm_topic, $this_key);

# grab pm_users file
if (-e "$vars_config{MembersPath}/pm_users/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_users/$user_number.cgi";
}  else {
&StandardHTML("$vars_wordlets_err{pm_nothing_to_delete}");
}

# delete from user record and delete actual pm topic
my $pm_prune_count = 0;

foreach $key(keys %in) {
if ($key =~ /delete/) {
$pm_prune_count++;
$this_key = $in{$key};
delete($pm_user_index{$this_key});
($pm_dir, $pm_topic) = split(/-/, $this_key);
unlink("$vars_config{MembersPath}/pm_topics/$pm_dir/$pm_topic.cgi");
}
}

# update user index file

open (FILE, ">$vars_config{MembersPath}/pm_users/$user_number.cgi");
&lock;
print FILE qq!\%pm_user_index = (\n!;

foreach $key (keys %pm_user_index) {
print FILE qq!"$key" => "$pm_user_index{$key}",\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);

chmod (0666, "$vars_config{MembersPath}/pm_users/$user_number.cgi");

# in case they did not select any PMs to delete--
unless ($pm_prune_count > 0) {
&StandardHTML("$vars_wordlets_err{no_pm_selected}");
}

# on screen confirmation
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile", "$vars_wordlets{thanks_for_pm_prune}", "$vars_wordlets{my_profile_header}");
} # end pm_prune

# DANGER: Do not remove the next line!
1;