# UBB Profile Routines : Perl Code

# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{profile}.cgi";

$direct_to = qq~

<script LANGUAGE="javascript">
<!--
function ignore()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_ignore&u=$in{u}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=275,height=200,top=200,left=200');
}
function buddy()
{
var listWindow = window.open('$vars_config{CGIURL}/ultimatebb.cgi?ubb=do_buddy&u=$in{u}','_blank','toolbar=no, menubar=no,location=no,directories=no,status=no,width=275,height=200,top=200,left=200');
}
//-->
</script>

~;


&set_page_elements;

sub my_rating_list {
local(%user, $key, $star_level, @level_1, @level_2, @level_3, @level_4, @level_5, $profiler, $level_1, $level_2, $level_3, $level_4, $level_5, $this_rating_list, $this_name);

# user must be logged in!
unless ($username ne '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
}

# grab user_rater hash
if (-e "$vars_config{MembersPath}/user_raters/$user_number.cgi") {
require "$vars_config{MembersPath}/user_raters/$user_number.cgi";
}

# sort by level:
foreach $key(keys %user) {
if (-e "$vars_config{MembersPath}/$key.cgi") {
	$this_name = &get_public_name($key);
	$profiler = qq!<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$key" target=_blank>$this_name</A>!;


if ($user{$key} == 1) {
	push(@level_1, $profiler);
}
elsif ($user{$key} == 2) {
	push(@level_2, $profiler);
}
elsif ($user{$key} == 3) {
	push(@level_3, $profiler);
}
elsif ($user{$key} == 4) {
	push(@level_4, $profiler);
}  else {
	push(@level_5, $profiler);
}
} # unless profile exists!
}

# assemble var lines
$level_1 = join(", ", @level_1);
$level_2 = join(", ", @level_2);
$level_3 = join(", ", @level_3);
$level_4 = join(", ", @level_4);
$level_5 = join(", ", @level_5);

# display my profile page
do "$vars_config{NonCGIPath}/Templates/public_rating_list.pl";

} # end my_rating_list

sub my_profile {
local(@user_profile, $chompee, $count, $overall_rating, $rating_wording, %votes, %totals, %avg, %weighted_avg, %pm_user_index, @pm_topics, $pm_dir, $pm_topic, %pm_topic, %pm_topic_data, %pm_date, %pm_time, %pm_post, %pm_icon, %pm_signature, %pm_to, %pm_from, %user, $user_public_name, $key, $star, $read_marker_1, $read_marker_2, $pm_count);

# retrieve profile

# user must be logged in!
unless ($username ne '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
}

# verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);
$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]); $count++;
}

# get rating:
if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {

if (-e "$vars_config{MembersPath}/user_ratings/$user_number.cgi") {
require "$vars_config{MembersPath}/user_ratings/$user_number.cgi";
$overall_rating = &round_up($weighted_avg{total});
}  else {
	$overall_rating = '';
}
}

if ($overall_rating ne '') {
	$overall_rating = ("user_ratings_" . "$overall_rating");
	$overall_rating = qq!<IMG SRC="$vars_config{NonCGIURL}/$vars_style{$overall_rating}" BORDER=0>!;
}  else {
	$overall_rating = "$vars_wordlets{not_rated}";
}


if ($vars_display{user_ratings} ne 'off') {
	$rating_wording = "$vars_wordlets{ratings_featured_only}";
}

# grab user_rater hash
if (-e "$vars_config{MembersPath}/user_raters/$user_number.cgi") {
require "$vars_config{MembersPath}/user_raters/$user_number.cgi";
}

# get pm topics for user
if (-e "$vars_config{MembersPath}/pm_users/$user_number.cgi") {
require "$vars_config{MembersPath}/pm_users/$user_number.cgi";
}

# sort %pm_user_index
@pm_topics = sort { $pm_user_index{$b} <=> $pm_user_index{$a} } keys %pm_user_index;


# pm max warning
$pm_count = 0;
foreach $key(keys %pm_user_index) {
$pm_count++;
}

# display my profile page
do "$vars_config{NonCGIPath}/Templates/public_my_profile.pl";

} # end my_profile

sub rate_member {
local($update, %user, %votes, %totals, %avg, %weighted_avg, $key, $rater_rating);
local(*FILE);

# are ratings permitted?
if ($vars_display{user_ratings} eq 'off') {
&StandardHTML("$vars_wordlets_err{ratings_off}");
}

# validate
my @ValidateArray = ("u", "rating");
&Validate(@ValidateArray);

# extra test
unless (($in{u} > 0) && ($in{rating} > 0)) {
&StandardHTML("$vars_wordlets_err{bad_input}");
}

# format ratee number
my $ratee = &Do8Digit($in{u});

# make sure rater is logged in!
if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a>!);
}

# you can't rate yourself!
if ($ratee eq "$user_number") { &StandardHTML("$vars_wordlets_err{cant_rate_self}");
}

# make sure profile is still there
unless ((-e "$vars_config{MembersPath}/$ratee.cgi")  && ($ratee ne ''))  {
&StandardHTML("$vars_wordlets_err{member_gone}");
}

# get raters history or ratings
if (-e "$vars_config{MembersPath}/user_raters/$user_number.cgi") {

require "$vars_config{MembersPath}/user_raters/$user_number.cgi";
if (exists($user{"$ratee"})) {
# rater has already rated this person!
&StandardHTML("$vars_wordlets_err{rated_previously}");
}
}

$user{$ratee} = $in{rating};

# update user_raters file:
open(FILE, ">$vars_config{MembersPath}/user_raters/$user_number.cgi");
&lock;
print FILE qq!\%user = (\n!;
foreach $key (keys %user) {
print FILE qq!"$key" => "$user{$key}",\n!;
}
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/user_raters/$user_number.cgi");

# get rater's rating:
if (-e "$vars_config{MembersPath}/user_ratings/$user_number.cgi") {
require "$vars_config{MembersPath}/user_ratings/$user_number.cgi";
$rater_rating = &round_up($weighted_avg{total});
}  else {
$rater_rating = '0';
}

undef(%votes); undef(%totals); undef(%avg); undef(%weighted_avg);

# update ratee ratings
if (-e "$vars_config{MembersPath}/user_ratings/$ratee.cgi") {
require "$vars_config{MembersPath}/user_ratings/$ratee.cgi";
}

# update values for this rating group
if (exists($votes{$rater_rating})) {
$votes{$rater_rating}++;
$totals{$rater_rating} = $totals{$rater_rating} + $in{rating};
$avg{$rater_rating} = $totals{$rater_rating} / $votes{$rater_rating};
$avg{$rater_rating} = &Do2Decimal($avg{$rater_rating});
$weighted_avg{$rater_rating} = $avg{$rater_rating} * $weights{$rater_rating};

}  else {
$votes{$rater_rating} = '1';
$totals{$rater_rating} = $in{rating};
$avg{$rater_rating} = $in{rating};
$weighted_avg{$rater_rating} = $avg{$rater_rating} * $weights{$rater_rating};
}

$weighted_avg{$rater_rating} = &Do2Decimal($weighted_avg{$rater_rating});

# calculate unweighted average
$votes{total} = $votes{0} + $votes{1} + $votes{2} + $votes{3} + $votes{4} + $votes{5};

$totals{total} = $totals{0} + $totals{1} + $totals{2} + $totals{3} + $totals{4} + $totals{5};

$avg{total} = $totals{total} / $votes{total};

# calculate new total weighted average
# fill in blanks...
for(0..5) {
unless (exists($votes{$_})) {
$votes{$_} = '0'; $totals{$_} = '0'; $avg{$_} = 'N/A'; $weighted_avg{$_} = $avg{total} * $weights{$_};
$weighted_avg{$_} = &Do2Decimal($weighted_avg{$_});
}
}

$weighted_avg{total} = $weighted_avg{0} + $weighted_avg{1} + $weighted_avg{2} + $weighted_avg{3} + $weighted_avg{4} + $weighted_avg{5};

# format it
$weighted_avg{total} = &Do2Decimal($weighted_avg{total});

# print to ratings file!
open(FILE, ">$vars_config{MembersPath}/user_ratings/$ratee.cgi");
&lock;
print FILE qq!\%votes = (\n!;
foreach $key (keys %votes) {
print FILE qq!"$key" => "$votes{$key}",\n!;
}
print FILE qq!);\n!;
print FILE qq!\n!;

print FILE qq!\%totals = (\n!;
foreach $key (keys %totals) {
print FILE qq!"$key" => "$totals{$key}",\n!;
}
print FILE qq!);\n!;
print FILE qq!\n!;

print FILE qq!\%avg = (\n!;
foreach $key (keys %avg) {
print FILE qq!"$key" => "$avg{$key}",\n!;
}
print FILE qq!);\n!;
print FILE qq!\n!;

print FILE qq!\%weighted_avg = (\n!;
foreach $key (keys %weighted_avg) {
print FILE qq!"$key" => "$weighted_avg{$key}",\n!;
}
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$vars_config{MembersPath}/user_ratings/$ratee.cgi");


# get member name
my @user_profile = &OpenProfile($ratee);
chomp($user_profile[15]);
my $member_name = $user_profile[15];
if ($member_name eq '') { $member_name = $user_profile[0]; }
chomp($member_name);

if ($in{refer} eq '') {
$in{refer} = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$ratee";
}

# on screen confirmation
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$in{refer}", "$vars_wordlets{thanks_for_rating}", "$in{refer}");
exit;

} # end rate_member

sub edit_my_profile {
local(@user_profile, $logged_in_status, $days, %select_list, $chompee, $mm_yes, $mm_no, $ev_yes, $ev_no, $count, $email_verify_requirement, $Signature, $user_public_name, $update_wording, $update_name, $update_un, $user_status, $update_date, $pm_yes, $pm_no, $pm_notify_yes, $pm_notify_no);


require "$vars_config{CGIPath}/ubb_lib_posting.cgi";
# lib required for reverse_ubb_code

# user must be logged in!
unless ($username ne '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!);
}

# verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);
$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]);
$count++;
}

# is profile locked?
if ($user_profile[24] eq 'yes') {
&StandardHTML(qq!$vars_wordlets_err{profile_locked}!);
}

# custom status
$user_status = &CustomTitle($user_profile[8]);

# request for user's own profile
$in{u} = $user_number;

# calibrate topic view
$days = $user_profile[21];
if ($days eq '') { $days = $vars_display{DaysPruneDefault}; }
foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)){
$select_list{$_}='';
}
$select_list{$days} = 'SELECTED';

# calibrate mass mail
if ($user_profile[14] eq 'yes') { $mm_yes = 'CHECKED'; $mm_no = ''; }
else { $mm_no = 'CHECKED';  $mm_yes =''; }

# calibrate email view mail
if ($user_profile[11] eq 'yes') { $ev_yes = 'CHECKED';  $ev_no = ''; }
else {$ev_no = 'CHECKED'; $ev_yes = ''; }

# calibrate user ratings option
if ($user_profile[25] eq 'no') { $ratings_no = 'CHECKED';  $ratings_yes = ''; }
else {$ratings_yes = 'CHECKED'; $ratings_no = ''; }

# calibrate pm option
if ($user_profile[27] eq 'no') { $pm_no = 'CHECKED';  $pm_yes = ''; }
else {$pm_yes = 'CHECKED'; $pm_no = ''; }

# calibrate pm notify option
if ($user_profile[28] eq 'no') { $pm_notify_no = 'CHECKED';  $pm_notify_yes = ''; }
else {$pm_notify_yes = 'CHECKED'; $pm_notify_no = ''; }

# convert signature
$Signature = &reverse_ubb_code("$user_profile[12]");
$Signature =~ s/<p>/\n\r\n/isg;
$Signature =~ s/<br>/\n/isg;

# check for last update
if ($user_profile[23] ne '') {
($update_name, $update_un, $update_date) = split(/\|\^\|/, $user_profile[23]);

#format date
$update_date = &DateFormat($update_date);

$update_wording = qq!$vars_wordlets{profile_update_stamp} <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile&u=$update_un">$update_name</A> ($update_date)!;

} # last update check

if ($user_profile[15] eq '') { $user_profile[15] = $user_profile[0]; }

# display profile info
do "$vars_config{NonCGIPath}/Templates/public_edit_profile.pl";


exit;

} # end edit_my_profile


sub get_profile {
local(@user_profile, $user_public_name, $user_status, $count, $chompee, $date_registered, $reg_month, $reg_day, $reg_year, @themonths, @viewer_profile, $is_admin_mod, $u, $rating_line, $overall_rating, $admin_view_rating, %user, $personal_line, $personal_rating, $user_ratings_off, %votes, %totals, %avg, %weighted_avg, $pm_line, %pm_ignore, %pm_buddy, $total_votes, $add_2_list);

# get requested profile
@user_profile = &OpenProfile($in{u});
$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]);
$count++;
}

# set rating line
if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {
$rating_line = qq!
<SELECT NAME="rating">
	<OPTION value=''>$vars_wordlets{rate_member}
	<OPTION value='5'>$vars_wordlets{member_rating_5}
	<OPTION value='4'>$vars_wordlets{member_rating_4}
	<OPTION value='3'>$vars_wordlets{member_rating_3}
	<OPTION value='2'>$vars_wordlets{member_rating_2}
	<OPTION value='1'>$vars_wordlets{member_rating_1}
</SELECT> <INPUT TYPE="SUBMIT" NAME="Submit" VALUE="$vars_wordlets{rate}">
!;
}  else {
	$rating_line = '';
}

$u = $in{u} + 0; # get rid of extra zeros
my $u_formatted = &Do8Digit($u);

# custom status
$user_status = &CustomTitle($user_profile[8]);

# set public_name
if ($user_profile[15] eq '') {
$user_public_name = $user_profile[0];
} else {
$user_public_name = $user_profile[15];
}

# set registration date (in proper format)
($reg_month, $reg_day, $reg_year) = split(/-/, $user_profile[10]);


# get user rating?
if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no')) {
($overall_rating, $total_votes) = &get_rating($u);
$admin_view_rating = $overall_rating;
if (($vars_display{user_ratings} eq 'feature_top') && ($overall_rating < 4)) {
$overall_rating = '';
}
}

# is this an admin or mod that is viewing?
if ($username ne '') {
# verify cookie id
@viewer_profile = &verify_id_num($username, $password, $user_number);
chomp($viewer_profile[8]);
if (($viewer_profile[8] eq 'Administrator') || ($viewer_profile[8] eq 'Moderator')) {
$is_admin_mod = 'true';
} else {
$is_admin_mod = 'false';
}

# viewing your own record.. if so, can't rate yourself
if ($user_number eq "$u_formatted") { 	$rating_line = ''; }

# has viewer rated this person?
if (-e "$vars_config{MembersPath}/user_raters/$user_number.cgi") {

require "$vars_config{MembersPath}/user_raters/$user_number.cgi";

if (exists($user{$u_formatted})) {
	$personal_rating = $user{$u_formatted};
	$rating_line = '';
}  else {
	$personal_rating = '';
}
# in case user has disabled ratings...
 if ($user_profile[25] eq 'no') {  	$personal_rating = '';  }

} # if viewer has user rater file



}  else {
$is_admin_mod = 'false';
$rating_line = ''; $personal_rating = '';
} # end admin/mod check

if ($user_profile[10] eq '') {

$date_registered = "$vars_wordlets{pre_reg_date_wording}";

} else {

$date_registered = &DateFormat($user_profile[10]);

}

#make personal_line?
if (($personal_rating ne '') && ($vars_display{user_ratings} ne 'off')) {
	my $stars = ("user_ratings_" . "$personal_rating");
	$personal_line = qq!
$vars_wordlets{personal_rating} <IMG SRC="$vars_config{NonCGIURL}/$vars_style{$stars}" BORDER=0>
	!;
}

if ($admin_view_rating ne '') {
	$admin_view_rating = ("user_ratings_" . "$admin_view_rating");
	$admin_view_rating = qq!<IMG SRC="$vars_config{NonCGIURL}/$vars_style{$admin_view_rating}" BORDER=0>!;
} else {
$admin_view_rating = $vars_wordlets{not_rated};
}
if ($overall_rating ne '') {
	$overall_rating = ("user_ratings_" . "$overall_rating");
}

if (($user_profile[25] eq 'no') && ($vars_display{user_ratings} ne 'off'))  {
	$user_ratings_off = $vars_wordlets{user_turned_off_ratings};
}
elsif ($vars_display{user_ratings} eq 'off') {
	$user_ratings_off = $vars_wordlets{admin_turned_off_ratings};
}  else {
	$user_ratings_off = '';
}

# pm?
if (($user_profile[27] ne 'no') && ($vars_pm{feature} ne 'off')) {
unless ( ($vars_pm{feature} eq 'leaders_only') && (($user_profile[8] ne 'Administrator') && ($user_profile[8] ne 'Moderator')) ) {
$pm_line = qq! | <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=private_message&u=$in{u}">$vars_wordlets{send_private_message}</A>!;
}
} # end pm check

# list check
if ($user_number > 0) {
$add_2_list = &list_check("$in{u}");
$add_2_list = "$user_public_name: $add_2_list";
} else {
$add_2_list = '';
}

if ($rating_line eq '') { $rating_line = '&nbsp;'; }

# display limited profile info
do "$vars_config{NonCGIPath}/Templates/public_display_profile.pl";

exit;

} # end get_profile

sub edit_profile {
local($count, @user_profile, $user_status, $chompee, $old_public_name);

# user must be logged in!
unless ($username ne '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!);
}

# verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);

$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]);
$count++;
}

# set current public name (so we can compare later)
$old_public_name = $user_profile[15];

if (($user_profile[8] eq 'Administrator') || ($in{u} == $user_number)) {

# authorized editor
&update_profile;

}  else {

# unauthorized editor
&StandardHTML("$vars_wordlets_err{cant_edit_profile}");

}


} # end edit_profile

sub update_profile {
local($pub_warning, $email, $new_password, $sig_html, $public_name, $ubb_code_images, $sig, $subject, $text_message, $html_message, $modify_warning, $lc_old_email, $lc_email, $j, $this_email, $theemail, $checkemail, $html_message, $lc_it, $old_email, $dos, $thisnum, @amend, $checker, $NewLine, $logoff, $lc_un, $lc_old_public_name, $lc_new_public_name);

# make sure user is approved (mod reg)
if ($user_profile[4] !~ /Write/i) {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

	&StandardHTML("$vars_wordlets_err{user_not_approved}");
}


# clean up, validate, & ensure that this profile can be updated
foreach $key (keys %in) {
# rem HTML and unclosed tags
$in{$key} =~ s/(__)(\w+)(__)/_ $2 _ /g; #rem IIS exploit
unless ( ($key eq 'password') ) {
$in{$key} =~ s/<.*?>//sg;
$in{$key} =~ s/</&lt;/sg;  $in{$key} =~ s/>/&gt;/g;

unless ($key eq 'signature') {
$in{$key} =~ s/\s+/ /sg;
$in{$key} =~ s/"/&quot\;/sg;
}
}
} # foreach key

# make sure size is ok
if ( (length($in{public_name}) > 35) || (length($in{password}) > 13) ) {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

	&StandardHTML("$vars_wordlets_err{name_too_long}");
}

# check email
my $email_test = &email_test($in{email});
if ($email_test eq 'n') {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{email_invalid}");
}

# clean email
$email = $in{email}; $email =~ s/\s+//g;

# check password --
if ($in{password} =~ m/__\w+__/) {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

	&StandardHTML("$vars_wordlets_err{password_error}");
}

# lc email for dupe checks later
$lc_email = lc($email);
$old_email =  $user_profile[2];
$lc_old_email = lc($old_email);

# validate
my @VA = ("email", "password", "u");

if ($vars_registration{location_field_use} eq 'REQ') { push(@VA, "location"); }
if ($vars_registration{occupation_field_use} eq 'REQ') { push(@VA, "occupation"); }
if ($vars_registration{picture_field_use} eq 'REQ') { push(@VA, "picture"); }
if ($vars_registration{homepage_field_use} eq 'REQ') { push(@VA, "homepage"); }
if ($vars_registration{interests_field_use} eq 'REQ') { push(@VA, "interests"); }
if ($vars_registration{signature_field_use} eq 'REQ') { push(@VA, "signature"); }
if ($vars_registration{icq_field_use} eq 'REQ') { push(@VA, "icq"); }
if ($vars_registration{aim_field_use} eq 'REQ') { push(@VA, "aim"); }


if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push(@VA, "customfield1"); }
if (($vars_registration{custom2_field_use} eq 'REQ') && ($vars_registration{customfield2} ne '')) { push(@VA, "customfield2"); }
if (($vars_registration{custom3_field_use} eq 'REQ') && ($vars_registration{customfield3} ne '')) { push(@VA, "customfield3"); }
if (($vars_registration{custom4_field_use} eq 'REQ') && ($vars_registration{customfield4} ne '')) { push(@VA, "customfield4"); }

&Validate(@VA);

# if displayed name is changing, need to make sure it is unique
# clean up public name input:
if (exists($in{public_name})) {

&illegal_name_check($in{public_name});
$public_name = &name_clean($in{public_name});

# lc checks
$lc_un = lc($user_profile[0]);
$lc_un = &name_clean($lc_un);
$old_public_name = &name_clean($old_public_name);

$lc_old_public_name = lc($old_public_name);
$lc_new_public_name = lc($public_name);

# are we changing the public name? if so, need to check it!
if (($lc_new_public_name ne "$lc_old_public_name") && ($lc_new_public_name ne "$lc_un")) {

my @pubs = &OpenFileAsArray("$vars_config{MembersPath}/public_names.cgi");

CHECKPUBS: foreach (@pubs) {
chomp($_);
$lc_it = lc($_);
if ($lc_new_public_name eq "$lc_it") {
$public_name = $old_public_name;
if ($public_name eq '') { $public_name = $user_profile[0]; }
$pub_warning = "$vars_wordlets{public_name_warning}";
last CHECKPUBS;
}
}

# check against login names too:
if ($pub_warning eq '') {

my @login_names = &GetMemberListArray;

CHECKLOGINS: for (@login_names) {
	$lc_it = lc($_);
	if ($lc_new_public_name eq "$lc_it") {
	$pub_warning = "$vars_wordlets{public_name_warning}";
	$public_name = $old_public_name;
	if ($public_name eq '') { $public_name = $user_profile[0]; }
	last CHECKLOGINS;
	}
}

}

} # end if need to check public_names


}  else {
$public_name = $user_profile[15];
my $lc_old_public_name = lc($old_public_name);
my $lc_new_public_name = lc($public_name);
my $lc_un = lc($user_profile[0]);
$lc_un = &name_clean($lc_un);
}


# is email banned?
&check_email_bans($lc_email);

# dupicate email check
if (($lc_email ne "$lc_old_email") && ($vars_registration{EmailCheck} eq 'true')) {

my @EmailList = &GetEmails;

CHECKEMAIL: for $this_email(@EmailList) {
($theemail, $j) = split(/\?\?/, $this_email);
$checkemail = lc($theemail);
if ($lc_email eq "$checkemail") {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

	&StandardHTML("$vars_wordlets_err{dupe_email}");
	last CHECKEMAIL;
} #end if regemail
} # end foreach


} # end dupe email check

# generate password & send by email, if necessary
if (($vars_registration{EmailVerify} eq 'ON') && ($lc_email ne "$lc_old_email")) {
		$new_password = &GeneratePassword;
		# need to log this user off, since PW is changing!
		$logoff = qq~?ubb=logoff~;

		# make sure email is activated!
		if ($vars_email{UseEmail} ne 'ON') {
			#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

			&StandardHTML("$vars_wordlets_err{email_not_on_for_reg}");
		}

		# generate password
		$new_password = &GeneratePassword;

		# send email!
		# set email template
		require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
		&set_page_elements;

		require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";
		require "$vars_config{CGIPath}/ubb_lib_mail.cgi";

		$subject = "$vars_config{BBName}: $vars_wordlets_email{new_password_subject}";

		if ($vars_email{email_format} ne 'html') {
			$text_message = "$vars_wordlets_email{new_password_text}";
		} else {
			$text_message = '';
		}

		if ($vars_email{email_format} ne 'ascii') {
		my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{new_password_html}" . qq!</FONT>!;
		$html_message = "$EmailHeader $html_body $Footer";
		}  else {
		$html_message = '';
		}

		&ubb_mail("$email", "$vars_registration{RegsAdminEmail}", "", "$subject", "$text_message", "$html_message", "");


		$modify_warning = "Note: Because you changed your email address, and because we require email verification, a new password has been issued to you.  This new password has been sent to: $email.  You may change your password, but you may not change your password and email address at the same time.  Thank you!";

} # end automatic pw change due to email verify...

 # assuming pw has not been generated...
if ($logoff eq '') {  $new_password = $in{password}; }

# set new cookie, if necessary
if (($lc_email ne "$lc_old_email") || ($new_password ne "$user_profile[1]") || ($public_name ne "$old_public_name") ) {
my $cookie2 = cookie(-name=> "ubber$vars_config{Cookie_Number}", -value=> [$user_profile[0], $new_password, $public_name, $in{DaysPrune}, $in{u}], -path=> '/', -expires=> '+2y');
print header(
	-cookie=>[$cookie2],
	-charset => "",
	-type => "text/html",
	);

}  else {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

}


$username = $user_profile[0];

# get assigned style template for profiles!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{profile}.cgi";

&set_page_elements;

# add new public name to list, assuming we can
if (($lc_new_public_name ne "$lc_old_public_name") && ($lc_new_public_name ne "$lc_un") && ($pub_warning eq '') ) {
open (FILE, ">>$vars_config{MembersPath}/public_names.cgi");
&lock;
	print FILE "$public_name\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/public_names.cgi");
}


# if email is changing, update emailfile.cgi
undef(@amend);
if ($lc_email ne "$lc_old_email") {

my @emailsfile = &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");

$lc_old_email =~ s/([\.|\@])/\\$1/isg;

foreach $checker(@emailsfile) {
chomp($checker);

if ($checker =~ m/^$lc_old_email\|\|/i) {
	($j, $thisnum) = split(/\|\|/, $checker);
	$NewLine = "$lc_email||$thisnum";
	push(@amend, $NewLine);
} else {
	push(@amend, $checker);
}
}

open(FILE, ">$vars_config{MembersPath}/emailfile.cgi");
&lock;
foreach $dos(@amend) {
chomp($dos);
print FILE "$dos\n";
}
&unlock;
close(FILE);
chmod (0666, "$vars_config{MembersPath}/emailfile.cgi");
}

# prep sig - prevent HTML, strip returns, do UBB Code
$sig = &CensorCheck($in{signature});
$sig =~ s/(<IMG SRC)(.*?)(>)//isg;


# remove leading/trainling whitespace
$sig =~ s/^\s+//; $sig =~ s/\s+$//;

$sig_html = &ConvertReturns($sig);
if ($vars_display{AllowSignatureImage} eq 'no'){
$ubb_code_images = 'no';
} else {
$ubb_code_images = 'yes';
}
$sig_html = &UBBCode("$sig_html");

# update registration file

open (FILE, ">$vars_config{MembersPath}/$in{u}.cgi") or die("Unable to open Members directory.");
&lock;
	print FILE ("$user_profile[0]\n");
	print FILE ("$new_password\n");
	print FILE ("$email\n");
	print FILE ("$in{homepage}\n");
	print FILE ("$user_profile[4]\n");
	print FILE ("$in{occupation}\n");
	print FILE ("$in{location}\n");
	print FILE ("$user_profile[7]\n");
	print FILE ("$user_profile[8]\n");
	print FILE ("$in{interests}\n");
	print FILE ("$user_profile[10]\n");
	print FILE ("$in{EmailView}\n");
	print FILE ("$sig_html\n");
	print FILE ("$in{icq}\n");
	print FILE ("$in{AllowMassMail}\n");
	print FILE ("$public_name\n");
	print FILE ("$in{customfield1}\n");
	print FILE ("$in{customfield2}\n");
	print FILE ("$in{customfield3}\n");
	print FILE ("$in{customfield4}\n");
	print FILE ("$in{picture}\n");
	print FILE ("$in{DaysPrune}\n");
	print FILE ("$in{aim}\n");
	print FILE ("$pubname|^|$user_number|^|$GotTime{HyphenDate}\n");
	print FILE ("$user_profile[24]\n");
	print FILE ("$in{user_ratings}\n");
	print FILE ("$user_profile[26]\n");
	print FILE ("$in{private_message}\n");
	print FILE ("$in{private_message_notify}\n");
	print FILE ("$user_profile[29]\n");
&unlock;
close (FILE);
chmod (0777, "$vars_config{MembersPath}/$in{u}.cgi");

# take viewer back to forum
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi$logoff", "$vars_wordlets{profile_updated} <P>$pub_warning<P>$modify_warning", "$vars_config{BBName}");
exit;
} # end update_profile sr

sub email_user {
local(@user_profile, $user_email, $pub_name, $un);

@user_profile = &OpenProfile("$in{ToWhom}");
my $email_address = $user_profile[2];
my $email_view = $user_profile[11];
$pub_name = $user_profile[15];
$un = $user_profile[0];
$user_email = $user_profile[2];

chomp($email_address); chomp($email_view); chomp($un); chomp($pub_name); chomp($user_email);

if ($pub_name eq '') { $pub_name = $un; }

if (($vars_display{EmailBlock} ne 'ON') && ($email_view ne 'no')) {
do "$vars_config{NonCGIPath}/Templates/public_show_email.pl";
} else {
&StandardHTML("$vars_wordlets_err{email_blocked}");
}

} # end email_user

sub recent_user_posts {
local(@user_profile, $chompee, $count, $user_public_name, @posts, @rev_posts, $total, $f, $t, $r, @this_topic, @stat_line, @this_forum, $counter, %ExactPath);

# get user profile
# get requested profile
@user_profile = &OpenProfile($in{u});
$count = 0;
foreach $chompee(@user_profile) {
chomp($user_profile[$count]);
$count++;
}

# set public_name
if ($user_profile[15] eq '') {
$user_public_name = $user_profile[0];
} else {
$user_public_name = $user_profile[15];
}

# grab user posts record
if (-e "$vars_config{MembersPath}/user_posts/$in{u}.cgi") {
@posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{u}.cgi");
}

# sort newest to oldest
@rev_posts = reverse(@posts);

# limit to last 50 posts
$total = @rev_posts;
if ($total > 50) {
@rev_posts = @rev_posts[0..49];
}

$counter=0;
do "$vars_config{NonCGIPath}/Templates/public_user_posts.pl";


}  # end recent user posts


# DANGER: Do not remove the next line!
1;