# UBB Registration Routines : Perl Code

# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{registration}.cgi";

&set_page_elements;

sub do_agree {
local($BBRules);

# if user is logged in, no need to register
if ($username ne '') {
&StandardHTML("$vars_wordlets_err{already_registered}");
}

# are registrations being accepted?
if ($vars_registration{SuspendRegister} eq "true") {
&StandardHTML("$vars_wordlets_err{registrations_suspended}"); }

# do age check?
if (($vars_registration{COPPACheck} eq "ON") && ($in{age} ne "OK")){
&age_check; exit;
}

# display rules
$BBRules = &ConvertReturns($vars_registration{BBRules});
do "$vars_config{NonCGIPath}/Templates/public_display_rules.pl";


} # do_agree

sub age_check {
local($NextCOPPALink, $PrivacyStatement, $PrivacyStatementVerbose);

&GetDateTime;	# sets %GotTime vars

my @months = ("blank" , "$vars_wordlets_date{month_1}", "$vars_wordlets_date{month_2}", "$vars_wordlets_date{month_3}", "$vars_wordlets_date{month_4}", "$vars_wordlets_date{month_5}", "$vars_wordlets_date{month_6}", "$vars_wordlets_date{month_7}", "$vars_wordlets_date{august_month_8}", "$vars_wordlets_date{month_9}", "$vars_wordlets_date{month_10}", "$vars_wordlets_date{month_11}", "$vars_wordlets_date{month_12}");

$COPPADate = "$GotTime{mday} $months[$GotTime{JSMonth}] " . ($GotTime{JSYear}-13);

if ($vars_registration{COPPAFormOnly} eq 'YES') {
	$NextCOPPALink = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=show_coppa_form";
} else {
	$NextCOPPALink = "$vars_config{CGIURL}/ultimatebb.cgi?ubb=coppa_agree";
}


if($vars_display{ShowPrivacyLink} eq 'ON'){
	$PrivacyStatement = qq!| <A HREF="$vars_display{PrivacyURL}">$vars_wordlets{privacy_statement}</A>!;
	$PrivacyStatementVerbose = qq!<p><A HREF="$vars_display{PrivacyURL}">$vars_config{BBName} $vars_wordlets{privacy_statement}</a>.!;
}

do "$vars_config{NonCGIPath}/Templates/public_age_check.pl";

}  # end age_check

sub register_page {
local ($B1, $B2, $ImagesWording, $days, %select_list);

$days = $vars_display{DaysPruneDefault};
foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)){
$select_list{$_}='';
}
$select_list{$days} = 'SELECTED';

do "$vars_config{NonCGIPath}/Templates/public_register_page.pl";
}  # end register_page


sub coppa_agree {
local($COPPAWording, %select_list);
# check to see if admin wants to deny outright
if($vars_registration{COPPAType} eq 'COPPADenied') {
&StandardHTML("$vars_wordlets_err{age_deny}");
}

# accepting reg?
if ($vars_registration{SuspendRegister} eq "true") {
&StandardHTML("$vars_wordlets_err{registrations_suspended}");
}
# display rules
$COPPAWording = &ConvertReturns($vars_registration{COPPAWording});
do "$vars_config{NonCGIPath}/Templates/public_rules_for_minors.pl";
} # end coppa_agree


sub underage_register_page {
local(@email_verify_html, $pw_wording_1, $pw_wording_2);
if ($vars_registration{SuspendRegister} eq 'true') {
&StandardHTML("$vars_wordlets_err{registrations_suspended}");
}

my $days = $vars_display{DaysPruneDefault};
foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)){
$select_list{$_}='';
}
$select_list{$days} = 'SELECTED';

do "$vars_config{NonCGIPath}/Templates/public_register_page_kid.pl";
}  # end underage_register_page



sub GetLastMemberNumber {
local ($last_number);
$last_number = &OpenFileAsVar("$vars_config{MembersPath}/last_number.cgi");
chomp($last_number); return($last_number);
}  # end Get Last Member Number sr


sub submit_registration {
local ($lc_it, $the_email, $j, $lc_the_email, $ubb_code_images, $permission, $sendto, $from, $subject, $message, $message_text, $message_html, $reg_wording_1, $reg_wording_2, $public_name, $pub_warning, $lc_public_name, $cc, $bcc, $COPPAInstructions, $password, $user_name, $email, %select_list, $sig, $sig_html, $this_status, $html_body, $ModWording, $HTMLMessage, $mod_q, $user_ratings, $AllowMassMail, $EmailView, $private_message, $private_message_notify);
local(*MEMBERSHIP); local(*FILE);

if ($vars_misc{FloodCheck} eq 'ON') {
require "ubb_lib_posting.cgi";
&floodcheck;
}

foreach $key (keys %in) {
# rem HTML and unclosed tags
$in{$key} =~ s/(__)(\w+)(__)/_ $2 _ /g; #rem IIS exploit

unless (($key eq 'username') || ($key eq 'password') || ($key eq 'password_confirm')) {
$in{$key} =~ s/<.*?>//sg;
$in{$key} =~ s/</&lt;/sg;  $in{$key} =~ s/>/&gt;/g;

unless ($key eq 'signature') {
$in{$key} =~ s/\s+/ /sg;
$in{$key} =~ s/"/&quot\;/sg;
}
}
}

#let's assign a few
$user_name = &name_clean($in{username});
$email = $in{email};
$password = $in{password};


# login name has to be clean

#check for illegal (non alphanumeric characters)
&illegal_name_check($user_name);
if ($in{public_name} ne '') { &illegal_name_check($in{public_name}); }

# make sure size is ok
if ( (length($in{username}) > 25) || (length($in{public_name}) > 35) || (length($in{password}) > 13) ) {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{name_too_long}");
}

# make sure email is in valid format!
my $email_test = &email_test($email);

if ($email_test eq 'n') {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{email_invalid}");
}

# check password --
if ($password =~ m/__\w+__/) {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{password_error}");
}

# does email match confirmation?
if ($email ne "$in{email_confirm}") {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{email_confirm_err}");
}

# does pw match confirmation?
if ($vars_registration{EmailVerify} eq 'OFF') {
if ($password ne "$in{password_confirm}") {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{password_confirm_err}");
}
}

# validate
my @VA = ("username");

if ($vars_registration{EmailVerify} eq 'ON') {
push(@VA, 'email'); push(@VA, "email_confirm");
}

if ($in{kid} eq 'yes') {

push(@VA, "parent_email");

unless ($in{parent_email} ne $email) {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{parent_email_not_unique}");
}

}  else {

if ($vars_registration{location_field_use} eq 'REQ') { push(@VA, "location"); }
if ($vars_registration{occupation_field_use} eq "REQ") { push(@VA, "occupation"); }
if ($vars_registration{picture_field_use} eq "REQ") { push(@VA, "picture"); }
if ($vars_registration{homepage_field_use} eq "REQ") { push(@VA, "homepage"); }
if ($vars_registration{interests_field_use} eq "REQ") { push(@VA, "interests"); }
if ($vars_registration{signature_field_use} eq "REQ") { push(@VA, "signature"); }
if ($vars_registration{icq_field_use} eq "REQ") { push(@VA, "icq"); }
if ($vars_registration{aim_field_use} eq "REQ") { push(@VA, "aim"); }

if ($vars_registration{EmailVerify} eq 'OFF') { push(@VA, "password"); push(@VA, "password_confirm"); }

if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push(@VA, "customfield1"); }
if (($vars_registration{custom2_field_use} eq "REQ") && ($vars_registration{customfield2} ne '')) { push(@VA, "customfield2"); }
if (($vars_registration{custom3_field_use} eq "REQ") && ($vars_registration{customfield3} ne '')) { push(@VA, "customfield3"); }
if (($vars_registration{custom4_field_use} eq "REQ") && ($vars_registration{customfield4} ne '')) { push(@VA, "customfield4"); }

} # if/else a child

&Validate(@VA);

$user_name =~ s/\s+/ /g;
$email =~ s/\s+//g;

# is user banned?
&check_email_bans($email);
&check_ip_bans;

if ($in{public_name} eq '') {
	$public_name = "$user_name";
} else {
	$public_name = &name_clean($in{public_name});
}

#lc pub name for check later...
$lc_public_name = lc($public_name);

# check to make sure login name is unique
my @members = &GetMemberListArray;
my @email_list = &GetEmails;

my $lc_username = lc($user_name);

CHECKDUPES: for (@members) {
	$lc_it = lc($_);
	if ($lc_it eq "$lc_username") {
		#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

		&StandardHTML("$vars_wordlets_err{dupe_name}");
		last CHECKDUPES;
	}
	if ($lc_it eq "$lc_public_name") {
	$pub_warning = "$vars_wordlets{public_name_warning}";
	$public_name = $user_name;
	}
}


# make sure email isn't a duplicate, if this is a requirement

if ($vars_registration{EmailCheck} eq 'true') {
my $lc_email = lc($email);  #lowercase to check for dupe
 CHECKEMAIL:  for (@email_list) {
 ($the_email, $j) = split(/\?\?/, $_);
 $lc_the_email = lc($the_email);
	if ($lc_email eq "$lc_the_email") {
		#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

		&StandardHTML("$vars_wordlets_err{dupe_email}");
		last CHECKEMAIL;
	}
 }
}  #END if we need to do dupe email check

# make sure publicly displayed name is unique
# and check login name against pub names
if (-s "$vars_config{MembersPath}/public_names.cgi") {
my @pubs = &OpenFileAsArray("$vars_config{MembersPath}/public_names.cgi");

foreach (@pubs) {
chomp($_);
$lc_it = lc($_);
if ($lc_public_name eq "$lc_it") {
$public_name = $user_name;
$pub_warning = "$vars_wordlets{public_name_warning}";
}


if ($lc_username eq "$lc_it") {
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);
&StandardHTML("$vars_wordlets_err{dupe_name}");
}

}
} # if pub names file exists and has size

# generate password, if necessary
if ($vars_registration{EmailVerify} eq 'ON') {
# make sure email is activated!
if ($vars_email{UseEmail} ne 'ON') {
	#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

	&StandardHTML("$vars_wordlets_err{email_not_on_for_reg}");
}
	#generate password
	$password = &GeneratePassword;
}

# prep sig - prevent HTML, strip returns, do UBB Code
$sig = &CensorCheck($in{signature});
$sig =~ s/(<IMG SRC)(.*?)(>)//isg;
$sig =~ s/(__)(\w+)(__)/_ $2 _ /g; #rem IIS exploit

# remove leading/trainling whitespace
$sig = &strip_lead_trail_space($sig);

$sig_html = &ConvertReturns($sig);
if ($vars_display{AllowSignatureImage} eq 'no'){
$ubb_code_images = 'no';
} else {
$ubb_code_images = 'yes';
}
$sig_html = &UBBCode("$sig_html");

$in{icq} =~ s/\D//sg; # rem non numbers

# assign member number
my $last_number = &GetLastMemberNumber;
my $orig_last_number = $last_number + 0;

$last_number++;
$next_number = sprintf("%8d", $last_number);
$next_number =~ tr/ /0/;

# permissions?
if ($in{kid} eq 'yes') {
	if ($vars_registration{ModerateRegs} eq 'ON') {
		$mod_q = 'Q';
		&add_to_registration_mod_list($next_number);
	}
	$permission = '&COPPA';
	$in{AllowMassMail} = 'no';
	$in{private_message} = 'no';
	$in{private_message_notify} = 'no';
}
elsif($vars_registration{ModerateRegs} eq 'ON') {
	$permission = '&';
	$mod_q = 'Q';
	&add_to_registration_mod_list($next_number);
} else {
	$permission = 'Write&';
}

# set wordlets for options (new 6.01):
if ($in{AllowMassMail} eq 'yes') { 	$AllowMassMail = "$vars_wordlets{yes_option}";
}  else {
	$AllowMassMail = "$vars_wordlets{no_option}";
}
if ($in{EmailView} eq 'yes') { 	$EmailView = "$vars_wordlets{yes_option}";
}  else {
	$EmailView = "$vars_wordlets{no_option}";
}
if ($in{user_ratings} eq 'yes') { 	$user_ratings = "$vars_wordlets{yes_option}";
}  else {
	$user_ratings = "$vars_wordlets{no_option}";
}
if ($in{private_message} eq 'yes') { 	$private_message = "$vars_wordlets{yes_option}";
}  else {
	$private_message = "$vars_wordlets{no_option}";
}
if ($in{private_message_notify} eq 'yes') { 	$private_message_notify = "$vars_wordlets{yes_option}";
}  else {
	$private_message_notify = "$vars_wordlets{no_option}";
}



# set cookie
if ($vars_registration{EmailVerify} eq 'OFF') {
my $cookie = cookie(-name=> "ubber$vars_config{Cookie_Number}", -value=> [$user_name, $password, $public_name, $in{DaysPrune}, $next_number],  -path=> '/', -expires=> '+2y');
$username = $user_name;

print header(
	-cookie=>[$cookie],
	-charset => "$masterCharset",
	-type => "text/html",
	);

}  else {
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

}

$this_status = 'Junior Member';

# is this first member? if so, make admin
if ($orig_last_number == 0) {
unless (-e "$vars_config{MembersPath}/memberslist.cgi") {
$permission = 'WriteAdmin&';
$this_status = 'Administrator';
unlink("$vars_config{MembersPath}/member_test.cgi");
}
}

# create registration file
open (MEMBERSHIP, ">$vars_config{MembersPath}/$next_number.cgi") or die("Unable to open Members directory.");
&lock;
	print MEMBERSHIP ("$user_name\n");
	print MEMBERSHIP ("$password\n");
	print MEMBERSHIP ("$email\n");
	print MEMBERSHIP ("$in{homepage}\n");
	print MEMBERSHIP ("$permission\n");
	print MEMBERSHIP ("$in{occupation}\n");
	print MEMBERSHIP ("$in{location}\n");
	print MEMBERSHIP ("0\n");
	print MEMBERSHIP ("$this_status\n");
	print MEMBERSHIP ("$in{interests}\n");
	print MEMBERSHIP ("$GotTime{HyphenDate}\n");
	print MEMBERSHIP ("$in{EmailView}\n");
	print MEMBERSHIP ("$sig_html\n");
	print MEMBERSHIP ("$in{icq}\n");
	print MEMBERSHIP ("$in{AllowMassMail}\n");
	print MEMBERSHIP ("$public_name\n");
	print MEMBERSHIP ("$in{customfield1}\n");
	print MEMBERSHIP ("$in{customfield2}\n");
	print MEMBERSHIP ("$in{customfield3}\n");
	print MEMBERSHIP ("$in{customfield4}\n");
	print MEMBERSHIP ("$in{picture}\n");
	print MEMBERSHIP ("$in{DaysPrune}\n");
	print MEMBERSHIP ("$in{aim}\n");
	print MEMBERSHIP ("\n");
	print MEMBERSHIP ("\n");
	print MEMBERSHIP ("$in{user_ratings}\n");
	print MEMBERSHIP ("$mod_q\n");
	print MEMBERSHIP ("$in{private_message}\n");
	print MEMBERSHIP ("$in{private_message_notify}\n");
	print MEMBERSHIP ("yes\n");
&unlock;
close (MEMBERSHIP);
chmod (0777, "$vars_config{MembersPath}/$next_number.cgi");

$total_members = (@members + 1); #the total number of registered users

# make sure that file was created:
# this is in case disk quota is exceeded, to limit damage--

if (-z "$vars_config{MembersPath}/$next_number.cgi") {
#moved mail req here to try to find prob...
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
# alert admin!
if ($vars_email{UseEmail} eq 'ON')  {

require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";
my $this_message = qq!$vars_wordlets_email{reg_alert_cant_write}!;

&ubb_mail("$vars_registration{RegsAdminEmail}", "$vars_registration{RegsAdminEmail}", "", "$vars_wordlets_err{reg_no_write_subject} : $vars_config{BBName}", "$this_message", "", "$vars_display{BBEmail}");
}

&StandardHTML("$vars_wordlets_err{reg_no_write}");
} # end alert!

# update associated files
open (FILE, ">$vars_config{MembersPath}/membertotal.cgi");
&lock;
	print FILE $total_members;
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/membertotal.cgi");

open (FILE, ">>$vars_config{MembersPath}/memberslist.cgi");
&lock;
	print FILE "$user_name|!!|$next_number\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/memberslist.cgi");

open (FILE, ">>$vars_config{MembersPath}/emailfile.cgi");
&lock;
	print FILE "$email||$next_number\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/last_number.cgi");

open (FILE, ">$vars_config{MembersPath}/last_number.cgi");
&lock;
	print FILE "$next_number\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/last_number.cgi");

# last approved member:
unless ($vars_registration{ModerateRegs} eq 'ON') {
open (FILE, ">$vars_config{MembersPath}/last_approved.cgi");
&lock;
	print FILE "$next_number\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/last_approved.cgi");
}


if ($pub_warning eq '') {
# add new public name to list, assuming we can
open (FILE, ">>$vars_config{MembersPath}/public_names.cgi");
&lock;
	print FILE "$public_name\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/public_names.cgi");
}

# clear forum summ cache if necessary
if (($vars_display{DisplayMemberTotal} eq 'true') || ($vars_display{NewestMemberWelcome} eq 'yes')) {
&ClearSummaryCache;
}

# now do email functions--
if ($in{kid} ne 'yes') { $in{kid} = 'no'; }

if ($vars_email{UseEmail} eq 'ON')  {
require "$vars_config{VariablesPath}/vars_wordlets_email.cgi";

# set email template
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";

&set_page_elements;

$sendto = "$email";
$from = "$vars_registration{RegsAdminEmail}";

# standard email verification -> send new user a password

if ($vars_registration{EmailVerify} eq 'ON') {
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";

$subject = "$vars_wordlets_email{registration_subject}";

if ($in{kid} eq 'yes') {

#convert coppa instructions
$coppa_instructions = $vars_registration{COPPAInstructions};
$subject = "$vars_wordlets_email{reg_subject_kid}";
$sendto = "$in{parent_email}";
$cc = "$email";

$message = "$vars_wordlets_email{reg_text_kid}";
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_kid}" . qq!</FONT>!;
}

elsif ($vars_registration{ModerateRegs} eq "ON") {
$message = "$vars_wordlets_email{reg_text_mod}";
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_mod}" . qq!</FONT>!;

} else {
$message = "$vars_wordlets_email{reg_text_normal}";
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_html_normal}" . qq!</FONT>!;
}

# is HTML format to be sent?
if ($vars_email{email_format} ne "ascii") {
$HTMLMessage = "$EmailHeader $html_body $Footer";
}  else {
$HTMLMessage = '';
}

# in case only HTML format is to be sent:
if ($vars_email{email_format} eq 'html') { $message = ''; }
&ubb_mail("$sendto", "$from", "", "$subject", "$message", "$HTMLMessage", "$cc");

}

# notify registration admin?
if ($vars_registration{OnRegsNotifyAdmin} ne 'OFF') {

unless (($vars_registration{OnRegsNotifyAdmin} eq 'COPPA') && ($in{kid} eq 'no')) {

$subject = "$vars_wordlets_email{reg_notify_admin_subject}: $public_name";
$message = "$vars_wordlets_email{reg_notify_admin}";
$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{reg_notify_admin_html}" . qq!</FONT>!;

# is HTML format to be sent?
if ($vars_email{email_format} ne 'ascii') {
$HTMLMessage = "$EmailHeader $html_body $Footer";
}  else {
$HTMLMessage = '';
}

# in case only HTML format is to be sent:
if ($vars_email{email_format} eq 'html') { $message = ''; }
require "$vars_config{CGIPath}/ubb_lib_mail.cgi";
&ubb_mail("$from", "$from", "", "$subject", "$message", "$HTMLMessage", "");
}

}


} # if email is activated

# get assigned style template!
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{registration}.cgi";
&set_page_elements;

# on screen confirmation

my $days = $in{DaysPrune};
foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)){
$select_list{$_}='';
}
$select_list{$days} = 'SELECTED';

if ($in{kid} eq 'yes') {
$COPPAInstructions = &ConvertReturns($vars_registration{COPPAInstructions});
do "$vars_config{NonCGIPath}/Templates/public_reg_confirm_kid.pl";
}  else {
if ($vars_registration{ModerateRegs} eq "ON") {
$ModWording = "$vars_wordlets{moderated_reg}";
}
do "$vars_config{NonCGIPath}/Templates/public_reg_confirm.pl";
}

} # end submit_reg

sub add_to_registration_mod_list {
local(*FILE);
# parameter:
# $_[0] : member number

open (FILE, ">>$vars_config{MembersPath}/moderation_q.cgi");
&lock;
	print FILE "$_[0]\n";
&unlock;
close (FILE);
chmod (0666, "$vars_config{MembersPath}/moderation_q.cgi");

} # end add to registration_mod_list

# DANGER: Do not remove the next line!
1;