sub InitialConfig {
local ($cgipath, @cgipath, $cgiext, $CGIPath, $VariablesPath, $MembersPath, $NonCGIPath, $CGIURL, $NonCGIURL);

if ($CGIPath eq '') {
	if($ENV{'SCRIPT_FILENAME'}){ #*nix
	 	$thiscgipath = $ENV{'SCRIPT_FILENAME'};
	} elsif ($ENV{'PATH_TRANSLATED'}) { # Win32
		$thiscgipath = $ENV{'PATH_TRANSLATED'};
		$thiscgipath =~ s/\\/\//g;
	}
	@cgipath = split(/\//, $thiscgipath);
	pop(@cgipath);
	$CGIPath = join("\/", @cgipath);
	$VariablesPath = $CGIPath;
	$MembersPath = ("$CGIPath" . "/Members");
	$cgiext = pop(@cgipath);
}
if ($NonCGIPath eq '') { $NonCGIPath = "$ENV{'DOCUMENT_ROOT'}/ubb"; }
if ($NonCGIURL eq '') { $NonCGIURL = "http://$ENV{'HTTP_HOST'}/ubb"; }
if ($CGIURL eq '') { $CGIURL = "http://$ENV{'HTTP_HOST'}/$cgiext"; }

#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "ISO-8859-1",
	-type => "text/html",
	);


&InitialHTML;
$ThisHTML =~ s/\%\%(\w+)/${$1}/g;
print "$ThisHTML";
}


sub DoEnv {
local($key);
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "ISO-8859-1",
	-type => "text/html",
	);

print<<TheENV;
<HTML><HEAD><TITLE>UBB: Your Environmental Variables</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF">
<BR><BR>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Your Environmental Variables</b>
<P>
Use this information to help you figure out your absolute file paths, and other system information.
<P>
<B>Perl Info:</b><BR>
You are using <b>Perl Version $]</b>
<P>
<B>Your Environmental Variables:</b>
<BR>
<FONT SIZE="1">Note: "DOCUMENT_ROOT" shows your absolute path to your root web directory.  "SCRIPT_FILENAME" shows you absolute path of your CGI directory.  If your SCRIPT_FILENAME shows "/www/whatever/whatever/cgi-bin/cpanel.cgi", your Absolute Path variable for your CGI directory would be "/www/whatever/whatever/cgi-bin". On some servers this value is called PATH_TRANSLATED.</FONT><P>
TheENV

for $key (keys(%ENV)) {
printf("%-10.20s: <b>$ENV{$key}</B><BR>", $key);
}

print<<BOTTOM;
</FONT></BODY></HTML>
BOTTOM
}

sub SetInitial {
local($random_pw);
print header(
	-charset => "ISO-8859-1",
	-type => "text/html",
	);

# used to set important configuration info for the first time

# validate form first
my @ValidateArray = ("CGIPath", "NonCGIPath", "MembersPath", "VariablesPath", "CGIURL", "NonCGIURL", "BBName");
&Validate(@ValidateArray);

chmod(0777, "$in{NonCGIPath}");
chmod(0755, "$in{CGIPath}");
chmod(0777, "$in{MembersPath}");
chmod(0777, "$in{MembersPath}/member_test.cgi");
mkdir ("$in{NonCGIPath}/Forum1", 0777);
chmod(0777, "$in{NonCGIPath}/Forum1");

# make sure the info is pointing to the right places :)
unless (-e "$in{CGIPath}/cp.cgi") {
&StandardHTMLsetup(qq%Error:<P>Your CGI Directory Path is not correct. [There may be other errors, as well.]%);
}

unless (-e "$in{NonCGIPath}/on.gif") {
&StandardHTMLsetup(qq%Error:<P>Your UBB NonCGI Directory Path is not correct. You would also receive this error if you forgot to upload the on.gif file into your UBB Non CGI directory.  [There may be other errors, as well.]%);
}
unless (-d "$in{NonCGIPath}/Templates") {
&StandardHTMLsetup(qq%Error:<P>We cannot find your Templates directory!  We cannot continue until you place the Templates directory (and all of the files associated with that directory) inside your UBB Graphics (Non CGI) directory.  [There may be other errors, as well.]%);
}
unless (-d "$in{NonCGIPath}/icons") {
&StandardHTMLsetup(qq%Error:<P>We cannot find your "icons" directory!  We cannot continue until you place the icons directory (and all of the files associated with that directory) inside your UBB Graphics (Non CGI) directory.  [There may be other errors, as well.]%);
}
unless ((-e "$in{MembersPath}/member_test.cgi") || (-e "$in{MembersPath}/last_number.cgi")) {
&StandardHTMLsetup(qq%Error:<P>Your Members Directory Path is not correct. You would also receive this error if you are installing a new UBB and forgot to upload the member_test.cgi file into your Members directory.  [There may be other errors, as well.]%);
}

if ($in{MembersPath} eq "$in{CGIPath}") {
&StandardHTMLsetup(qq%Error:<P>Your Members Directory Path cannot be the same as your CGI path.  You must create a separate directory for your Members directory! [There may be other errors, as well.]%);
}
if ($in{MembersPath} eq "$in{NonCGIPath}") {
&StandardHTMLsetup(qq%Error:<P>Your Members Directory Path cannot be the same as your NonCGI path.  You must create a separate directory for your Members directory! [There may be other errors, as well.]%);
}
if ($in{MembersPath} eq "$in{VariablesPath}") {
&StandardHTMLsetup(qq%Error:<P>Your Members Directory Path cannot be the same as your Variables path.  You must create a separate directory for your Members directory! [There may be other errors, as well.]%);
}

unless (-d "$in{NonCGIPath}/Forum1") {
&StandardHTMLsetup("Error: We are unable to write to your UBB Non CGI Directory.  Please check your permissions on that directory.  It should be set to mode 777.  We cannot process until this permissions problem is fixed.");
exit;
}

require "ubb_lib_time.cgi";
require "ubb_lib.cgi";
$random_pw = &GeneratePassword2;
&GetDateTime;

my $CGIPath = &CleanVar2($in{CGIPath});
my $NonCGIPath = &CleanVar2($in{NonCGIPath});
my $MembersPath = &CleanVar2($in{MembersPath});
my $VariablesPath = &CleanVar2($in{VariablesPath});
my $NonCGIURL = &CleanVar2($in{NonCGIURL});
my $CGIURL = &CleanVar2($in{CGIURL});
my $BBName = &SmallClean($in{BBName});

open (FILE, ">$in{VariablesPath}/vars_config.cgi") or die("Unable to open vars_config.cgi file for writing.");
&lock;
print FILE qq!\%vars_config = (\n!;
print FILE "CGIPath => q!$CGIPath!,\n";
print FILE "NonCGIPath => q!$NonCGIPath!,\n";
print FILE "MembersPath => q!$MembersPath!,\n";
print FILE "VariablesPath => q!$VariablesPath!,\n";
print FILE "CGIURL => q!$CGIURL!,\n";
print FILE "NonCGIURL => q!$NonCGIURL!,\n";
print FILE qq!cache_pw => "$random_pw",\n!;
print FILE qq!Cookie_Number => "$GotTime{LastLoginJulian}",\n!;
print FILE qq!BBName => q~$BBName~,\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close (FILE);
chmod(0777, "$in{VariablesPath}/vars_config.cgi");

# LastNumber = last number used in members file
unless (-e "$in{MembersPath}/last_number.cgi") {
open(FILE, ">$in{MembersPath}/last_number.cgi");
print FILE "00000000\n";
close(FILE);
}

# set permissions/create directories

mkdir ("$in{NonCGIPath}/Forum2", 0777);
chmod(0777, "$in{NonCGIPath}/Forum2");
mkdir ("$in{NonCGIPath}/Forum3", 0777);
chmod(0777, "$in{NonCGIPath}/Forum3");
mkdir ("$in{NonCGIPath}/Forum4", 0777);
chmod(0777, "$in{NonCGIPath}/Forum4");
mkdir ("$in{NonCGIPath}/Forum5", 0777);
chmod(0777, "$in{NonCGIPath}/Forum5");
mkdir ("$in{NonCGIPath}/Forum6", 0777);
chmod(0777, "$in{NonCGIPath}/Forum6");
mkdir ("$in{NonCGIPath}/Forum7", 0777);
chmod(0777, "$in{NonCGIPath}/Forum7");
mkdir ("$in{NonCGIPath}/Forum8", 0777);
chmod(0777, "$in{NonCGIPath}/Forum8");
mkdir ("$in{NonCGIPath}/Forum9", 0777);
chmod(0777, "$in{NonCGIPath}/Forum9");


mkdir ("$in{NonCGIPath}/cache-$random_pw", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw");

mkdir ("$in{NonCGIPath}/styles", 0777);
chmod(0777, "$in{NonCGIPath}/styles");
mkdir ("$in{MembersPath}/user_ratings", 0777);
chmod(0777, "$in{MembersPath}/user_ratings");
mkdir ("$in{MembersPath}/user_raters", 0777);
chmod(0777, "$in{MembersPath}/user_raters");
mkdir ("$in{MembersPath}/user_posts", 0777);
chmod(0777, "$in{MembersPath}/user_posts");
mkdir ("$in{MembersPath}/pm_users", 0777);
chmod(0777, "$in{MembersPath}/pm_users");
mkdir ("$in{MembersPath}/pm_sent", 0777);
chmod(0777, "$in{MembersPath}/pm_sent");
mkdir ("$in{MembersPath}/pm_topics", 0777);
chmod(0777, "$in{MembersPath}/pm_topics");
mkdir ("$in{MembersPath}/pm_info", 0777);
chmod(0777, "$in{MembersPath}/pm_info");
mkdir ("$in{MembersPath}/pm_ignore", 0777);
chmod(0777, "$in{MembersPath}/pm_ignore");
mkdir ("$in{MembersPath}/pm_buddy", 0777);
chmod(0777, "$in{MembersPath}/pm_buddy");


# this is new!
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files");
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files/summary", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files/summary");
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files/forums", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files/forums");
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files/forum_page", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files/forum_page");
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files/misc", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files/misc");
mkdir ("$in{NonCGIPath}/cache-$random_pw/ubb_files/counter", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/ubb_files/counter");
mkdir ("$in{NonCGIPath}/cache-$random_pw/search_index", 0777);
chmod(0777, "$in{NonCGIPath}/cache-$random_pw/search_index");

unless (-d "$in{NonCGIPath}/BanLists") {
mkdir ("$in{NonCGIPath}/BanLists", 0777);
chmod(0777, "$in{NonCGIPath}/BanLists");
}

unless (-e "$in{MembersPath}/public_names.cgi") {
open(FILE, ">$in{MembersPath}/public_names.cgi");
print FILE '';
close(FILE);
chmod(0666, "$in{MembersPath}/public_names.cgi");
}

# move vars_style_1 to members/styles dir, if necessary
unless (-e "$in{NonCGIPath}/styles/vars_style_1.cgi") {
local($key);
# move file to proper directory...
require "$in{VariablesPath}/vars_style_1.cgi";
open(FILE, ">$in{NonCGIPath}/styles/vars_style_1.cgi");
&lock;
print FILE qq!\%vars_style = (\n!;
foreach $key(keys %vars_style) {
print FILE qq!$key => q~$vars_style{$key}~,\n!;
}

print FILE qq!);\n!;
print FILE qq!1;\n!;
&unlock;
close(FILE);
chmod(0777, "$in{NonCGIPath}/styles/vars_style_1.cgi");
}

# display primary CP screen
&StandardHTMLsetup(qq%Thank you!  You have successfully installed your UBB!<P>You still need to configure/customize your message board, which you can do in your Control Panel.  None of your email-oriented features will function until you configure your Email Settings there.  <P>To continue customizing your UBB, <A HREF="cp.cgi">click here</A>!%);
exit;
} #end initial set vars


sub Validate {
local($each, $Redo, $BadLine, @splitter);
$Redo = '';

foreach $each(@_) {
chomp($each);

if ($each !~ /\|/) {
if ($in{$each} eq '') {
$Redo = 'true';
$BadLine .= "You did not complete: $each<BR>";
}

}  else {
#this is an AND list
@splitter = split(/\|/, $each);
$ok = 'false';
foreach $one(@splitter) {
chomp($one);
if ($in{$one}) { $ok = 'true'; }
}

if ($ok eq 'false') {
$Redo = 'true';
$BadLine .= "You must complete one of: $each<BR>";
}


} #end single/OR
}
if ($Redo eq 'true') {
&StandardHTMLsetup(qq%You did not complete all required fields.<P>$BadLine%);
}

} #end validate
sub StandardHTMLsetup {
my $Text = shift;
print<<THETEXT;
<HTML><HEAD></HEAD><BODY>
<P><FONT SIZE="2" FACE="Verdana, Arial"><B>
$Text
</B></FONT><P>
</BODY></HTML>
THETEXT
exit;
}

sub InitialHTML {
$ThisHTML = qq|
<HTML>
<HEAD><TITLE>UBB Initial Setup</TITLE>
</HEAD>
<BODY>

<CENTER>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">
<FORM ACTION="cp.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_initial">

<table border="0" cellpadding="1" cellspacing="1" width="95%">
<tr><td bgcolor="#5D7790">

<table border="0" cellpadding="2" cellspacing="0" width="100%">
<tr bgcolor="#5D7790">
<td colspan="2">
<B><FONT face="VERDANA,ARIAL,HELVETICA" color="#FFFFFF" size="2">
<P>Welcome to the Ultimate Bulletin Board (UBB) Control Panel!
<P>
In order to use your UBB, you must provide the following information.  Your UBB will not operate if you do not provide the correct information below!
</FONT></B>
</TD></TR>

<tr bgcolor="#c0c800">
<td colspan="2">
<B><FONT SIZE="1" FACE="Verdana, Arial">
Absolute Directory Paths</FONT></B></TD></TR>

<TR bgcolor="#FFFFFF">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
Absolute paths reflect the physical locations of directories on a server.  They are the complete locations, not the locations from the web root, but from the server root.  Absolute paths on Win32/NT servers are displayed differently than on UNIX systems.  For instance, note the following samples for UNIX and NT:
<p>
For UNIX servers:  &nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">/usr/home/yourdomain/www/cgi-bin</font>
<BR>
For Win32/NT servers:&nbsp;&nbsp;&nbsp;&nbsp; <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">C:/home/yourdomain/cgi-bin</FONT>
<P>
Note: the paths listed above are examples, not your actual paths.
<P>
If you are installing on Win32/NT, be sure to use the format above for your absolute paths (note the forward slashes, rather than backward slashes).
<P>
The UBB will attempt to provide complete or partial absolute paths for you.  These paths may not be accurate or complete, but they will give you a headstart.  All absolute path fields MUST be provided for your UBB to run.
<P>
Need help with absolute paths? You can <A HREF="cp.cgi?ubb=env" target="_NEW">check your system's environmental variables</A>.
<P>
</FONT>
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>Absolute Path for:<BR>UBB CGI Directory</B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="CGIPath" VALUE="%%CGIPath" SIZE="60" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>Absolute Path for:<BR>UBB Graphics (NonCGI) Directory</B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="NonCGIPath" VALUE="%%NonCGIPath" SIZE="60" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>Absolute Path for:<BR>Members Directory</B>
<P>For maximum security, you can place this directory anywhere on your web server.  We recommend that you place it so that it is not accessible from the web.</FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="MembersPath" VALUE="%%MembersPath" SIZE="60" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>Absolute Path for:<BR>Variable Files</B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="VariablesPath" VALUE="%%VariablesPath" SIZE="60" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#FFFFFF">
<td colspan="2">
<FONT SIZE="1" FACE="Verdana, Arial">
You should use the same absolute path that you used for your CGI directory above.  If for some reason you cannot write to files in your CGI directory, however, you should place these files (all files in the variables directory of the distribution zip) in a separate directory where they can be written to.  If possible, place them in a directory that is not accessible from the web.<P></FONT></TD></TR>

<tr bgcolor="#c0c800">
<td colspan="2">
<B><FONT SIZE="1" FACE="Verdana, Arial">
URL Addresses</FONT></B></TD></TR>


<TR bgcolor="#FFFFFF">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please provide the following complete hyperlinks.  Use complete hyperlinks, such as http://www.yourdomain.com/cgi-bin, rather than relative links such as "/cgi-bin"</B></FONT>
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>URL for:<BR>UBB CGI Directory</B></FONT>
<FONT SIZE="1" FACE="Verdana, Arial"><B></B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="CGIURL" VALUE="%%CGIURL" SIZE="50" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>URL for:<BR>UBB Graphics (NonCGI) Directory</B></FONT>
<FONT SIZE="1" FACE="Verdana, Arial"><B></B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="NonCGIURL" VALUE="%%NonCGIURL" SIZE="50" MAXLENGTH="250">
</td></tr>

<tr bgcolor="#c0c800">
<td colspan="2">
<B><FONT SIZE="1" FACE="Verdana, Arial">
Other Settings</FONT></B></TD></TR>

<tr bgcolor="#FFFFFF">
<td width="175">
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name of Your Bulletin Board</B></FONT>
</td>
<td valign="top">
<INPUT TYPE="TEXT" NAME="BBName" VALUE="%%BBName" SIZE="40" MAXLENGTH="250">
</td></tr>

</table></td></tr></table><P>
</center>
<FONT SIZE="1" FACE="Verdana, Arial">Don't be nervous :) You cannot damage anything by pressing the button below.  If you did not configure something correctly, we'll let you know and you can try again!
<P>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Configure Your UBB Now!">
</form>
<P>
&copy; 2001 <A HREF="http://www.infopop.com">Infopop Corporation</A>, all rights reserved.
</center></FONT>
</BODY></HTML>|;

}

1;
